/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pc;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContextExecutor;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.pc.CompilerJobQueue;
import scala.meta.internal.pc.CompilerJobQueue$;
import scala.meta.internal.pc.CompilerThrowable$;
import scala.meta.internal.pc.CompilerWrapper;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.internal.pc.RangeOffset;
import scala.meta.pc.CancelToken;
import scala.meta.pc.OffsetParams;
import scala.meta.pc.PresentationCompilerConfig;
import scala.meta.pc.VirtualFileParams;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class CompilerAccess<Reporter, Compiler> {
    private final PresentationCompilerConfig config;
    private final Option<ScheduledExecutorService> sh;
    private final Function0<CompilerWrapper<Reporter, Compiler>> newCompiler;
    private final boolean shouldResetJobQueue;
    private final ExecutionContextExecutor ec;
    private final ReportContext rc;
    private final Logger logger;
    private final CompilerJobQueue jobs;
    private CompilerWrapper<Reporter, Compiler> _compiler;

    public CompilerAccess(PresentationCompilerConfig config, Option<ScheduledExecutorService> sh, Function0<CompilerWrapper<Reporter, Compiler>> newCompiler, boolean shouldResetJobQueue, ExecutionContextExecutor ec, ReportContext rc) {
        this.config = config;
        this.sh = sh;
        this.newCompiler = newCompiler;
        this.shouldResetJobQueue = shouldResetJobQueue;
        this.ec = ec;
        this.rc = rc;
        this.logger = Logger.getLogger(CompilerAccess.class.getName());
        this.jobs = CompilerJobQueue$.MODULE$.apply();
    }

    private boolean isEmpty() {
        return this._compiler == null;
    }

    private boolean isDefined() {
        return !this.isEmpty();
    }

    private CompilerWrapper<Reporter, Compiler> loadCompiler() {
        if (this._compiler == null) {
            this._compiler = (CompilerWrapper)this.newCompiler.apply();
        }
        this._compiler.resetReporter();
        return this._compiler;
    }

    public abstract Reporter newReporter();

    public Reporter reporter() {
        if (this.isEmpty()) {
            return this.newReporter();
        }
        return this._compiler.reporterAccess().reporter();
    }

    public boolean isLoaded() {
        return this._compiler != null;
    }

    public void shutdown() {
        this.shutdownCurrentCompiler();
        this.jobs.shutdown();
    }

    public void shutdownCurrentCompiler() {
        CompilerWrapper compiler = this._compiler;
        if (compiler != null) {
            compiler.askShutdown();
            this._compiler = null;
            this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
                CompilerAccess.shutdownCurrentCompiler$$anonfun$1$$anonfun$1(compiler);
                return BoxedUnit.UNIT;
            }, 2L, TimeUnit.SECONDS));
            return;
        }
    }

    public <T> CompletableFuture<T> withInterruptableCompiler(Option<VirtualFileParams> params, T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        AtomicBoolean isFinished = new AtomicBoolean(false);
        ObjectRef queueThread = ObjectRef.create((Object)Option$.MODULE$.empty());
        CompletableFuture<T> result = this.onCompilerJobQueue((Function0 & Serializable)() -> {
            Object object;
            Some some = Some$.MODULE$.apply((Object)Thread.currentThread());
            queueThread$1.elem = some;
            some = null;
            try {
                object = this.withSharedCompiler(params, t, thunk);
            }
            finally {
                isFinished.set(true);
            }
            return object;
        }, token);
        token.onCancel().whenCompleteAsync((isCancelled, _$2) -> ((Option)queueThread$2.elem).foreach((Function1)(JProcedure1 & Serializable)thread -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && isFinished.compareAndSet(false, true) && this.isDefined()) {
                Option<Thread> option = this._compiler.presentationCompilerThread();
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                if (option instanceof Some) {
                    Thread pcThread = (Thread)((Some)option).value();
                    pcThread.interrupt();
                    Thread thread2 = thread;
                    Thread thread3 = pcThread;
                    if (thread2 == null ? thread3 != null : !thread2.equals(thread3)) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
                throw new MatchError(option);
            }
        }), (Executor)this.ec);
        return result;
    }

    public <T> CompletableFuture<T> withNonInterruptableCompiler(Option<VirtualFileParams> params, T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        return this.onCompilerJobQueue((Function0 & Serializable)() -> this.withSharedCompiler(params, t, thunk), token);
    }

    public <T> T withSharedCompiler(Option<VirtualFileParams> params, T t, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        Object object;
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null && InterruptException$.MODULE$.unapply(throwable2)) {
                object = t;
            }
            if (throwable2 != null) {
                Throwable other = throwable2;
                object = this.handleSharedCompilerException(other).map((Function1 & Serializable)message -> this.retryWithCleanCompiler(params, thunk, t, (String)message)).getOrElse(() -> this.withSharedCompiler$$anonfun$2(params, t, other));
            }
            throw throwable;
        }
        return (T)object;
    }

    public abstract Option<String> handleSharedCompilerException(Throwable var1);

    public abstract boolean ignoreException(Throwable var1);

    private <T> T retryWithCleanCompiler(Option<VirtualFileParams> params, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, T t, String cause) {
        Object object;
        this.shutdownCurrentCompiler();
        this.logger.log(Level.INFO, new StringBuilder(62).append("compiler crashed due to ").append(cause).append(", retrying with new compiler instance.").toString());
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                if (InterruptException$.MODULE$.unapply(throwable2)) {
                    object = t;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.handleError(e, params);
                    object = t;
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    private void handleError(Throwable e, Option<VirtualFileParams> params) {
        Option<Path> pathToFull;
        String string;
        String stacktrace = Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n");
        Throwable error = CompilerThrowable$.MODULE$.trimStackTrace(e);
        Option<VirtualFileParams> option = params;
        if (None$.MODULE$.equals(option)) {
            string = "";
        } else if (option instanceof Some) {
            VirtualFileParams virtualFileParams = (VirtualFileParams)((Some)option).value();
            if (virtualFileParams instanceof RangeOffset) {
                RangeOffset r = (RangeOffset)virtualFileParams;
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(42).append("|range ").append(r.start()).append(" - ").append(r.end()).append("\n              |").append(CompilerAccess.virtualFileParamsToString$1((VirtualFileParams)r)).append("\n              |").toString()));
            } else if (virtualFileParams instanceof OffsetParams) {
                OffsetParams o = (OffsetParams)virtualFileParams;
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(40).append("|offset ").append(o.offset()).append("\n              |").append(CompilerAccess.virtualFileParamsToString$1((VirtualFileParams)o)).append("\n              |").toString()));
            } else {
                VirtualFileParams v = virtualFileParams;
                string = CompilerAccess.virtualFileParamsToString$1(v);
            }
        } else {
            throw new MatchError(option);
        }
        String paramsText = string;
        Reporter reporter = this.rc.unsanitized();
        Option<Path> option2 = pathToFull = reporter.create((Function0<Report>)((Function0 & Serializable)() -> CompilerAccess.$anonfun$2(stacktrace, error, paramsText)), reporter.create$default$2());
        if (option2 instanceof Some) {
            Path path = (Path)((Some)option2).value();
            this.logger.log(Level.SEVERE, new StringBuilder(93).append("A severe compiler error occurred, full details of the error can be found in the error report ").append(path).toString());
        } else {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.shutdownCurrentCompiler();
    }

    private <T> CompletableFuture<T> onCompilerJobQueue(Function0<T> thunk, CancelToken token) {
        CompletableFuture result = new CompletableFuture();
        this.jobs.submit(result, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            token.checkCanceled();
            Thread.interrupted();
            result.complete(thunk.apply());
        });
        token.onCancel().whenCompleteAsync((isCancelled, _$3) -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && !result.isDone()) {
                result.cancel(false);
                return;
            }
        }, (Executor)this.ec);
        this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
            this.onCompilerJobQueue$$anonfun$3$$anonfun$1(result);
            return BoxedUnit.UNIT;
        }, this.config.timeoutDelay(), this.config.timeoutUnit()));
        return result;
    }

    private static final /* synthetic */ void shutdownCurrentCompiler$$anonfun$1$$anonfun$1(CompilerWrapper compiler$2) {
        if (compiler$2.isAlive()) {
            compiler$2.stop();
            return;
        }
    }

    private final Object withSharedCompiler$$anonfun$2(Option params$4, Object default$4, Throwable other$1) {
        this.handleError(other$1, (Option<VirtualFileParams>)params$4);
        return default$4;
    }

    private static final String virtualFileParamsToString$1(VirtualFileParams v) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(57).append("|file uri: ").append(v.uri()).append("\n          |file text:\n          |").append(v.text()).append("\n          |").toString()));
    }

    private static final Report $anonfun$2(String stacktrace$1, Throwable error$2, String paramsText$1) {
        String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("|An error occurred in the presentation compiler:\n              |context stacktrace:\n              |").append(stacktrace$1).append("\n              |action params:\n              |").append(paramsText$1).append("\n              |").toString()));
        Some some = Some$.MODULE$.apply((Object)error$2);
        Option<String> option = Report$.MODULE$.$lessinit$greater$default$3();
        return Report$.MODULE$.apply("compiler-error", string, option, (Option<Throwable>)some);
    }

    private final /* synthetic */ void onCompilerJobQueue$$anonfun$3$$anonfun$1(CompletableFuture result$4) {
        if (!result$4.isDone()) {
            try {
                if (this.shouldResetJobQueue) {
                    this.jobs.reset();
                }
                result$4.cancel(false);
                this.shutdownCurrentCompiler();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                }
                if (throwable2 != null) {
                    Throwable other = throwable2;
                    if (!this.ignoreException(other)) {
                        throw other;
                    }
                }
                throw throwable;
            }
            return;
        }
    }
}

