/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.interactive.Completion;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.PureExpressionInStatementPosition;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.ParsedComment;
import dotty.tools.dotc.util.ParsedComment$;
import dotty.tools.dotc.util.Signatures;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans$;
import java.io.Serializable;
import java.net.URI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class DottyLanguageServer$
implements Serializable {
    public static final DottyLanguageServer$ MODULE$ = new DottyLanguageServer$();

    private DottyLanguageServer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DottyLanguageServer$.class);
    }

    public final String IDE_CONFIG_FILE() {
        return ".dotty-ide.json";
    }

    public final String RENAME_OVERRIDDEN_QUESTION() {
        return "Do you want to rename the base member, or only this member?";
    }

    public final String RENAME_OVERRIDDEN() {
        return "Rename the base member";
    }

    public final String RENAME_NO_OVERRIDDEN() {
        return "Rename only this member";
    }

    public SourcePosition sourcePosition(InteractiveDriver driver, URI uri, Position pos) {
        Position actualPosition = this.dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(uri) ? this.toWrappedPosition(pos) : pos;
        SourceFile source = (SourceFile)driver.openedFiles().apply((Object)uri);
        if (source.exists()) {
            int offset;
            Option option = source.lineToOffsetOpt(actualPosition.getLine()).map((Function1)(JFunction1.mcII.sp & Serializable)_$12 -> _$12 + actualPosition.getCharacter());
            if (option instanceof Some && (offset = BoxesRunTime.unboxToInt((Object)((Some)option).value())) <= source.content().length) {
                long p = Spans$.MODULE$.Span(offset);
                return new SourcePosition(source, p, SourcePosition$.MODULE$.$lessinit$greater$default$3());
            }
            return NoSourcePosition$.MODULE$;
        }
        return NoSourcePosition$.MODULE$;
    }

    public Option<Range> range(SourcePosition p) {
        if (p.exists()) {
            SourcePosition mappedPosition = (SourcePosition)this.positionMapperFor(p.source()).map((Function1 & Serializable)_$13 -> (SourcePosition)_$13.apply((Object)p)).getOrElse(() -> DottyLanguageServer$.$anonfun$24(p));
            return Some$.MODULE$.apply((Object)new Range(new Position(mappedPosition.startLine(), mappedPosition.startColumn()), new Position(mappedPosition.endLine(), mappedPosition.endColumn())));
        }
        return None$.MODULE$;
    }

    public Option<Location> location(SourcePosition p) {
        return InteractiveDriver$.MODULE$.toUriOption(p.source()).flatMap((Function1 & Serializable)uri -> MODULE$.range(p).map((Function1 & Serializable)r -> new Location(uri.toString(), r)));
    }

    public Option<Diagnostic> diagnostic(dotty.tools.dotc.reporting.Diagnostic dia, Contexts.Context ctx) {
        if (!dia.pos().exists()) {
            return None$.MODULE$;
        }
        Message message = dia.msg();
        if (this.displayMessage(message, dia.pos().source(), ctx)) {
            String code = BoxesRunTime.boxToInteger((int)message.errorId().errorNumber()).toString();
            return this.range(dia.pos()).map((Function1 & Serializable)r -> new Diagnostic(r, dia.message(), this.severity$1(dia.level()), "", code));
        }
        return None$.MODULE$;
    }

    private boolean displayMessage(Message message, SourceFile sourceFile, Contexts.Context ctx) {
        if (this.isWorksheet(sourceFile)) {
            Message message2 = message;
            if (message2 instanceof PureExpressionInStatementPosition) {
                PureExpressionInStatementPosition msg = (PureExpressionInStatementPosition)message2;
                Symbols.Symbol ownerSym = Symbols$.MODULE$.toDenot(msg.exprOwner(), ctx).isLocalDummy() ? Symbols$.MODULE$.toDenot(msg.exprOwner(), ctx).owner() : msg.exprOwner();
                return !this.isWorksheetWrapper(ownerSym, ctx);
            }
            return true;
        }
        return true;
    }

    public boolean dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(URI uri) {
        return uri.toString().endsWith(".sc");
    }

    private boolean isWorksheet(SourceFile sourcefile) {
        String string = sourcefile.file().extension();
        String string2 = "sc";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String dotty$tools$languageserver$DottyLanguageServer$$$wrapWorksheet(String source) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(28).append("object ").append(StdNames$.MODULE$.nme().WorksheetWrapper()).append(" {\n       |").append(source).append("\n       |}").toString()));
    }

    private SourcePosition toUnwrappedPosition(SourcePosition position) {
        return new SourcePosition(position, this){
            private final SourcePosition position$2;
            {
                this.position$2 = position$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(position$1.source(), position$1.span(), position$1.outer());
            }

            public int startLine() {
                return this.position$2.startLine() - 1;
            }

            public int endLine() {
                return this.position$2.endLine() - 1;
            }
        };
    }

    private Position toWrappedPosition(Position position) {
        return new Position(position.getLine() + 1, position.getCharacter());
    }

    private Option<Function1<SourcePosition, SourcePosition>> positionMapperFor(SourceFile sourcefile) {
        if (this.isWorksheet(sourcefile)) {
            return Some$.MODULE$.apply((Function1 & Serializable)position -> MODULE$.toUnwrappedPosition((SourcePosition)position));
        }
        return None$.MODULE$;
    }

    public boolean isWorksheetWrapper(SourceTree sourceTree, Contexts.Context ctx) {
        return this.isWorksheet(sourceTree.source()) && this.isWorksheetWrapper(sourceTree.tree().symbol(ctx), ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWorksheetWrapper(Symbols.Symbol symbol, Contexts.Context ctx) {
        Names.Name name = symbol.name(ctx);
        Names.TypeName typeName = NameOps$.MODULE$.moduleClassName(StdNames$.MODULE$.nme().WorksheetWrapper());
        if (name == null) {
            if (typeName != null) {
                return false;
            }
        } else if (!name.equals(typeName)) return false;
        Symbols.Symbol symbol2 = Symbols$.MODULE$.toDenot(symbol, ctx).owner();
        Symbols.ClassSymbol classSymbol = ctx.definitions().EmptyPackageClass();
        if (symbol2 == null) {
            if (classSymbol == null) return true;
            return false;
        } else {
            if (!symbol2.equals(classSymbol)) return false;
            return true;
        }
    }

    public boolean isTopLevelWrapper(SourceTree sourceTree, Contexts.Context ctx) {
        Symbols.Symbol symbol = sourceTree.tree().symbol(ctx);
        return Symbols$.MODULE$.toDenot(symbol, ctx).isPackageObject(ctx);
    }

    public CompletionItem completionItem(Completion completion, Contexts.Context ctx) {
        CompletionItem item = new CompletionItem(completion.label());
        item.setDetail(completion.description());
        List documentation = completion.symbols().flatMap((Function1 & Serializable)sym -> ParsedComment$.MODULE$.docOf(sym, ctx).map((Function1 & Serializable)doc -> doc));
        if (documentation.nonEmpty()) {
            item.setDocumentation(this.dotty$tools$languageserver$DottyLanguageServer$$$hoverContent((Option<String>)None$.MODULE$, (List<ParsedComment>)documentation, ctx));
        }
        item.setDeprecated(Predef$.MODULE$.boolean2Boolean(completion.symbols().forall((Function1 & Serializable)_$14 -> Symbols$.MODULE$.toDenot(_$14, ctx).hasAnnotation((Symbols.Symbol)Symbols$.MODULE$.defn(ctx).DeprecatedAnnot(), ctx))));
        completion.symbols().headOption().foreach((Function1)(JProcedure1 & Serializable)s -> item.setKind(this.completionItemKind$1((Symbols.Symbol)s, ctx)));
        return item;
    }

    public MarkupContent markupContent(String content) {
        if (content.isEmpty()) {
            return null;
        }
        MarkupContent markup = new MarkupContent();
        markup.setKind("markdown");
        markup.setValue(content.trim());
        return markup;
    }

    public MarkupContent dotty$tools$languageserver$DottyLanguageServer$$$hoverContent(Option<String> typeInfo, List<ParsedComment> comments, Contexts.Context ctx) {
        StringBuilder buf = new StringBuilder();
        typeInfo.foreach((Function1 & Serializable)info -> buf.append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(77).append("```scala\n                    |").append((String)info).append("\n                    |```\n                    |").toString()))));
        comments.foreach((Function1 & Serializable)comment -> buf.append(comment.renderAsMarkdown(ctx)));
        return this.markupContent(buf.toString());
    }

    public Option<SymbolInformation> symbolInfo(Symbols.Symbol sym, SourcePosition pos, Contexts.Context ctx) {
        String name = NameOps$.MODULE$.stripModuleClassSuffix(sym.name(ctx)).show(ctx);
        return this.location(pos).map((Function1 & Serializable)l -> new SymbolInformation(name, this.symbolKind$1(sym, ctx), l, this.containerName$1(ctx, sym)));
    }

    public SignatureInformation signatureToSignatureInformation(Signatures.Signature signature) {
        List tparams = signature.tparams().map((Function1 & Serializable)_$15 -> Signatures.Param$.MODULE$.apply("", _$15, Signatures.Param$.MODULE$.$lessinit$greater$default$3(), Signatures.Param$.MODULE$.$lessinit$greater$default$4()));
        List paramInfoss = ((List)signature.paramss().flatten(Predef$.MODULE$.$conforms())).$colon$colon$colon(tparams).map((Function1 & Serializable)param -> MODULE$.paramToParameterInformation((Signatures.Param)param));
        String paramLists = signature.paramss().forall((Function1 & Serializable)_$16 -> _$16.isEmpty()) && tparams.nonEmpty() ? "" : signature.paramss().map((Function1 & Serializable)paramList -> {
            List labels = paramList.map((Function1 & Serializable)_$17 -> _$17.show());
            String prefix = paramList.exists((Function1 & Serializable)_$18 -> _$18.isImplicit()) ? "using " : "";
            return labels.mkString(prefix, ", ", "");
        }).mkString("(", ")(", ")");
        String tparamsLabel = signature.tparams().isEmpty() ? "" : signature.tparams().mkString("[", ", ", "]");
        String returnTypeLabel = (String)signature.returnType().map((Function1 & Serializable)t -> new java.lang.StringBuilder(2).append(": ").append((String)t).toString()).getOrElse(DottyLanguageServer$::$anonfun$33);
        String label = new java.lang.StringBuilder(0).append(signature.name()).append(tparamsLabel).append(paramLists).append(returnTypeLabel).toString();
        Option documentation = signature.doc().map((Function1 & Serializable)content -> MODULE$.markupContent((String)content));
        SignatureInformation sig = new SignatureInformation(label);
        sig.setParameters(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)paramInfoss).asJava());
        documentation.foreach((Function1)(JProcedure1 & Serializable)_$19 -> sig.setDocumentation(_$19));
        return sig;
    }

    private ParameterInformation paramToParameterInformation(Signatures.Param param) {
        Option documentation = param.doc().map((Function1 & Serializable)content -> MODULE$.markupContent((String)content));
        ParameterInformation info = new ParameterInformation(param.show());
        documentation.foreach((Function1)(JProcedure1 & Serializable)_$20 -> info.setDocumentation(_$20));
        return info;
    }

    private static final SourcePosition $anonfun$24(SourcePosition p$2) {
        return p$2;
    }

    private final DiagnosticSeverity severity$1(int level) {
        int n = level;
        switch (n) {
            case 0: {
                return DiagnosticSeverity.Information;
            }
            case 1: {
                return DiagnosticSeverity.Warning;
            }
            case 2: {
                return DiagnosticSeverity.Error;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private final CompletionItemKind completionItemKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Module(), ctx)) {
            return CompletionItemKind.Module;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor()) {
            return CompletionItemKind.Constructor;
        }
        if (sym.isClass()) {
            return CompletionItemKind.Class;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx)) {
            return CompletionItemKind.Variable;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx)) {
            return CompletionItemKind.Method;
        }
        return CompletionItemKind.Field;
    }

    private final SymbolKind symbolKind$1(Symbols.Symbol sym, Contexts.Context ctx) {
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Package(), ctx)) {
            return SymbolKind.Package;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).isConstructor()) {
            return SymbolKind.Constructor;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Module(), ctx)) {
            return SymbolKind.Module;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).isAllOf(Flags$.MODULE$.EnumCase(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAllOf(Flags$.MODULE$.EnumValue(), ctx)) {
            return SymbolKind.EnumMember;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Enum(), ctx)) {
            return SymbolKind.Enum;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Trait(), ctx)) {
            return SymbolKind.Interface;
        }
        if (sym.isClass()) {
            return SymbolKind.Class;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Mutable(), ctx)) {
            return SymbolKind.Variable;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.Method(), ctx)) {
            return SymbolKind.Method;
        }
        if (Symbols$.MODULE$.toDenot(sym, ctx).is(Flags$.MODULE$.TypeParam(), ctx) || Symbols$.MODULE$.toDenot(sym, ctx).isAbstractOrAliasType()) {
            return SymbolKind.TypeParameter;
        }
        return SymbolKind.Field;
    }

    private final String containerName$1(Contexts.Context ctx$11, Symbols.Symbol sym) {
        Symbols.Symbol owner;
        Symbols.Symbol symbol = owner = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$11).owner(), ctx$11).exists() && Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$11).owner(), ctx$11).isPackageObject(ctx$11) ? Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, ctx$11).owner(), ctx$11).owner() : Symbols$.MODULE$.toDenot(sym, ctx$11).owner();
        if (Symbols$.MODULE$.toDenot(owner, ctx$11).exists() && !Symbols$.MODULE$.toDenot(owner, ctx$11).isEmptyPackage(ctx$11)) {
            return NameOps$.MODULE$.stripModuleClassSuffix(owner.name(ctx$11)).show(ctx$11);
        }
        return null;
    }

    private static final String $anonfun$33() {
        return "";
    }
}

