/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver.worksheet;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.languageserver.DottyLanguageServer;
import dotty.tools.languageserver.DottyLanguageServer$;
import dotty.tools.languageserver.worksheet.Worksheet$;
import dotty.tools.languageserver.worksheet.WorksheetRunOutput$;
import dotty.tools.languageserver.worksheet.WorksheetRunParams;
import dotty.tools.languageserver.worksheet.WorksheetRunResult;
import dotty.tools.languageserver.worksheet.WorksheetRunResult$;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.LinearSeqOps;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

@JsonSegment(value="worksheet")
public interface WorksheetService {
    public static CompletableFuture run$(WorksheetService $this, WorksheetRunParams params) {
        return $this.run(params);
    }

    @JsonRequest
    default public CompletableFuture<WorksheetRunResult> run(WorksheetRunParams params) {
        return ((DottyLanguageServer)this).computeAsync((Function1 & Serializable)cancelChecker -> {
            WorksheetRunResult worksheetRunResult;
            URI uri = new URI(params.textDocument().getUri());
            try {
                InteractiveDriver driver = ((DottyLanguageServer)this).driverFor(uri);
                JProcedure2 & Serializable sendMessage = (JProcedure2 & Serializable)(pos, msg) -> ((DottyLanguageServer)this).client().publishOutput(WorksheetRunOutput$.MODULE$.apply(params.textDocument(), (Range)DottyLanguageServer$.MODULE$.range((SourcePosition)pos).get(), (String)msg));
                this.runWorksheet(driver, uri, (Function2<SourcePosition, String, BoxedUnit>)sendMessage, (CancelChecker)cancelChecker, driver.currentCtx());
                cancelChecker.checkCanceled();
                worksheetRunResult = WorksheetRunResult$.MODULE$.apply(true);
            }
            catch (Throwable throwable) {
                worksheetRunResult = WorksheetRunResult$.MODULE$.apply(false);
            }
            return worksheetRunResult;
        }, false);
    }

    private void runWorksheet(InteractiveDriver driver, URI uri, Function2<SourcePosition, String, BoxedUnit> sendMessage, CancelChecker cancelChecker, Contexts.Context ctx) {
        Option option;
        WorksheetService worksheetService = this;
        synchronized (worksheetService) {
            option = ((LinearSeqOps)driver.openedTrees().apply((Object)uri)).headOption();
        }
        Option treeOpt = option;
        treeOpt.foreach((Function1)(JProcedure1 & Serializable)tree -> Worksheet$.MODULE$.run((SourceTree)tree, this, sendMessage, cancelChecker, ctx));
    }
}

