/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.untpd;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.NameOps$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.decompiler.IDEDecompilerDriver;
import dotty.tools.dotc.interactive.Completion;
import dotty.tools.dotc.interactive.Completion$;
import dotty.tools.dotc.interactive.Interactive;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.interactive.InteractiveDriver$;
import dotty.tools.dotc.interactive.SourceTree;
import dotty.tools.dotc.util.ParsedComment;
import dotty.tools.dotc.util.ParsedComment$;
import dotty.tools.dotc.util.Signatures;
import dotty.tools.dotc.util.Signatures$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.Spans;
import dotty.tools.languageserver.DottyClient;
import dotty.tools.languageserver.DottyLanguageServer;
import dotty.tools.languageserver.DottyLanguageServer$;
import dotty.tools.languageserver.DottyLanguageServer$DottyServerCapabilities$3$;
import dotty.tools.languageserver.Memory$;
import dotty.tools.languageserver.config.ProjectConfig;
import dotty.tools.languageserver.decompiler.TastyDecompilerService;
import dotty.tools.languageserver.worksheet.WorksheetService;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class DottyLanguageServer
implements LanguageServer,
TextDocumentService,
WorkspaceService,
WorksheetService,
TastyDecompilerService {
    private String rootUri;
    private DottyClient myClient;
    private scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> myDrivers;
    private scala.collection.mutable.Map<ProjectConfig, scala.collection.mutable.Set<ProjectConfig>> myDependentProjects;

    public static String IDE_CONFIG_FILE() {
        return DottyLanguageServer$.MODULE$.IDE_CONFIG_FILE();
    }

    public static String RENAME_NO_OVERRIDDEN() {
        return DottyLanguageServer$.MODULE$.RENAME_NO_OVERRIDDEN();
    }

    public static String RENAME_OVERRIDDEN() {
        return DottyLanguageServer$.MODULE$.RENAME_OVERRIDDEN();
    }

    public static String RENAME_OVERRIDDEN_QUESTION() {
        return DottyLanguageServer$.MODULE$.RENAME_OVERRIDDEN_QUESTION();
    }

    public static CompletionItem completionItem(Completion completion, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.completionItem(completion, context);
    }

    public static Option<Diagnostic> diagnostic(dotty.tools.dotc.reporting.Diagnostic diagnostic, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.diagnostic(diagnostic, context);
    }

    public static boolean isTopLevelWrapper(SourceTree sourceTree, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.isTopLevelWrapper(sourceTree, context);
    }

    public static boolean isWorksheetWrapper(SourceTree sourceTree, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.isWorksheetWrapper(sourceTree, context);
    }

    public static boolean isWorksheetWrapper(Symbols.Symbol symbol, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.isWorksheetWrapper(symbol, context);
    }

    public static Option<Location> location(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.location(sourcePosition);
    }

    public static MarkupContent markupContent(String string) {
        return DottyLanguageServer$.MODULE$.markupContent(string);
    }

    public static Option<Range> range(SourcePosition sourcePosition) {
        return DottyLanguageServer$.MODULE$.range(sourcePosition);
    }

    public static SignatureInformation signatureToSignatureInformation(Signatures.Signature signature) {
        return DottyLanguageServer$.MODULE$.signatureToSignatureInformation(signature);
    }

    public static SourcePosition sourcePosition(InteractiveDriver interactiveDriver, URI uRI, Position position) {
        return DottyLanguageServer$.MODULE$.sourcePosition(interactiveDriver, uRI, position);
    }

    public static Option<SymbolInformation> symbolInfo(Symbols.Symbol symbol, SourcePosition sourcePosition, Contexts.Context context) {
        return DottyLanguageServer$.MODULE$.symbolInfo(symbol, sourcePosition, context);
    }

    public DottyClient client() {
        return this.myClient;
    }

    public Map<ProjectConfig, InteractiveDriver> drivers() {
        scala.collection.mutable.Map<ProjectConfig, InteractiveDriver> map;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            if (this.myDrivers == null) {
                if (this.rootUri == null) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"`drivers` cannot be called before `initialize`");
                }
                File configFile = new File(new URI(new StringBuilder(26).append(this.rootUri).append('/').append(".dotty-ide.json").toString()));
                List configs = Predef$.MODULE$.wrapRefArray((Object[])new ObjectMapper().readValue(configFile, ProjectConfig[].class)).toList();
                List defaultFlags = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never"}));
                this.myDrivers = new HashMap();
                configs.foreach((Function1)(JProcedure1 & Serializable)config -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])config.dependencyClasspath);
                    List settings = (List)defaultFlags.$plus$plus((IterableOnce)DottyLanguageServer.updateDeco$2(DottyLanguageServer.updateDeco$2(DottyLanguageServer.updateDeco$2(Predef$.MODULE$.wrapRefArray((Object[])config.compilerArguments).toList()).update("-d", config.classDirectory.getAbsolutePath())).update("-classpath", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)config.classDirectory, ClassTag$.MODULE$.apply(File.class))).mkString(File.pathSeparator))).update("-sourcepath", Predef$.MODULE$.wrapRefArray((Object[])config.sourceDirectories).mkString(File.pathSeparator)));
                    this.myDrivers.update(config, (Object)new InteractiveDriver(settings));
                });
            }
            map = this.myDrivers;
        }
        return map;
    }

    private void restart() {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            BoxedUnit boxedUnit;
            List driverConfigs = (List)this.myDrivers.toList().withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ProjectConfig config = (ProjectConfig)tuple2._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ProjectConfig config = (ProjectConfig)tuple2._1();
                InteractiveDriver driver = (InteractiveDriver)tuple2._2();
                return Tuple3$.MODULE$.apply((Object)config, (Object)new InteractiveDriver(driver.settings()), (Object)driver.openedFiles());
            });
            driverConfigs.withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    ProjectConfig config = (ProjectConfig)tuple3._1();
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                ProjectConfig config = (ProjectConfig)tuple3._1();
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                this.myDrivers.update((Object)config, (Object)driver);
            });
            System.gc();
            driverConfigs.withFilter((Function1 & Serializable)x$1 -> {
                boolean bl;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                    Map opened = (Map)tuple3._3();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                InteractiveDriver driver = (InteractiveDriver)tuple3._2();
                Map opened = (Map)tuple3._3();
                opened.withFilter((Function1 & Serializable)x$1 -> {
                    boolean bl;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        URI uri = (URI)tuple2._1();
                        SourceFile source = (SourceFile)tuple2._2();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    URI uri = (URI)tuple2._1();
                    SourceFile source = (SourceFile)tuple2._2();
                    return driver.run(uri, source);
                });
            });
            if (Memory$.MODULE$.isCritical()) {
                Predef$.MODULE$.println((Object)"WARNING: Insufficient memory to run Scala language server on these projects.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void checkMemory() {
        if (Memory$.MODULE$.isCritical()) {
            CompletableFutures.computeAsync(_$5 -> {
                this.checkMemory$$anonfun$1((CancelChecker)_$5);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ProjectConfig configFor(URI uri) {
        ProjectConfig projectConfig;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            Option config2 = this.drivers().keys().find((Function1 & Serializable)config -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])config.sourceDirectories);
                return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)sourceDir -> new File(uri.getPath()).getCanonicalPath().startsWith(sourceDir.getCanonicalPath()));
            });
            projectConfig = (ProjectConfig)config2.getOrElse(this::configFor$$anonfun$1);
        }
        return projectConfig;
    }

    public InteractiveDriver driverFor(URI uri) {
        return (InteractiveDriver)this.drivers().apply((Object)this.configFor(uri));
    }

    public IDEDecompilerDriver decompilerDriverFor(URI uri, String classPath) {
        IDEDecompilerDriver iDEDecompilerDriver;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            ProjectConfig config = this.configFor(uri);
            List defaultFlags = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-color:never"}));
            Object object = Predef$.MODULE$.refArrayOps((Object[])config.dependencyClasspath);
            List settings = (List)defaultFlags.$plus$plus((IterableOnce)DottyLanguageServer.updateDeco$4(Predef$.MODULE$.wrapRefArray((Object[])config.compilerArguments).toList()).update("-classpath", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)classPath, ClassTag$.MODULE$.apply(Serializable.class))).mkString(File.pathSeparator)));
            iDEDecompilerDriver = new IDEDecompilerDriver(settings);
        }
        return iDEDecompilerDriver;
    }

    public Map<ProjectConfig, Set<ProjectConfig>> dependentProjects() {
        scala.collection.mutable.Map<ProjectConfig, scala.collection.mutable.Set<ProjectConfig>> map;
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            if (this.myDependentProjects == null) {
                scala.collection.immutable.Map idToConfig = ((IterableOnceOps)this.drivers().keys().map((Function1 & Serializable)k -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k.id);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, k);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Set allProjects = this.drivers().keySet();
                this.myDependentProjects = new HashMap().withDefaultValue(Set$.MODULE$.empty());
                allProjects.foreach((Function1)(JProcedure1 & Serializable)project -> DottyLanguageServer.transitiveDependencies$1(idToConfig, project).foreach((Function1 & Serializable)dependency -> (scala.collection.mutable.Set)((Growable)this.myDependentProjects.apply(dependency)).$plus$eq(project)));
            }
            map = this.myDependentProjects;
        }
        return map;
    }

    public void connect(DottyClient client) {
        this.myClient = client;
    }

    public void exit() {
        System.exit(0);
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(new Object());
    }

    public <R> CompletableFuture<R> computeAsync(Function1<CancelChecker, R> fun, boolean synchronize) {
        return CompletableFutures.computeAsync(cancelToken -> {
            Object object;
            if (synchronize) {
                DottyLanguageServer dottyLanguageServer = this;
                synchronized (dottyLanguageServer) {
                    Object object2 = this.computation$1(fun, (CancelChecker)cancelToken);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl6 : MonitorExitStatement: MONITOREXIT : var4_4
                    object = object2;
                }
            } else {
                object = this.computation$1(fun, (CancelChecker)cancelToken);
            }
            return object;
        });
    }

    public boolean computeAsync$default$2() {
        return true;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            LazyRef lazyRef = new LazyRef();
            this.rootUri = params.getRootUri();
            if (this.rootUri == null) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            private class Dotty_tools_languageserver_DottyLanguageServer$DottyServerCapabilities$1
            extends ServerCapabilities {
                private final boolean worksheetRunProvider;
                private final boolean tastyDecompiler;

                public Dotty_tools_languageserver_DottyLanguageServer$DottyServerCapabilities$1(boolean worksheetRunProvider, boolean tastyDecompiler) {
                    this.worksheetRunProvider = worksheetRunProvider;
                    this.tastyDecompiler = tastyDecompiler;
                }

                public boolean worksheetRunProvider() {
                    return this.worksheetRunProvider;
                }

                public boolean tastyDecompiler() {
                    return this.tastyDecompiler;
                }
            }
            Dotty_tools_languageserver_DottyLanguageServer$DottyServerCapabilities$1 c = new Dotty_tools_languageserver_DottyLanguageServer$DottyServerCapabilities$1(DottyLanguageServer.DottyServerCapabilities$2(lazyRef).$lessinit$greater$default$1(), DottyLanguageServer.DottyServerCapabilities$2(lazyRef).$lessinit$greater$default$2());
            c.setTextDocumentSync(TextDocumentSyncKind.Full);
            c.setDocumentHighlightProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setImplementationProvider(Predef$.MODULE$.boolean2Boolean(true));
            c.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(false), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"."}))).asJava()));
            c.setSignatureHelpProvider(new SignatureHelpOptions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"("}))).asJava()));
            CompletableFuture.supplyAsync(() -> this.drivers()).exceptionally(ex -> {
                ex.printStackTrace();
                throw scala.sys.package$.MODULE$.exit(1);
            });
            return new InitializeResult((ServerCapabilities)c);
        }, this.computeAsync$default$2());
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            this.checkMemory();
            TextDocumentItem document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            InteractiveDriver driver = this.driverFor(uri);
            boolean worksheetMode = DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(uri);
            String text = worksheetMode ? DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$wrapWorksheet(document.getText()) : document.getText();
            List diags = driver.run(uri, text);
            this.client().publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1 & Serializable)dia -> DottyLanguageServer$.MODULE$.diagnostic((dotty.tools.dotc.reporting.Diagnostic)dia, DottyLanguageServer.ctx$8(driver)))).asJava()));
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier document = params.getTextDocument();
        URI uri = new URI(document.getUri());
        boolean worksheetMode = DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$isWorksheet(uri);
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            this.checkMemory();
            InteractiveDriver driver = this.driverFor(uri);
            TextDocumentContentChangeEvent change = (TextDocumentContentChangeEvent)params.getContentChanges().get(0);
            if (change.getRange() != null) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"TextDocumentSyncKind.Incremental support is not implemented");
            }
            String text = worksheetMode ? DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$wrapWorksheet(change.getText()) : change.getText();
            List diags = driver.run(uri, text);
            this.client().publishDiagnostics(new PublishDiagnosticsParams(document.getUri(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)diags.flatMap((Function1 & Serializable)dia -> DottyLanguageServer$.MODULE$.diagnostic((dotty.tools.dotc.reporting.Diagnostic)dia, DottyLanguageServer.ctx$9(driver)))).asJava()));
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        DottyLanguageServer dottyLanguageServer = this;
        synchronized (dottyLanguageServer) {
            TextDocumentIdentifier document = params.getTextDocument();
            URI uri = new URI(document.getUri());
            this.driverFor(uri).close(uri);
        }
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            Nil$ nil$;
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            Option option = driver.compilationUnits().get((Object)uri);
            if (option instanceof Some) {
                CompilationUnit unit = (CompilationUnit)((Some)option).value();
                Contexts.FreshContext freshCtx = DottyLanguageServer.ctx$10(driver).fresh().setCompilationUnit(unit);
                nil$ = (List)Completion$.MODULE$.completions(pos, (Contexts.Context)freshCtx)._2();
            } else if (None$.MODULE$.equals(option)) {
                nil$ = package$.MODULE$.Nil();
            } else {
                throw new MatchError((Object)option);
            }
            Nil$ items = nil$;
            return Either.forRight((Object)new CompletionList(false, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)items.map((Function1 & Serializable)completion -> DottyLanguageServer$.MODULE$.completionItem((Completion)completion, DottyLanguageServer.ctx$10(driver)))).asJava()));
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<? extends Location>> definition(TextDocumentPositionParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List path = Interactive$.MODULE$.pathTo((List)driver.openedTrees().apply((Object)uri), pos, DottyLanguageServer.ctx$11(driver));
            List definitions = Interactive$.MODULE$.findDefinitions(path, pos, driver).toList();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)definitions.flatMap((Function1 & Serializable)d -> DottyLanguageServer$.MODULE$.location(d.namePos(DottyLanguageServer.ctx$11(driver))))).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            boolean includeDeclaration = params.getContext().isIncludeDeclaration();
            int includes = Interactive.Include$.Set$.MODULE$.$bar$extension(Interactive.Include$.Set$.MODULE$.$bar$extension(Interactive.Include$.Set$.MODULE$.$bar$extension(Interactive.Include$.Set$.MODULE$.$bar$extension(Interactive.Include$.MODULE$.references(), Interactive.Include$.MODULE$.overriding()), Interactive.Include$.MODULE$.imports()), Interactive.Include$.MODULE$.local()), includeDeclaration ? Interactive.Include$.MODULE$.definitions() : Interactive.Include$.MODULE$.empty());
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List path = Interactive$.MODULE$.pathTo((List)driver.openedTrees().apply((Object)uri), pos, DottyLanguageServer.ctx$12(driver));
            List definitions = Interactive$.MODULE$.findDefinitions(path, pos, driver);
            List originalSymbols = Interactive$.MODULE$.enclosingSourceSymbols(path, pos, DottyLanguageServer.ctx$12(driver));
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)definitions, (Object)originalSymbols);
            List definitions2 = (List)tuple2._1();
            List originalSymbols2 = (List)tuple2._2();
            List<Tuple3<InteractiveDriver, Contexts.Context, List<Symbols.Symbol>>> perProjectInfo = this.inProjectsSeeing(driver, (List<SourceTree>)definitions2, (List<Symbols.Symbol>)originalSymbols2);
            List references = perProjectInfo.flatMap((Function1 & Serializable)x$1 -> DottyLanguageServer.definitions$1(x$1).flatMap((Function1 & Serializable)definition -> {
                String name = NameOps$.MODULE$.sourceModuleName(definition.name(DottyLanguageServer.ctx$13(x$1))).toString();
                List trees = DottyLanguageServer.remoteDriver$2(x$1).sourceTreesContaining(name, DottyLanguageServer.ctx$13(x$1));
                List matches = Interactive$.MODULE$.findTreesMatching(trees, includes, definition, Interactive$.MODULE$.findTreesMatching$default$4(), DottyLanguageServer.ctx$13(x$1));
                return matches.map((Function1 & Serializable)tree -> DottyLanguageServer$.MODULE$.location(tree.namePos(DottyLanguageServer.ctx$13(x$1))));
            })).toList();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqOps)references.flatten(Predef$.MODULE$.$conforms())).distinct()).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.computeAsync(arg_0 -> this.rename$$anonfun$1(params, arg_0), this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            List path = Interactive$.MODULE$.pathTo(uriTrees, pos, DottyLanguageServer.ctx$16(driver));
            List syms = Interactive$.MODULE$.enclosingSourceSymbols(path, pos, DottyLanguageServer.ctx$16(driver));
            int includes = Interactive.Include$.Set$.MODULE$.except$extension(Interactive.Include$.MODULE$.all(), Interactive.Include$.MODULE$.linkedClass());
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)syms.flatMap((Function1 & Serializable)sym -> {
                List refs = Interactive$.MODULE$.findTreesMatching(uriTrees, includes, sym, Interactive$.MODULE$.findTreesMatching$default$4(), DottyLanguageServer.ctx$16(driver));
                return refs.flatMap((Function1 & Serializable)ref -> DottyLanguageServer$.MODULE$.range(ref.namePos(DottyLanguageServer.ctx$16(driver))).map((Function1 & Serializable)nameRange -> new DocumentHighlight(nameRange, DocumentHighlightKind.Read)));
            }).distinct()).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List trees = (List)driver.openedTrees().apply((Object)uri);
            List path = Interactive$.MODULE$.pathTo(trees, pos, DottyLanguageServer.ctx$17(driver));
            Types.Type tp = Interactive$.MODULE$.enclosingType(trees, pos, DottyLanguageServer.ctx$17(driver));
            Types.Type tpw = tp.widenTermRefExpr(DottyLanguageServer.ctx$17(driver));
            if (tp.isError(DottyLanguageServer.ctx$17(driver))) return null;
            Types.Type type = tpw;
            Types.NoType$ noType$ = Types.NoType$.MODULE$;
            if (type == null) {
                if (noType$ == null) return null;
            } else if (type.equals(noType$)) {
                return null;
            }
            List list = Interactive$.MODULE$.enclosingSourceSymbols(path, pos, DottyLanguageServer.ctx$17(driver));
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (nil$ == null) {
                if (list2 == null) return null;
            } else if (nil$.equals(list2)) {
                return null;
            }
            List symbols = list;
            List docComments = symbols.flatMap((Function1 & Serializable)symbol -> ParsedComment$.MODULE$.docOf(symbol, DottyLanguageServer.ctx$17(driver)));
            MarkupContent content = DottyLanguageServer$.MODULE$.dotty$tools$languageserver$DottyLanguageServer$$$hoverContent((Option<String>)Some$.MODULE$.apply((Object)tpw.show(DottyLanguageServer.ctx$17(driver))), (List<ParsedComment>)docComments, DottyLanguageServer.ctx$17(driver));
            Hover hover = new Hover(content, null);
            return hover;
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            List uriTrees = (List)driver.openedTrees().apply((Object)uri);
            Function1 & Serializable excludeParamsFromSyntheticSymbols = (Function1 & Serializable)n -> {
                Symbols.Symbol owner = Symbols$.MODULE$.toDenot(n.symbol(DottyLanguageServer.ctx$18(driver)), DottyLanguageServer.ctx$18(driver)).owner();
                return !Symbols$.MODULE$.toDenot(n.symbol(DottyLanguageServer.ctx$18(driver)), DottyLanguageServer.ctx$18(driver)).is(Flags$.MODULE$.Param(), DottyLanguageServer.ctx$18(driver)) || !Symbols$.MODULE$.toDenot(owner, DottyLanguageServer.ctx$18(driver)).is(Flags$.MODULE$.Synthetic(), DottyLanguageServer.ctx$18(driver)) && !Symbols$.MODULE$.toDenot(owner, DottyLanguageServer.ctx$18(driver)).isPrimaryConstructor(DottyLanguageServer.ctx$18(driver));
            };
            List defs = Interactive$.MODULE$.namedTrees(uriTrees, Interactive.Include$.MODULE$.local(), (Function1)excludeParamsFromSyntheticSymbols, DottyLanguageServer.ctx$18(driver));
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)defs.withFilter((Function1 & Serializable)d -> !DottyLanguageServer$.MODULE$.isWorksheetWrapper((SourceTree)d, DottyLanguageServer.ctx$18(driver)) && !DottyLanguageServer$.MODULE$.isTopLevelWrapper((SourceTree)d, DottyLanguageServer.ctx$18(driver))).flatMap((Function1 & Serializable)d -> DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(DottyLanguageServer.ctx$18(driver)), d.pos(DottyLanguageServer.ctx$18(driver)), DottyLanguageServer.ctx$18(driver)).map((Function1 & Serializable)info -> Either.forLeft((Object)info)))).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            String query = params.getQuery();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.drivers().values().toList().flatMap((Function1 & Serializable)driver -> {
                List trees = driver.sourceTreesContaining(query, DottyLanguageServer.ctx$19(driver));
                List defs = Interactive$.MODULE$.namedTrees(trees, Interactive.Include$.MODULE$.empty(), (Function1 & Serializable)_$10 -> _$10.name().toString().contains(query), DottyLanguageServer.ctx$19(driver));
                return defs.flatMap((Function1 & Serializable)d -> DottyLanguageServer$.MODULE$.symbolInfo(d.tree().symbol(DottyLanguageServer.ctx$19(driver)), d.namePos(DottyLanguageServer.ctx$19(driver)), DottyLanguageServer.ctx$19(driver)));
            })).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<java.util.List<? extends Location>> implementation(TextDocumentPositionParams params) {
        return this.computeAsync((Function1 & Serializable)cancelToken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List path = Interactive$.MODULE$.pathTo((List)driver.openedTrees().apply((Object)uri), pos, DottyLanguageServer.ctx$20(driver));
            List originalSymbols = Interactive$.MODULE$.enclosingSourceSymbols(path, pos, DottyLanguageServer.ctx$20(driver));
            List definitions = Interactive$.MODULE$.findDefinitions(path, pos, driver);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)definitions, (Object)originalSymbols);
            List definitions2 = (List)tuple2._1();
            List originalSymbols2 = (List)tuple2._2();
            List<Tuple3<InteractiveDriver, Contexts.Context, List<Symbols.Symbol>>> perProjectInfo = this.inProjectsSeeing(driver, (List<SourceTree>)definitions2, (List<Symbols.Symbol>)originalSymbols2);
            List implementations = perProjectInfo.flatMap((Function1 & Serializable)x$1 -> {
                List trees = DottyLanguageServer.remoteDriver$4(x$1).sourceTrees(DottyLanguageServer.ctx$21(x$1));
                List predicates = DottyLanguageServer.definitions$3(x$1).map((Function1 & Serializable)_$11 -> Interactive$.MODULE$.implementationFilter(_$11, DottyLanguageServer.ctx$21(x$1)));
                Function1 & Serializable predicate = (Function1 & Serializable)tree -> predicates.exists((Function1 & Serializable)_$12 -> BoxesRunTime.unboxToBoolean((Object)_$12.apply(tree)));
                List matches = Interactive$.MODULE$.namedTrees(trees, Interactive.Include$.MODULE$.local(), (Function1)predicate, DottyLanguageServer.ctx$21(x$1));
                return matches.map((Function1 & Serializable)tree -> DottyLanguageServer$.MODULE$.location(tree.namePos(DottyLanguageServer.ctx$21(x$1))));
            }).toList();
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)implementations.flatten(Predef$.MODULE$.$conforms())).asJava();
        }, this.computeAsync$default$2());
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        return this.computeAsync((Function1 & Serializable)canceltoken -> {
            URI uri = new URI(params.getTextDocument().getUri());
            InteractiveDriver driver = this.driverFor(uri);
            SourcePosition pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params.getPosition());
            List trees = (List)driver.openedTrees().apply((Object)uri);
            List path = (List)Interactive$.MODULE$.pathTo(trees, pos, DottyLanguageServer.ctx$22(driver)).dropWhile((Function1 & Serializable)t -> !(t instanceof Trees.Apply) && !(t instanceof Trees.UnApply));
            Tuple3 tuple3 = Signatures$.MODULE$.callInfo(path, pos.span(), DottyLanguageServer.ctx$22(driver));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int paramN = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int callableN = BoxesRunTime.unboxToInt((Object)tuple3._2());
            List alternatives = (List)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)paramN), (Object)BoxesRunTime.boxToInteger((int)callableN), (Object)alternatives);
            int paramN2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int callableN2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            List alternatives2 = (List)tuple32._3();
            List signatureInfos = alternatives2.flatMap((Function1 & Serializable)denot -> Signatures$.MODULE$.toSignature(denot, DottyLanguageServer.ctx$22(driver)));
            return new SignatureHelp((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)signatureInfos.map((Function1 & Serializable)signature -> DottyLanguageServer$.MODULE$.signatureToSignatureInformation((Signatures.Signature)signature))).asJava(), Predef$.MODULE$.int2Integer(callableN2), Predef$.MODULE$.int2Integer(paramN2));
        }, this.computeAsync$default$2());
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return null;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return null;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens params) {
        return null;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem params) {
        return null;
    }

    private Set<ProjectConfig> projectsSeeing(List<SourceTree> definitions, Contexts.Context ctx) {
        return definitions.isEmpty() ? this.drivers().keySet() : (Set)definitions.toSet().flatMap((Function1 & Serializable)definition -> (IterableOnce)((IterableOps)Option$.MODULE$.option2Iterable(InteractiveDriver$.MODULE$.toUriOption(definition.pos(ctx).source())).toSet().map((Function1 & Serializable)uri -> {
            ProjectConfig config = this.configFor((URI)uri);
            return Tuple2$.MODULE$.apply(uri, (Object)config);
        })).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URI uri = (URI)tuple2._1();
            ProjectConfig config = (ProjectConfig)tuple2._2();
            return (Set)((SetOps)this.dependentProjects().apply((Object)config)).union((Set)scala.collection.Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProjectConfig[]{config}))).map((Function1 & Serializable)project -> project);
        }));
    }

    private List<Tuple3<InteractiveDriver, Contexts.Context, List<Symbols.Symbol>>> inProjectsSeeing(InteractiveDriver baseDriver, List<SourceTree> definitions, List<Symbols.Symbol> symbols) {
        Set<ProjectConfig> projects = this.projectsSeeing(definitions, baseDriver.currentCtx());
        return projects.toList().map((Function1 & Serializable)config -> {
            InteractiveDriver remoteDriver = (InteractiveDriver)this.drivers().apply(config);
            Contexts.Context ctx = remoteDriver.currentCtx();
            List definitions = symbols.map((Function1 & Serializable)_$13 -> Interactive$.MODULE$.localize(_$13, baseDriver, remoteDriver));
            return Tuple3$.MODULE$.apply((Object)remoteDriver, (Object)ctx, (Object)definitions);
        });
    }

    private <T> CompletableFuture<Option<T>> showMessageRequest(MessageType tpe, String message2, List<Tuple2<String, Function0<T>>> choices) {
        List options = choices.map((Function1 & Serializable)x$1 -> new MessageActionItem(DottyLanguageServer.title$1(x$1)));
        ShowMessageRequestParams request = new ShowMessageRequestParams((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)options).asJava());
        request.setMessage(message2);
        request.setType(tpe);
        return this.client().showMessageRequest(request).thenApply(message -> Option$.MODULE$.apply(message).flatMap((Function1 & Serializable)answer -> choices.find((Function1 & Serializable)_$15 -> {
            Object object = _$15._1();
            String string = answer.getTitle();
            return !(object != null ? !object.equals(string) : string != null);
        }).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Function0 action = (Function0)tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Function0 action = (Function0)tuple2._2();
            return action.apply();
        })));
    }

    private static final updateDeco.1 updateDeco$2(List ss) {
        private class Dotty_tools_languageserver_DottyLanguageServer$updateDeco$1 {
            private final List ss;

            public Dotty_tools_languageserver_DottyLanguageServer$updateDeco$1(List ss) {
                this.ss = ss;
            }

            public List update(String pathKind, String pathInfo) {
                int idx = this.ss.indexOf((Object)pathKind);
                List ss1 = idx >= 0 ? (List)this.ss.take(idx).$plus$plus((IterableOnce)this.ss.drop(idx + 2)) : this.ss;
                return (List)ss1.$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{pathKind, pathInfo})));
            }
        }
        return new Dotty_tools_languageserver_DottyLanguageServer$updateDeco$1(ss);
    }

    private final /* synthetic */ void checkMemory$$anonfun$1(CancelChecker _$5) {
        this.restart();
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectConfig configFor$$anonfun$1() {
        void var1_1;
        ProjectConfig config = (ProjectConfig)this.drivers().keys().head();
        return var1_1;
    }

    private static final updateDeco.3 updateDeco$4(List ss) {
        private class Dotty_tools_languageserver_DottyLanguageServer$updateDeco$3 {
            private final List ss;

            public Dotty_tools_languageserver_DottyLanguageServer$updateDeco$3(List ss) {
                this.ss = ss;
            }

            public List update(String pathKind, String pathInfo) {
                int idx = this.ss.indexOf((Object)pathKind);
                List ss1 = idx >= 0 ? (List)this.ss.take(idx).$plus$plus((IterableOnce)this.ss.drop(idx + 2)) : this.ss;
                return (List)ss1.$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{pathKind, pathInfo})));
            }
        }
        return new Dotty_tools_languageserver_DottyLanguageServer$updateDeco$3(ss);
    }

    private static final Set transitiveDependencies$1(scala.collection.immutable.Map idToConfig$1, ProjectConfig config2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])config2.projectDependencies);
        scala.collection.immutable.Set dependencies = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)key -> idToConfig$1.get(key), ClassTag$.MODULE$.apply(ProjectConfig.class))).toSet();
        return (Set)dependencies.$plus$plus((IterableOnce)dependencies.flatMap((Function1 & Serializable)config -> DottyLanguageServer.transitiveDependencies$1(idToConfig$1, config)));
    }

    private final Object computation$1(Function1 fun$1, CancelChecker cancelToken$1) {
        Object object;
        cancelToken$1.checkCanceled();
        this.checkMemory();
        try {
            object = fun$1.apply((Object)cancelToken$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                ex.printStackTrace();
                throw ex;
            }
            throw throwable;
        }
        return object;
    }

    private static final DottyLanguageServer$DottyServerCapabilities$3$ DottyServerCapabilities$lzyINIT1$1(LazyRef DottyServerCapabilities$lzy1$1) {
        DottyLanguageServer$DottyServerCapabilities$3$ dottyLanguageServer$DottyServerCapabilities$3$;
        LazyRef lazyRef = DottyServerCapabilities$lzy1$1;
        synchronized (lazyRef) {
            dottyLanguageServer$DottyServerCapabilities$3$ = (DottyLanguageServer$DottyServerCapabilities$3$)(DottyServerCapabilities$lzy1$1.initialized() ? DottyServerCapabilities$lzy1$1.value() : DottyServerCapabilities$lzy1$1.initialize((Object)new DottyLanguageServer$DottyServerCapabilities$3$()));
        }
        return dottyLanguageServer$DottyServerCapabilities$3$;
    }

    private static final DottyLanguageServer$DottyServerCapabilities$3$ DottyServerCapabilities$2(LazyRef DottyServerCapabilities$lzy1$2) {
        return (DottyLanguageServer$DottyServerCapabilities$3$)(DottyServerCapabilities$lzy1$2.initialized() ? DottyServerCapabilities$lzy1$2.value() : DottyLanguageServer.DottyServerCapabilities$lzyINIT1$1(DottyServerCapabilities$lzy1$2));
    }

    private static final Contexts.Context ctx$8(InteractiveDriver driver$2) {
        return driver$2.currentCtx();
    }

    private static final Contexts.Context ctx$9(InteractiveDriver driver$3) {
        return driver$3.currentCtx();
    }

    private static final Contexts.Context ctx$10(InteractiveDriver driver$4) {
        return driver$4.currentCtx();
    }

    private static final Contexts.Context ctx$11(InteractiveDriver driver$5) {
        return driver$5.currentCtx();
    }

    private static final Contexts.Context ctx$12(InteractiveDriver driver$6) {
        return driver$6.currentCtx();
    }

    private static final InteractiveDriver remoteDriver$2(Tuple3 x$1$1) {
        return (InteractiveDriver)x$1$1._1();
    }

    private static final Contexts.Context ctx$13(Tuple3 x$1$2) {
        return (Contexts.Context)x$1$2._2();
    }

    private static final List definitions$1(Tuple3 x$1$3) {
        return (List)x$1$3._3();
    }

    private static final Contexts.Context ctx$14(InteractiveDriver driver$7) {
        return driver$7.currentCtx();
    }

    private static final List findRenamedReferences$1(InteractiveDriver driver$23, List trees, List syms, Names.Name withName) {
        int includes = Interactive.Include$.MODULE$.all();
        return syms.flatMap((Function1 & Serializable)sym -> Interactive$.MODULE$.findTreesMatching(trees, Interactive.Include$.MODULE$.all(), sym, (Function1 & Serializable)t -> Interactive$.MODULE$.sameName(t.name(), withName), DottyLanguageServer.ctx$14(driver$23)));
    }

    private static final /* synthetic */ boolean $anonfun$7(InteractiveDriver driver$24, Symbols.Symbol _$6) {
        return Symbols$.MODULE$.toDenot(_$6, DottyLanguageServer.ctx$14(driver$24)).allOverriddenSymbols(DottyLanguageServer.ctx$14(driver$24)).nonEmpty();
    }

    private static final /* synthetic */ Tuple2 $anonfun$8(InteractiveDriver driver$9, List syms$1) {
        return Tuple2$.MODULE$.apply((Object)new Interactive.Include$.Set(Interactive.Include$.MODULE$.all()), (Object)syms$1.flatMap((Function1 & Serializable)s -> Symbols$.MODULE$.toDenot(s, DottyLanguageServer.ctx$14(driver$9)).allOverriddenSymbols(DottyLanguageServer.ctx$14(driver$9)).toList().$colon$colon(s)));
    }

    private static final /* synthetic */ Tuple2 $anonfun$9(List syms$2) {
        return Tuple2$.MODULE$.apply((Object)new Interactive.Include$.Set(Interactive.Include$.Set$.MODULE$.except$extension(Interactive.Include$.MODULE$.all(), Interactive.Include$.MODULE$.overridden())), (Object)syms$2);
    }

    private static final Tuple2 $anonfun$10() {
        return Tuple2$.MODULE$.apply((Object)new Interactive.Include$.Set(Interactive.Include$.MODULE$.empty()), (Object)package$.MODULE$.Nil());
    }

    private static final /* synthetic */ Names.TermName $anonfun$11(InteractiveDriver driver$26, Symbols.Symbol _$7) {
        return NameOps$.MODULE$.sourceModuleName(_$7.name(DottyLanguageServer.ctx$14(driver$26)));
    }

    private static final InteractiveDriver remoteDriver$3(Tuple3 x$1$5) {
        return (InteractiveDriver)x$1$5._1();
    }

    private static final Contexts.Context ctx$15(Tuple3 x$1$6) {
        return (Contexts.Context)x$1$6._2();
    }

    private static final List definitions$2(Tuple3 x$1$7) {
        return (List)x$1$7._3();
    }

    private static final /* synthetic */ IterableOnce $anonfun$12(int include$1, scala.collection.immutable.Set names$1, Tuple3 x$1) {
        return DottyLanguageServer.definitions$2(x$1).flatMap((Function1 & Serializable)definition -> {
            String name = NameOps$.MODULE$.sourceModuleName(definition.name(DottyLanguageServer.ctx$15(x$1))).toString();
            List trees = DottyLanguageServer.remoteDriver$3(x$1).sourceTreesContaining(name, DottyLanguageServer.ctx$15(x$1));
            return Interactive$.MODULE$.findTreesMatching(trees, include$1, definition, (Function1 & Serializable)t -> names$1.exists((Function1 & Serializable)_$8 -> Interactive$.MODULE$.sameName(t.name(), (Names.Name)_$8)), DottyLanguageServer.ctx$15(x$1));
        });
    }

    private static final /* synthetic */ Option $anonfun$13(SourceTree ref) {
        return InteractiveDriver$.MODULE$.toUriOption(ref.source());
    }

    private static final /* synthetic */ Option $anonfun$14(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option uriOpt = (Option)tuple2._1();
        List refs = (List)tuple2._2();
        return uriOpt.map((Function1 & Serializable)uri -> Tuple2$.MODULE$.apply((Object)uri.toString(), (Object)refs));
    }

    private static final /* synthetic */ java.util.List $anonfun$15(InteractiveDriver driver$10, String newName$1, String _$9, List refs) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)refs.flatMap((Function1 & Serializable)ref -> DottyLanguageServer$.MODULE$.range(ref.namePos(DottyLanguageServer.ctx$14(driver$10))).map((Function1 & Serializable)nameRange -> new TextEdit(nameRange, newName$1))).distinct()).asJava();
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ WorkspaceEdit rename$$anonfun$1(RenameParams params$5, CancelChecker cancelToken) {
        block6: {
            block5: {
                uri = new URI(params$5.getTextDocument().getUri());
                driver = this.driverFor(uri);
                uriTrees = (List)driver.openedTrees().apply((Object)uri);
                pos = DottyLanguageServer$.MODULE$.sourcePosition(driver, uri, params$5.getPosition());
                path = Interactive$.MODULE$.pathTo(uriTrees, pos, DottyLanguageServer.ctx$14(driver));
                syms = Interactive$.MODULE$.enclosingSourceSymbols(path, pos, DottyLanguageServer.ctx$14(driver));
                newName = params$5.getNewName();
                var11_10 = path;
                if (!(var11_10 instanceof .colon.colon)) ** GOTO lbl-1000
                var12_11 = (.colon.colon)var11_10;
                var13_12 = (Trees.Tree)var12_11.head();
                var14_13 = var12_11.next$access$1();
                if (!(var13_12 instanceof untpd.ImportSelector)) break block5;
                var15_14 = untpd.ImportSelector$.MODULE$.unapply((untpd.ImportSelector)var13_12);
                var16_15 = var15_14._1();
                var17_16 = var15_14._2();
                var18_17 = var15_14._3();
                if (!(var17_16 instanceof Trees.Ident)) break block5;
                rename = (Trees.Ident)var17_16;
                if (!(var14_13 instanceof .colon.colon)) break block5;
                var20_19 = (.colon.colon)var14_13;
                var21_20 = var20_19.next$access$1();
                if (!(var20_19.head() instanceof Trees.Import)) break block5;
                rest = var21_20;
                if (!Spans.Span$.MODULE$.contains$extension(rename.span(), pos.span())) break block5;
                v0 = DottyLanguageServer.findRenamedReferences$1(driver, uriTrees, syms, rename.name());
                break block6;
            }
            if (!(var13_12 instanceof Trees.NameTree)) ** GOTO lbl-1000
            nameTree = (Trees.NameTree)var13_12;
            rest = var14_13;
            if (Interactive$.MODULE$.isRenamed(nameTree, DottyLanguageServer.ctx$14(driver))) {
                v0 = DottyLanguageServer.findRenamedReferences$1(driver, uriTrees, syms, nameTree.name());
            } else lbl-1000:
            // 3 sources

            {
                if (syms.exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(dotty.tools.dotc.interactive.InteractiveDriver dotty.tools.dotc.core.Symbols$Symbol ), (Ldotty/tools/dotc/core/Symbols$Symbol;)Z)((InteractiveDriver)driver))) {
                    v1 = new Tuple2[2];
                    var27_24 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Rename the base member");
                    v1[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var27_24, (Object)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(dotty.tools.dotc.interactive.InteractiveDriver scala.collection.immutable.List ), ()Lscala/Tuple2;)((InteractiveDriver)driver, (List)syms));
                    var28_25 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Rename only this member");
                    v1[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var28_25, (Object)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$9(scala.collection.immutable.List ), ()Lscala/Tuple2;)((List)syms));
                    v2 = (Tuple2)this.showMessageRequest(MessageType.Info, "Do you want to rename the base member, or only this member?", (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(v1))).get().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$10(), ()Lscala/Tuple2;)());
                } else {
                    v2 = var26_26 = Tuple2$.MODULE$.apply((Object)new Interactive.Include$.Set(Interactive.Include$.MODULE$.all()), (Object)syms);
                }
                if (var26_26 == null) {
                    throw new MatchError((Object)var26_26);
                }
                include = var26_26._1() == null ? BoxesRunTime.unboxToInt(null) : ((Interactive.Include$.Set)var26_26._1()).bits();
                allSymbols = (List)var26_26._2();
                var25_29 = Tuple2$.MODULE$.apply((Object)new Interactive.Include$.Set(include), (Object)allSymbols);
                include = var25_29._1() == null ? BoxesRunTime.unboxToInt(null) : ((Interactive.Include$.Set)var25_29._1()).bits();
                allSymbols = (List)var25_29._2();
                names = allSymbols.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$11(dotty.tools.dotc.interactive.InteractiveDriver dotty.tools.dotc.core.Symbols$Symbol ), (Ldotty/tools/dotc/core/Symbols$Symbol;)Ldotty/tools/dotc/core/Names$TermName;)((InteractiveDriver)driver)).toSet();
                definitions = Interactive$.MODULE$.findDefinitions(allSymbols, driver, Interactive.Include$.Set$.MODULE$.isOverridden$extension(include), true);
                perProjectInfo = this.inProjectsSeeing(driver, (List<SourceTree>)definitions, (List<Symbols.Symbol>)allSymbols);
                v0 = perProjectInfo.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$12(int scala.collection.immutable.Set scala.Tuple3 ), (Lscala/Tuple3;)Lscala/collection/IterableOnce;)((int)include, (scala.collection.immutable.Set)names));
            }
        }
        refs = v0;
        changes = (scala.collection.immutable.Map)((MapOps)refs.groupBy((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$13(dotty.tools.dotc.interactive.SourceTree ), (Ldotty/tools/dotc/interactive/SourceTree;)Lscala/Option;)()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$14(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Option;)())).transform((Function2)(Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$15(dotty.tools.dotc.interactive.InteractiveDriver java.lang.String java.lang.String scala.collection.immutable.List ), (Ljava/lang/String;Lscala/collection/immutable/List;)Ljava/util/List;)((InteractiveDriver)driver, (String)newName));
        return new WorkspaceEdit((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)changes).asJava());
    }

    private static final Contexts.Context ctx$16(InteractiveDriver driver$12) {
        return driver$12.currentCtx();
    }

    private static final Contexts.Context ctx$17(InteractiveDriver driver$14) {
        return driver$14.currentCtx();
    }

    private static final Contexts.Context ctx$18(InteractiveDriver driver$15) {
        return driver$15.currentCtx();
    }

    private static final Contexts.Context ctx$19(InteractiveDriver driver$16) {
        return driver$16.currentCtx();
    }

    private static final Contexts.Context ctx$20(InteractiveDriver driver$17) {
        return driver$17.currentCtx();
    }

    private static final InteractiveDriver remoteDriver$4(Tuple3 x$1$9) {
        return (InteractiveDriver)x$1$9._1();
    }

    private static final Contexts.Context ctx$21(Tuple3 x$1$10) {
        return (Contexts.Context)x$1$10._2();
    }

    private static final List definitions$3(Tuple3 x$1$11) {
        return (List)x$1$11._3();
    }

    private static final Contexts.Context ctx$22(InteractiveDriver driver$18) {
        return driver$18.currentCtx();
    }

    private static final String title$1(Tuple2 x$1$12) {
        return (String)x$1$12._1();
    }

    private static final Function0 _$14$1(Tuple2 x$1$13) {
        return (Function0)x$1$13._2();
    }
}

