/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dottydoc;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.config.CompilerCommand$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Comments$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.util.SrcPos;
import dotty.tools.dottydoc.DocCompiler;
import dotty.tools.dottydoc.core.ContextDottydoc;
import dotty.tools.dottydoc.staticsite.Site;
import dotty.tools.dottydoc.staticsite.Site$;
import dotty.tools.dottydoc.util.syntax$;
import dotty.tools.dottydoc.util.syntax$ContextWithContextDottydoc$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JFunction1;

public class DocDriver
extends Driver {
    public Tuple2<List<String>, Contexts.Context> setup(String[] args, Contexts.Context rootCtx) {
        Contexts.FreshContext ctx = rootCtx.fresh();
        Settings.ArgsSummary summary = CompilerCommand$.MODULE$.distill(args, (Contexts.Context)ctx);
        ctx.setSettings(summary.sstate());
        ctx.setSetting(ctx.settings().YcookComments(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        ctx.setProperty(Comments$.MODULE$.ContextDoc(), (Object)new ContextDottydoc());
        List fileNames = CompilerCommand$.MODULE$.checkUsage(summary, this.sourcesRequired(), (Contexts.Context)ctx);
        return this.fromTastySetup(fileNames, (Contexts.Context)ctx);
    }

    public Compiler newCompiler(Contexts.Context x$1) {
        return new DocCompiler();
    }

    public Reporter process(String[] args, Contexts.Context rootCtx) {
        Contexts.Context ictx;
        Tuple2<List<String>, Contexts.Context> tuple2 = this.setup(args, (Contexts.Context)this.initCtx().fresh());
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<List<String>, Contexts.Context> tuple22 = tuple2;
        List filesToDocument = (List)tuple22._1();
        Contexts.Context ictx2 = (Contexts.Context)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)filesToDocument, (Object)ictx2);
        List filesToDocument2 = (List)tuple23._1();
        Contexts.Context ctx = ictx = (Contexts.Context)tuple23._2();
        Reporter reporter = this.doCompile(this.newCompiler(ctx), filesToDocument2, ctx);
        File siteRoot = new File((String)Settings.Setting$.MODULE$.value(ctx.settings().siteRoot(), ctx));
        String projectName = (String)Settings.Setting$.MODULE$.value(ctx.settings().projectName(), ctx);
        String projectVersion = (String)Settings.Setting$.MODULE$.value(ctx.settings().projectVersion(), ctx);
        Option projectUrl = Option$.MODULE$.apply(Settings.Setting$.MODULE$.value(ctx.settings().projectUrl(), ctx)).filter((Function1)(JFunction1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1)));
        Option projectLogo = Option$.MODULE$.apply(Settings.Setting$.MODULE$.value(ctx.settings().projectLogo(), ctx)).filter((Function1)(JFunction1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2)));
        boolean docSnapshot = BoxesRunTime.unboxToBoolean((Object)Settings.Setting$.MODULE$.value(ctx.settings().docSnapshot(), ctx));
        String baseUrl = "";
        File outDir = new File(siteRoot, "_site");
        String snapshotFolderName = projectVersion.endsWith("NIGHTLY") ? "nightly" : projectVersion;
        File snapshotOutDir = new File(outDir, snapshotFolderName);
        String snapshotBaseUrl = "" + baseUrl + "/" + snapshotFolderName;
        if (projectName.isEmpty()) {
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation(DocDriver::process$$anonfun$1), (SrcPos)report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), ctx);
        } else if (!siteRoot.exists()) {
            report$.MODULE$.echo(() -> DocDriver.process$$anonfun$2(siteRoot), (SrcPos)report$.MODULE$.echo$default$2(), ctx);
        } else if (!siteRoot.isDirectory()) {
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> DocDriver.process$$anonfun$3(siteRoot)), (SrcPos)report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), ctx);
        } else {
            DocDriver.generateSite$1(ctx, siteRoot, projectName, projectVersion, projectUrl, projectLogo, outDir, baseUrl);
            if (docSnapshot) {
                DocDriver.generateSite$1(ctx, siteRoot, projectName, projectVersion, projectUrl, projectLogo, snapshotOutDir, snapshotBaseUrl);
            }
            syntax$ContextWithContextDottydoc$.MODULE$.docbase$extension(syntax$.MODULE$.ContextWithContextDottydoc(ctx)).printSummary(ctx);
        }
        return reporter;
    }

    private static final String process$$anonfun$1() {
        return "Site project name not set. Use `-project <title>` to set the project name";
    }

    private static final String process$$anonfun$2(File siteRoot$1) {
        return "Site root (`-siteroot`) does not exist: " + siteRoot$1 + ", no documentation will be generated.";
    }

    private static final String process$$anonfun$3(File siteRoot$2) {
        return "Site root (`-siteroot`) is not a directory: " + siteRoot$2;
    }

    private static final Site generateSite$1(Contexts.Context ctx$1, File siteRoot$3, String projectName$1, String projectVersion$1, Option projectUrl$1, Option projectLogo$1, File outDir, String baseUrl) {
        return Site$.MODULE$.apply(siteRoot$3, outDir, projectName$1, projectVersion$1, (Option<String>)projectUrl$1, (Option<String>)projectLogo$1, syntax$ContextWithContextDottydoc$.MODULE$.docbase$extension(syntax$.MODULE$.ContextWithContextDottydoc(ctx$1)).packages(), baseUrl).generateApiDocs(ctx$1).copyStaticFiles(ctx$1).generateHtmlFiles(ctx$1).generateBlog(ctx$1);
    }
}

