/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File;
import dotty.tools.io.FileExtension;
import dotty.tools.io.Path;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4$;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StringOps$;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public abstract class AbstractFile
implements Iterable<AbstractFile> {
    private final FileExtension ext;

    public static AbstractFile getDirectory(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(Path path) {
        return AbstractFile$.MODULE$.getDirectory(path);
    }

    public static AbstractFile getDirectory(String string) {
        return AbstractFile$.MODULE$.getDirectory(string);
    }

    public static AbstractFile getFile(java.nio.file.Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(Path path) {
        return AbstractFile$.MODULE$.getFile(path);
    }

    public static AbstractFile getFile(String string) {
        return AbstractFile$.MODULE$.getFile(string);
    }

    public static AbstractFile getResources(URL uRL) {
        return AbstractFile$.MODULE$.getResources(uRL);
    }

    public static AbstractFile getURL(URL uRL) {
        return AbstractFile$.MODULE$.getURL(uRL);
    }

    public AbstractFile() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        this.ext = Path$.MODULE$.fileExtension(this.name());
    }

    public <S extends Stepper<?>> S stepper(StepperShape<AbstractFile, S> shape) {
        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
    }

    public int knownSize() {
        return IterableOnce.knownSize$((IterableOnce)this);
    }

    public boolean hasDefiniteSize() {
        return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
    }

    public <U> void foreach(Function1<AbstractFile, U> f) {
        IterableOnceOps.foreach$((IterableOnceOps)this, f);
    }

    public boolean forall(Function1<AbstractFile, Object> p) {
        return IterableOnceOps.forall$((IterableOnceOps)this, p);
    }

    public boolean exists(Function1<AbstractFile, Object> p) {
        return IterableOnceOps.exists$((IterableOnceOps)this, p);
    }

    public int count(Function1<AbstractFile, Object> p) {
        return IterableOnceOps.count$((IterableOnceOps)this, p);
    }

    public Option<AbstractFile> find(Function1<AbstractFile, Object> p) {
        return IterableOnceOps.find$((IterableOnceOps)this, p);
    }

    public <B> B foldLeft(B z, Function2<B, AbstractFile, B> op) {
        return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
    }

    public <B> B foldRight(B z, Function2<AbstractFile, B, B> op) {
        return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
    }

    public final <B> B $div$colon(B z, Function2<B, AbstractFile, B> op) {
        return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
    }

    public final <B> B $colon$bslash(B z, Function2<AbstractFile, B, B> op) {
        return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
    }

    public <B> B reduce(Function2<B, B, B> op) {
        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
    }

    public <B> B reduceLeft(Function2<B, AbstractFile, B> op) {
        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
    }

    public <B> B reduceRight(Function2<AbstractFile, B, B> op) {
        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, AbstractFile, B> op) {
        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<AbstractFile, B, B> op) {
        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
    }

    public boolean isEmpty() {
        return IterableOnceOps.isEmpty$((IterableOnceOps)this);
    }

    public boolean nonEmpty() {
        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
    }

    public int size() {
        return IterableOnceOps.size$((IterableOnceOps)this);
    }

    public final <B> void copyToBuffer(Buffer<B> dest) {
        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
    }

    public <B> int copyToArray(Object xs) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
    }

    public <B> int copyToArray(Object xs, int start) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
    }

    public <B> int copyToArray(Object xs, int start, int len) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
    }

    public Object min(Ordering ord) {
        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<AbstractFile> minOption(Ordering<B> ord) {
        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
    }

    public Object max(Ordering ord) {
        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<AbstractFile> maxOption(Ordering<B> ord) {
        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
    }

    public Object maxBy(Function1 f, Ordering ord) {
        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
    }

    public <B> Option<AbstractFile> maxByOption(Function1<AbstractFile, B> f, Ordering<B> ord) {
        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
    }

    public Object minBy(Function1 f, Ordering ord) {
        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
    }

    public <B> Option<AbstractFile> minByOption(Function1<AbstractFile, B> f, Ordering<B> ord) {
        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
    }

    public <B> Option<B> collectFirst(PartialFunction<AbstractFile, B> pf) {
        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, AbstractFile, B> seqop, Function2<B, B, B> combop) {
        return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
    }

    public <B> boolean corresponds(IterableOnce<B> that, Function2<AbstractFile, B, Object> p) {
        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
    }

    public final String mkString(String start, String sep, String end) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
    }

    public final String mkString(String sep) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
    }

    public final String mkString() {
        return IterableOnceOps.mkString$((IterableOnceOps)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public final StringBuilder addString(StringBuilder b, String sep) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
    }

    public final StringBuilder addString(StringBuilder b) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
    }

    public <C1> C1 to(Factory<AbstractFile, C1> factory) {
        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
    }

    public final Iterator<AbstractFile> toIterator() {
        return IterableOnceOps.toIterator$((IterableOnceOps)this);
    }

    public List<AbstractFile> toList() {
        return IterableOnceOps.toList$((IterableOnceOps)this);
    }

    public Vector<AbstractFile> toVector() {
        return IterableOnceOps.toVector$((IterableOnceOps)this);
    }

    public <K, V> Map<K, V> toMap(.less.colon.less<AbstractFile, Tuple2<K, V>> ev) {
        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
    }

    public <B> Set<B> toSet() {
        return IterableOnceOps.toSet$((IterableOnceOps)this);
    }

    public Seq<AbstractFile> toSeq() {
        return IterableOnceOps.toSeq$((IterableOnceOps)this);
    }

    public IndexedSeq<AbstractFile> toIndexedSeq() {
        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
    }

    public final Stream<AbstractFile> toStream() {
        return IterableOnceOps.toStream$((IterableOnceOps)this);
    }

    public final <B> Buffer<B> toBuffer() {
        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
    }

    public <B> Object toArray(ClassTag<B> evidence$2) {
        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
    }

    public Iterable<AbstractFile> reversed() {
        return IterableOnceOps.reversed$((IterableOnceOps)this);
    }

    public final Iterable<AbstractFile> toTraversable() {
        return IterableOps.toTraversable$((IterableOps)this);
    }

    public boolean isTraversableAgain() {
        return IterableOps.isTraversableAgain$((IterableOps)this);
    }

    public final Object repr() {
        return IterableOps.repr$((IterableOps)this);
    }

    public IterableFactory<Iterable> companion() {
        return IterableOps.companion$((IterableOps)this);
    }

    public Object head() {
        return IterableOps.head$((IterableOps)this);
    }

    public Option<AbstractFile> headOption() {
        return IterableOps.headOption$((IterableOps)this);
    }

    public Object last() {
        return IterableOps.last$((IterableOps)this);
    }

    public Option<AbstractFile> lastOption() {
        return IterableOps.lastOption$((IterableOps)this);
    }

    public View<AbstractFile> view() {
        return IterableOps.view$((IterableOps)this);
    }

    public int sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public final IterableOps sizeIs() {
        return IterableOps.sizeIs$((IterableOps)this);
    }

    public int sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public View<AbstractFile> view(int from, int until) {
        return IterableOps.view$((IterableOps)this, (int)from, (int)until);
    }

    public Object transpose(Function1 asIterable) {
        return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
    }

    public Object filter(Function1 pred) {
        return IterableOps.filter$((IterableOps)this, (Function1)pred);
    }

    public Object filterNot(Function1 pred) {
        return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
    }

    public WithFilter<AbstractFile, Iterable> withFilter(Function1<AbstractFile, Object> p) {
        return IterableOps.withFilter$((IterableOps)this, p);
    }

    public Tuple2<Iterable<AbstractFile>, Iterable<AbstractFile>> partition(Function1<AbstractFile, Object> p) {
        return IterableOps.partition$((IterableOps)this, p);
    }

    public Tuple2<Iterable<AbstractFile>, Iterable<AbstractFile>> splitAt(int n) {
        return IterableOps.splitAt$((IterableOps)this, (int)n);
    }

    public Object take(int n) {
        return IterableOps.take$((IterableOps)this, (int)n);
    }

    public Object takeRight(int n) {
        return IterableOps.takeRight$((IterableOps)this, (int)n);
    }

    public Object takeWhile(Function1 p) {
        return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
    }

    public Tuple2<Iterable<AbstractFile>, Iterable<AbstractFile>> span(Function1<AbstractFile, Object> p) {
        return IterableOps.span$((IterableOps)this, p);
    }

    public Object drop(int n) {
        return IterableOps.drop$((IterableOps)this, (int)n);
    }

    public Object dropRight(int n) {
        return IterableOps.dropRight$((IterableOps)this, (int)n);
    }

    public Object dropWhile(Function1 p) {
        return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
    }

    public Iterator<Iterable<AbstractFile>> grouped(int size) {
        return IterableOps.grouped$((IterableOps)this, (int)size);
    }

    public Iterator<Iterable<AbstractFile>> sliding(int size) {
        return IterableOps.sliding$((IterableOps)this, (int)size);
    }

    public Iterator<Iterable<AbstractFile>> sliding(int size, int step) {
        return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
    }

    public Object tail() {
        return IterableOps.tail$((IterableOps)this);
    }

    public Object init() {
        return IterableOps.init$((IterableOps)this);
    }

    public Object slice(int from, int until) {
        return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
    }

    public <K> Map<K, Iterable<AbstractFile>> groupBy(Function1<AbstractFile, K> f) {
        return IterableOps.groupBy$((IterableOps)this, f);
    }

    public <K, B> Map<K, Iterable<B>> groupMap(Function1<AbstractFile, K> key, Function1<AbstractFile, B> f) {
        return IterableOps.groupMap$((IterableOps)this, key, f);
    }

    public <K, B> Map<K, B> groupMapReduce(Function1<AbstractFile, K> key, Function1<AbstractFile, B> f, Function2<B, B, B> reduce) {
        return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
    }

    public Object scan(Object z, Function2 op) {
        return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object scanLeft(Object z, Function2 op) {
        return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object scanRight(Object z, Function2 op) {
        return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object map(Function1 f) {
        return IterableOps.map$((IterableOps)this, (Function1)f);
    }

    public Object flatMap(Function1 f) {
        return IterableOps.flatMap$((IterableOps)this, (Function1)f);
    }

    public Object flatten(Function1 asIterable) {
        return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
    }

    public Object collect(PartialFunction pf) {
        return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<AbstractFile, Either<A1, A2>> f) {
        return IterableOps.partitionMap$((IterableOps)this, f);
    }

    public Object concat(IterableOnce suffix) {
        return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
    }

    public final Object $plus$plus(IterableOnce suffix) {
        return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
    }

    public Object zip(IterableOnce that) {
        return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
    }

    public Object zipWithIndex() {
        return IterableOps.zipWithIndex$((IterableOps)this);
    }

    public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
        return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<AbstractFile, Tuple2<A1, A2>> asPair) {
        return IterableOps.unzip$((IterableOps)this, asPair);
    }

    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<AbstractFile, Tuple3<A1, A2, A3>> asTriple) {
        return IterableOps.unzip3$((IterableOps)this, asTriple);
    }

    public Iterator<Iterable<AbstractFile>> tails() {
        return IterableOps.tails$((IterableOps)this);
    }

    public Iterator<Iterable<AbstractFile>> inits() {
        return IterableOps.inits$((IterableOps)this);
    }

    public Object tapEach(Function1 f) {
        return IterableOps.tapEach$((IterableOps)this, (Function1)f);
    }

    public Object $plus$plus$colon(IterableOnce that) {
        return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
    }

    public IterableOps fromSpecific(IterableOnce coll) {
        return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
    }

    public Builder<AbstractFile, Iterable<AbstractFile>> newSpecificBuilder() {
        return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
    }

    public IterableOps empty() {
        return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
    }

    public final Iterable toIterable() {
        return Iterable.toIterable$((Iterable)this);
    }

    public final Iterable coll() {
        return Iterable.coll$((Iterable)this);
    }

    public IterableFactory<Iterable> iterableFactory() {
        return Iterable.iterableFactory$((Iterable)this);
    }

    public Iterable seq() {
        return Iterable.seq$((Iterable)this);
    }

    public String className() {
        return Iterable.className$((Iterable)this);
    }

    public final String collectionClassName() {
        return Iterable.collectionClassName$((Iterable)this);
    }

    public String stringPrefix() {
        return Iterable.stringPrefix$((Iterable)this);
    }

    public <B> LazyZip2<AbstractFile, B, AbstractFile> lazyZip(Iterable<B> that) {
        return Iterable.lazyZip$((Iterable)this, that);
    }

    public abstract String name();

    public abstract String path();

    public String absolutePath() {
        return this.path();
    }

    public String canonicalPath() {
        if (this.jpath() == null) {
            return this.path();
        }
        return this.jpath().normalize().toString();
    }

    public boolean hasExtension(String other) {
        return this.ext().toLowerCase().equalsIgnoreCase(other);
    }

    public FileExtension ext() {
        return this.ext;
    }

    public String extension() {
        return this.ext().toLowerCase();
    }

    public abstract AbstractFile absolute();

    public abstract AbstractFile container();

    public java.io.File file() {
        java.io.File file;
        block3: {
            try {
                if (this.jpath() == null) {
                    file = null;
                    break block3;
                }
                file = this.jpath().toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                file = null;
            }
        }
        return file;
    }

    public abstract java.nio.file.Path jpath();

    public Option<AbstractFile> underlyingSource() {
        return None$.MODULE$;
    }

    public boolean exists() {
        return this.jpath() == null || Files.exists(this.jpath(), new LinkOption[0]);
    }

    public boolean isClassContainer() {
        return this.isDirectory() || this.jpath() != null && this.ext().isJarOrZip();
    }

    public abstract boolean isDirectory();

    public boolean isVirtual() {
        return false;
    }

    public abstract long lastModified();

    public abstract InputStream input();

    public abstract OutputStream output();

    public BufferedOutputStream bufferedOutput() {
        return new BufferedOutputStream(this.output());
    }

    public Option<Object> sizeOption() {
        return None$.MODULE$;
    }

    public URL toURL() {
        if (this.jpath() == null) {
            return null;
        }
        return this.jpath().toUri().toURL();
    }

    public char[] toCharArray() throws IOException {
        return new String(this.toByteArray()).toCharArray();
    }

    public byte[] toByteArray() throws IOException {
        InputStream in = this.input();
        Option<Object> option = this.sizeOption();
        if (option instanceof Some) {
            int size;
            int res;
            int rest;
            Some some = (Some)option;
            byte[] arr = new byte[rest];
            for (rest = size = BoxesRunTime.unboxToInt((Object)some.value()); rest > 0; rest -= res) {
                res = in.read(arr, arr.length - rest, rest);
                if (res != -1) continue;
                throw new IOException("read error");
            }
            in.close();
            return arr;
        }
        if (None$.MODULE$.equals(option)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
            in.close();
            return out.toByteArray();
        }
        throw new MatchError(option);
    }

    public abstract Iterator<AbstractFile> iterator();

    public final AbstractFile lookupPath(Seq<String> parts, boolean directory) {
        int i;
        AbstractFile file = this;
        int n = parts.length() - 1;
        for (i = 0; file != null && i < n; file = file.lookupName((String)parts.apply(i), true), ++i) {
        }
        if (file == null) {
            return null;
        }
        return file.lookupName((String)parts.apply(i), directory);
    }

    public abstract AbstractFile lookupName(String var1, boolean var2);

    public abstract AbstractFile lookupNameUnchecked(String var1, boolean var2);

    public AbstractFile lookupPathUnchecked(String path, boolean directory) {
        return this.lookup((Function3<AbstractFile, String, Object, AbstractFile>)(Function3 & Serializable)(f, p, dir) -> ((AbstractFile)f).lookupNameUnchecked((String)p, BoxesRunTime.unboxToBoolean((Object)dir)), path, directory);
    }

    private AbstractFile lookup(Function3<AbstractFile, String, Object, AbstractFile> getFile, String path0, boolean directory) {
        char separator = java.io.File.separatorChar;
        String path = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path0)) == separator ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path0), 1) : path0;
        int length = path.length();
        if (length <= 0 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path)) == separator) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)path);
        }
        AbstractFile file = this;
        int start = 0;
        while (true) {
            int index = path.indexOf(Char$.MODULE$.char2int(separator), start);
            if (index >= 0 && start >= index) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)Tuple4$.MODULE$.apply((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)directory), (Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)index)));
            }
            String name = path.substring(start, index < 0 ? length : index);
            if ((file = (AbstractFile)getFile.apply((Object)file, (Object)name, (Object)(index < 0 ? BoxesRunTime.boxToBoolean((boolean)directory) : BoxesRunTime.boxToBoolean((boolean)true)))) == null || index < 0) {
                return file;
            }
            start = index + 1;
        }
        return file;
    }

    public final AbstractFile resolveSibling(String name) {
        return this.container().lookupName(name, false);
    }

    public final AbstractFile resolveSiblingWithExtension(FileExtension extension) {
        return this.resolveSibling(new java.lang.StringBuilder(1).append(Path$.MODULE$.fileName(this.name())).append(".").append(extension).toString());
    }

    private AbstractFile fileOrSubdirectoryNamed(String name, boolean isDir) {
        AbstractFile abstractFile;
        block7: {
            Object object;
            java.nio.file.Path path;
            abstractFile = this.lookupName(name, isDir);
            if (abstractFile != null) break block7;
            try {
                path = Files.createDirectories(this.jpath(), new FileAttribute[0]);
            }
            catch (Throwable throwable) {
                block9: {
                    block8: {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof FileAlreadyExistsException)) break block8;
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (Files.isDirectory(this.jpath(), new LinkOption[0])) break block9;
                    }
                    throw throwable;
                }
                path = BoxedUnit.UNIT;
            }
            java.nio.file.Path path2 = this.jpath().resolve(name);
            try {
                object = isDir ? Files.createDirectory(path2, new FileAttribute[0]) : Files.createFile(path2, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                object = BoxedUnit.UNIT;
            }
            return new PlainFile(new File(path2, Codec$.MODULE$.fallbackSystemCodec()));
        }
        AbstractFile lookup = abstractFile;
        return lookup;
    }

    public AbstractFile fileNamed(String name) {
        if (!this.isDirectory()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, this.path()})));
        }
        return this.fileOrSubdirectoryNamed(name, false);
    }

    public AbstractFile subdirectoryNamed(String name) {
        if (!this.isDirectory()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tried to find '%s' in '%s' but it is not a directory"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, this.path()})));
        }
        return this.fileOrSubdirectoryNamed(name, true);
    }

    public Nothing$ unsupported() {
        return this.unsupported(null);
    }

    public Nothing$ unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        return this.path();
    }
}

