/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.GenericHashSet$;
import dotty.tools.dotc.util.MutableSet;
import java.util.Arrays;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;

public abstract class GenericHashSet<T>
extends MutableSet<T> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    private Object[] table;

    public static <T> int $lessinit$greater$default$1() {
        return GenericHashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int $lessinit$greater$default$2() {
        return GenericHashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public GenericHashSet(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear(this.clear$default$1());
    }

    public int used() {
        return this.used;
    }

    public void used_$eq(int x$1) {
        this.used = x$1;
    }

    public int limit() {
        return this.limit;
    }

    public void limit_$eq(int x$1) {
        this.limit = x$1;
    }

    public Object[] table() {
        return this.table;
    }

    public void table_$eq(Object[] x$1) {
        this.table = x$1;
    }

    private void allocate(int capacity) {
        this.table_$eq(new Object[capacity]);
        this.limit_$eq(capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple);
    }

    private int roundToPower(int n) {
        if (n < 4) {
            return 4;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    @Override
    public void clear(boolean resetToInitial) {
        this.used_$eq(0);
        if (resetToInitial) {
            this.allocate(this.roundToPower(this.initialCapacity));
            return;
        }
        Arrays.fill(this.table(), null);
    }

    @Override
    public int size() {
        return this.used();
    }

    public boolean isDense() {
        return this.limit() < 8;
    }

    public abstract int hash(T var1);

    public abstract boolean isEqual(T var1, T var2);

    private int index(int x) {
        return x & this.table().length - 1;
    }

    public Object[] currentTable() {
        return this.table();
    }

    private int firstIndex(T x) {
        if (this.isDense()) {
            return 0;
        }
        return this.index(this.hash(x));
    }

    private int nextIndex(int idx) {
        return this.index(idx + 1);
    }

    public Object dotty$tools$dotc$util$GenericHashSet$$entryAt(int idx) {
        return this.table()[idx];
    }

    private void setEntry(int idx, T x) {
        this.table()[idx] = x;
    }

    @Override
    public Object lookup(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy1 = e;
            if (this.isEqual(x$proxy1, x)) {
                return e;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return null;
    }

    private T addEntryAt(int idx, T x) {
        this.setEntry(idx, x);
        this.used_$eq(this.used() + 1);
        if (this.used() > this.limit()) {
            this.growTable();
        }
        return x;
    }

    @Override
    public boolean add(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy2 = e;
            if (this.isEqual(x$proxy2, x)) {
                return false;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        this.addEntryAt(idx, x);
        return true;
    }

    @Override
    public T put(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy3 = e;
            if (this.isEqual(x$proxy3, x)) {
                Object x$proxy4 = e;
                return (T)x$proxy4;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return this.addEntryAt(idx, x);
    }

    @Override
    public void $plus$eq(T x) {
        this.put(x);
    }

    public boolean remove(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy5 = e;
            if (this.isEqual(x$proxy5, x)) {
                int hole = idx;
                while ((e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx = this.nextIndex(idx))) != null) {
                    Object x$proxy6 = e;
                    int eidx = this.index(this.hash(x$proxy6));
                    if (!this.isDense() && this.index(eidx - (hole + 1)) <= this.index(idx - (hole + 1))) continue;
                    Object x$proxy7 = e;
                    this.setEntry(hole, x$proxy7);
                    hole = idx;
                }
                this.table()[hole] = null;
                this.used_$eq(this.used() - 1);
                return true;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return false;
    }

    @Override
    public void $minus$eq(T x) {
        this.remove(x);
    }

    private void addOld(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        this.setEntry(idx, x);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy((Object)oldTable, 0, (Object)this.table(), 0, oldTable.length);
            return;
        }
        for (int idx = 0; idx < oldTable.length; ++idx) {
            Object e = oldTable[idx];
            if (e == null) continue;
            Object x$proxy8 = e;
            this.addOld(x$proxy8);
        }
    }

    public void growTable() {
        Object[] oldTable = this.table();
        int newLength = oldTable.length == 8 ? 16 * this.roundToPower(this.capacityMultiple) : this.table().length * 2;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator(this){
            private final /* synthetic */ GenericHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().mkString("HashSet(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashSet(dense)." : "HashSet.";
        String suffix = this.getClass().getSimpleName();
        return new StringBuilder(1).append(prefix).append(op).append(" ").append(suffix).toString();
    }

    public abstract class EntryIterator
    implements Iterator<T> {
        private int idx;

        public EntryIterator() {
            if (GenericHashSet.this == null) {
                throw new NullPointerException();
            }
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.idx = 0;
        }

        public <S extends Stepper<?>> S stepper(StepperShape<T, S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public Tuple2<Iterator<T>, Iterator<T>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U> void foreach(Function1<T, U> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<T, Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<T, Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<T, Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<T> find(Function1<T, Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, T, B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<T, B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, T, B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<T, B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, T, B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<T, B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object xs) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
        }

        public <B> int copyToArray(Object xs, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
        }

        public <B> int copyToArray(Object xs, int start, int len) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public <B> T min(Ordering<B> ord) {
            return IterableOnceOps.min$((IterableOnceOps)this, ord);
        }

        public <B> Option<T> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public <B> T max(Ordering<B> ord) {
            return IterableOnceOps.max$((IterableOnceOps)this, ord);
        }

        public <B> Option<T> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public <B> T maxBy(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.maxBy$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<T> maxByOption(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> T minBy(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.minBy$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<T> minByOption(Function1<T, B> f, Ordering<B> ord) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<T, B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public scala.collection.mutable.StringBuilder addString(scala.collection.mutable.StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (scala.collection.mutable.StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final scala.collection.mutable.StringBuilder addString(scala.collection.mutable.StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (scala.collection.mutable.StringBuilder)b, (String)sep);
        }

        public final scala.collection.mutable.StringBuilder addString(scala.collection.mutable.StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (scala.collection.mutable.StringBuilder)b);
        }

        public <C1> C1 to(Factory<T, C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<T> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<T> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<T> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<T, Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<T> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<T> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<T> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$2) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
        }

        public Iterable<T> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<T> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<T> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<T> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<T, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<T> filter(Function1<T, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<T> filterNot(Function1<T, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<T> filterImpl(Function1<T, Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<T> withFilter(Function1<T, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<T> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<T> distinctBy(Function1<T, B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<T, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<T, IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<T, IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<T> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<T> takeWhile(Function1<T, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<T> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<T> dropWhile(Function1<T, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<T> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<T> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<T, B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<T, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U> Iterator<T> tapEach(Function1<T, U> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator seq() {
            return Iterator.seq$((Iterator)this);
        }

        public abstract Object entry(int var1);

        public boolean hasNext() {
            while (this.idx < GenericHashSet.this.table().length && GenericHashSet.this.table()[this.idx] == null) {
                ++this.idx;
            }
            return this.idx < GenericHashSet.this.table().length;
        }

        /*
         * WARNING - void declaration
         */
        public T next() {
            void v0;
            Predef$.MODULE$.require(this.hasNext());
            try {
                void var1_1;
                Object x$proxy9 = this.entry(this.idx);
                v0 = var1_1;
            }
            finally {
                ++this.idx;
            }
            return v0;
        }

        public final /* synthetic */ GenericHashSet dotty$tools$dotc$util$GenericHashSet$EntryIterator$$$outer() {
            return GenericHashSet.this;
        }
    }
}

