/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core;

import dotty.tools.dotc.classpath.FileUtils$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.CompilationUnitInfo;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.SymDenotations;
import dotty.tools.dotc.core.SymbolLoader;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.classfile.ClassfileTastyUUIDParser;
import dotty.tools.dotc.core.tasty.DottyUnpickler;
import dotty.tools.dotc.core.tasty.DottyUnpickler$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.io.AbstractFile;
import dotty.tools.tasty.UnpickleException;
import dotty.tools.tasty.besteffort.BestEffortTastyHeaderUnpickler;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TastyLoader
extends SymbolLoader {
    private final AbstractFile tastyFile;
    private final boolean isBestEffortTasty;
    private final DottyUnpickler unpickler;
    private final CompilationUnitInfo compilationUnitInfo;

    public TastyLoader(AbstractFile tastyFile) {
        this.tastyFile = tastyFile;
        this.isBestEffortTasty = FileUtils$.MODULE$.hasBetastyExtension(tastyFile);
        this.unpickler = (DottyUnpickler)this.handleUnpicklingExceptions(() -> this.$init$$$anonfun$1(tastyFile));
        this.compilationUnitInfo = this.unpickler.compilationUnitInfo();
    }

    public AbstractFile tastyFile() {
        return this.tastyFile;
    }

    public boolean isBestEffortTasty() {
        return this.isBestEffortTasty;
    }

    @Override
    public CompilationUnitInfo compilationUnitInfo() {
        return this.compilationUnitInfo;
    }

    @Override
    public String description(Contexts.Context x$1) {
        if (this.isBestEffortTasty()) {
            return new StringBuilder(23).append("Best Effort TASTy file ").append(this.tastyFile().toString()).toString();
        }
        return new StringBuilder(11).append("TASTy file ").append(this.tastyFile().toString()).toString();
    }

    @Override
    public void doComplete(SymDenotations.SymDenotation root, Contexts.Context x$2) {
        this.handleUnpicklingExceptions((Function0 & Serializable)() -> {
            this.doComplete$$anonfun$3(root, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private <T> T handleUnpicklingExceptions(Function0<T> thunk) {
        Object object;
        try {
            object = thunk.apply();
        }
        catch (RuntimeException e) {
            String string;
            String tastyType = this.isBestEffortTasty() ? "Best Effort TASTy" : "TASTy";
            RuntimeException runtimeException = e;
            if (runtimeException instanceof UnpickleException) {
                UnpickleException e2 = (UnpickleException)runtimeException;
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(55).append(tastyType).append(" file ").append(this.tastyFile().canonicalPath()).append(" could not be read, failing with:\n            |  ").append(Option$.MODULE$.apply((Object)e2.getMessage()).getOrElse(TastyLoader::$anonfun$9)).toString()));
            } else {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(55).append(this.tastyFile()).append(" file ").append(this.tastyFile().canonicalPath()).append(" is broken, reading aborted with ").append(e.getClass()).append("\n            |  ").append(Option$.MODULE$.apply((Object)e.getMessage()).getOrElse(TastyLoader::$anonfun$10)).toString()));
            }
            String message = string;
            throw new IOException(message, e);
        }
        return (T)object;
    }

    private void checkTastyUUID(Contexts.Context x$1) {
        String className = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.tastyFile().name()), ".tasty");
        AbstractFile classfile = this.tastyFile().resolveSibling(new StringBuilder(6).append(className).append(".class").toString());
        if (classfile != null) {
            UUID tastyUUID = this.unpickler.unpickler().header().uuid();
            new ClassfileTastyUUIDParser(classfile, x$1).checkTastyUUID(tastyUUID, x$1);
            return;
        }
        report$.MODULE$.inform((Function0<String>)((Function0 & Serializable)this::checkTastyUUID$$anonfun$1), report$.MODULE$.inform$default$2(), x$1);
    }

    private void checkBeTastyUUID(AbstractFile tastyFile, byte[] tastyBytes, Contexts.Context x$3) {
        new BestEffortTastyHeaderUnpickler(tastyBytes).readHeader();
    }

    private boolean mayLoadTreesFromTasty(Contexts.Context x$1) {
        return BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().YretainTrees(), x$1)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().fromTasty(), x$1));
    }

    private final DottyUnpickler $init$$$anonfun$1(AbstractFile tastyFile$1) {
        byte[] tastyBytes = tastyFile$1.toByteArray();
        return new DottyUnpickler(tastyFile$1, tastyBytes, this.isBestEffortTasty(), DottyUnpickler$.MODULE$.$lessinit$greater$default$4());
    }

    private final void doComplete$$anonfun$3(SymDenotations.SymDenotation root$9, Contexts.Context x$2$12) {
        Tuple2<SymDenotations.ClassDenotation, SymDenotations.ClassDenotation> tuple2 = this.rootDenots(root$9.asClass(), x$2$12);
        SymDenotations.ClassDenotation classRoot = (SymDenotations.ClassDenotation)tuple2._1();
        SymDenotations.ClassDenotation moduleRoot = (SymDenotations.ClassDenotation)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)classRoot, (Object)moduleRoot);
        SymDenotations.ClassDenotation classRoot2 = (SymDenotations.ClassDenotation)tuple22._1();
        SymDenotations.ClassDenotation moduleRoot2 = (SymDenotations.ClassDenotation)tuple22._2();
        if (!this.isBestEffortTasty() || x$2$12.withBestEffortTasty()) {
            byte[] tastyBytes = this.tastyFile().toByteArray();
            this.unpickler.enter((Set<SymDenotations.SymDenotation>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SymDenotations.SymDenotation[]{classRoot2, moduleRoot2, Symbols$.MODULE$.toDenot(moduleRoot2.sourceModule(x$2$12), x$2$12)}))), x$2$12.withSource(NoSource$.MODULE$));
            if (this.mayLoadTreesFromTasty(x$2$12) || this.isBestEffortTasty()) {
                classRoot2.classSymbol().rootTreeOrProvider_$eq(this.unpickler, x$2$12);
                moduleRoot2.classSymbol().rootTreeOrProvider_$eq(this.unpickler, x$2$12);
            }
            if (this.isBestEffortTasty()) {
                this.checkBeTastyUUID(this.tastyFile(), tastyBytes, x$2$12);
                x$2$12.setUsedBestEffortTasty();
                return;
            }
            this.checkTastyUUID(x$2$12);
            return;
        }
        report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot read Best Effort TASTy ", " without the ", " option"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_AbstractFile()).apply((Object)this.tastyFile()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)x$2$12.settings().YwithBestEffortTasty().name())}), x$2$12), report$.MODULE$.error$default$2(), x$2$12);
    }

    private static final String $anonfun$9() {
        return "";
    }

    private static final String $anonfun$10() {
        return "";
    }

    private final String checkTastyUUID$$anonfun$1() {
        return new StringBuilder(49).append("No classfiles found for ").append(this.tastyFile()).append(" when checking TASTy UUID").toString();
    }
}

