/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.JDK9Reflectors;
import dotty.tools.io.ZipArchive;
import dotty.tools.io.ZipArchive$;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class FileZipArchive
extends ZipArchive {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileZipArchive.class.getDeclaredField("$1$$lzy1"));
    private final Option<String> release;
    private volatile Object $1$$lzy1;
    private List<Closeable> closeables;

    public FileZipArchive(Path jpath, Option<String> release) {
        this.release = release;
        super(jpath, release);
        this.closeables = package$.MODULE$.Nil();
    }

    private Path jpath$accessor() {
        return super.jpath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZipFile dotty$tools$io$FileZipArchive$$openZipFile() {
        try {
            ZipFile zipFile;
            Option<String> option = this.release;
            if (option instanceof Some) {
                String r = (String)((Some)option).value();
                if (this.file().getName().endsWith(".jar")) {
                    Object releaseVersion = JDK9Reflectors.runtimeVersionParse(r);
                    zipFile = JDK9Reflectors.newJarFile(this.file(), true, 1, releaseVersion);
                    return zipFile;
                }
            }
            zipFile = new ZipFile(this.file());
            return zipFile;
        }
        catch (IOException ioe) {
            throw new IOException(new StringBuilder(16).append("Error accessing ").append(this.file().getPath()).toString(), ioe);
        }
    }

    private Tuple2<ZipArchive.DirEntry, Map<String, ZipArchive.DirEntry>> $1$() {
        Object object = this.$1$$lzy1;
        if (object instanceof Tuple2) {
            return (Tuple2)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple2)this.$1$$lzyINIT1();
    }

    private Object $1$$lzyINIT1() {
        Object object;
        block15: {
            while (true) {
                if ((object = this.$1$$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple2 tuple2 = null;
                    try {
                        ZipArchive.DirEntry root2 = new ZipArchive.DirEntry(this, "/", null);
                        Object[] objectArray = new Tuple2[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"/");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)root2);
                        HashMap dirs = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        ZipFile zipFile = this.dotty$tools$io$FileZipArchive$$openZipFile();
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        try {
                            while (entries.hasMoreElements()) {
                                ZipEntry zipEntryVersioned;
                                ZipEntry zipEntry = entries.nextElement();
                                if (zipEntry.getName().startsWith("META-INF/versions/")) continue;
                                ZipEntry zipEntry2 = zipEntryVersioned = this.release.isDefined() ? zipFile.getEntry(zipEntry.getName()) : zipEntry;
                                if (zipEntry.isDirectory()) continue;
                                ZipArchive.DirEntry dir = this.getDir((scala.collection.mutable.Map<String, ZipArchive.DirEntry>)dirs, zipEntry);
                                ZipArchive.Entry f = ZipArchive$.MODULE$.closeZipFile() ? new LazyEntry(this, zipEntry.getName(), zipEntry.getTime(), (int)zipEntry.getSize(), dir) : new LeakyEntry(this, zipFile, zipEntryVersioned, dir);
                                dir.entries().update((Object)f.name(), (Object)f);
                            }
                        }
                        finally {
                            if (ZipArchive$.MODULE$.closeZipFile()) {
                                zipFile.close();
                            } else {
                                this.closeables = this.closeables.$colon$colon((Object)zipFile);
                            }
                        }
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)root2, (Object)dirs);
                        if (!(tuple22 instanceof Tuple2)) {
                            throw new MatchError((Object)tuple22);
                        }
                        Tuple2 tuple23 = tuple22;
                        ZipArchive.DirEntry root3 = (ZipArchive.DirEntry)tuple23._1();
                        Map allDirs = (Map)tuple23._2();
                        tuple2 = Tuple2$.MODULE$.apply((Object)root3, (Object)allDirs);
                        object2 = tuple2 == null ? LazyVals.NullValue$.MODULE$ : tuple2;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return tuple2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block15;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ZipArchive.DirEntry root() {
        return (ZipArchive.DirEntry)this.$1$()._1();
    }

    public Map<String, ZipArchive.DirEntry> allDirs() {
        return (Map)this.$1$()._2();
    }

    public Iterator<ZipArchive.Entry> iterator() {
        return this.root().iterator();
    }

    @Override
    public String name() {
        return this.jpath$accessor().getFileName().toString();
    }

    @Override
    public String path() {
        return this.jpath$accessor().toString();
    }

    @Override
    public InputStream input() {
        return Files.newInputStream(this.jpath$accessor(), new OpenOption[0]);
    }

    @Override
    public long lastModified() {
        return Files.getLastModifiedTime(this.jpath$accessor(), new LinkOption[0]).toMillis();
    }

    @Override
    public Option<Object> sizeOption() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)Files.size(this.jpath$accessor()))));
    }

    public boolean canEqual(Object other) {
        return other instanceof FileZipArchive;
    }

    public int hashCode() {
        return this.jpath$accessor().hashCode();
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof FileZipArchive) {
            FileZipArchive x = (FileZipArchive)object;
            Path path = this.jpath$accessor().toAbsolutePath();
            Path path2 = x.jpath().toAbsolutePath();
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        }
        return false;
    }

    @Override
    public void close() {
        this.closeables.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.close());
        this.closeables = package$.MODULE$.Nil();
    }

    public class LazyEntry
    extends ZipArchive.Entry {
        private final String name;
        private final long time;
        private final int size;
        private final /* synthetic */ FileZipArchive $outer;

        public LazyEntry(FileZipArchive $outer, String name, long time, int size, ZipArchive.DirEntry parent) {
            this.name = name;
            this.time = time;
            this.size = size;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, name, parent);
        }

        private ZipArchive.DirEntry parent$accessor() {
            return (ZipArchive.DirEntry)super.parent();
        }

        @Override
        public long lastModified() {
            return this.time;
        }

        @Override
        public InputStream input() {
            ZipFile zipFile = this.$outer.dotty$tools$io$FileZipArchive$$openZipFile();
            ZipEntry entry = zipFile.getEntry(this.name);
            InputStream delegate = zipFile.getInputStream(entry);
            return new FilterInputStream(delegate, zipFile){
                private final ZipFile zipFile$2;
                {
                    this.zipFile$2 = zipFile$1;
                    super(delegate$1);
                }

                public void close() {
                    this.zipFile$2.close();
                }
            };
        }

        @Override
        public Option<Object> sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.size));
        }

        public final /* synthetic */ FileZipArchive dotty$tools$io$FileZipArchive$LazyEntry$$$outer() {
            return this.$outer;
        }
    }

    public class LeakyEntry
    extends ZipArchive.Entry {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;
        private final /* synthetic */ FileZipArchive $outer;

        public LeakyEntry(FileZipArchive $outer, ZipFile zipFile, ZipEntry zipEntry, ZipArchive.DirEntry parent) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, zipEntry.getName(), parent);
        }

        private ZipArchive.DirEntry parent$accessor() {
            return (ZipArchive.DirEntry)super.parent();
        }

        @Override
        public long lastModified() {
            return this.zipEntry.getTime();
        }

        @Override
        public InputStream input() {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        @Override
        public Option<Object> sizeOption() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.zipEntry.getSize())));
        }

        public final /* synthetic */ FileZipArchive dotty$tools$io$FileZipArchive$LeakyEntry$$$outer() {
            return this.$outer;
        }
    }
}

