/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.FatalError;
import dotty.tools.io.AbstractFile;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;

public final class FileUtils$
implements Serializable {
    private static final String SUFFIX_CLASS;
    private static final String SUFFIX_SCALA;
    private static final String SUFFIX_TASTY;
    private static final String SUFFIX_JAVA;
    private static final String SUFFIX_SIG;
    public static final FileUtils$ MODULE$;

    private FileUtils$() {
    }

    static {
        MODULE$ = new FileUtils$();
        SUFFIX_CLASS = ".class";
        SUFFIX_SCALA = ".scala";
        SUFFIX_TASTY = ".tasty";
        SUFFIX_JAVA = ".java";
        SUFFIX_SIG = ".sig";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtils$.class);
    }

    public boolean isPackage(AbstractFile file) {
        return file.isDirectory() && this.mayBeValidPackage(file.name());
    }

    public boolean isClass(AbstractFile file) {
        return !file.isDirectory() && this.hasClassExtension(file);
    }

    public boolean hasClassExtension(AbstractFile file) {
        return file.ext().isClass();
    }

    public boolean hasTastyExtension(AbstractFile file) {
        return file.ext().isTasty();
    }

    public boolean isTasty(AbstractFile file) {
        return !file.isDirectory() && this.hasTastyExtension(file);
    }

    public boolean isScalaBinary(AbstractFile file) {
        return this.isClass(file) || this.isTasty(file);
    }

    public boolean isScalaOrJavaSource(AbstractFile file) {
        return !file.isDirectory() && file.ext().isScalaOrJava();
    }

    public boolean isJarOrZip(AbstractFile file) {
        return file.ext().isJarOrZip();
    }

    public Seq<URL> toURLs(AbstractFile file, Function0<Seq<URL>> function0) {
        if (file.file() == null) {
            return (Seq)function0.apply();
        }
        return (Seq)((SeqOps)new .colon.colon((Object)file.toURL(), (List)Nil$.MODULE$));
    }

    public Seq<URL> toURLs$default$2(AbstractFile file) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean hasSiblingTasty(AbstractFile file) {
        if (!this.hasClassExtension(file)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(11).append("non-class: ").append(file).toString());
        }
        return file.resolveSibling(this.classNameToTasty(file.name())) != null;
    }

    public boolean isPackage(File file) {
        return file.isDirectory() && this.mayBeValidPackage(file.getName());
    }

    public boolean isClass(File file) {
        return file.isFile() && this.hasClassExtension(file);
    }

    public boolean hasClassExtension(File file) {
        return file.getName().endsWith(SUFFIX_CLASS);
    }

    public boolean isTasty(File file) {
        return file.isFile() && file.getName().endsWith(SUFFIX_TASTY);
    }

    public boolean hasSiblingTasty(File file) {
        if (!this.hasClassExtension(file)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(11).append("non-class: ").append(file).toString());
        }
        Path path = file.toPath();
        Path tastyPath = path.resolveSibling(this.classNameToTasty(file.getName()));
        return Files.exists(tastyPath, new LinkOption[0]);
    }

    public String stripSourceExtension(String fileName) {
        if (this.endsScala(fileName)) {
            return this.stripClassExtension(fileName);
        }
        if (this.endsJava(fileName)) {
            return this.stripJavaExtension(fileName);
        }
        throw new FatalError(new StringBuilder(31).append("Unexpected source file ending: ").append(fileName).toString());
    }

    public String dirPath(String forPackage) {
        return forPackage.replace('.', File.separatorChar);
    }

    public String dirPathInJar(String forPackage) {
        return forPackage.replace('.', '/');
    }

    public boolean endsClass(String fileName) {
        return fileName.endsWith(SUFFIX_CLASS) && fileName.length() > SUFFIX_CLASS.length() || fileName.endsWith(SUFFIX_SIG);
    }

    public boolean endsScalaOrJava(String fileName) {
        return this.endsScala(fileName) || this.endsJava(fileName);
    }

    public boolean endsJava(String fileName) {
        return fileName.endsWith(SUFFIX_JAVA) && fileName.length() > SUFFIX_JAVA.length();
    }

    public boolean endsScala(String fileName) {
        return fileName.endsWith(SUFFIX_SCALA) && fileName.length() > SUFFIX_SCALA.length();
    }

    public String stripClassExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public String stripJavaExtension(String fileName) {
        return fileName.substring(0, fileName.length() - 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayBeValidPackage(String dirName) {
        String string = dirName;
        String string2 = "META-INF";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = dirName;
        String string4 = "";
        if (string3 == null) {
            if (string4 == null) return false;
        } else if (string3.equals(string4)) return false;
        if (dirName.charAt(0) == '.') return false;
        return true;
    }

    public FileFilter mkFileFilter(Function1<File, Object> f) {
        return new FileFilter(f){
            private final Function1 f$1;
            {
                this.f$1 = f$2;
            }

            public boolean accept(File pathname) {
                return BoxesRunTime.unboxToBoolean((Object)this.f$1.apply((Object)pathname));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private String classNameToTasty(String fileName) {
        classOrModuleName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fileName), ".class");
        if (!classOrModuleName.endsWith("$")) ** GOTO lbl-1000
        v0 = classOrModuleName;
        var4_3 = "Null$";
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = classOrModuleName;
        var5_4 = "Nothing$";
        if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false)) ** GOTO lbl-1000
        v2 = classOrModuleName;
        var6_5 = "$";
        if (v2 == null ? var6_5 != null : v2.equals(var6_5) == false) {
            v3 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(classOrModuleName), "$");
        } else lbl-1000:
        // 4 sources

        {
            v3 = classOrModuleName;
        }
        className = v3;
        return new StringBuilder(0).append(className).append(FileUtils$.SUFFIX_TASTY).toString();
    }
}

