/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.Run;
import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.SourceVersion;
import dotty.tools.dotc.config.SourceVersion$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.typer.ImportInfo;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Feature$
implements Serializable {
    private static final Names.TermName namedTypeArguments;
    private static final Names.TermName genericNumberLiterals;
    private static final Names.TermName scala2macros;
    private static final Names.TermName dependent;
    private static final Names.TermName erasedDefinitions;
    private static final Names.TermName symbolLiterals;
    private static final Names.TermName fewerBraces;
    private static final Names.TermName saferExceptions;
    private static final Names.TermName clauseInterleaving;
    private static final Names.TermName pureFunctions;
    private static final Names.TermName captureChecking;
    private static final Names.TermName into;
    private static final Set<Names.TermName> globalOnlyImports;
    public static final Feature$ MODULE$;

    private Feature$() {
    }

    static {
        MODULE$ = new Feature$();
        namedTypeArguments = MODULE$.experimental("namedTypeArguments");
        genericNumberLiterals = MODULE$.experimental("genericNumberLiterals");
        scala2macros = MODULE$.experimental("macros");
        dependent = MODULE$.experimental("dependent");
        erasedDefinitions = MODULE$.experimental("erasedDefinitions");
        symbolLiterals = MODULE$.deprecated("symbolLiterals");
        fewerBraces = MODULE$.experimental("fewerBraces");
        saferExceptions = MODULE$.experimental("saferExceptions");
        clauseInterleaving = MODULE$.experimental("clauseInterleaving");
        pureFunctions = MODULE$.experimental("pureFunctions");
        captureChecking = MODULE$.experimental("captureChecking");
        into = MODULE$.experimental("into");
        globalOnlyImports = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Names.TermName[]{MODULE$.pureFunctions(), MODULE$.captureChecking()}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Feature$.class);
    }

    public Names.TermName experimental(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().experimental(), Decorators$.MODULE$.toTermName(str));
    }

    private Names.TermName deprecated(Object str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().deprecated(), Decorators$.MODULE$.toTermName(str));
    }

    public Names.TermName scala2macros() {
        return scala2macros;
    }

    public Names.TermName dependent() {
        return dependent;
    }

    public Names.TermName erasedDefinitions() {
        return erasedDefinitions;
    }

    public Names.TermName symbolLiterals() {
        return symbolLiterals;
    }

    public Names.TermName fewerBraces() {
        return fewerBraces;
    }

    public Names.TermName saferExceptions() {
        return saferExceptions;
    }

    public Names.TermName clauseInterleaving() {
        return clauseInterleaving;
    }

    public Names.TermName pureFunctions() {
        return pureFunctions;
    }

    public Names.TermName captureChecking() {
        return captureChecking;
    }

    public Names.TermName into() {
        return into;
    }

    public Set<Names.TermName> globalOnlyImports() {
        return globalOnlyImports;
    }

    public boolean enabledBySetting(Names.TermName feature, Contexts.Context x$2) {
        return ((List)Settings$Setting$.MODULE$.value(x$2.base().settings().language(), x$2)).contains((Object)feature.toString());
    }

    public boolean enabledByImport(Names.TermName feature, Contexts.Context x$2) {
        ImportInfo info = x$2.importInfo();
        return info != null && info.featureImported(feature, x$2);
    }

    public boolean enabled(Names.TermName feature, Contexts.Context x$2) {
        return this.enabledBySetting(feature, x$2) || this.enabledByImport(feature, x$2);
    }

    public boolean autoTuplingEnabled(Contexts.Context x$1) {
        return !this.enabled((Names.TermName)StdNames$.MODULE$.nme().noAutoTupling(), x$1);
    }

    public boolean dynamicsEnabled(Contexts.Context x$1) {
        return this.enabled((Names.TermName)StdNames$.MODULE$.nme().dynamics(), x$1);
    }

    public boolean dependentEnabled(Contexts.Context x$1) {
        return this.enabled(this.dependent(), x$1);
    }

    public boolean namedTypeArgsEnabled(Contexts.Context x$1) {
        return this.enabled(namedTypeArguments, x$1);
    }

    public boolean clauseInterleavingEnabled(Contexts.Context x$1) {
        return this.enabled(this.clauseInterleaving(), x$1);
    }

    public boolean genericNumberLiteralsEnabled(Contexts.Context x$1) {
        return this.enabled(genericNumberLiterals, x$1);
    }

    public boolean scala2ExperimentalMacroEnabled(Contexts.Context x$1) {
        return this.enabled(this.scala2macros(), x$1);
    }

    public boolean pureFunsEnabled(Contexts.Context x$1) {
        return this.enabledBySetting(this.pureFunctions(), x$1) || x$1.compilationUnit().knowsPureFuns() || this.ccEnabled(x$1);
    }

    public boolean ccEnabled(Contexts.Context x$1) {
        return this.enabledBySetting(this.captureChecking(), x$1) || x$1.compilationUnit().needsCaptureChecking();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pureFunsEnabledSomewhere(Contexts.Context x$1) {
        if (this.enabledBySetting(this.pureFunctions(), x$1)) return true;
        if (x$1.run() != null) {
            Run x$proxy1 = x$1.run();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            if (x$proxy1.pureFunsImportEncountered()) return true;
        }
        if (!this.ccEnabledSomewhere(x$1)) return false;
        return true;
    }

    public boolean ccEnabledSomewhere(Contexts.Context x$1) {
        if (x$1.run() != null) {
            Run x$proxy2 = x$1.run();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy2.ccEnabledSomewhere();
        }
        return this.enabledBySetting(this.captureChecking(), x$1);
    }

    public SourceVersion sourceVersionSetting(Contexts.Context x$1) {
        return SourceVersion$.MODULE$.valueOf((String)Settings$Setting$.MODULE$.value(x$1.settings().source(), x$1));
    }

    public SourceVersion sourceVersion(Contexts.Context x$1) {
        Option<SourceVersion> option = x$1.compilationUnit().sourceVersion();
        if (option instanceof Some) {
            SourceVersion v = (SourceVersion)((Some)option).value();
            return v;
        }
        Option<SourceVersion> none = option;
        return this.sourceVersionSetting(x$1);
    }

    public boolean migrateTo3(Contexts.Context x$1) {
        SourceVersion sourceVersion = this.sourceVersion(x$1);
        SourceVersion sourceVersion2 = SourceVersion$.3$u002E0$minusmigration;
        return !(sourceVersion != null ? !sourceVersion.equals(sourceVersion2) : sourceVersion2 != null);
    }

    public boolean fewerBracesEnabled(Contexts.Context x$1) {
        return this.sourceVersion(x$1).isAtLeast(SourceVersion$.3$u002E3) || this.enabled(this.fewerBraces(), x$1);
    }

    public boolean warnOnMigration(Message msg, SrcPos pos, SourceVersion version, Contexts.Context x$4) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!this.sourceVersion(x$4).isMigrating()) break block2;
                        SourceVersion sourceVersion = this.sourceVersion(x$4).stable();
                        SourceVersion sourceVersion2 = version;
                        if (!(sourceVersion == null ? sourceVersion2 != null : !sourceVersion.equals(sourceVersion2))) break block3;
                    }
                    SourceVersion sourceVersion = version;
                    SourceVersion sourceVersion3 = SourceVersion$.3$u002E0;
                    if (!(sourceVersion == null ? sourceVersion3 != null : !sourceVersion.equals(sourceVersion3))) break block4;
                    SourceVersion sourceVersion4 = version;
                    SourceVersion sourceVersion5 = SourceVersion$.3$u002E1;
                    if (sourceVersion4 != null ? !sourceVersion4.equals(sourceVersion5) : sourceVersion5 != null) break block5;
                }
                if (!this.migrateTo3(x$4)) break block5;
            }
            report$.MODULE$.migrationWarning(msg, pos, x$4);
            return true;
        }
        return false;
    }

    public void checkExperimentalFeature(String which, SrcPos srcPos, Function0<String> note, Contexts.Context x$4) {
        if (!this.isExperimentalEnabled(x$4)) {
            report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Experimental ", " may only be used under experimental mode:\n            |  1. in a definition marked as @experimental, or\n            |  2. compiling with the -experimental compiler flag, or\n            |  3. with a nightly or snapshot version of the compiler.", "\n          "})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)which), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(note.apply())}), x$4), srcPos, x$4);
            return;
        }
    }

    public String checkExperimentalFeature$default$3() {
        return "";
    }

    private boolean ccException(Symbols.Symbol sym, Contexts.Context x$2) {
        return this.ccEnabled(x$2) && Symbols$.MODULE$.defn(x$2).ccExperimental().contains((Object)sym);
    }

    public void checkExperimentalDef(Symbols.Symbol sym, SrcPos srcPos, Contexts.Context x$3) {
        Symbols.Symbol experimentalSym;
        Symbols.Symbol symbol = Symbols$.MODULE$.toDenot(sym, x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? sym : (experimentalSym = Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$3).owner(), x$3).hasAnnotation(Symbols$.MODULE$.defn(x$3).ExperimentalAnnot(), x$3) ? Symbols$.MODULE$.toDenot(sym, x$3).owner() : Symbols$NoSymbol$.MODULE$);
        if (!this.ccException(experimentalSym, x$3)) {
            String note = Symbols$.MODULE$.toDenot(experimentalSym, x$3).exists() ? Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is marked @experimental"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)experimentalSym)}), x$3) : Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " inherits @experimental"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)sym)}), x$3);
            this.checkExperimentalFeature("definition", srcPos, (Function0<String>)((Function0 & Serializable)() -> Feature$.checkExperimentalDef$$anonfun$1(note)), x$3);
            return;
        }
    }

    public void checkExperimentalSettings(Contexts.Context x$1) {
        ((IterableOps)Settings$Setting$.MODULE$.value(x$1.settings().language(), x$1)).withFilter((Function1 & Serializable)setting -> {
            if (!setting.startsWith("experimental.")) return false;
            String string = setting;
            String string2 = "experimental.macros";
            if (string == null) {
                if (string2 == null) return false;
                return true;
            } else if (string.equals(string2)) return false;
            return true;
        }).foreach((Function1)(JProcedure1 & Serializable)setting -> this.checkExperimentalFeature(new StringBuilder(8).append("feature ").append((String)setting).toString(), NoSourcePosition$.MODULE$, (Function0<String>)((Function0 & Serializable)this::checkExperimentalSettings$$anonfun$2$$anonfun$1), x$1));
    }

    public boolean isExperimentalEnabled(Contexts.Context x$1) {
        return Properties$.MODULE$.experimental() && !BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().YnoExperimental(), x$1)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().experimental(), x$1));
    }

    public boolean handleGlobalLanguageImport(Names.TermName prefix, Names.Name imported, Contexts.Context x$3) {
        Names.TermName fullFeatureName;
        Names.TermName termName = fullFeatureName = NameKinds$.MODULE$.QualifiedName().apply(prefix, imported.asTermName());
        Names.TermName termName2 = this.pureFunctions();
        if (!(termName != null ? !((Object)termName).equals(termName2) : termName2 != null)) {
            x$3.compilationUnit().knowsPureFuns_$eq(true);
            if (x$3.run() != null) {
                Run x$proxy3 = x$3.run();
                if (x$proxy3 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy3.pureFunsImportEncountered_$eq(true);
            }
            return true;
        }
        Names.TermName termName3 = fullFeatureName;
        Names.TermName termName4 = this.captureChecking();
        if (!(termName3 != null ? !((Object)termName3).equals(termName4) : termName4 != null)) {
            x$3.compilationUnit().needsCaptureChecking_$eq(true);
            if (x$3.run() != null) {
                Run x$proxy4 = x$3.run();
                if (x$proxy4 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy4.ccEnabledSomewhere_$eq(true);
            }
            return true;
        }
        return false;
    }

    private static final String checkExperimentalDef$$anonfun$1(String note$1) {
        return new StringBuilder(2).append("\n\n").append(note$1).toString();
    }

    private final String checkExperimentalSettings$$anonfun$2$$anonfun$1() {
        return this.checkExperimentalFeature$default$3();
    }
}

