/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.repl;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.util.StackTraceOps$;
import dotty.tools.io.AbstractFile;
import dotty.tools.repl.AbstractFileClassLoader;
import dotty.tools.repl.Rendering$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public class Rendering {
    private final Option<ClassLoader> parentClassLoader;
    private AbstractFileClassLoader myClassLoader;
    private Function3 myReplStringOf;

    public static String REPL_WRAPPER_NAME_PREFIX() {
        return Rendering$.MODULE$.REPL_WRAPPER_NAME_PREFIX();
    }

    public static Throwable rootCause(Throwable throwable) {
        return Rendering$.MODULE$.rootCause(throwable);
    }

    public static String showUser(Symbols.Symbol symbol, Contexts.Context context) {
        return Rendering$.MODULE$.showUser(symbol, context);
    }

    public static Option<ClassLoader> $lessinit$greater$default$1() {
        return Rendering$.MODULE$.$lessinit$greater$default$1();
    }

    public Rendering(Option<ClassLoader> parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public AbstractFileClassLoader myClassLoader() {
        return this.myClassLoader;
    }

    public void myClassLoader_$eq(AbstractFileClassLoader x$1) {
        this.myClassLoader = x$1;
    }

    public Function3<Object, Object, Object, String> myReplStringOf() {
        return this.myReplStringOf;
    }

    public void myReplStringOf_$eq(Function3<Object, Object, Object, String> x$1) {
        this.myReplStringOf = x$1;
    }

    public AbstractFileClassLoader classLoader(Contexts.Context x$1) {
        if (this.myClassLoader() != null) {
            AbstractFile abstractFile = this.myClassLoader().root();
            Object t = Settings$Setting$.MODULE$.value(x$1.settings().outputDir(), x$1);
            if (!(abstractFile != null ? !abstractFile.equals(t) : t != null)) {
                return this.myClassLoader();
            }
        }
        ClassLoader parent = (ClassLoader)Option$.MODULE$.apply((Object)this.myClassLoader()).orElse(this::$anonfun$1).getOrElse(() -> Rendering.$anonfun$2(x$1));
        this.myClassLoader_$eq(new AbstractFileClassLoader((AbstractFile)Settings$Setting$.MODULE$.value(x$1.settings().outputDir(), x$1), parent));
        Class<?> scalaRuntime = Class.forName("scala.runtime.ScalaRunTime", true, this.myClassLoader());
        String renderer = "stringOf";
        this.myReplStringOf_$eq((Function3<Object, Object, Object, String>)(Function3 & Serializable)(value, maxElements, maxCharacters) -> this.classLoader$$anonfun$1(x$1, scalaRuntime, renderer, value, BoxesRunTime.unboxToInt((Object)maxElements), BoxesRunTime.unboxToInt((Object)maxCharacters)));
        return this.myClassLoader();
    }

    public String truncate(String str, int maxPrintCharacters, Contexts.Context ctx) {
        int ncp = str.codePointCount(0, str.length());
        if (ncp <= maxPrintCharacters) {
            return str;
        }
        return str.substring(0, str.offsetByCodePoints(0, maxPrintCharacters - 1));
    }

    public String replStringOf(Object value, Contexts.Context x$2) {
        if (this.myReplStringOf() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"replStringOf should only be called on values creating using `classLoader()`, but `classLoader()` has not been called so far");
        }
        int maxPrintElements = BoxesRunTime.unboxToInt(x$2.settings().VreplMaxPrintElements().valueIn(x$2.settingsState()));
        int maxPrintCharacters = BoxesRunTime.unboxToInt(x$2.settings().VreplMaxPrintCharacters().valueIn(x$2.settingsState()));
        String res = (String)this.myReplStringOf().apply(value, (Object)BoxesRunTime.boxToInteger((int)maxPrintElements), (Object)BoxesRunTime.boxToInteger((int)maxPrintCharacters));
        if (res == null) {
            return "null // non-null reference has null-valued toString";
        }
        return res;
    }

    private Option<String> valueOf(Symbols.Symbol sym, Contexts.Context x$2) {
        String objectName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Symbols$.MODULE$.toDenot(Symbols$.MODULE$.toDenot(sym, x$2).owner(), x$2).fullName(x$2).encode().toString()), "$");
        Class<?> resObj = Class.forName(objectName, true, this.classLoader(x$2));
        Object object = Predef$.MODULE$.refArrayOps((Object[])resObj.getDeclaredMethods());
        Option symValue = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$1 -> {
            String string = _$1.getName();
            String string2 = sym.name(x$2).encode().toString();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).flatMap((Function1 & Serializable)result -> this.rewrapValueClass(Symbols$.MODULE$.toDenot(sym, x$2).info(x$2).classSymbol(x$2), result.invoke(null, new Object[0]), x$2));
        Option valueString = symValue.map((Function1 & Serializable)value -> this.replStringOf(value, x$2));
        if (!Symbols$.MODULE$.toDenot(sym, x$2).is(Flags$.MODULE$.Method(), x$2)) {
            Types.Type type = Symbols$.MODULE$.toDenot(sym, x$2).info(x$2);
            Types.TypeRef typeRef = Symbols$.MODULE$.defn(x$2).UnitType();
            if (!(type != null ? !type.equals(typeRef) : typeRef != null)) {
                return None$.MODULE$;
            }
        }
        return valueString.map((Function1 & Serializable)s -> {
            if (s.startsWith("rs$line$")) {
                return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), "rs$line$".length())), (Function1 & Serializable)c -> Rendering.valueOf$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
            }
            return s;
        });
    }

    private Option<Object> rewrapValueClass(Symbols.Symbol sym, Object value, Contexts.Context x$3) {
        if (Symbols$.MODULE$.isDerivedValueClass(sym, x$3)) {
            Class<?> valueClass = Class.forName(Symbols$.MODULE$.toDenot(sym, x$3).binaryClassName(x$3), true, this.classLoader(x$3));
            Object object = Predef$.MODULE$.refArrayOps((Object[])valueClass.getConstructors());
            return ArrayOps$.MODULE$.headOption$extension(object).map((Function1 & Serializable)_$2 -> _$2.newInstance(value));
        }
        return Some$.MODULE$.apply(value);
    }

    public Diagnostic renderTypeDef(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("// defined "), Rendering$.MODULE$.showUser(d.symbol(), x$2)), d, x$2);
    }

    public Diagnostic renderTypeAlias(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("// defined alias "), Rendering$.MODULE$.showUser(d.symbol(), x$2)), d, x$2);
    }

    public Diagnostic renderMethod(Denotations.Denotation d, Contexts.Context x$2) {
        return this.infoDiagnostic(Rendering$.MODULE$.showUser(d.symbol(), x$2), d, x$2);
    }

    public Either<ReflectiveOperationException, Option<Diagnostic>> renderVal(Denotations.Denotation d, Contexts.Context x$2) {
        Left left;
        String dcl = Rendering$.MODULE$.showUser(d.symbol(), x$2);
        try {
            left = package$.MODULE$.Right().apply(Symbols$.MODULE$.toDenot(d.symbol(), x$2).is(Flags$.MODULE$.Lazy(), x$2) ? Some$.MODULE$.apply((Object)this.msg$2(d, x$2, dcl)) : this.valueOf(d.symbol(), x$2).map((Function1 & Serializable)value -> this.msg$2(d, x$2, new StringBuilder(3).append(dcl).append(" = ").append((String)value).toString())));
        }
        catch (ReflectiveOperationException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Seq<Diagnostic> forceModule(Symbols.Symbol sym, Contexts.Context x$2) {
        Nil$ nil$;
        try {
            nil$ = this.load$1(sym, x$2);
        }
        catch (ExceptionInInitializerError e) {
            nil$ = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Diagnostic[]{this.renderError(e, sym.denot(x$2), x$2)}));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                nil$ = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Diagnostic[]{this.renderError(e, sym.denot(x$2), x$2)}));
            }
            throw throwable;
        }
        return nil$;
    }

    public Diagnostic renderError(Throwable thr, Denotations.Denotation d, Contexts.Context x$3) {
        Throwable cause = Rendering$.MODULE$.rootCause(thr);
        return this.infoDiagnostic(StackTraceOps$.MODULE$.formatStackTracePrefix(cause, (Function1<StackTraceElement, Object>)(Function1 & Serializable)_$3 -> !Rendering.isWrapperInitialization$1(x$3, _$3)), d, x$3);
    }

    private Diagnostic infoDiagnostic(String msg, Denotations.Denotation d, Contexts.Context x$3) {
        return new Diagnostic.Info((Function0<String>)((Function0 & Serializable)() -> Rendering.infoDiagnostic$$anonfun$1(msg)), d.symbol().sourcePos(x$3));
    }

    private final Option $anonfun$1() {
        return this.parentClassLoader;
    }

    private static final ClassLoader $anonfun$2(Contexts.Context x$1$1) {
        Seq<URL> compilerClasspath = x$1$1.platform().classPath(x$1$1).asURLs();
        ClassLoader baseClassLoader = ClassLoader.getSystemClassLoader().getParent();
        return new URLClassLoader((URL[])compilerClasspath.toArray(ClassTag$.MODULE$.apply(URL.class)), baseClassLoader);
    }

    private static final String stringOfMaybeTruncated$1(Class scalaRuntime$1, String renderer$1, Object value, int maxElements) {
        String string;
        try {
            Method meth = scalaRuntime$1.getMethod(renderer$1, Object.class, Integer.TYPE, Boolean.TYPE);
            Boolean truly = Boolean.TRUE;
            string = (String)meth.invoke(null, value, BoxesRunTime.boxToInteger((int)maxElements), truly);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method meth = scalaRuntime$1.getMethod(renderer$1, Object.class, Integer.TYPE);
            string = (String)meth.invoke(null, value, BoxesRunTime.boxToInteger((int)maxElements));
        }
        return string;
    }

    private final /* synthetic */ String classLoader$$anonfun$1(Contexts.Context x$1$2, Class scalaRuntime$2, String renderer$2, Object value, int maxElements, int maxCharacters) {
        String notTruncated = Rendering.stringOfMaybeTruncated$1(scalaRuntime$2, renderer$2, value, Integer.MAX_VALUE);
        String maybeTruncatedByElementCount = Rendering.stringOfMaybeTruncated$1(scalaRuntime$2, renderer$2, value, maxElements);
        String maybeTruncated = this.truncate(maybeTruncatedByElementCount, maxCharacters, x$1$2);
        if (notTruncated.length() == maybeTruncated.length()) {
            return maybeTruncated;
        }
        return new StringBuilder(52).append(maybeTruncated).append(" ... large output truncated, print value to show all").toString();
    }

    private static final /* synthetic */ boolean valueOf$$anonfun$1$$anonfun$1(char c) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '$';
    }

    private final Diagnostic msg$2(Denotations.Denotation d$1, Contexts.Context x$2$4, String s) {
        return this.infoDiagnostic(s, d$1, x$2$4);
    }

    private final Nil$ load$1(Symbols.Symbol sym$3, Contexts.Context x$2$6) {
        String objectName = Symbols$.MODULE$.toDenot(sym$3, x$2$6).fullName(x$2$6).encode().toString();
        Class.forName(objectName, true, this.classLoader(x$2$6));
        return package$.MODULE$.Nil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWrapperInitialization$1(Contexts.Context x$3$1, StackTraceElement ste) {
        if (!ste.getClassName().startsWith("rs$line$")) return false;
        String string = ste.getMethodName();
        String string2 = ((Names.Name)StdNames$.MODULE$.nme().STATIC_CONSTRUCTOR()).show(x$3$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = ste.getMethodName();
        String string4 = ((Names.Name)StdNames$.MODULE$.nme().CONSTRUCTOR()).show(x$3$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String infoDiagnostic$$anonfun$1(String msg$1) {
        return msg$1;
    }
}

