/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.CodeAction;
import dotty.tools.dotc.reporting.CodeAction$;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.MessageKind;
import dotty.tools.dotc.reporting.MessageKind$;
import dotty.tools.dotc.rewrites.Rewrites;
import dotty.tools.dotc.rewrites.Rewrites$ActionPatch$;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PatternMatchExhaustivity
extends Message {
    private final Seq<String> uncoveredCases;
    private final Trees.Match<Types.Type> tree;
    private final boolean hasMore;
    private final String uncovered;

    public PatternMatchExhaustivity(Seq<String> uncoveredCases, Trees.Match<Types.Type> tree, Contexts.Context x$3) {
        this.uncoveredCases = uncoveredCases;
        this.tree = tree;
        super(ErrorMessageID$.PatternMatchExhaustivityID, x$3);
        this.hasMore = uncoveredCases.lengthCompare(6) > 0;
        this.uncovered = ((IterableOnceOps)uncoveredCases.take(6)).mkString(", ");
    }

    @Override
    public MessageKind kind() {
        return MessageKind$.PatternMatchExhaustivity;
    }

    public String uncovered() {
        return this.uncovered;
    }

    @Override
    public String msg(Contexts.Context x$1) {
        String addendum = this.hasMore ? "(More unmatched cases are elided)" : "";
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|", " may not be exhaustive.\n        |\n        |It would fail on pattern case: ", "\n        |", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)Formatting$.MODULE$.hl("match", x$1)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)this.uncovered()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)addendum)}), x$1);
    }

    @Override
    public String explain(Contexts.Context x$1) {
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|There are several ways to make the match exhaustive:\n        | - Add missing cases as shown in the warning\n        | - If an extractor always return ", ", write ", " for its return type\n        | - Add a ", " at the end to match all remaining cases\n        |"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)Formatting$.MODULE$.hl("Some(...)", x$1)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)Formatting$.MODULE$.hl("Some[X]", x$1)), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)Formatting$.MODULE$.hl("case _ => ...", x$1))}), x$1);
    }

    @Override
    public List<CodeAction> actions(Contexts.Context x$1) {
        SourcePosition endPos = (SourcePosition)this.tree.cases().lastOption().map((Function1 & Serializable)_$6 -> _$6.endPos(x$1)).getOrElse(() -> this.$anonfun$8(x$1));
        int startColumn = BoxesRunTime.unboxToInt((Object)this.tree.cases().lastOption().map((Function1 & Serializable)_$7 -> _$7.startPos(x$1).startColumn()).getOrElse(() -> this.$anonfun$10(x$1)));
        List pathes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rewrites.ActionPatch[]{Rewrites$ActionPatch$.MODULE$.apply(endPos, ((IterableOnceOps)this.uncoveredCases.map((Function1 & Serializable)c -> this.indent(new StringBuilder(12).append("case ").append((String)c).append(" => ???").toString(), startColumn))).mkString("\n", "\n", ""))}));
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodeAction[]{CodeAction$.MODULE$.apply(new StringBuilder(23).append("Insert missing cases (").append(this.uncoveredCases.size()).append(")").toString(), (Option<String>)None$.MODULE$, (List<Rewrites.ActionPatch>)pathes)}));
    }

    private String indent(String text, int margin) {
        return new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), margin)).append(text).toString();
    }

    private final SourcePosition $anonfun$8(Contexts.Context x$1$12) {
        return this.tree.selector().endPos(x$1$12);
    }

    private final int $anonfun$10(Contexts.Context x$1$14) {
        return this.tree.selector().startPos(x$1$14).startColumn() + 2;
    }
}

