/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.AbstractFile;
import dotty.tools.io.File;
import dotty.tools.io.FileZipArchive;
import dotty.tools.io.VirtualFile;
import dotty.tools.io.ZipArchive$;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.;
import scala.$less$colon$less$;
import scala.Equals;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.runtime.ScalaRunTime$;

public abstract class ZipArchive
extends AbstractFile
implements Equals {
    private final Path jpath;

    public static boolean closeZipFile() {
        return ZipArchive$.MODULE$.closeZipFile();
    }

    public static FileZipArchive fromFile(File file) {
        return ZipArchive$.MODULE$.fromFile(file);
    }

    public static AbstractFile fromManifestURL(URL uRL) {
        return ZipArchive$.MODULE$.fromManifestURL(uRL);
    }

    public static FileZipArchive fromPath(Path path) {
        return ZipArchive$.MODULE$.fromPath(path);
    }

    public ZipArchive(Path jpath, Option<String> release) {
        this.jpath = jpath;
    }

    @Override
    public Path jpath() {
        return this.jpath;
    }

    public Option<ZipArchive> underlyingSource() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw this.unsupported();
    }

    @Override
    public void create() {
        throw this.unsupported();
    }

    @Override
    public void delete() {
        throw this.unsupported();
    }

    @Override
    public OutputStream output() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile container() {
        throw this.unsupported();
    }

    @Override
    public AbstractFile absolute() {
        throw this.unsupported();
    }

    private DirEntry ensureDir(Map<String, DirEntry> dirs, String path) {
        Option option = dirs.get((Object)path);
        if (option instanceof Some) {
            DirEntry v = (DirEntry)((Some)option).value();
            return v;
        }
        if (None$.MODULE$.equals(option)) {
            DirEntry parent = this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(path));
            DirEntry dir = new DirEntry(path, parent);
            parent.entries().update((Object)ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), (Object)dir);
            dirs.update((Object)path, (Object)dir);
            return dir;
        }
        throw new MatchError((Object)option);
    }

    public DirEntry getDir(Map<String, DirEntry> dirs, ZipEntry entry) {
        if (entry.isDirectory()) {
            return this.ensureDir(dirs, entry.getName());
        }
        return this.ensureDir(dirs, ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$dirName(entry.getName()));
    }

    public abstract void close();

    public class DirEntry
    extends Entry {
        private final HashMap entries;

        public DirEntry(String path, Entry parent) {
            if (ZipArchive.this == null) {
                throw new NullPointerException();
            }
            super(ZipArchive.this, path, parent);
            this.entries = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        private String path$accessor() {
            return super.path();
        }

        private Entry parent$accessor() {
            return super.parent();
        }

        public HashMap<String, Entry> entries() {
            return this.entries;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public Iterator<Entry> iterator() {
            return this.entries().valuesIterator();
        }

        @Override
        public Entry lookupName(String name, boolean directory) {
            if (directory) {
                return (Entry)this.entries().get((Object)new StringBuilder(1).append(name).append("/").toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return (Entry)this.entries().get((Object)name).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public final /* synthetic */ ZipArchive dotty$tools$io$ZipArchive$DirEntry$$$outer() {
            return ZipArchive.this;
        }
    }

    public abstract class Entry
    extends VirtualFile {
        private final Entry parent;
        private final /* synthetic */ ZipArchive $outer;

        public Entry(ZipArchive $outer, String path, Entry parent) {
            this.parent = parent;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(ZipArchive$.MODULE$.dotty$tools$io$ZipArchive$$$baseName(path), path);
        }

        private String path$accessor() {
            return super.path();
        }

        public Entry parent() {
            return this.parent;
        }

        public ZipFile getArchive() {
            return null;
        }

        public Option<ZipArchive> underlyingSource() {
            return Some$.MODULE$.apply((Object)this.$outer);
        }

        @Override
        public AbstractFile resolveSibling(String name) {
            return this.parent().lookupName(name, false);
        }

        @Override
        public String toString() {
            return new StringBuilder(2).append(this.$outer.path()).append("(").append(this.path$accessor()).append(")").toString();
        }

        public final /* synthetic */ ZipArchive dotty$tools$io$ZipArchive$Entry$$$outer() {
            return this.$outer;
        }
    }
}

