/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.ast.Positioned;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.tasty.TastyPickler;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.Spans$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.function.JProcedure1;

public class PositionPickler {
    private final TastyPickler pickler;
    private final TreeToAddr addrOfTree;
    private final Function1<Trees.MemberDef<Types.Type>, List<Trees.Tree<Types.Type>>> treeAnnots;
    private final String relativePathReference;
    private final TastyBuffer buf;
    private final BitSet pickledIndices;

    public PositionPickler(TastyPickler pickler, TreeToAddr addrOfTree, Function1<Trees.MemberDef<Types.Type>, List<Trees.Tree<Types.Type>>> treeAnnots, String relativePathReference) {
        this.pickler = pickler;
        this.addrOfTree = addrOfTree;
        this.treeAnnots = treeAnnots;
        this.relativePathReference = relativePathReference;
        this.buf = new TastyBuffer(5000);
        pickler.newSection("Positions", this.buf());
        this.pickledIndices = new BitSet();
    }

    public TastyBuffer buf() {
        return this.buf;
    }

    public int header(int addrDelta, boolean hasStartDelta, boolean hasEndDelta, boolean hasPoint) {
        return addrDelta << 3 | PositionPickler.toInt$1(hasStartDelta) << 2 | PositionPickler.toInt$1(hasEndDelta) << 1 | PositionPickler.toInt$1(hasPoint);
    }

    public void picklePositions(SourceFile source, List<Trees.Tree<Types.Type>> roots, ListBuffer<Message> warnings) {
        this.pickleLineOffsets$1(source);
        IntRef lastIndex = IntRef.create((int)0);
        LongRef lastSpan = LongRef.create((long)Spans$.MODULE$.Span(0, 0));
        roots.foreach((Function1)(JProcedure1 & Serializable)root -> this.traverse$1(lastIndex, lastSpan, root, NoSource$.MODULE$));
    }

    private static final int toInt$1(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    private static final /* synthetic */ boolean pickleLineOffsets$1$$anonfun$1(char _$1) {
        return _$1 == '\n';
    }

    private final void pickleLineOffsets$1(SourceFile source$1) {
        char[] content = source$1.content();
        Object object = Predef$.MODULE$.charArrayOps(content);
        this.buf().writeNat(ArrayOps$.MODULE$.count$extension(object, (Function1 & Serializable)_$1 -> PositionPickler.pickleLineOffsets$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1))) + 1);
        Object object2 = Predef$.MODULE$.charArrayOps(content);
        int lastIndex = ArrayOps$.MODULE$.indexOf$extension(object2, (Object)BoxesRunTime.boxToCharacter((char)'\n'), 0);
        this.buf().writeNat(lastIndex);
        while (lastIndex != -1) {
            Object object3 = Predef$.MODULE$.charArrayOps(content);
            int nextIndex = ArrayOps$.MODULE$.indexOf$extension(object3, (Object)BoxesRunTime.boxToCharacter((char)'\n'), lastIndex + 1);
            int end = nextIndex != -1 ? nextIndex : content.length;
            this.buf().writeNat(end - lastIndex - 1);
            lastIndex = nextIndex;
        }
    }

    private final BitSet pickleDeltas$1(IntRef lastIndex$1, LongRef lastSpan$1, int index, long span) {
        long l;
        int n;
        int addrDelta = index - lastIndex$1.elem;
        int startDelta = Spans$Span$.MODULE$.start$extension(span) - Spans$Span$.MODULE$.start$extension(lastSpan$1.elem);
        int endDelta = Spans$Span$.MODULE$.end$extension(span) - Spans$Span$.MODULE$.end$extension(lastSpan$1.elem);
        this.buf().writeInt(this.header(addrDelta, startDelta != 0, endDelta != 0, !Spans$Span$.MODULE$.isSynthetic$extension(span)));
        if (startDelta != 0) {
            this.buf().writeInt(startDelta);
        }
        if (endDelta != 0) {
            this.buf().writeInt(endDelta);
        }
        if (!Spans$Span$.MODULE$.isSynthetic$extension(span)) {
            this.buf().writeInt(Spans$Span$.MODULE$.pointDelta$extension(span));
        }
        lastIndex$1.elem = n = index;
        lastSpan$1.elem = l = span;
        return this.pickledIndices.addOne(index);
    }

    private final void pickleSource$1(SourceFile source) {
        this.buf().writeInt(4);
        String relativePath = SourceFile$.MODULE$.relativePath(source, this.relativePathReference);
        this.buf().writeInt(this.pickler.nameBuffer().nameIndex(Decorators$.MODULE$.toTermName(relativePath)));
    }

    private static final boolean alwaysNeedsPos$1(Positioned x) {
        Positioned positioned = x;
        return positioned instanceof Trees.WithLazyField || positioned instanceof Trees.DefTree || positioned instanceof Trees.PackageDef || positioned instanceof Trees.Hole;
        {
        }
    }

    private final void traverse$1(IntRef lastIndex$2, LongRef lastSpan$2, Object x, SourceFile current) {
        while (true) {
            Object object;
            if ((object = x) instanceof Trees.Tree) {
                Trees.Tree tree;
                int addr;
                Trees.Tree x2 = (Trees.Tree)object;
                if (Spans$Span$.MODULE$.exists$extension(x2.span()) && TastyBuffer.Addr$.MODULE$.$bang$eq$extension(addr = this.addrOfTree.apply(x2), TastyBuffer$.MODULE$.NoAddr())) {
                    SourceFile sourceFile = x2.source();
                    SourceFile sourceFile2 = current;
                    if (sourceFile == null ? sourceFile2 != null : !((Object)sourceFile).equals(sourceFile2)) {
                        this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                        this.pickleSource$1(x2.source());
                    } else if (!this.pickledIndices.contains(addr) && (Spans$Span$.MODULE$.$bang$eq$extension(Spans$Span$.MODULE$.toSynthetic$extension(x2.span()), x2.envelope(x2.source(), x2.envelope$default$2())) || PositionPickler.alwaysNeedsPos$1(x2))) {
                        this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                    }
                }
                if ((tree = x2) instanceof Trees.MemberDef) {
                    Trees.MemberDef x3 = (Trees.MemberDef)tree;
                    this.traverse$1(lastIndex$2, lastSpan$2, this.treeAnnots.apply((Object)x3), x3.source());
                }
                int limit = x2.productArity();
                for (int n = 0; n < limit; ++n) {
                    this.traverse$1(lastIndex$2, lastSpan$2, x2.productElement(n), x2.source());
                }
                return;
            }
            if (!(object instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)object;
            List list = colon2.next$access$1();
            Object y = colon2.head();
            List ys = list;
            this.traverse$1(lastIndex$2, lastSpan$2, y, current);
            x = ys;
        }
    }

    @FunctionalInterface
    public static interface TreeToAddr {
        public int apply(Trees.Tree<Types.Type> var1);
    }
}

