/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.config.Feature$;
import dotty.tools.dotc.config.NoScalaVersion$;
import dotty.tools.dotc.config.ScalaVersion;
import dotty.tools.dotc.config.ScalaVersion$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Constants;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.Types$TermRef$;
import dotty.tools.dotc.core.Types$TypeRef$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.reporting.SymbolChangedSemanticsInVersion;
import dotty.tools.dotc.reporting.SymbolHasUnparsableVersionNumber;
import dotty.tools.dotc.transform.CrossVersionChecks;
import dotty.tools.dotc.transform.CrossVersionChecks$;
import dotty.tools.dotc.transform.FirstTransform$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.transform.SymUtils$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class CrossVersionChecks
extends MegaPhase.MiniPhase {
    public static void checkExperimentalRef(Symbols.Symbol symbol, SrcPos srcPos, Contexts.Context context) {
        CrossVersionChecks$.MODULE$.checkExperimentalRef(symbol, srcPos, context);
    }

    public static String name() {
        return CrossVersionChecks$.MODULE$.name();
    }

    @Override
    public String phaseName() {
        return CrossVersionChecks$.MODULE$.name();
    }

    @Override
    public String description() {
        return CrossVersionChecks$.MODULE$.description();
    }

    @Override
    public Set<String> runsAfterGroupsOf() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FirstTransform$.MODULE$.name()}));
    }

    private void checkUndesiredProperties(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        ScalaVersion xMigrationValue;
        this.checkDeprecated(sym, pos, x$3);
        CrossVersionChecks$.MODULE$.checkExperimentalRef(sym, pos, x$3);
        ScalaVersion scalaVersion = xMigrationValue = (ScalaVersion)Settings$Setting$.MODULE$.value(x$3.settings().Xmigration(), x$3);
        NoScalaVersion$ noScalaVersion$ = NoScalaVersion$.MODULE$;
        if (scalaVersion == null ? noScalaVersion$ != null : !scalaVersion.equals(noScalaVersion$)) {
            this.checkMigration(sym, pos, xMigrationValue, x$3);
            return;
        }
    }

    private void checkDeprecated(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        Symbols$.MODULE$.toDenot(sym, x$3).getAnnotation(Symbols$.MODULE$.defn(x$3).DeprecatedAnnot(), x$3).foreach((Function1)(JProcedure1 & Serializable)annot -> {
            if (!CrossVersionChecks.skipWarning$1(sym, x$3)) {
                String msg = (String)annot.argumentConstant(0, x$3).map((Function1 & Serializable)_$2 -> new StringBuilder(2).append(": ").append(_$2.stringValue()).toString()).getOrElse(CrossVersionChecks::$anonfun$2);
                String since = (String)annot.argumentConstant(1, x$3).map((Function1 & Serializable)_$3 -> new StringBuilder(7).append(" since ").append(_$3.stringValue()).toString()).getOrElse(CrossVersionChecks::$anonfun$4);
                report$.MODULE$.deprecationWarning(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> CrossVersionChecks.checkDeprecated$$anonfun$1$$anonfun$1(sym, x$3, msg, since))), pos, x$3);
                return;
            }
        });
    }

    private void checkExperimentalSignature(Symbols.Symbol sym, SrcPos pos, Contexts.Context x$3) {
        if (!SymUtils$.MODULE$.isInExperimentalScope(sym, x$3)) {
            public class Dotty_tools_dotc_transform_CrossVersionChecks$Checker$1
            extends Types.TypeTraverser {
                private final SrcPos pos$3;

                public Dotty_tools_dotc_transform_CrossVersionChecks$Checker$1(SrcPos pos$2, Contexts.Context x$3$3) {
                    this.pos$3 = pos$2;
                    super(x$3$3);
                }

                public void traverse(Types.Type tp) {
                    if (SymUtils$.MODULE$.isExperimental(tp.typeSymbol(this.accCtx()), this.accCtx())) {
                        Feature$.MODULE$.checkExperimentalDef(tp.typeSymbol(this.accCtx()), this.pos$3, this.accCtx());
                        return;
                    }
                    this.traverseChildren(tp);
                }
            }
            new Dotty_tools_dotc_transform_CrossVersionChecks$Checker$1(pos, x$3).traverse(Symbols$.MODULE$.toDenot(sym, x$3).info(x$3));
            return;
        }
    }

    private void checkExperimentalAnnots(Symbols.Symbol sym, Contexts.Context x$2) {
        if (!SymUtils$.MODULE$.isInExperimentalScope(sym, x$2)) {
            Symbols$.MODULE$.toDenot(sym, x$2).annotations(x$2).withFilter((Function1 & Serializable)annot -> SymUtils$.MODULE$.isExperimental(annot.symbol(x$2), x$2)).foreach((Function1)(JProcedure1 & Serializable)annot -> Feature$.MODULE$.checkExperimentalDef(annot.symbol(x$2), annot.tree(x$2), x$2));
            return;
        }
    }

    private void checkMigration(Symbols.Symbol sym, SrcPos pos, ScalaVersion xMigrationValue, Contexts.Context x$4) {
        Symbols$.MODULE$.toDenot(sym, x$4).getAnnotation(Symbols$.MODULE$.defn(x$4).MigrationAnnot(), x$4).foreach((Function1)(JProcedure1 & Serializable)annot -> {
            ScalaVersion symVersion;
            Try<ScalaVersion> migrationVersion = ScalaVersion$.MODULE$.parse(((Constants.Constant)annot.argumentConstant(1, x$4).get()).stringValue());
            Try<ScalaVersion> try_ = migrationVersion;
            if (try_ instanceof Success && xMigrationValue.$less(symVersion = (ScalaVersion)((Success)try_).value())) {
                String msg = ((Constants.Constant)annot.argumentConstant(0, x$4).get()).stringValue();
                report$.MODULE$.warning(new SymbolChangedSemanticsInVersion(sym, symVersion, msg, x$4), pos, x$4);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                String x$proxy1 = ex.getMessage();
                report$.MODULE$.warning(new SymbolHasUnparsableVersionNumber(sym, (String)Scala3RunTime$.MODULE$.nn((Object)x$proxy1), x$4), pos, x$4);
                return;
            }
        });
    }

    private void checkDeprecatedOvers(Trees.Tree<Types.Type> tree, Contexts.Context x$2) {
        Symbols.Symbol symbol = tree.symbol(x$2);
        if (SymUtils$.MODULE$.isDeprecated(symbol, x$2)) {
            Iterator concrOvers = Symbols$.MODULE$.toDenot(symbol, x$2).allOverriddenSymbols(x$2).filter((Function1 & Serializable)sym -> !SymUtils$.MODULE$.isDeprecated((Symbols.Symbol)sym, x$2) && !Symbols$.MODULE$.toDenot((Symbols.Symbol)sym, x$2).is(Flags$.MODULE$.Deferred(), x$2));
            if (!concrOvers.isEmpty()) {
                report$.MODULE$.deprecationWarning(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> CrossVersionChecks.checkDeprecatedOvers$$anonfun$1(x$2, symbol, concrOvers))), tree.srcPos(), x$2);
                return;
            }
            return;
        }
    }

    private void checkExperimentalInheritance(Symbols.ClassSymbol cls, Contexts.Context x$2) {
        if (!Symbols$.MODULE$.toClassDenot(cls, x$2).isAnonymousClass(x$2) && !Symbols$.MODULE$.toClassDenot(cls, x$2).hasAnnotation(Symbols$.MODULE$.defn(x$2).ExperimentalAnnot(), x$2)) {
            Option option = Symbols$.MODULE$.toClassDenot(cls, x$2).info(x$2).parents(x$2).find((Function1 & Serializable)_$5 -> SymUtils$.MODULE$.isExperimental(_$5.typeSymbol(x$2), x$2));
            if (option instanceof Some) {
                Types.Type parent = (Types.Type)((Some)option).value();
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation((Function0<String>)((Function0 & Serializable)() -> CrossVersionChecks.checkExperimentalInheritance$$anonfun$2(x$2, parent))), cls.srcPos(), report$.MODULE$.error$default$3(), x$2);
                return;
            }
            return;
        }
    }

    public Trees.ValDef<Types.Type> transformValDef(Trees.ValDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkDeprecatedOvers(tree, x$2);
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        this.checkExperimentalSignature(tree.symbol(x$2), tree, x$2);
        return tree;
    }

    public Trees.DefDef<Types.Type> transformDefDef(Trees.DefDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkDeprecatedOvers(tree, x$2);
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        this.checkExperimentalSignature(tree.symbol(x$2), tree, x$2);
        return tree;
    }

    @Override
    public Trees.Tree<Types.Type> transformTemplate(Trees.Template<Types.Type> tree, Contexts.Context x$2) {
        Symbols.ClassSymbol cls = x$2.owner().asClass();
        this.checkExperimentalInheritance(cls, x$2);
        this.checkExperimentalAnnots(cls, x$2);
        return tree;
    }

    public Trees.Ident<Types.Type> transformIdent(Trees.Ident<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(tree.symbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.Select<Types.Type> transformSelect(Trees.Select<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(tree.symbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.New<Types.Type> transformNew(Trees.New<Types.Type> tree, Contexts.Context x$2) {
        this.checkUndesiredProperties(((Types.Type)tree.tpe()).typeSymbol(x$2), tree.srcPos(), x$2);
        return tree;
    }

    public Trees.TypeTree<Types.Type> transformTypeTree(Trees.TypeTree<Types.Type> tree, Contexts.Context x$2) {
        Types.Type tpe = (Types.Type)tree.tpe();
        tpe.foreachPart((Function1<Types.Type, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            Types.Type type = x$1;
            if (type instanceof Types.TypeRef) {
                Types.TypeRef typeRef = Types$TypeRef$.MODULE$.unapply((Types.TypeRef)type);
                Types.Type type2 = typeRef._1();
                Names.Designator designator = typeRef._2();
                if (designator instanceof Symbols.Symbol) {
                    Symbols.Symbol sym = (Symbols.Symbol)designator;
                    this.checkDeprecated(sym, tree.srcPos(), x$2);
                    CrossVersionChecks$.MODULE$.checkExperimentalRef(sym, tree.srcPos(), x$2);
                    return;
                }
            }
            if (type instanceof Types.TermRef) {
                Types.TermRef termRef = Types$TermRef$.MODULE$.unapply((Types.TermRef)type);
                Types.Type type3 = termRef._1();
                Names.Designator designator = termRef._2();
                if (designator instanceof Symbols.Symbol) {
                    Symbols.Symbol sym = (Symbols.Symbol)designator;
                    this.checkDeprecated(sym, tree.srcPos(), x$2);
                    CrossVersionChecks$.MODULE$.checkExperimentalRef(sym, tree.srcPos(), x$2);
                    return;
                }
            }
        }, tpe.foreachPart$default$2(), x$2);
        return tree;
    }

    public Trees.TypeDef<Types.Type> transformTypeDef(Trees.TypeDef<Types.Type> tree, Contexts.Context x$2) {
        this.checkExperimentalAnnots(tree.symbol(x$2), x$2);
        return tree;
    }

    private static final boolean isEnumOwner$1(Symbols.Symbol sym$1, Symbols.Symbol owner, Contexts.Context x$2) {
        if (SymUtils$.MODULE$.isEnumClass(owner, x$2)) {
            return Symbols$.MODULE$.toDenot(owner, x$2).companionClass(x$2) == Symbols$.MODULE$.toDenot(sym$1, x$2).owner();
        }
        if (Symbols$.MODULE$.toDenot(owner, x$2).is(Flags$.MODULE$.ModuleClass(), x$2) && SymUtils$.MODULE$.isEnumClass(Symbols$.MODULE$.toDenot(owner, x$2).companionClass(x$2), x$2)) {
            return owner == Symbols$.MODULE$.toDenot(sym$1, x$2).owner();
        }
        return false;
    }

    private static final boolean isDeprecatedOrEnum$1(Symbols.Symbol sym$7, Symbols.Symbol owner, Contexts.Context x$2) {
        return SymUtils$.MODULE$.isDeprecated(owner, x$2) || CrossVersionChecks.isEnumOwner$1(sym$7, owner, x$2);
    }

    private static final boolean skipWarning$1(Symbols.Symbol sym$2, Contexts.Context x$1) {
        return Symbols$.MODULE$.toDenot(x$1.owner(), x$1).ownersIterator(x$1).exists((Function1)(SymUtils$.MODULE$.isEnumCase(sym$2, x$1) ? (Function1 & Serializable)owner -> CrossVersionChecks.isDeprecatedOrEnum$1(sym$2, owner, x$1) : (Function1 & Serializable)_$1 -> SymUtils$.MODULE$.isDeprecated((Symbols.Symbol)_$1, x$1)));
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final String checkDeprecated$$anonfun$1$$anonfun$1(Symbols.Symbol sym$5, Contexts.Context x$3$2, String msg$1, String since$1) {
        return new StringBuilder(14).append(sym$5.showLocated(x$3$2)).append(" is deprecated").append(since$1).append(msg$1).toString();
    }

    private static final String checkDeprecatedOvers$$anonfun$1(Contexts.Context x$2$4, Symbols.Symbol symbol$1, Iterator concrOvers$1) {
        return new StringBuilder(46).append(symbol$1.toString()).append(" overrides concrete, non-deprecated symbol(s):").append(concrOvers$1.map((Function1 & Serializable)_$4 -> _$4.name(x$2$4)).mkString("    ", ", ", "")).toString();
    }

    private static final String checkExperimentalInheritance$$anonfun$2(Contexts.Context x$2$7, Types.Type parent$1) {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"extension of experimental ", " must have @experimental annotation"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply((Object)parent$1.typeSymbol(x$2$7))}), x$2$7);
    }
}

