/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Path$;
import dotty.tools.io.Streamable$;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Streamable {
    public static byte[] bytes(Function0<InputStream> function0) {
        return Streamable$.MODULE$.bytes(function0);
    }

    public static <T extends Closeable, U> U closing(T t, Function1<T, U> function1) {
        return Streamable$.MODULE$.closing(t, function1);
    }

    public static String slurp(Function0<InputStream> function0, Codec codec) {
        return Streamable$.MODULE$.slurp(function0, codec);
    }

    public static String slurp(URL uRL, Codec codec) {
        return Streamable$.MODULE$.slurp(uRL, codec);
    }

    public static interface Bytes {
        public InputStream inputStream();

        public static long length$(Bytes $this) {
            return $this.length();
        }

        default public long length() {
            return -1L;
        }

        public static BufferedInputStream bufferedInput$(Bytes $this) {
            return $this.bufferedInput();
        }

        default public BufferedInputStream bufferedInput() {
            return new BufferedInputStream(this.inputStream());
        }

        public static Iterator bytes$(Bytes $this) {
            return $this.bytes();
        }

        default public Iterator<Object> bytes() {
            return this.bytesAsInts().map((Function1 & Serializable)_$1 -> this.bytes$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1)));
        }

        public static Iterator bytesAsInts$(Bytes $this) {
            return $this.bytesAsInts();
        }

        default public Iterator<Object> bytesAsInts() {
            BufferedInputStream in = this.bufferedInput();
            return package$.MODULE$.Iterator().continually(() -> this.bytesAsInts$$anonfun$1(in)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 != -1);
        }

        public static byte[] toByteArray$(Bytes $this) {
            return $this.toByteArray();
        }

        default public byte[] toByteArray() {
            LazyRef lazyRef = new LazyRef();
            if (this.length() == -1L) {
                return (byte[])((IterableOnceOps)new ArrayBuffer().$plus$plus$eq(this.bytes())).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
            }
            byte[] arr = new byte[(int)this.length()];
            int len = arr.length;
            IntRef offset = IntRef.create((int)0);
            try {
                this.loop$1(arr, len, offset, lazyRef);
            }
            finally {
                this.in$2(lazyRef).close();
            }
            if (offset.elem != arr.length) {
                throw Path$.MODULE$.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Could not read entire source (%d of %d bytes)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset.elem), BoxesRunTime.boxToInteger((int)len)})));
            }
            return arr;
        }

        private /* synthetic */ byte bytes$$anonfun$1(int _$1) {
            return (byte)_$1;
        }

        private int bytesAsInts$$anonfun$1(BufferedInputStream in$1) {
            return in$1.read();
        }

        private BufferedInputStream in$lzyINIT1$1(LazyRef in$lzy1$1) {
            BufferedInputStream bufferedInputStream;
            LazyRef lazyRef = in$lzy1$1;
            synchronized (lazyRef) {
                bufferedInputStream = (BufferedInputStream)(in$lzy1$1.initialized() ? in$lzy1$1.value() : in$lzy1$1.initialize((Object)this.bufferedInput()));
            }
            return bufferedInputStream;
        }

        private BufferedInputStream in$2(LazyRef in$lzy1$2) {
            return (BufferedInputStream)(in$lzy1$2.initialized() ? in$lzy1$2.value() : this.in$lzyINIT1$1(in$lzy1$2));
        }

        private void loop$1(byte[] arr$1, int len$1, IntRef offset$1, LazyRef in$lzy1$3) {
            int read;
            while (offset$1.elem < len$1 && (read = this.in$2(in$lzy1$3).read(arr$1, offset$1.elem, len$1 - offset$1.elem)) >= 0) {
                int n;
                offset$1.elem = n = offset$1.elem + read;
            }
        }
    }

    public static interface Chars
    extends Bytes {
        public static Codec creationCodec$(Chars $this) {
            return $this.creationCodec();
        }

        default public Codec creationCodec() {
            return (Codec)Predef$.MODULE$.implicitly((Object)Codec$.MODULE$.fallbackSystemCodec());
        }

        public static BufferedSource chars$(Chars $this, Codec codec) {
            return $this.chars(codec);
        }

        default public BufferedSource chars(Codec codec) {
            return Source$.MODULE$.fromInputStream(this.inputStream(), codec);
        }

        public static Iterator lines$(Chars $this) {
            return $this.lines();
        }

        default public Iterator<String> lines() {
            return this.lines(this.creationCodec());
        }

        public static Iterator lines$(Chars $this, Codec codec) {
            return $this.lines(codec);
        }

        default public Iterator<String> lines(Codec codec) {
            return this.chars(codec).getLines();
        }

        public static InputStreamReader reader$(Chars $this, Codec codec) {
            return $this.reader(codec);
        }

        default public InputStreamReader reader(Codec codec) {
            return new InputStreamReader(this.inputStream(), codec.charSet());
        }

        public static BufferedReader bufferedReader$(Chars $this) {
            return $this.bufferedReader();
        }

        default public BufferedReader bufferedReader() {
            return this.bufferedReader(this.creationCodec());
        }

        public static BufferedReader bufferedReader$(Chars $this, Codec codec) {
            return $this.bufferedReader(codec);
        }

        default public BufferedReader bufferedReader(Codec codec) {
            return new BufferedReader(this.reader(codec));
        }

        public static Object applyReader$(Chars $this, Function1 f) {
            return $this.applyReader(f);
        }

        default public <T> T applyReader(Function1<BufferedReader, T> f) {
            Object object;
            try (BufferedReader in = this.bufferedReader();){
                object = f.apply((Object)in);
            }
            return (T)object;
        }

        public static String slurp$(Chars $this) {
            return $this.slurp();
        }

        default public String slurp() {
            return this.slurp(this.creationCodec());
        }

        public static String slurp$(Chars $this, Codec codec) {
            return $this.slurp(codec);
        }

        default public String slurp(Codec codec) {
            String string;
            try (BufferedSource src = this.chars(codec);){
                string = src.mkString();
            }
            return string;
        }
    }
}

