/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Highlighting$Blue$;
import dotty.tools.dotc.printing.Highlighting$Red$;
import dotty.tools.dotc.printing.Highlighting$Yellow$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public interface MessageRendering {
    public static String stripColor$(MessageRendering $this, String str) {
        return $this.stripColor(str);
    }

    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    public static List outer$(MessageRendering $this, SourcePosition pos, String prefix, Contexts.Context x$3) {
        return $this.outer(pos, prefix, x$3);
    }

    default public List<String> outer(SourcePosition pos, String prefix, Contexts.Context x$3) {
        Nil$ nil$;
        if (pos.outer().exists()) {
            String string = Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "| This location contains code that was inlined from ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{prefix, pos}), x$3);
            nil$ = this.outer(pos.outer(), prefix, x$3).$colon$colon((Object)string);
        } else {
            nil$ = scala.package$.MODULE$.Nil();
        }
        return nil$;
    }

    public static Tuple3 sourceLines$(MessageRendering $this, SourcePosition pos, String diagnosticLevel, Contexts.Context x$3) {
        return $this.sourceLines(pos, diagnosticLevel, x$3);
    }

    default public Tuple3<List<String>, List<String>, Object> sourceLines(SourcePosition pos, String diagnosticLevel, Contexts.Context x$3) {
        if (!pos.exists() || !pos.source().file().exists()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        IntRef maxLen = IntRef.create((int)Integer.MIN_VALUE);
        Object t = Settings$Setting$.MODULE$.value(x$3.settings().color(), x$3);
        String string = "never";
        char[] syntax = (t == null ? string != null : !t.equals(string)) ? SyntaxHighlighting$.MODULE$.highlight(new String(pos.linesSlice()), x$3).toCharArray() : pos.linesSlice();
        List lines = MessageRendering.linesFrom$1(syntax);
        Tuple2<List<Object>, List<Object>> tuple2 = pos.beforeAndAfterPoint();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List before = (List)tuple2._1();
        List after = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)before, (Object)after);
        List before2 = (List)tuple22._1();
        List after2 = (List)tuple22._2();
        return Tuple3$.MODULE$.apply((Object)((List)before2.zip((IterableOnce)lines)).map((Function1 & Serializable)offsetAndLine -> this.render$1(pos, diagnosticLevel, x$3, maxLen, (Tuple2)offsetAndLine)), (Object)((List)after2.zip((IterableOnce)lines.drop(before2.length()))).map((Function1 & Serializable)offsetAndLine -> this.render$1(pos, diagnosticLevel, x$3, maxLen, (Tuple2)offsetAndLine)), (Object)BoxesRunTime.boxToInteger((int)maxLen.elem));
    }

    public static String columnMarker$(MessageRendering $this, SourcePosition pos, int offset, String diagnosticLevel, Contexts.Context x$4) {
        return $this.columnMarker(pos, offset, diagnosticLevel, x$4);
    }

    default public String columnMarker(SourcePosition pos, int offset, String diagnosticLevel, Contexts.Context x$4) {
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset - 1);
        String padding = pos.startColumnPadding();
        String carets = this.hl(diagnosticLevel, pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^", x$4);
        return new StringBuilder(1).append(prefix).append("|").append(padding).append(carets).toString();
    }

    public static String errorMsg$(MessageRendering $this, SourcePosition pos, String msg, int offset, Contexts.Context x$4) {
        return $this.errorMsg(pos, msg, offset, x$4);
    }

    default public String errorMsg(SourcePosition pos, String msg, int offset, Contexts.Context x$4) {
        String padding = (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).foldLeft((Object)pos.startColumnPadding(), (Function2 & Serializable)(pad, line) -> {
            int lineLength = this.stripColor((String)line).length();
            int maxPad = package$.MODULE$.max(0, BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$4.settings().pageWidth(), x$4)) - offset - lineLength) - offset;
            return maxPad < pad.length() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxPad) : pad;
        });
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).map((Function1 & Serializable)line -> new StringBuilder(1).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset - 1)).append("|").append(line.isEmpty() ? "" : new StringBuilder(0).append(padding).append((String)line).toString()).toString()).mkString(System.lineSeparator());
    }

    public static String posFileStr$(MessageRendering $this, SourcePosition pos) {
        return $this.posFileStr(pos);
    }

    /*
     * WARNING - void declaration
     */
    default public String posFileStr(SourcePosition pos) {
        void var2_2;
        String path = pos.source().file().path();
        return pos.exists() ? new StringBuilder(2).append(path).append(":").append(pos.line() + 1).append(":").append(pos.column()).toString() : var2_2;
    }

    public static String posStr$(MessageRendering $this, SourcePosition pos, String diagnosticLevel, Message message, Contexts.Context x$4) {
        return $this.posStr(pos, diagnosticLevel, message, x$4);
    }

    default public String posStr(SourcePosition pos, String diagnosticLevel, Message message, Contexts.Context x$4) {
        String string;
        SourceFile sourceFile = pos.source();
        SourceFile sourceFile2 = NoSourcePosition$.MODULE$.source();
        if (sourceFile == null ? sourceFile2 != null : !((Object)sourceFile).equals(sourceFile2)) {
            String string2;
            String file;
            String fileAndPos = this.posFileStr(pos.nonInlined());
            String string3 = file = fileAndPos.isEmpty() || fileAndPos.endsWith(" ") ? fileAndPos : new StringBuilder(1).append(fileAndPos).append(" ").toString();
            if (message.errorId() != ErrorMessageID$.NoExplanationID) {
                int errorNumber = message.errorId().errorNumber();
                string2 = new StringBuilder(4).append("[E").append(new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 3 - BoxesRunTime.boxToInteger((int)errorNumber).toString().length())).append(errorNumber).toString()).append("] ").toString();
            } else {
                string2 = "";
            }
            String errId = string2;
            String string4 = message.kind();
            String string5 = "";
            String kind = !(string4 != null ? !string4.equals(string5) : string5 != null) ? diagnosticLevel : new StringBuilder(1).append(message.kind()).append(" ").append(diagnosticLevel).toString();
            String prefix = new StringBuilder(5).append("-- ").append(errId).append(kind).append(": ").append(file).toString();
            string = this.hl(diagnosticLevel, new StringBuilder(0).append(prefix).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), package$.MODULE$.max(BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$4.settings().pageWidth(), x$4)) - this.stripColor(prefix).length(), 0))).toString(), x$4);
        } else {
            string = "";
        }
        return string;
    }

    public static String explanation$(MessageRendering $this, Message m, Contexts.Context x$2) {
        return $this.explanation(m, x$2);
    }

    default public String explanation(Message m, Contexts.Context x$2) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(25).append("|\n          |").append(Highlighting$Blue$.MODULE$.apply("Explanation").show(x$2)).append("\n          |").append(Highlighting$Blue$.MODULE$.apply("===========").show(x$2)).toString())));
        sb.append(System.lineSeparator()).append(m.explanation());
        if (!m.explanation().endsWith(System.lineSeparator())) {
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static void appendFilterHelp$(MessageRendering $this, Diagnostic dia, scala.collection.mutable.StringBuilder sb) {
        $this.appendFilterHelp(dia, sb);
    }

    default public void appendFilterHelp(Diagnostic dia, scala.collection.mutable.StringBuilder sb) {
        String category;
        boolean hasId = dia.msg().errorId().errorNumber() >= 0;
        Diagnostic diagnostic = dia;
        String string = diagnostic instanceof Diagnostic.UncheckedWarning ? "unchecked" : (diagnostic instanceof Diagnostic.DeprecationWarning ? "deprecation" : (category = diagnostic instanceof Diagnostic.FeatureWarning ? "feature" : ""));
        if (hasId || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(category))) {
            sb.append(System.lineSeparator()).append("Matching filters for @nowarn or -Wconf:");
            if (hasId) {
                sb.append(System.lineSeparator()).append("  - id=E").append(dia.msg().errorId().errorNumber());
                sb.append(System.lineSeparator()).append("  - name=").append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(dia.msg().errorId().productPrefix()), "ID"));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(category))) {
                sb.append(System.lineSeparator()).append("  - cat=").append(category);
            }
        }
    }

    public static String messageAndPos$(MessageRendering $this, Diagnostic dia, Contexts.Context x$2) {
        return $this.messageAndPos(dia, x$2);
    }

    default public String messageAndPos(Diagnostic dia, Contexts.Context x$2) {
        scala.collection.mutable.StringBuilder stringBuilder;
        String levelString = this.diagnosticLevel(dia);
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        String posString = this.posStr(dia.pos(), levelString, dia.msg(), x$2);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(posString))) {
            sb.append(posString).append(System.lineSeparator());
        }
        if (dia.pos().exists()) {
            SourcePosition pos1 = dia.pos().nonInlined();
            if (pos1.exists() && pos1.source().file().exists()) {
                Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines(pos1, levelString, x$2);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                List srcBefore = (List)tuple3._1();
                List srcAfter = (List)tuple3._2();
                int offset = BoxesRunTime.unboxToInt((Object)tuple3._3());
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
                List srcBefore2 = (List)tuple32._1();
                List srcAfter2 = (List)tuple32._2();
                int offset2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                String marker = this.columnMarker(pos1, offset2, levelString, x$2);
                String err = this.errorMsg(pos1, dia.msg().message(), offset2, x$2);
                List<String> list = this.outer(dia.pos(), StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offset2 - 1), x$2);
                stringBuilder = sb.append(srcAfter2.$colon$colon$colon(list).$colon$colon((Object)err).$colon$colon((Object)marker).$colon$colon$colon(srcBefore2).mkString(System.lineSeparator()));
            } else {
                stringBuilder = sb.append(dia.msg().message());
            }
        } else {
            stringBuilder = sb.append(dia.msg().message());
        }
        if (dia.isVerbose()) {
            this.appendFilterHelp(dia, sb);
        }
        return sb.toString();
    }

    public static String hl$(MessageRendering $this, String diagnosticLevel, String str, Contexts.Context x$3) {
        return $this.hl(diagnosticLevel, str, x$3);
    }

    default public String hl(String diagnosticLevel, String str, Contexts.Context x$3) {
        String string;
        String string2 = diagnosticLevel;
        if ("Info".equals(string2)) {
            string = Highlighting$Blue$.MODULE$.apply(str).show(x$3);
        } else if ("Error".equals(string2)) {
            string = Highlighting$Red$.MODULE$.apply(str).show(x$3);
        } else {
            if (!diagnosticLevel.contains("Warning")) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            string = Highlighting$Yellow$.MODULE$.apply(str).show(x$3);
        }
        return string;
    }

    public static String diagnosticLevel$(MessageRendering $this, Diagnostic dia) {
        return $this.diagnosticLevel(dia);
    }

    default public String diagnosticLevel(Diagnostic dia) {
        String string;
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.FeatureWarning) {
            Diagnostic.FeatureWarning dia2 = (Diagnostic.FeatureWarning)diagnostic;
            string = "Feature Warning";
        } else if (diagnostic instanceof Diagnostic.DeprecationWarning) {
            Diagnostic.DeprecationWarning dia3 = (Diagnostic.DeprecationWarning)diagnostic;
            string = "Deprecation Warning";
        } else if (diagnostic instanceof Diagnostic.UncheckedWarning) {
            Diagnostic.UncheckedWarning dia4 = (Diagnostic.UncheckedWarning)diagnostic;
            string = "Unchecked Warning";
        } else if (diagnostic instanceof Diagnostic.MigrationWarning) {
            Diagnostic.MigrationWarning dia5 = (Diagnostic.MigrationWarning)diagnostic;
            string = "Migration Warning";
        } else {
            int n = dia.level();
            switch (n) {
                case 2: {
                    string = "Error";
                    break;
                }
                case 1: {
                    string = "Warning";
                    break;
                }
                case 0: {
                    string = "Info";
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        return string;
    }

    private String render$1(SourcePosition pos$1, String diagnosticLevel$1, Contexts.Context x$3$1, IntRef maxLen$1, Tuple2 offsetAndLine) {
        int n;
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int offset = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String line = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset), (Object)line);
        int offset2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String line2 = (String)tuple22._2();
        int lineNbr = pos$1.source().offsetToLine(offset2);
        String prefix = new StringBuilder(2).append(lineNbr + 1).append(" |").toString();
        maxLen$1.elem = n = package$.MODULE$.max(maxLen$1.elem, prefix.length());
        String lnum = this.hl(diagnosticLevel$1, new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), package$.MODULE$.max(0, maxLen$1.elem - prefix.length()))).append(prefix).toString(), x$3$1);
        return new StringBuilder(0).append(lnum).append(StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line2))).toString();
    }

    private static boolean pred$1(char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static /* synthetic */ boolean $anonfun$2(char _$1) {
        return !MessageRendering.pred$1(_$1);
    }

    private static List linesFrom$1(char[] arr) {
        Object object = Predef$.MODULE$.charArrayOps(arr);
        Tuple2 tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1 & Serializable)_$1 -> MessageRendering.$anonfun$2(BoxesRunTime.unboxToChar((Object)_$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char[] line = (char[])tuple2._1();
        char[] rest0 = (char[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)line, (Object)rest0);
        char[] line2 = (char[])tuple22._1();
        char[] rest02 = (char[])tuple22._2();
        Object object2 = Predef$.MODULE$.charArrayOps(rest02);
        Tuple2 tuple23 = ArrayOps$.MODULE$.span$extension(object2, (Function1 & Serializable)c -> MessageRendering.pred$1(BoxesRunTime.unboxToChar((Object)c)));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        char[] rest = (char[])tuple23._2();
        char[] rest2 = rest;
        String string = new String(line2);
        Object object3 = Predef$.MODULE$.charArrayOps(rest2);
        return (ArrayOps$.MODULE$.isEmpty$extension(object3) ? scala.package$.MODULE$.Nil() : MessageRendering.linesFrom$1(rest2)).$colon$colon((Object)string);
    }
}

