/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.util.Chars$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.Util$;
import dotty.tools.io.AbstractFile;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.util.Optional;
import scala.CanEqual;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class SourceFile
implements dotty.tools.dotc.interfaces.SourceFile {
    private final AbstractFile file;
    private final Function0<char[]> computeContent;
    private char[] myContent;
    private boolean _maybeInComplete;
    private int[] lineIndicesCache;
    private int lastLine;

    public static CanEqual<SourceFile, SourceFile> eqSource() {
        return SourceFile$.MODULE$.eqSource();
    }

    public static SourceFile fromContext(Contexts.Context context) {
        return SourceFile$.MODULE$.fromContext(context);
    }

    public static boolean isScript(AbstractFile abstractFile, char[] cArray) {
        return SourceFile$.MODULE$.isScript(abstractFile, cArray);
    }

    public static String relativePath(SourceFile sourceFile, String string) {
        return SourceFile$.MODULE$.relativePath(sourceFile, string);
    }

    public static SourceFile virtual(String string, String string2, boolean bl) {
        return SourceFile$.MODULE$.virtual(string, string2, bl);
    }

    public static boolean virtual$default$3() {
        return SourceFile$.MODULE$.virtual$default$3();
    }

    public SourceFile(AbstractFile file, Function0<char[]> computeContent) {
        this.file = file;
        this.computeContent = computeContent;
        this.myContent = null;
        this._maybeInComplete = false;
        this.lastLine = 0;
    }

    public AbstractFile file() {
        return this.file;
    }

    public char[] content() {
        if (this.myContent == null) {
            this.myContent = (char[])this.computeContent.apply();
        }
        return this.myContent;
    }

    private boolean _maybeInComplete() {
        return this._maybeInComplete;
    }

    public void dotty$tools$dotc$util$SourceFile$$_maybeInComplete_$eq(boolean x$0) {
        this._maybeInComplete = x$0;
    }

    public boolean maybeIncomplete() {
        return this._maybeInComplete();
    }

    public SourceFile(AbstractFile file, Codec codec) {
        this(file, SourceFile.SourceFile$superArg$1(file, codec));
    }

    public int tabInc() {
        return 8;
    }

    public String name() {
        return this.file().name();
    }

    public String path() {
        return this.file().path();
    }

    public Optional<File> jfile() {
        return Optional.ofNullable(this.file().file());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (this == that) return true;
        Object object = that;
        if (!(object instanceof SourceFile)) return false;
        SourceFile that2 = (SourceFile)object;
        AbstractFile abstractFile = this.file();
        AbstractFile abstractFile2 = that2.file();
        if (abstractFile == null) {
            if (abstractFile2 != null) {
                return false;
            }
        } else if (!abstractFile.equals(abstractFile2)) return false;
        if (this.start() != that2.start()) return false;
        return true;
    }

    public int hashCode() {
        return this.file().hashCode() * 41 + BoxesRunTime.boxToInteger((int)this.start()).hashCode();
    }

    public char apply(int idx) {
        return this.content()[idx];
    }

    public int length() {
        int n;
        if (this.lineIndicesCache != null) {
            Object object = Predef$.MODULE$.intArrayOps(this.lineIndicesCache);
            n = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(object));
        } else {
            n = this.content().length;
        }
        return n;
    }

    public boolean exists() {
        return true;
    }

    public SourceFile underlying() {
        return this;
    }

    public int start() {
        return 0;
    }

    public SourcePosition atSpan(long span) {
        return Spans$Span$.MODULE$.exists$extension(span) ? SourcePosition$.MODULE$.apply(this.underlying(), span, SourcePosition$.MODULE$.$lessinit$greater$default$3()) : NoSourcePosition$.MODULE$;
    }

    public boolean isSelfContained() {
        return this.underlying() == this;
    }

    public SourcePosition positionInUltimateSource(SourcePosition position) {
        return SourcePosition$.MODULE$.apply(this.underlying(), Spans$Span$.MODULE$.shift$extension(position.span(), this.start()), SourcePosition$.MODULE$.$lessinit$greater$default$3());
    }

    private int[] calculateLineIndicesFromContents() {
        char[] cs = this.content();
        ArrayBuffer buf = new ArrayBuffer();
        buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        for (int i = 0; i < cs.length; ++i) {
            boolean isLineBreak;
            char ch = cs[i];
            boolean bl = ch == '\r' ? i + 1 == cs.length || cs[i + 1] != '\n' : (isLineBreak = Chars$.MODULE$.isLineBreakChar(ch));
            if (!isLineBreak) continue;
            buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
        }
        buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)cs.length));
        return (int[])buf.toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    private int[] lineIndices() {
        if (this.lineIndicesCache == null) {
            this.lineIndicesCache = this.calculateLineIndicesFromContents();
        }
        return this.lineIndicesCache;
    }

    public boolean initialized() {
        return this.lineIndicesCache != null;
    }

    public void setLineIndicesFromLineSizes(int[] sizes) {
        int lines = sizes.length;
        int[] indices = new int[lines + 1];
        int penultimate = lines - 1;
        for (int i = 0; i < penultimate; ++i) {
            indices[i + 1] = indices[i] + sizes[i] + 1;
        }
        indices[lines] = indices[penultimate] + sizes[penultimate];
        this.lineIndicesCache = indices;
    }

    public int lineToOffset(int index) {
        return this.lineIndices()[index];
    }

    public Option<Object> lineToOffsetOpt(int index) {
        return index < 0 || index >= this.lineIndices().length ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.lineToOffset(index)));
    }

    public int offsetToLine(int offset) {
        this.lastLine = Util$.MODULE$.bestFit(this.lineIndices(), this.lineIndices().length, offset, this.lastLine);
        if (offset >= this.length()) {
            --this.lastLine;
        }
        return this.lastLine;
    }

    public int startOfLine(int offset) {
        Predef$.MODULE$.require(offset >= 0);
        return this.lineToOffset(this.offsetToLine(offset));
    }

    public int nextLine(int offset) {
        return this.lineToOffset(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.offsetToLine(offset) + 1), this.lineIndices().length - 1));
    }

    public String lineContent(int offset) {
        Object object = Predef$.MODULE$.charArrayOps(this.content());
        return Predef$.MODULE$.wrapCharArray((char[])ArrayOps$.MODULE$.slice$extension(object, this.startOfLine(offset), this.nextLine(offset))).mkString();
    }

    /*
     * WARNING - void declaration
     */
    public int column(int offset) {
        void var3_3;
        int col = 0;
        for (int idx = this.startOfLine(offset); idx != offset; ++idx) {
            col += idx < this.content().length && this.content()[idx] == '\t' ? (this.tabInc() - col) % this.tabInc() : 1;
        }
        return (int)var3_3;
    }

    public String startColumnPadding(int offset) {
        StringBuilder pad = new StringBuilder();
        for (int idx = this.startOfLine(offset); idx != offset; ++idx) {
            pad.append((char)(idx < this.length() && this.content()[idx] == '\t' ? 9 : 32));
        }
        return pad.result();
    }

    public String toString() {
        return this.file().toString();
    }

    private static Function0<char[]> SourceFile$superArg$1(AbstractFile file, Codec codec) {
        return () -> SourceFile.SourceFile$superArg$1$$anonfun$1(file, codec);
    }

    private static final char[] SourceFile$superArg$1$$anonfun$1(AbstractFile file$2, Codec codec$1) {
        char[] cArray;
        try {
            cArray = new String(file$2.toByteArray(), codec$1.charSet()).toCharArray();
        }
        catch (NoSuchFileException noSuchFileException) {
            cArray = new char[]{};
        }
        return cArray;
    }
}

