/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scripting;

import dotty.tools.dotc.Driver;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath$;
import dotty.tools.io.Directory$;
import dotty.tools.io.PlainDirectory;
import dotty.tools.scripting.ScriptingException$;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ScriptingDriver
extends Driver {
    private final String[] compilerArgs;
    private final File scriptFile;
    private final String[] scriptArgs;

    public ScriptingDriver(String[] compilerArgs, File scriptFile, String[] scriptArgs) {
        this.compilerArgs = compilerArgs;
        this.scriptFile = scriptFile;
        this.scriptArgs = scriptArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compileAndRun(Function3<Path, Seq<Path>, String, Object> pack) {
        Tuple2 tuple2;
        Path outDir = Files.createTempDirectory("scala3-scripting", new FileAttribute[0]);
        outDir.toFile().deleteOnExit();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.compilerArgs);
        Option<Tuple2<List<AbstractFile>, Contexts.Context>> option = this.setup((String[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)this.scriptFile.getAbsolutePath(), ClassTag$.MODULE$.apply(String.class)), this.initCtx().fresh());
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            LazyRef lazyRef;
            List toCompile = (List)tuple2._1();
            Contexts.Context rootCtx = (Contexts.Context)tuple2._2();
            if (this.doCompile(this.newCompiler(ScriptingDriver.given_Context$1(outDir, rootCtx, lazyRef = new LazyRef())), (List<AbstractFile>)toCompile, ScriptingDriver.given_Context$1(outDir, rootCtx, lazyRef)).hasErrors()) {
                throw ScriptingException$.MODULE$.apply("Errors encountered during compilation");
            }
            try {
                try {
                    boolean bl;
                    String classpath = new StringBuilder(0).append(Settings$Setting$.MODULE$.value(ScriptingDriver.given_Context$1(outDir, rootCtx, lazyRef).settings().classpath(), ScriptingDriver.given_Context$1(outDir, rootCtx, lazyRef))).append(this.pathsep()).append(scala.sys.package$.MODULE$.props().apply((Object)"java.class.path")).toString();
                    List classpathEntries = ClassPath$.MODULE$.expandPath(classpath, true).map((Function1 & Serializable)_$1 -> Paths.get(_$1, new String[0]));
                    Tuple2<String, Method> tuple22 = this.detectMainClassAndMethod(outDir, (Seq<Path>)classpathEntries, this.scriptFile);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    String mainClass = (String)tuple22._1();
                    Method mainMethod = (Method)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)mainClass, (Object)mainMethod);
                    String mainClass2 = (String)tuple23._1();
                    Method mainMethod2 = (Method)tuple23._2();
                    Option option2 = Option$.MODULE$.apply(pack);
                    if (option2 instanceof Some) {
                        Function3 func = (Function3)((Some)option2).value();
                        bl = BoxesRunTime.unboxToBoolean((Object)func.apply((Object)outDir, (Object)classpathEntries, (Object)mainClass2));
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                        bl = true;
                    }
                    boolean invokeMain = bl;
                    if (!invokeMain) return;
                    mainMethod2.invoke(null, new Object[]{this.scriptArgs});
                    return;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            finally {
                this.deleteFile(outDir.toFile());
            }
        } else {
            if (None$.MODULE$.equals(option)) return;
            throw new MatchError(option);
        }
    }

    public Function3<Path, Seq<Path>, String, Object> compileAndRun$default$1() {
        return null;
    }

    private void deleteFile(File target) {
        if (target.isDirectory()) {
            Predef$.MODULE$.wrapRefArray((Object[])target.listFiles()).toList().foreach((Function1)(JProcedure1 & Serializable)member -> this.deleteFile((File)member));
        }
        target.delete();
    }

    private Tuple2<String, Method> detectMainClassAndMethod(Path outDir, Seq<Path> classpathEntries, File scriptFile) {
        Tuple2 m;
        block7: {
            List list;
            block5: {
                List list2;
                Nil$ nil$;
                block6: {
                    List candidates;
                    Seq classpathUrls = (Seq)((IterableOps)classpathEntries.$colon$plus((Object)outDir)).map((Function1 & Serializable)_$2 -> _$2.toUri().toURL());
                    URLClassLoader cl = new URLClassLoader((URL[])classpathUrls.toArray(ClassTag$.MODULE$.apply(URL.class)));
                    list = candidates = Predef$.MODULE$.wrapRefArray((Object[])outDir.toFile().listFiles()).toList().flatMap((Function1 & Serializable)file -> ScriptingDriver.collectMainMethods$3(cl, file, "").map((Function1 & Serializable)method -> method));
                    Nil$ nil$2 = package$.MODULE$.Nil();
                    List list3 = list;
                    if (!(nil$2 != null ? !nil$2.equals(list3) : list3 != null)) {
                        throw ScriptingException$.MODULE$.apply(new StringBuilder(35).append("No main methods detected in script ").append(scriptFile).toString());
                    }
                    if (!(list instanceof .colon.colon)) break block5;
                    .colon.colon colon2 = (.colon.colon)list;
                    List list4 = colon2.next$access$1();
                    if (list4 instanceof .colon.colon) {
                        List list5 = ((.colon.colon)list4).next$access$1();
                        throw ScriptingException$.MODULE$.apply(new StringBuilder(44).append("A script must contain only one main method. ").append(new StringBuilder(37).append("Detected the following main methods:\n").append(candidates.mkString("\n")).toString()).toString());
                    }
                    m = (Tuple2)colon2.head();
                    nil$ = package$.MODULE$.Nil();
                    list2 = list4;
                    if (nil$ != null) break block6;
                    if (list2 == null) break block7;
                    break block5;
                }
                if (nil$.equals(list2)) break block7;
            }
            throw new MatchError((Object)list);
        }
        return m;
    }

    public String pathsep() {
        return (String)scala.sys.package$.MODULE$.props().apply((Object)"path.separator");
    }

    private static final Contexts.Context given_Context$lzyINIT1$1(Path outDir$1, Contexts.Context rootCtx$1, LazyRef given_Context$lzy1$1) {
        Contexts.Context context;
        LazyRef lazyRef = given_Context$lzy1$1;
        synchronized (lazyRef) {
            context = (Contexts.Context)(given_Context$lzy1$1.initialized() ? given_Context$lzy1$1.value() : given_Context$lzy1$1.initialize((Object)rootCtx$1.fresh().setSetting(rootCtx$1.settings().outputDir(), new PlainDirectory(Directory$.MODULE$.apply(outDir$1)))));
        }
        return context;
    }

    private static final Contexts.Context given_Context$1(Path outDir$2, Contexts.Context rootCtx$2, LazyRef given_Context$lzy1$2) {
        return (Contexts.Context)(given_Context$lzy1$2.initialized() ? given_Context$lzy1$2.value() : ScriptingDriver.given_Context$lzyINIT1$1(outDir$2, rootCtx$2, given_Context$lzy1$2));
    }

    private static final /* synthetic */ boolean $anonfun$4(char _$3) {
        return _$3 != '.';
    }

    private static final List collectMainMethods$3(URLClassLoader cl$2, File target, String path) {
        Nil$ nil$;
        block7: {
            String targetPath;
            String nameWithoutExtension = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(target.getName()), (Function1 & Serializable)_$3 -> ScriptingDriver.$anonfun$4(BoxesRunTime.unboxToChar((Object)_$3)));
            String string = targetPath = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path)) ? new StringBuilder(1).append(path).append(".").append(nameWithoutExtension).toString() : nameWithoutExtension;
            if (target.isDirectory()) {
                nil$ = Predef$.MODULE$.wrapRefArray((Object[])target.listFiles()).toList().flatMap((Function1 & Serializable)packageMember -> ScriptingDriver.collectMainMethods$3(cl$2, packageMember, targetPath).map((Function1 & Serializable)membersMainMethod -> membersMainMethod));
            } else if (target.getName().endsWith(".class")) {
                Class<?> cls = cl$2.loadClass(targetPath);
                try {
                    Method method = cls.getMethod("main", String[].class);
                    if (Modifier.isStatic(method.getModifiers())) {
                        nil$ = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)cls.getName(), (Object)method)}));
                        break block7;
                    }
                    nil$ = package$.MODULE$.Nil();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    nil$ = package$.MODULE$.Nil();
                }
            } else {
                nil$ = package$.MODULE$.Nil();
            }
        }
        return nil$;
    }
}

