/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb;

import dotty.tools.dotc.semanticdb.Language;
import dotty.tools.dotc.semanticdb.Language$JAVA$;
import dotty.tools.dotc.semanticdb.Language$SCALA$;
import dotty.tools.dotc.semanticdb.Language$UNKNOWN_LANGUAGE$;
import dotty.tools.dotc.semanticdb.Language$Unrecognized$;
import dotty.tools.dotc.semanticdb.PrinterSymtab;
import dotty.tools.dotc.semanticdb.PrinterSymtab$;
import dotty.tools.dotc.semanticdb.Range;
import dotty.tools.dotc.semanticdb.Scala3$;
import dotty.tools.dotc.semanticdb.Scala3$StringOps$;
import dotty.tools.dotc.semanticdb.Schema;
import dotty.tools.dotc.semanticdb.Schema$LEGACY$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB3$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB4$;
import dotty.tools.dotc.semanticdb.Schema$Unrecognized$;
import dotty.tools.dotc.semanticdb.SymbolInfomationPrinter;
import dotty.tools.dotc.semanticdb.SymbolInformation;
import dotty.tools.dotc.semanticdb.SymbolOccurrence;
import dotty.tools.dotc.semanticdb.TextDocument;
import dotty.tools.dotc.semanticdb.TextDocuments;
import dotty.tools.dotc.semanticdb.TextDocuments$;
import dotty.tools.dotc.semanticdb.internal.MD5$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class Tools$
implements Serializable {
    public static final Tools$ MODULE$ = new Tools$();

    private Tools$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tools$.class);
    }

    public String mkURIstring(Path path) {
        Iterable uriParts = (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)path).asScala()).map((Function1 & Serializable)part -> new URI(null, null, part.toString(), null));
        return uriParts.mkString("/");
    }

    public TextDocument loadTextDocument(Path scalaAbsolutePath, Path scalaRelativePath, Path semanticdbAbsolutePath) {
        String text;
        TextDocument document;
        String reluri = this.mkURIstring(scalaRelativePath);
        TextDocuments sdocs = this.parseTextDocuments(semanticdbAbsolutePath);
        Option option = sdocs.documents().find((Function1 & Serializable)_$1 -> {
            String string = _$1.uri();
            String string2 = reluri;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchElementException(String.valueOf(scalaRelativePath));
        }
        if (option instanceof Some) {
            document = (TextDocument)((Some)option).value();
            text = new String(Files.readAllBytes(scalaAbsolutePath), StandardCharsets.UTF_8);
            String md5FingerprintOnDisk = MD5$.MODULE$.compute(text);
            String string = document.md5();
            String string2 = md5FingerprintOnDisk;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(18).append("stale semanticdb: ").append(scalaRelativePath).toString());
            }
        } else {
            throw new MatchError((Object)option);
        }
        return document.copy(document.copy$default$1(), document.copy$default$2(), text, document.copy$default$4(), document.copy$default$5(), document.copy$default$6(), document.copy$default$7(), document.copy$default$8(), document.copy$default$9());
    }

    private TextDocuments parseTextDocuments(Path path) {
        byte[] bytes = Files.readAllBytes(path);
        return (TextDocuments)TextDocuments$.MODULE$.parseFrom(bytes);
    }

    public StringBuilder metac(TextDocument doc, Path realPath, StringBuilder sb) {
        LazyRef lazyRef = new LazyRef();
        PrinterSymtab symtab = PrinterSymtab$.MODULE$.fromTextDocument(doc);
        SymbolInfomationPrinter symPrinter = new SymbolInfomationPrinter(symtab);
        String realURI = realPath.toString();
        StringBuilder sb$proxy1 = sb.append(realURI);
        sb$proxy1.append(System.lineSeparator());
        StringBuilder sb$proxy2 = sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), realURI.length()));
        sb$proxy2.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy3 = sb.append("Summary:");
        sb$proxy3.append(System.lineSeparator());
        StringBuilder sb$proxy4 = sb.append("Schema => ").append(this.schemaString(doc.schema()));
        sb$proxy4.append(System.lineSeparator());
        StringBuilder sb$proxy5 = sb.append("Uri => ").append(doc.uri());
        sb$proxy5.append(System.lineSeparator());
        StringBuilder sb$proxy6 = sb.append("Text => empty");
        sb$proxy6.append(System.lineSeparator());
        StringBuilder sb$proxy7 = sb.append("Language => ").append(this.languageString(doc.language()));
        sb$proxy7.append(System.lineSeparator());
        StringBuilder sb$proxy8 = sb.append("Symbols => ").append(doc.symbols().length()).append(" entries");
        sb$proxy8.append(System.lineSeparator());
        StringBuilder sb$proxy9 = sb.append("Occurrences => ").append(doc.occurrences().length()).append(" entries");
        sb$proxy9.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy10 = sb.append("Symbols:");
        sb$proxy10.append(System.lineSeparator());
        ((IterableOnceOps)doc.symbols().sorted(Scala3$.MODULE$.given_Ordering_SymbolInformation())).foreach((Function1)(JProcedure1 & Serializable)s -> this.processSymbol((SymbolInformation)s, symPrinter, sb));
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy11 = sb.append("Occurrences:");
        sb$proxy11.append(System.lineSeparator());
        ((IterableOnceOps)doc.occurrences().sorted(Scala3$.MODULE$.OccurrenceOrdering())).foreach((Function1)(JProcedure1 & Serializable)occ -> this.processOccurrence((SymbolOccurrence)occ, sb, this.given_SourceFile$1(doc, lazyRef)));
        return sb.append(System.lineSeparator());
    }

    private String schemaString(Schema schema) {
        String string;
        Schema schema2 = schema;
        if (Schema$SEMANTICDB3$.MODULE$.equals(schema2)) {
            string = "SemanticDB v3";
        } else if (Schema$SEMANTICDB4$.MODULE$.equals(schema2)) {
            string = "SemanticDB v4";
        } else if (Schema$LEGACY$.MODULE$.equals(schema2)) {
            string = "SemanticDB legacy";
        } else if (schema2 instanceof Schema.Unrecognized) {
            Schema.Unrecognized unrecognized = Schema$Unrecognized$.MODULE$.unapply((Schema.Unrecognized)schema2);
            int n = unrecognized._1();
            string = "unknown";
        } else {
            throw new MatchError((Object)schema2);
        }
        return string;
    }

    private String languageString(Language language) {
        String string;
        Language language2 = language;
        if (Language$SCALA$.MODULE$.equals(language2)) {
            string = "Scala";
        } else if (Language$JAVA$.MODULE$.equals(language2)) {
            string = "Java";
        } else {
            if (!Language$UNKNOWN_LANGUAGE$.MODULE$.equals(language2)) {
                if (!(language2 instanceof Language.Unrecognized)) {
                    throw new MatchError((Object)language2);
                }
                Language.Unrecognized unrecognized = Language$Unrecognized$.MODULE$.unapply((Language.Unrecognized)language2);
                int n = unrecognized._1();
            }
            string = "unknown";
        }
        return string;
    }

    private void processSymbol(SymbolInformation info, SymbolInfomationPrinter printer, StringBuilder sb) {
        StringBuilder sb$proxy12 = sb.append(printer.pprintSymbolInformation(info));
        sb$proxy12.append(System.lineSeparator());
    }

    private void processOccurrence(SymbolOccurrence occ, StringBuilder sb, SourceFile sourceFile) {
        StringBuilder stringBuilder;
        Option<Range> option = occ.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            sb.append('[').append(range.startLine()).append(':').append(range.startCharacter()).append("..").append(range.endLine()).append(':').append(range.endCharacter()).append("):");
            if (!(range.endLine() != range.startLine() || range.startCharacter() == range.endCharacter() || Scala3$StringOps$.MODULE$.isConstructor(occ.symbol()) && occ.role().isDefinition())) {
                String line = sourceFile.lineContent(sourceFile.lineToOffset(range.startLine()));
                if (range.startCharacter() > line.length() || range.endCharacter() > line.length()) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new java.lang.StringBuilder(42).append("Line is only ").append(line.length()).append(" - start line was ").append(range.startLine()).append(" in source ").append(sourceFile.name()).toString());
                }
                sb.append(" ").append(line.substring(range.startCharacter(), range.endCharacter()));
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = BoxedUnit.UNIT;
            }
        } else {
            stringBuilder = sb.append("[):");
        }
        StringBuilder sb$proxy13 = sb.append(occ.role().isReference() ? " -> " : " <- ").append(occ.symbol());
        sb$proxy13.append(System.lineSeparator());
    }

    private final SourceFile given_SourceFile$lzyINIT1$1(TextDocument doc$1, LazyRef given_SourceFile$lzy1$1) {
        SourceFile sourceFile;
        LazyRef lazyRef = given_SourceFile$lzy1$1;
        synchronized (lazyRef) {
            sourceFile = (SourceFile)(given_SourceFile$lzy1$1.initialized() ? given_SourceFile$lzy1$1.value() : given_SourceFile$lzy1$1.initialize((Object)SourceFile$.MODULE$.virtual(doc$1.uri(), doc$1.text(), SourceFile$.MODULE$.virtual$default$3())));
        }
        return sourceFile;
    }

    private final SourceFile given_SourceFile$1(TextDocument doc$2, LazyRef given_SourceFile$lzy1$2) {
        return (SourceFile)(given_SourceFile$lzy1$2.initialized() ? given_SourceFile$lzy1$2.value() : this.given_SourceFile$lzyINIT1$1(doc$2, given_SourceFile$lzy1$2));
    }
}

