/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.reporting.Reporter$;
import dotty.tools.dotc.util.NoSourcePosition$;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class Reporter
implements ReporterResult {
    private boolean _truncationOK = true;
    private Function2 incompleteHandler = Reporter$.dotty$tools$dotc$reporting$Reporter$$$defaultIncompleteHandler;
    private int _errorCount = 0;
    private int _warningCount = 0;
    private List<Diagnostic.Error> errors = package$.MODULE$.Nil();
    private Set<Symbols.Symbol> reportedFeaturesUseSites = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Symbols.Symbol[0]));
    private Map unreportedWarnings = Predef$.MODULE$.Map().empty();

    public static void displayPrompt(BufferedReader bufferedReader, PrintWriter printWriter) {
        Reporter$.MODULE$.displayPrompt(bufferedReader, printWriter);
    }

    public static Reporter fromSimpleReporter(SimpleReporter simpleReporter) {
        return Reporter$.MODULE$.fromSimpleReporter(simpleReporter);
    }

    public abstract void doReport(Diagnostic var1, Contexts.Context var2);

    public boolean truncationOK() {
        return this._truncationOK;
    }

    public <T> T withoutTruncating(Function0<T> body) {
        Object object;
        boolean saved = this._truncationOK;
        this._truncationOK = false;
        try {
            object = body.apply();
        }
        finally {
            this._truncationOK = saved;
        }
        return (T)object;
    }

    public <T> T withIncompleteHandler(Function2<Diagnostic, Contexts.Context, BoxedUnit> handler, Function0<T> op) {
        Object object;
        Function2 saved = this.incompleteHandler;
        this.incompleteHandler = handler;
        try {
            object = op.apply();
        }
        finally {
            this.incompleteHandler = saved;
        }
        return (T)object;
    }

    public int errorCount() {
        return this._errorCount;
    }

    public int warningCount() {
        return this._warningCount;
    }

    public boolean hasErrors() {
        return this.errorCount() > 0;
    }

    public boolean hasWarnings() {
        return this.warningCount() > 0;
    }

    public List<Diagnostic.Error> allErrors() {
        return this.errors;
    }

    public boolean hasStickyErrors() {
        return false;
    }

    public boolean errorsReported() {
        return this.hasErrors();
    }

    public boolean reportsErrorsFor(Function1<Contexts.Context, BoxedUnit> op, Contexts.Context x$2) {
        int initial = this.errorCount();
        op.apply((Object)x$2);
        return this.errorCount() > initial;
    }

    public boolean isReportedFeatureUseSite(Symbols.Symbol featureTrait) {
        return featureTrait != Symbols$NoSymbol$.MODULE$ && this.reportedFeaturesUseSites.contains((Object)featureTrait);
    }

    public void reportNewFeatureUseSite(Symbols.Symbol featureTrait) {
        this.reportedFeaturesUseSites = (Set)this.reportedFeaturesUseSites.$plus((Object)featureTrait);
    }

    public Map<String, Object> unreportedWarnings() {
        return this.unreportedWarnings;
    }

    public void unreportedWarnings_$eq(Map<String, Object> x$1) {
        this.unreportedWarnings = x$1;
    }

    public void report(Diagnostic dia, Contexts.Context x$2) {
        boolean isSummarized;
        Diagnostic.ConditionalWarning dia2;
        Diagnostic diagnostic = dia;
        boolean bl = diagnostic instanceof Diagnostic.ConditionalWarning ? !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value((dia2 = (Diagnostic.ConditionalWarning)diagnostic).enablingOption(x$2), x$2)) : (isSummarized = false);
        if (isSummarized || !this.isHidden(dia, x$2)) {
            Diagnostic.ConditionalWarning dia3;
            int mode$proxy1 = Mode$.MODULE$.$bar$extension(x$2.mode(), Mode$.MODULE$.Printing());
            Contexts.Context evidence$3$proxy1 = Mode$.MODULE$.$bang$eq$extension(mode$proxy1, x$2.mode()) ? x$2.fresh().setMode(mode$proxy1) : x$2;
            this.doReport(dia, evidence$3$proxy1);
            Diagnostic diagnostic2 = dia;
            if (diagnostic2 instanceof Diagnostic.ConditionalWarning && !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value((dia3 = (Diagnostic.ConditionalWarning)diagnostic2).enablingOption(x$2), x$2))) {
                String key = dia3.enablingOption(x$2).name();
                this.unreportedWarnings_$eq((Map<String, Object>)((Map)this.unreportedWarnings().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.unreportedWarnings().getOrElse((Object)key, Reporter::report$$anonfun$1)) + 1)))));
            } else if (diagnostic2 instanceof Diagnostic.Warning) {
                Diagnostic.Warning dia4 = (Diagnostic.Warning)diagnostic2;
                ++this._warningCount;
            } else if (diagnostic2 instanceof Diagnostic.Error) {
                Diagnostic.Error dia5 = (Diagnostic.Error)diagnostic2;
                this.errors = this.errors.$colon$colon((Object)dia5);
                ++this._errorCount;
                if (x$2.typerState().isGlobalCommittable()) {
                    x$2.base().errorsToBeReported_$eq(true);
                }
            } else if (diagnostic2 instanceof Diagnostic.Info) {
                Diagnostic.Info dia6 = (Diagnostic.Info)diagnostic2;
            } else {
                throw new MatchError((Object)diagnostic2);
            }
        }
    }

    public void incomplete(Diagnostic dia, Contexts.Context x$2) {
        this.incompleteHandler.apply((Object)dia, (Object)x$2);
    }

    public String summary() {
        ListBuffer b = new ListBuffer();
        if (this.warningCount() > 0) {
            b.$plus$eq((Object)new StringBuilder(6).append(this.countString(this.warningCount(), "warning")).append(" found").toString());
        }
        if (this.errorCount() > 0) {
            b.$plus$eq((Object)new StringBuilder(6).append(this.countString(this.errorCount(), "error")).append(" found").toString());
        }
        this.unreportedWarnings().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String settingName = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String settingName = (String)tuple2._1();
            int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return (ListBuffer)b.$plus$eq((Object)new StringBuilder(49).append("there were ").append(count).append(" ").append(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(settingName))).append(" warning(s); re-run with ").append(settingName).append(" for details").toString());
        });
        return b.mkString("\n");
    }

    public void printSummary(Contexts.Context x$1) {
        String s;
        String string = s = this.summary();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.report(new Diagnostic.Info(Message$.MODULE$.toNoExplanation(() -> Reporter.printSummary$$anonfun$1(s)), NoSourcePosition$.MODULE$), x$1);
        }
    }

    public String countString(int n, String elements) {
        int n2 = n;
        return 0 == n2 ? new StringBuilder(4).append("no ").append(elements).append("s").toString() : (1 == n2 ? new StringBuilder(2).append("1 ").append(elements).toString() : new StringBuilder(2).append(n).append(" ").append(elements).append("s").toString());
    }

    public boolean isHidden(Diagnostic dia, Contexts.Context x$2) {
        return Mode$.MODULE$.is$extension(x$2.mode(), Mode$.MODULE$.Printing());
    }

    public boolean hasUnreportedErrors() {
        return false;
    }

    public List<Diagnostic> removeBufferedMessages(Contexts.Context x$1) {
        return package$.MODULE$.Nil();
    }

    public void flush(Contexts.Context x$1) {
        List<Diagnostic> msgs = this.removeBufferedMessages(x$1);
        if (msgs.nonEmpty()) {
            Reporter reporter = x$1.reporter();
            msgs.foreach((Function1)(JProcedure1 & Serializable)dia -> reporter.report((Diagnostic)dia, x$1));
        }
    }

    public List<Diagnostic> pendingMessages(Contexts.Context x$1) {
        return package$.MODULE$.Nil();
    }

    private static final int report$$anonfun$1() {
        return 0;
    }

    private static final String printSummary$$anonfun$1(String s$1) {
        return s$1;
    }
}

