/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb;

import dotty.tools.dotc.semanticdb.Language;
import dotty.tools.dotc.semanticdb.Language$JAVA$;
import dotty.tools.dotc.semanticdb.Language$SCALA$;
import dotty.tools.dotc.semanticdb.Language$UNKNOWN_LANGUAGE$;
import dotty.tools.dotc.semanticdb.Language$Unrecognized$;
import dotty.tools.dotc.semanticdb.Range;
import dotty.tools.dotc.semanticdb.Scala3$;
import dotty.tools.dotc.semanticdb.Scala3$InfoOps$;
import dotty.tools.dotc.semanticdb.Scala3$StringOps$;
import dotty.tools.dotc.semanticdb.Schema;
import dotty.tools.dotc.semanticdb.Schema$LEGACY$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB3$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB4$;
import dotty.tools.dotc.semanticdb.Schema$Unrecognized$;
import dotty.tools.dotc.semanticdb.SymbolInformation;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$CLASS$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$CONSTRUCTOR$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$FIELD$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$INTERFACE$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$LOCAL$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$MACRO$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$METHOD$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$OBJECT$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$PACKAGE$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$PACKAGE_OBJECT$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$PARAMETER$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$SELF_PARAMETER$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$TRAIT$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$TYPE$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$TYPE_PARAMETER$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$UNKNOWN_KIND$;
import dotty.tools.dotc.semanticdb.SymbolInformation$Kind$Unrecognized$;
import dotty.tools.dotc.semanticdb.SymbolOccurrence;
import dotty.tools.dotc.semanticdb.TextDocument;
import dotty.tools.dotc.semanticdb.TextDocuments;
import dotty.tools.dotc.semanticdb.TextDocuments$;
import dotty.tools.dotc.semanticdb.internal.MD5$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class Tools$
implements Serializable {
    public static final Tools$ MODULE$ = new Tools$();

    private Tools$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tools$.class);
    }

    public String mkURIstring(Path path) {
        Iterable uriParts = (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)path).asScala()).map((Function1 & Serializable)part -> new URI(null, null, part.toString(), null));
        return uriParts.mkString("/");
    }

    public TextDocument loadTextDocument(Path scalaAbsolutePath, Path scalaRelativePath, Path semanticdbAbsolutePath) {
        String text;
        TextDocument document;
        String reluri = this.mkURIstring(scalaRelativePath);
        TextDocuments sdocs = this.parseTextDocuments(semanticdbAbsolutePath);
        Option option = sdocs.documents().find((Function1 & Serializable)_$1 -> {
            String string = _$1.uri();
            String string2 = reluri;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchElementException(String.valueOf(scalaRelativePath));
        }
        if (option instanceof Some) {
            document = (TextDocument)((Some)option).value();
            text = new String(Files.readAllBytes(scalaAbsolutePath), StandardCharsets.UTF_8);
            String md5FingerprintOnDisk = MD5$.MODULE$.compute(text);
            String string = document.md5();
            String string2 = md5FingerprintOnDisk;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException("stale semanticdb: " + scalaRelativePath);
            }
        } else {
            throw new MatchError((Object)option);
        }
        return document.copy(document.copy$default$1(), document.copy$default$2(), document.copy$default$3(), text, document.copy$default$5(), document.copy$default$6(), document.copy$default$7());
    }

    private TextDocuments parseTextDocuments(Path path) {
        byte[] bytes = Files.readAllBytes(path);
        return TextDocuments$.MODULE$.parseFrom(bytes);
    }

    public StringBuilder metac(TextDocument doc, Path realPath, StringBuilder sb) {
        LazyRef lazyRef = new LazyRef();
        String realURI = realPath.toString();
        StringBuilder sb$proxy1 = sb.append(realURI);
        sb$proxy1.append(System.lineSeparator());
        StringBuilder sb$proxy2 = sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), realURI.length()));
        sb$proxy2.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy3 = sb.append("Summary:");
        sb$proxy3.append(System.lineSeparator());
        StringBuilder sb$proxy4 = sb.append("Schema => ").append(this.schemaString(doc.schema()));
        sb$proxy4.append(System.lineSeparator());
        StringBuilder sb$proxy5 = sb.append("Uri => ").append(doc.uri());
        sb$proxy5.append(System.lineSeparator());
        StringBuilder sb$proxy6 = sb.append("Text => empty");
        sb$proxy6.append(System.lineSeparator());
        StringBuilder sb$proxy7 = sb.append("Language => ").append(this.languageString(doc.language()));
        sb$proxy7.append(System.lineSeparator());
        StringBuilder sb$proxy8 = sb.append("Symbols => ").append(doc.symbols().length()).append(" entries");
        sb$proxy8.append(System.lineSeparator());
        StringBuilder sb$proxy9 = sb.append("Occurrences => ").append(doc.occurrences().length()).append(" entries");
        sb$proxy9.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy10 = sb.append("Symbols:");
        sb$proxy10.append(System.lineSeparator());
        ((IterableOnceOps)doc.symbols().sorted(Scala3$.MODULE$.given_Ordering_SymbolInformation())).foreach((Function1)(JProcedure1 & Serializable)info -> this.processSymbol((SymbolInformation)info, sb));
        sb.append(System.lineSeparator());
        StringBuilder sb$proxy11 = sb.append("Occurrences:");
        sb$proxy11.append(System.lineSeparator());
        ((IterableOnceOps)doc.occurrences().sorted(Scala3$.MODULE$.OccurrenceOrdering())).foreach((Function1)(JProcedure1 & Serializable)occ -> this.processOccurrence((SymbolOccurrence)occ, sb, this.given_SourceFile$1(doc, lazyRef)));
        return sb.append(System.lineSeparator());
    }

    private String schemaString(Schema schema) {
        String string;
        Schema schema2 = schema;
        if (Schema$SEMANTICDB3$.MODULE$.equals(schema2)) {
            string = "SemanticDB v3";
        } else if (Schema$SEMANTICDB4$.MODULE$.equals(schema2)) {
            string = "SemanticDB v4";
        } else if (Schema$LEGACY$.MODULE$.equals(schema2)) {
            string = "SemanticDB legacy";
        } else if (schema2 instanceof Schema.Unrecognized) {
            Schema.Unrecognized unrecognized = Schema$Unrecognized$.MODULE$.unapply((Schema.Unrecognized)schema2);
            int n = unrecognized._1();
            string = "unknown";
        } else {
            throw new MatchError((Object)schema2);
        }
        return string;
    }

    private String languageString(Language language) {
        String string;
        Language language2 = language;
        if (Language$SCALA$.MODULE$.equals(language2)) {
            string = "Scala";
        } else if (Language$JAVA$.MODULE$.equals(language2)) {
            string = "Java";
        } else {
            if (!Language$UNKNOWN_LANGUAGE$.MODULE$.equals(language2)) {
                if (!(language2 instanceof Language.Unrecognized)) {
                    throw new MatchError((Object)language2);
                }
                Language.Unrecognized unrecognized = Language$Unrecognized$.MODULE$.unapply((Language.Unrecognized)language2);
                int n = unrecognized._1();
            }
            string = "unknown";
        }
        return string;
    }

    private void processSymbol(SymbolInformation info, StringBuilder sb) {
        StringBuilder stringBuilder;
        SymbolInformation.Kind kind;
        sb.append(info.symbol()).append(" => ");
        if (Scala3$InfoOps$.MODULE$.isAbstract(info)) {
            sb.append("abstract ");
        }
        if (Scala3$InfoOps$.MODULE$.isFinal(info)) {
            sb.append("final ");
        }
        if (Scala3$InfoOps$.MODULE$.isSealed(info)) {
            sb.append("sealed ");
        }
        if (Scala3$InfoOps$.MODULE$.isImplicit(info)) {
            sb.append("implicit ");
        }
        if (Scala3$InfoOps$.MODULE$.isLazy(info)) {
            sb.append("lazy ");
        }
        if (Scala3$InfoOps$.MODULE$.isCase(info)) {
            sb.append("case ");
        }
        if (Scala3$InfoOps$.MODULE$.isCovariant(info)) {
            sb.append("covariant ");
        }
        if (Scala3$InfoOps$.MODULE$.isContravariant(info)) {
            sb.append("contravariant ");
        }
        if (Scala3$InfoOps$.MODULE$.isVal(info)) {
            sb.append("val ");
        }
        if (Scala3$InfoOps$.MODULE$.isVar(info)) {
            sb.append("var ");
        }
        if (Scala3$InfoOps$.MODULE$.isStatic(info)) {
            sb.append("static ");
        }
        if (Scala3$InfoOps$.MODULE$.isPrimary(info)) {
            sb.append("primary ");
        }
        if (Scala3$InfoOps$.MODULE$.isEnum(info)) {
            sb.append("enum ");
        }
        if (Scala3$InfoOps$.MODULE$.isDefault(info)) {
            sb.append("default ");
        }
        if (SymbolInformation$Kind$LOCAL$.MODULE$.equals(kind = info.kind())) {
            stringBuilder = sb.append("local ");
        } else if (SymbolInformation$Kind$FIELD$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("field ");
        } else if (SymbolInformation$Kind$METHOD$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("method ");
        } else if (SymbolInformation$Kind$CONSTRUCTOR$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("ctor ");
        } else if (SymbolInformation$Kind$MACRO$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("macro ");
        } else if (SymbolInformation$Kind$TYPE$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("type ");
        } else if (SymbolInformation$Kind$PARAMETER$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("param ");
        } else if (SymbolInformation$Kind$SELF_PARAMETER$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("selfparam ");
        } else if (SymbolInformation$Kind$TYPE_PARAMETER$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("typeparam ");
        } else if (SymbolInformation$Kind$OBJECT$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("object ");
        } else if (SymbolInformation$Kind$PACKAGE$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("package ");
        } else if (SymbolInformation$Kind$PACKAGE_OBJECT$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("package object ");
        } else if (SymbolInformation$Kind$CLASS$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("class ");
        } else if (SymbolInformation$Kind$TRAIT$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("trait ");
        } else if (SymbolInformation$Kind$INTERFACE$.MODULE$.equals(kind)) {
            stringBuilder = sb.append("interface ");
        } else {
            if (!SymbolInformation$Kind$UNKNOWN_KIND$.MODULE$.equals(kind)) {
                if (!(kind instanceof SymbolInformation.Kind.Unrecognized)) {
                    throw new MatchError((Object)kind);
                }
                SymbolInformation.Kind.Unrecognized unrecognized = SymbolInformation$Kind$Unrecognized$.MODULE$.unapply((SymbolInformation.Kind.Unrecognized)kind);
                int n = unrecognized._1();
            }
            stringBuilder = sb.append("unknown ");
        }
        StringBuilder sb$proxy12 = sb.append(info.displayName());
        sb$proxy12.append(System.lineSeparator());
    }

    private void processOccurrence(SymbolOccurrence occ, StringBuilder sb, SourceFile sourceFile) {
        StringBuilder stringBuilder;
        Option<Range> option = occ.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            sb.append('[').append(range.startLine()).append(':').append(range.startCharacter()).append("..").append(range.endLine()).append(':').append(range.endCharacter()).append("):");
            if (!(range.endLine() != range.startLine() || range.startCharacter() == range.endCharacter() || Scala3$StringOps$.MODULE$.isConstructor(occ.symbol()) && occ.role().isDefinition())) {
                String line = sourceFile.lineContent(sourceFile.lineToOffset(range.startLine()));
                if (range.startCharacter() > line.length() || range.endCharacter() > line.length()) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("Line is only " + line.length() + " - start line was " + range.startLine() + " in source " + sourceFile.name()));
                }
                sb.append(" ").append(line.substring(range.startCharacter(), range.endCharacter()));
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = BoxedUnit.UNIT;
            }
        } else {
            stringBuilder = sb.append("[):");
        }
        StringBuilder sb$proxy13 = sb.append(occ.role().isReference() ? " -> " : " <- ").append(occ.symbol());
        sb$proxy13.append(System.lineSeparator());
    }

    private final SourceFile given_SourceFile$lzyINIT1$1(TextDocument doc$1, LazyRef given_SourceFile$lzy1$1) {
        SourceFile sourceFile;
        LazyRef lazyRef = given_SourceFile$lzy1$1;
        synchronized (lazyRef) {
            sourceFile = (SourceFile)(given_SourceFile$lzy1$1.initialized() ? given_SourceFile$lzy1$1.value() : given_SourceFile$lzy1$1.initialize((Object)SourceFile$.MODULE$.virtual(doc$1.uri(), doc$1.text(), SourceFile$.MODULE$.virtual$default$3())));
        }
        return sourceFile;
    }

    private final SourceFile given_SourceFile$1(TextDocument doc$2, LazyRef given_SourceFile$lzy1$2) {
        return (SourceFile)(given_SourceFile$lzy1$2.initialized() ? given_SourceFile$lzy1$2.value() : this.given_SourceFile$lzyINIT1$1(doc$2, given_SourceFile$lzy1$2));
    }
}

