/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.config.Properties$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.config.SourceVersion;
import dotty.tools.dotc.config.SourceVersion$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.NameKinds$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.StdNames$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Feature$
implements Serializable {
    private static final Names.TermName namedTypeArguments;
    private static final Names.TermName genericNumberLiterals;
    private static final Names.TermName scala2macros;
    private static final Names.TermName dependent;
    private static final Names.TermName erasedDefinitions;
    private static final Names.TermName symbolLiterals;
    private static final Names.TermName fewerBraces;
    private static final String experimentalWarningMessage;
    public static final Feature$ MODULE$;

    private Feature$() {
    }

    static {
        MODULE$ = new Feature$();
        namedTypeArguments = MODULE$.experimental("namedTypeArguments");
        genericNumberLiterals = MODULE$.experimental("genericNumberLiterals");
        scala2macros = MODULE$.experimental("macros");
        dependent = MODULE$.experimental("dependent");
        erasedDefinitions = MODULE$.experimental("erasedDefinitions");
        symbolLiterals = MODULE$.deprecated("symbolLiterals");
        fewerBraces = MODULE$.experimental("fewerBraces");
        experimentalWarningMessage = "Experimental features may only be used with nightly or snapshot version of compiler.";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Feature$.class);
    }

    private Names.TermName experimental(String str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().experimental(), Decorators$.MODULE$.toTermName(str));
    }

    private Names.TermName deprecated(String str) {
        return NameKinds$.MODULE$.QualifiedName().apply((Names.TermName)StdNames$.MODULE$.nme().deprecated(), Decorators$.MODULE$.toTermName(str));
    }

    public Names.TermName dependent() {
        return dependent;
    }

    public Names.TermName erasedDefinitions() {
        return erasedDefinitions;
    }

    public Names.TermName symbolLiterals() {
        return symbolLiterals;
    }

    public Names.TermName fewerBraces() {
        return fewerBraces;
    }

    public String experimentalWarningMessage() {
        return experimentalWarningMessage;
    }

    public boolean experimentalEnabled(Contexts.Context x$1) {
        return Properties$.MODULE$.experimental() && !BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(x$1.settings().YnoExperimental(), x$1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExperimental(Names.TermName feature) {
        Names.TermName termName = feature;
        Names.TermName termName2 = scala2macros;
        if (termName == null) {
            if (termName2 == null) return false;
        } else if (((Object)termName).equals(termName2)) return false;
        Names.TermName termName3 = feature;
        if (!(termName3 instanceof Names.DerivedName)) return false;
        Option<Tuple2<Names.TermName, Names.SimpleName>> option = NameKinds$.MODULE$.QualifiedName().unapply((Names.DerivedName)termName3);
        if (option.isEmpty()) return false;
        Tuple2 tuple2 = (Tuple2)option.get();
        Object n = StdNames$.MODULE$.nme().experimental();
        Object object = tuple2._1();
        if (n != null) {
            if (!n.equals(object)) return false;
            return true;
        }
        if (object == null) return true;
        return false;
    }

    public boolean enabledBySetting(Names.TermName feature, Contexts.Context x$2) {
        return Settings$Setting$.MODULE$.value(x$2.base().settings().language(), x$2).contains((Object)feature.toString());
    }

    public boolean enabledByImport(Names.TermName feature, Contexts.Context x$2) {
        return x$2.importInfo() != null && x$2.importInfo().featureImported(feature, x$2);
    }

    public boolean enabled(Names.TermName feature, Contexts.Context x$2) {
        return !(!this.experimentalEnabled(x$2) && this.isExperimental(feature) || !this.enabledBySetting(feature, x$2) && !this.enabledByImport(feature, x$2));
    }

    public boolean autoTuplingEnabled(Contexts.Context x$1) {
        return !this.enabled((Names.TermName)StdNames$.MODULE$.nme().noAutoTupling(), x$1);
    }

    public boolean dynamicsEnabled(Contexts.Context x$1) {
        return this.enabled((Names.TermName)StdNames$.MODULE$.nme().dynamics(), x$1);
    }

    public boolean dependentEnabled(Contexts.Context x$1) {
        return this.enabled(this.dependent(), x$1);
    }

    public boolean namedTypeArgsEnabled(Contexts.Context x$1) {
        return this.enabled(namedTypeArguments, x$1);
    }

    public boolean genericNumberLiteralsEnabled(Contexts.Context x$1) {
        return this.enabled(genericNumberLiterals, x$1);
    }

    public boolean erasedEnabled(Contexts.Context x$1) {
        return this.enabled(this.erasedDefinitions(), x$1);
    }

    public boolean scala2ExperimentalMacroEnabled(Contexts.Context x$1) {
        return this.enabled(scala2macros, x$1);
    }

    public SourceVersion sourceVersionSetting(Contexts.Context x$1) {
        return SourceVersion$.MODULE$.valueOf(Settings$Setting$.MODULE$.value(x$1.settings().source(), x$1));
    }

    public SourceVersion sourceVersion(Contexts.Context x$1) {
        SourceVersion sourceVersion;
        if (x$1.compilationUnit() == null) {
            sourceVersion = this.sourceVersionSetting(x$1);
        } else {
            Option<SourceVersion> option = x$1.compilationUnit().sourceVersion();
            if (option instanceof Some) {
                SourceVersion v;
                sourceVersion = v = (SourceVersion)((Some)option).value();
            } else {
                Option<SourceVersion> none = option;
                sourceVersion = this.sourceVersionSetting(x$1);
            }
        }
        return sourceVersion;
    }

    public boolean migrateTo3(Contexts.Context x$1) {
        SourceVersion sourceVersion = this.sourceVersion(x$1);
        SourceVersion sourceVersion2 = SourceVersion$.3$u002E0$minusmigration;
        return !(sourceVersion != null ? !sourceVersion.equals(sourceVersion2) : sourceVersion2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean warnOnMigration(Message msg, SrcPos pos, SourceVersion version, Contexts.Context x$4) {
        block6: {
            block5: {
                if (!this.sourceVersion(x$4).isMigrating()) break block5;
                SourceVersion sourceVersion = this.sourceVersion(x$4).stable();
                SourceVersion sourceVersion2 = version;
                if (!(sourceVersion == null ? sourceVersion2 != null : !sourceVersion.equals(sourceVersion2))) break block6;
            }
            SourceVersion sourceVersion = version;
            SourceVersion sourceVersion3 = SourceVersion$.3$u002E0;
            if (sourceVersion == null) {
                if (sourceVersion3 != null) {
                    return false;
                }
            } else if (!sourceVersion.equals(sourceVersion3)) return false;
            if (!this.migrateTo3(x$4)) return false;
        }
        report$.MODULE$.migrationWarning(msg, pos, x$4);
        return true;
    }

    public SourceVersion warnOnMigration$default$3() {
        return SourceVersion$.MODULE$.defaultSourceVersion();
    }

    public void checkExperimentalFlags(Contexts.Context x$1) {
        List features;
        if (!this.experimentalEnabled(x$1) && (features = Settings$Setting$.MODULE$.value(x$1.settings().language(), x$1).filter((Function1 & Serializable)feature -> feature.contains(((Names.TermName)StdNames$.MODULE$.nme().experimental()).toString()) && !feature.contains("macros"))).nonEmpty()) {
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> this.checkExperimentalFlags$$anonfun$1(features)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$1);
        }
    }

    private final String checkExperimentalFlags$$anonfun$1(List features$1) {
        return this.experimentalWarningMessage() + "\nThe experimental language features are enabled via -language:" + features$1.mkString(",");
    }
}

