/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc;

import dotty.tools.FatalError;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.ast.Positioned$;
import dotty.tools.dotc.config.CompilerCommand$;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Comments;
import dotty.tools.dotc.core.Comments$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.MacroClassLoader$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.TypeError;
import dotty.tools.dotc.fromtasty.TASTYCompiler;
import dotty.tools.dotc.fromtasty.TastyFileUtil$;
import dotty.tools.dotc.interfaces.CompilerCallback;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.Reporter$;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.io.AbstractFile;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public class Driver {
    public Compiler newCompiler(Contexts.Context x$1) {
        return BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(x$1.settings().fromTasty(), x$1)) ? new TASTYCompiler() : new Compiler();
    }

    public Reporter emptyReporter() {
        return new StoreReporter(null);
    }

    public Reporter doCompile(Compiler compiler, List<AbstractFile> files, Contexts.Context x$3) {
        if (files.nonEmpty()) {
            try {
                Run run = compiler.newRun(x$3);
                run.compile(files);
                this.finish(compiler, run, x$3);
            }
            catch (FatalError ex) {
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> Driver.doCompile$$anonfun$1(ex)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$3);
            }
            catch (TypeError ex) {
                Predef$.MODULE$.println((Object)("" + ex.toMessage(x$3) + " while compiling " + files.map((Function1 & Serializable)_$1 -> _$1.path()).mkString(", ")));
                throw ex;
            }
            catch (Throwable ex) {
                Predef$.MODULE$.println((Object)("" + ex + " while compiling " + files.map((Function1 & Serializable)_$2 -> _$2.path()).mkString(", ")));
                throw ex;
            }
        }
        return x$3.reporter();
    }

    public void finish(Compiler compiler, Run run, Contexts.Context x$3) {
        run.printSummary();
        if (!x$3.reporter().errorsReported() && run.suspendedUnits().nonEmpty()) {
            List suspendedUnits = run.suspendedUnits().toList();
            if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(x$3.settings().XprintSuspension(), x$3))) {
                report$.MODULE$.echo(() -> Driver.finish$$anonfun$1(x$3, suspendedUnits), report$.MODULE$.echo$default$2(), x$3);
            }
            Run run1 = compiler.newRun(x$3);
            suspendedUnits.foreach((Function1)(JProcedure1 & Serializable)unit -> unit.suspended_$eq(false));
            run1.compileUnits((List<CompilationUnit>)suspendedUnits);
            this.finish(compiler, run1, MacroClassLoader$.MODULE$.init(x$3.fresh()));
        }
    }

    public Contexts.Context initCtx() {
        return new Contexts.ContextBase().initialCtx();
    }

    public boolean sourcesRequired() {
        return true;
    }

    public Tuple2<List<AbstractFile>, Contexts.Context> setup(String[] args, Contexts.Context rootCtx) {
        Contexts.FreshContext ictx = rootCtx.fresh();
        Settings.ArgsSummary summary = CompilerCommand$.MODULE$.distill(args, ictx);
        ictx.setSettings(summary.sstate());
        MacroClassLoader$.MODULE$.init(ictx);
        Positioned$.MODULE$.init(ictx);
        if (!BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(ictx.settings().YdropComments(), ictx)) || Mode$.MODULE$.is$extension(ictx.mode(), Mode$.MODULE$.ReadComments())) {
            ictx.setProperty(Comments$.MODULE$.ContextDoc(), new Comments.ContextDocstrings());
        }
        List<String> fileNames = CompilerCommand$.MODULE$.checkUsage(summary, this.sourcesRequired(), ictx);
        Contexts.FreshContext freshContext = ictx;
        List files = fileNames.map((Function1 & Serializable)name -> freshContext.getFile((String)name));
        return Tuple2$.MODULE$.apply((Object)files, (Object)this.fromTastySetup((List<AbstractFile>)files, ictx));
    }

    public Contexts.Context fromTastySetup(List<AbstractFile> files, Contexts.Context x$2) {
        Contexts.Context context;
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.value(x$2.settings().fromTasty(), x$2))) {
            List newEntries = (List)files.flatMap((Function1 & Serializable)file -> {
                Some some;
                if (!file.exists()) {
                    report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> Driver.$anonfun$3$$anonfun$1(file)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$2);
                    some = None$.MODULE$;
                } else {
                    String string = file.extension();
                    if ("jar".equals(string)) {
                        some = Some$.MODULE$.apply((Object)file.path());
                    } else if ("tasty".equals(string)) {
                        Option<String> option = TastyFileUtil$.MODULE$.getClassPath((AbstractFile)file);
                        if (option instanceof Some) {
                            String classpath = (String)((Some)option).value();
                            some = Some$.MODULE$.apply((Object)classpath);
                        } else {
                            report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> Driver.$anonfun$4$$anonfun$2(file)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$2);
                            some = None$.MODULE$;
                        }
                    } else {
                        report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> Driver.$anonfun$5$$anonfun$3(file)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$2);
                        some = None$.MODULE$;
                    }
                }
                return some;
            }).distinct();
            Contexts.FreshContext ctx1 = x$2.fresh();
            String fullClassPath = ((IterableOnceOps)newEntries.$colon$plus(Settings$Setting$.MODULE$.value(x$2.settings().classpath(), x$2))).mkString(File.pathSeparator);
            context = ctx1.setSetting(ctx1.settings().classpath(), fullClassPath);
        } else {
            context = x$2;
        }
        return context;
    }

    public final ReporterResult process(String[] args, SimpleReporter simple, CompilerCallback callback) {
        Reporter reporter = simple == null ? null : Reporter$.MODULE$.fromSimpleReporter(simple);
        return this.process(args, reporter, callback);
    }

    public final Reporter process(String[] args, Reporter reporter, CompilerCallback callback) {
        Contexts.FreshContext compileCtx = this.initCtx().fresh();
        if (reporter != null) {
            compileCtx.setReporter(reporter);
        }
        if (callback != null) {
            compileCtx.setCompilerCallback(callback);
        }
        return this.process(args, compileCtx);
    }

    public Null$ process$default$2() {
        return null;
    }

    public Null$ process$default$3() {
        return null;
    }

    public final Reporter process(String[] args) {
        return this.process(args, (Reporter)null, (CompilerCallback)null);
    }

    public Reporter process(String[] args, Contexts.Context rootCtx) {
        Tuple2<List<AbstractFile>, Contexts.Context> tuple2 = this.setup(args, rootCtx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List files = (List)tuple2._1();
        Contexts.Context compileCtx = (Contexts.Context)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)files, (Object)compileCtx);
        List files2 = (List)tuple22._1();
        Contexts.Context compileCtx2 = (Contexts.Context)tuple22._2();
        return this.doCompile(this.newCompiler(compileCtx2), (List<AbstractFile>)files2, compileCtx2);
    }

    public void main(String[] args) {
        NonFatal$ nonFatal$ = NonFatal$.MODULE$;
        throw package$.MODULE$.exit(this.process(args).hasErrors() ? 1 : 0);
    }

    private static final String doCompile$$anonfun$1(FatalError ex$1) {
        return ex$1.getMessage();
    }

    private static final String finish$$anonfun$1(Contexts.Context x$3$1, List suspendedUnits$1) {
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compiling suspended ", "%, %"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{suspendedUnits$1}), x$3$1);
    }

    private static final String $anonfun$3$$anonfun$1(AbstractFile file$1) {
        return "File does not exist: " + file$1.path();
    }

    private static final String $anonfun$4$$anonfun$2(AbstractFile file$2) {
        return "Could not load classname from: " + file$2.path();
    }

    private static final String $anonfun$5$$anonfun$3(AbstractFile file$3) {
        return "File extension is not `tasty` or `jar`: " + file$3.path();
    }
}

