/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.EventType;
import dotty.tools.dotc.profile.EventType$;
import dotty.tools.dotc.profile.GcEventData;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileReporter;
import dotty.tools.dotc.profile.RealProfiler;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;

public class StreamProfileReporter
implements ProfileReporter {
    private final PrintWriter out;

    public StreamProfileReporter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void header(RealProfiler profiler) {
        this.out.println("info, " + profiler.id() + ", version, 2, output, " + profiler.outDir());
        this.out.println("header(main/background),startNs,endNs,runId,phaseId,phaseName,purpose,task-count,threadId,threadName,runNs,idleNs,cpuTimeNs,userTimeNs,allocatedByte,heapSize");
        this.out.println("header(GC),startNs,endNs,startMs,endMs,name,action,cause,threads");
    }

    @Override
    public void reportBackground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.BACKGROUND(), profiler, threadRange);
    }

    @Override
    public void reportForeground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MODULE$.MAIN(), profiler, threadRange);
    }

    private void reportCommon(EventType tpe, RealProfiler profiler, ProfileRange threadRange) {
        this.out.println("" + tpe + "," + threadRange.start().snapTimeNanos() + "," + threadRange.end().snapTimeNanos() + "," + profiler.id() + "," + threadRange.phase().id() + "," + threadRange.phase().phaseName().replace(',', ' ') + "," + threadRange.purpose() + "," + threadRange.taskCount() + "," + threadRange.thread().getId() + "," + threadRange.thread().getName() + "," + threadRange.runNs() + "," + threadRange.idleNs() + "," + threadRange.cpuNs() + "," + threadRange.userNs() + "," + threadRange.allocatedBytes() + "," + threadRange.end().heapBytes() + " ");
    }

    @Override
    public void reportGc(GcEventData data) {
        long duration = TimeUnit.MILLISECONDS.toNanos(data.gcEndMillis() - data.gcStartMillis() + 1L);
        long start = data.reportTimeNs() - duration;
        this.out.println("" + EventType$.MODULE$.GC() + "," + start + "," + data.reportTimeNs() + "," + data.gcStartMillis() + ", " + data.gcEndMillis() + "," + data.name() + "," + data.action() + "," + data.cause() + "," + data.threads());
    }

    @Override
    public void close(RealProfiler profiler) {
        this.out.flush();
        this.out.close();
    }
}

