/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.FatalError;
import dotty.tools.io.AbstractFile;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.URL;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class FileUtils$
implements Serializable {
    private static final String SUFFIX_CLASS;
    private static final String SUFFIX_SCALA;
    private static final String SUFFIX_JAVA;
    private static final String SUFFIX_SIG;
    public static final FileUtils$ MODULE$;

    private FileUtils$() {
    }

    static {
        MODULE$ = new FileUtils$();
        SUFFIX_CLASS = ".class";
        SUFFIX_SCALA = ".scala";
        SUFFIX_JAVA = ".java";
        SUFFIX_SIG = ".sig";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtils$.class);
    }

    public boolean isPackage(AbstractFile file) {
        return file.isDirectory() && this.mayBeValidPackage(file.name());
    }

    public boolean isClass(AbstractFile file) {
        return !file.isDirectory() && file.hasExtension("class") && !file.name().endsWith("$class.class");
    }

    public boolean isScalaOrJavaSource(AbstractFile file) {
        return !file.isDirectory() && (file.hasExtension("scala") || file.hasExtension("java"));
    }

    public boolean isJarOrZip(AbstractFile file) {
        return file.hasExtension("jar") || file.hasExtension("zip");
    }

    public Seq<URL> toURLs(AbstractFile file, Function0<Seq<URL>> function0) {
        return file.file() == null ? (Seq)function0.apply() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URL[]{file.toURL()}));
    }

    public Seq<URL> toURLs$default$2(AbstractFile file) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean isPackage(File file) {
        return file.isDirectory() && this.mayBeValidPackage(file.getName());
    }

    public boolean isClass(File file) {
        return file.isFile() && file.getName().endsWith(".class") && !file.getName().endsWith("$class.class");
    }

    public String stripSourceExtension(String fileName) {
        String string;
        if (this.endsScala(fileName)) {
            string = this.stripClassExtension(fileName);
        } else if (this.endsJava(fileName)) {
            string = this.stripJavaExtension(fileName);
        } else {
            throw new FatalError("Unexpected source file ending: " + fileName);
        }
        return string;
    }

    public String dirPath(String forPackage) {
        return forPackage.replace('.', File.separatorChar);
    }

    public String dirPathInJar(String forPackage) {
        return forPackage.replace('.', '/');
    }

    public boolean endsClass(String fileName) {
        return fileName.endsWith(SUFFIX_CLASS) && fileName.length() > SUFFIX_CLASS.length() || fileName.endsWith(SUFFIX_SIG);
    }

    public boolean endsScalaOrJava(String fileName) {
        return this.endsScala(fileName) || this.endsJava(fileName);
    }

    public boolean endsJava(String fileName) {
        return fileName.endsWith(SUFFIX_JAVA) && fileName.length() > SUFFIX_JAVA.length();
    }

    public boolean endsScala(String fileName) {
        return fileName.endsWith(SUFFIX_SCALA) && fileName.length() > SUFFIX_SCALA.length();
    }

    public String stripClassExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public String stripJavaExtension(String fileName) {
        return fileName.substring(0, fileName.length() - 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayBeValidPackage(String dirName) {
        String string = dirName;
        String string2 = "META-INF";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = dirName;
        String string4 = "";
        if (string3 == null) {
            if (string4 == null) return false;
        } else if (string3.equals(string4)) return false;
        if (dirName.charAt(0) == '.') return false;
        return true;
    }

    public FileFilter mkFileFilter(Function1<File, Object> f) {
        return new FileFilter(f){
            private final Function1 f$1;
            {
                this.f$1 = f$2;
            }

            public boolean accept(File pathname) {
                return BoxesRunTime.unboxToBoolean((Object)this.f$1.apply((Object)pathname));
            }
        };
    }
}

