/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.WeakHashSet$;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.AbstractIterator;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.SetOps;
import scala.collection.mutable.Shrinkable;
import scala.runtime.RichDouble$;
import scala.runtime.Scala3RunTime$;

public final class WeakHashSet<A>
implements scala.collection.mutable.Set<A> {
    private final int initialCapacity;
    private final double loadFactor;
    private final ReferenceQueue<A> queue;
    public int dotty$tools$dotc$util$WeakHashSet$$count;
    public Entry<A>[] dotty$tools$dotc$util$WeakHashSet$$table;
    private int threshold;

    public static int apply$default$1() {
        return WeakHashSet$.MODULE$.apply$default$1();
    }

    public static double apply$default$2() {
        return WeakHashSet$.MODULE$.apply$default$2();
    }

    public <A> WeakHashSet(int initialCapacity, double loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.mutable.Iterable.$init$((scala.collection.mutable.Iterable)this);
        scala.collection.SetOps.$init$((scala.collection.SetOps)this);
        Set.$init$((Set)this);
        Cloneable.$init$((Cloneable)this);
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        Shrinkable.$init$((Shrinkable)this);
        SetOps.$init$((SetOps)this);
        scala.collection.mutable.Set.$init$((scala.collection.mutable.Set)this);
        this.queue = new ReferenceQueue();
        this.dotty$tools$dotc$util$WeakHashSet$$count = 0;
        this.dotty$tools$dotc$util$WeakHashSet$$table = new Entry[this.computeCapacity()];
        this.threshold = this.computeThreshold();
    }

    public Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    public <A> WeakHashSet() {
        this(16, 0.75);
    }

    /*
     * WARNING - void declaration
     */
    private int computeCapacity() {
        void var1_1;
        if (this.initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        for (int candidate = 1; candidate < this.initialCapacity; candidate *= 2) {
        }
        return (int)var1_1;
    }

    private int computeThreshold() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.dotty$tools$dotc$util$WeakHashSet$$table);
        return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)ArrayOps$.MODULE$.size$extension(object) * this.loadFactor));
    }

    public Option<A> get(A elem) {
        return Option$.MODULE$.apply(this.findEntry(elem));
    }

    public int dotty$tools$dotc$util$WeakHashSet$$bucketFor(int hash) {
        int h = hash;
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.dotty$tools$dotc$util$WeakHashSet$$table.length - 1;
    }

    private void remove(int bucket, Entry<A> prevEntry, Entry<A> entry) {
        Entry<A> entry2 = prevEntry;
        if (entry2 == null) {
            this.dotty$tools$dotc$util$WeakHashSet$$table[bucket] = entry.tail();
        } else {
            prevEntry.tail_$eq(entry.tail());
        }
        --this.dotty$tools$dotc$util$WeakHashSet$$count;
    }

    private void removeStaleEntries() {
        this.queueLoop$1();
    }

    private void resize() {
        Object[] oldTable = this.dotty$tools$dotc$util$WeakHashSet$$table;
        Object object = Predef$.MODULE$.refArrayOps(oldTable);
        this.dotty$tools$dotc$util$WeakHashSet$$table = new Entry[ArrayOps$.MODULE$.size$extension(object) * 2];
        this.threshold = this.computeThreshold();
        this.tableLoop$1((Entry[])oldTable, 0);
    }

    public boolean contains(A elem) {
        return this.findEntry(elem) != null;
    }

    public A findEntry(A elem) {
        A a = elem;
        if (a == null) {
            throw new NullPointerException("WeakHashSet cannot hold nulls");
        }
        this.removeStaleEntries();
        int hash = elem.hashCode();
        int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(hash);
        return (A)WeakHashSet.linkedListLoop$1(elem, this.dotty$tools$dotc$util$WeakHashSet$$table[bucket]);
    }

    public A findEntryOrUpdate(A elem) {
        A a = elem;
        if (a == null) {
            throw new NullPointerException("WeakHashSet cannot hold nulls");
        }
        this.removeStaleEntries();
        int hash = elem.hashCode();
        int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(hash);
        Entry<A> oldHead = this.dotty$tools$dotc$util$WeakHashSet$$table[bucket];
        return (A)this.linkedListLoop$2(elem, hash, bucket, oldHead, oldHead);
    }

    public WeakHashSet addOne(A elem) {
        A a = elem;
        if (a == null) {
            throw new NullPointerException("WeakHashSet cannot hold nulls");
        }
        this.removeStaleEntries();
        int hash = elem.hashCode();
        int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(hash);
        Entry<A> oldHead = this.dotty$tools$dotc$util$WeakHashSet$$table[bucket];
        this.linkedListLoop$3(elem, hash, bucket, oldHead, oldHead);
        return this;
    }

    public WeakHashSet subtractOne(A elem) {
        WeakHashSet weakHashSet;
        A a = elem;
        if (a == null) {
            weakHashSet = this;
        } else {
            this.removeStaleEntries();
            int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(elem.hashCode());
            this.linkedListLoop$4(elem, bucket, null, this.dotty$tools$dotc$util$WeakHashSet$$table[bucket]);
            weakHashSet = this;
        }
        return weakHashSet;
    }

    public void clear() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.dotty$tools$dotc$util$WeakHashSet$$table);
        this.dotty$tools$dotc$util$WeakHashSet$$table = new Entry[ArrayOps$.MODULE$.size$extension(object)];
        this.threshold = this.computeThreshold();
        this.dotty$tools$dotc$util$WeakHashSet$$count = 0;
        this.queueLoop$2();
    }

    public WeakHashSet empty() {
        return new WeakHashSet<A>(this.initialCapacity, this.loadFactor);
    }

    public int size() {
        this.removeStaleEntries();
        return this.dotty$tools$dotc$util$WeakHashSet$$count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public <U> void foreach(Function1<A, U> f) {
        this.iterator().foreach(f);
    }

    public List<A> toList() {
        return this.iterator().toList();
    }

    public Iterator<A> iterator() {
        this.removeStaleEntries();
        return new AbstractIterator(this){
            private int currentBucket;
            private Entry entry;
            private Object lookaheadelement;
            private final WeakHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Object object = Predef$.MODULE$.refArrayOps((Object[])$outer.dotty$tools$dotc$util$WeakHashSet$$table);
                this.currentBucket = ArrayOps$.MODULE$.size$extension(object);
                this.entry = null;
                this.lookaheadelement = null;
            }

            public boolean hasNext() {
                boolean bl;
                block3: {
                    $anon$1 var1_1 = this;
                    while (true) {
                        if (var1_1.entry == null && var1_1.currentBucket > 0) {
                            --var1_1.currentBucket;
                            var1_1.entry = var1_1.$outer.dotty$tools$dotc$util$WeakHashSet$$table[var1_1.currentBucket];
                            continue;
                        }
                        if (var1_1.entry == null) {
                            bl = false;
                            break block3;
                        }
                        var1_1.lookaheadelement = var1_1.entry.get();
                        if (var1_1.lookaheadelement != null) break;
                        var1_1.entry = var1_1.entry.tail();
                    }
                    bl = true;
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                if (this.lookaheadelement == null) {
                    throw new IndexOutOfBoundsException("next on an empty iterator");
                }
                Object result = this.lookaheadelement;
                this.lookaheadelement = null;
                this.entry = this.entry.tail();
                return var1_1;
            }
        };
    }

    public Diagnostics diagnostics() {
        return new Diagnostics(this);
    }

    private final Entry poll$1() {
        return (Entry)this.queue.poll();
    }

    private final void linkedListLoop$5(Entry stale$1, int bucket$1, Entry prevEntry, Entry entry) {
        Entry entry2 = entry;
        Entry entry3 = prevEntry;
        while (true) {
            if (stale$1 == entry2) {
                this.remove(bucket$1, entry3, entry2);
                break;
            }
            if (entry2 == null) break;
            Entry entry4 = entry2;
            Entry entry5 = entry2.tail();
            entry3 = entry4;
            entry2 = entry5;
        }
    }

    private final void queueLoop$1() {
        Entry stale;
        while ((stale = this.poll$1()) != null) {
            int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(stale.hash());
            this.linkedListLoop$5(stale, bucket, null, this.dotty$tools$dotc$util$WeakHashSet$$table[bucket]);
        }
    }

    private final void linkedListLoop$6(Entry entry) {
        Entry<A> entry2;
        Entry<A> entry3 = entry;
        while ((entry2 = entry3) != null) {
            int bucket = this.dotty$tools$dotc$util$WeakHashSet$$bucketFor(entry3.hash());
            Entry<A> oldNext = entry3.tail();
            entry3.tail_$eq(this.dotty$tools$dotc$util$WeakHashSet$$table[bucket]);
            this.dotty$tools$dotc$util$WeakHashSet$$table[bucket] = entry3;
            entry3 = oldNext;
        }
    }

    private final void tableLoop$1(Entry[] oldTable$1, int oldBucket) {
        Object object;
        for (int i = oldBucket; i < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])oldTable$1)); ++i) {
            this.linkedListLoop$6(oldTable$1[i]);
        }
    }

    private static final Object linkedListLoop$1(Object elem$1, Entry entry) {
        Object v0;
        Entry entry2 = entry;
        while (true) {
            Entry entry3;
            if ((entry3 = entry2) == null) {
                v0 = null;
                break;
            }
            Object entryElem = entry2.get();
            if (elem$1.equals(entryElem)) {
                v0 = entryElem;
                break;
            }
            entry2 = entry2.tail();
        }
        return v0;
    }

    private final Object add$1(Object elem$2, int hash$1, int bucket$2, Entry oldHead$1) {
        this.dotty$tools$dotc$util$WeakHashSet$$table[bucket$2] = new Entry<Object>(elem$2, hash$1, oldHead$1, this.queue);
        ++this.dotty$tools$dotc$util$WeakHashSet$$count;
        if (this.dotty$tools$dotc$util$WeakHashSet$$count > this.threshold) {
            this.resize();
        }
        return elem$2;
    }

    private final Object linkedListLoop$2(Object elem$3, int hash$2, int bucket$3, Entry oldHead$2, Entry entry) {
        Object object;
        Entry entry2 = entry;
        while (true) {
            Entry entry3;
            if ((entry3 = entry2) == null) {
                object = this.add$1(elem$3, hash$2, bucket$3, oldHead$2);
                break;
            }
            Object entryElem = entry2.get();
            if (elem$3.equals(entryElem)) {
                object = entryElem;
                break;
            }
            entry2 = entry2.tail();
        }
        return object;
    }

    private final void add$2(Object elem$4, int hash$3, int bucket$4, Entry oldHead$3) {
        this.dotty$tools$dotc$util$WeakHashSet$$table[bucket$4] = new Entry<Object>(elem$4, hash$3, oldHead$3, this.queue);
        ++this.dotty$tools$dotc$util$WeakHashSet$$count;
        if (this.dotty$tools$dotc$util$WeakHashSet$$count > this.threshold) {
            this.resize();
        }
    }

    private final void linkedListLoop$3(Object elem$5, int hash$4, int bucket$5, Entry oldHead$4, Entry entry) {
        Entry entry2 = entry;
        while (true) {
            Entry entry3;
            if ((entry3 = entry2) == null) {
                this.add$2(elem$5, hash$4, bucket$5, oldHead$4);
                break;
            }
            if (elem$5.equals(entry2.get())) break;
            entry2 = entry2.tail();
        }
    }

    private final void linkedListLoop$4(Object elem$6, int bucket$6, Entry prevEntry, Entry entry) {
        Entry entry2;
        Entry entry3 = entry;
        Entry entry4 = prevEntry;
        while ((entry2 = entry3) != null) {
            if (elem$6.equals(entry3.get())) {
                this.remove(bucket$6, entry4, entry3);
                break;
            }
            Entry entry5 = entry3;
            Entry entry6 = entry3.tail();
            entry4 = entry5;
            entry3 = entry6;
        }
    }

    private final void queueLoop$2() {
        while (this.queue.poll() != null) {
        }
    }

    public static final /* synthetic */ boolean dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$collisionBucketsCount$$anonfun$1(Entry entry) {
        return entry != null && entry.tail() != null;
    }

    public static final /* synthetic */ boolean dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$fullBucketsCount$$anonfun$1(Entry entry) {
        return entry != null;
    }

    public class Diagnostics {
        private final WeakHashSet<A> $outer;

        public Diagnostics(WeakHashSet $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public void fullyValidate() {
            Object object;
            int computedCount = 0;
            for (int bucket = 0; bucket < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.dotty$tools$dotc$util$WeakHashSet$$table)); ++bucket) {
                for (Entry entry = this.$outer.dotty$tools$dotc$util$WeakHashSet$$table[bucket]; entry != null; entry = entry.tail()) {
                    int realHash;
                    if (entry.get() == null) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)("" + entry + " had a null value indicated that gc activity was happening during diagnostic validation or that a null value was inserted"));
                    }
                    ++computedCount;
                    int cachedHash = entry.hash();
                    if (cachedHash != (realHash = entry.get().hashCode())) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)("for " + entry + " cached hash was " + cachedHash + " but should have been " + realHash));
                    }
                    int computedBucket = this.$outer.dotty$tools$dotc$util$WeakHashSet$$bucketFor(realHash);
                    if (computedBucket == bucket) continue;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("for " + entry + " the computed bucket was " + computedBucket + " but should have been " + bucket));
                }
            }
            if (computedCount != this.$outer.dotty$tools$dotc$util$WeakHashSet$$count) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("The computed count was " + computedCount + " but should have been " + this.$outer.dotty$tools$dotc$util$WeakHashSet$$count));
            }
        }

        public String dump() {
            return Arrays.toString(this.$outer.dotty$tools$dotc$util$WeakHashSet$$table);
        }

        public int collisionBucketsCount() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.dotty$tools$dotc$util$WeakHashSet$$table);
            return ArrayOps$.MODULE$.count$extension(object, WeakHashSet::dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$collisionBucketsCount$$anonfun$1);
        }

        public int fullBucketsCount() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.dotty$tools$dotc$util$WeakHashSet$$table);
            return ArrayOps$.MODULE$.count$extension(object, WeakHashSet::dotty$tools$dotc$util$WeakHashSet$Diagnostics$$_$fullBucketsCount$$anonfun$1);
        }

        public int bucketsCount() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.dotty$tools$dotc$util$WeakHashSet$$table);
            return ArrayOps$.MODULE$.size$extension(object);
        }

        public final WeakHashSet<A> dotty$tools$dotc$util$WeakHashSet$Diagnostics$$$outer() {
            return this.$outer;
        }
    }

    private static class Entry<A>
    extends WeakReference<A> {
        private final int hash;
        private Entry tail;

        public <A> Entry(A element, int hash, Entry<A> tail, ReferenceQueue<A> queue) {
            this.hash = hash;
            this.tail = tail;
            super(element, queue);
        }

        public int hash() {
            return this.hash;
        }

        public Entry<A> tail() {
            return this.tail;
        }

        public void tail_$eq(Entry<A> x$1) {
            this.tail = x$1;
        }
    }
}

