/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.runtime.function.JFunction0;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.util.HashMap;
import dotty.tools.dotc.util.HashMap$;
import dotty.tools.dotc.util.ReadOnlyMap;
import dotty.tools.dotc.util.Spans;
import dotty.tools.dotc.util.Spans$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyReader;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class PositionUnpickler {
    private final TastyReader reader;
    private final Function1<TastyBuffer.NameRef, Names.TermName> nameAtRef;
    private HashMap<TastyBuffer.Addr, Spans.Span> mySpans;
    private HashMap<TastyBuffer.Addr, String> mySourcePaths;
    private boolean isDefined;

    public PositionUnpickler(TastyReader reader, Function1<TastyBuffer.NameRef, Names.TermName> nameAtRef) {
        this.reader = reader;
        this.nameAtRef = nameAtRef;
        this.isDefined = false;
    }

    public void ensureDefined() {
        if (!this.isDefined) {
            this.mySpans = new HashMap(HashMap$.MODULE$.$lessinit$greater$default$1(), HashMap$.MODULE$.$lessinit$greater$default$2());
            this.mySourcePaths = new HashMap(HashMap$.MODULE$.$lessinit$greater$default$1(), HashMap$.MODULE$.$lessinit$greater$default$2());
            int curIndex = 0;
            int curStart = 0;
            int curEnd = 0;
            while (!this.reader.isAtEnd()) {
                boolean hasPoint;
                int header = this.reader.readInt();
                if (header == 4) {
                    String path = ((Names.TermName)this.nameAtRef.apply((Object)new TastyBuffer.NameRef(this.reader.readNameRef()))).toString();
                    this.mySourcePaths.update(new TastyBuffer.Addr(TastyBuffer.Addr$.MODULE$.apply(curIndex)), path);
                    continue;
                }
                int addrDelta = header >> 3;
                boolean hasStart = (header & 4) != 0;
                boolean hasEnd = (header & 2) != 0;
                boolean bl = hasPoint = (header & 1) != 0;
                if ((curIndex += addrDelta) < 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (hasStart) {
                    curStart += this.reader.readInt();
                }
                if (hasEnd) {
                    curEnd += this.reader.readInt();
                }
                this.mySpans.update(new TastyBuffer.Addr(TastyBuffer.Addr$.MODULE$.apply(curIndex)), hasPoint ? new Spans.Span(Spans$.MODULE$.Span(curStart, curEnd, curStart + this.reader.readInt())) : new Spans.Span(Spans$.MODULE$.Span(curStart, curEnd)));
            }
            this.isDefined = true;
        }
    }

    public ReadOnlyMap<TastyBuffer.Addr, Spans.Span> spans() {
        this.ensureDefined();
        return this.mySpans;
    }

    public ReadOnlyMap<TastyBuffer.Addr, String> sourcePaths() {
        this.ensureDefined();
        return this.mySourcePaths;
    }

    public long spanAt(int addr) {
        Spans.Span span = this.spans().getOrElse(new TastyBuffer.Addr(addr), (Function0<Spans.Span>)((JFunction0 & Serializable)PositionUnpickler::spanAt$$anonfun$adapted$1));
        return span == null ? BoxesRunTime.unboxToLong(null) : span.coords();
    }

    public String sourcePathAt(int addr) {
        return this.sourcePaths().getOrElse(new TastyBuffer.Addr(addr), (Function0<String>)((Function0 & Serializable)PositionUnpickler::sourcePathAt$$anonfun$1));
    }

    private static final long spanAt$$anonfun$1() {
        return Spans$.MODULE$.NoSpan();
    }

    private static final Object spanAt$$anonfun$adapted$1() {
        return new Spans.Span(PositionUnpickler.spanAt$$anonfun$1());
    }

    private static final String sourcePathAt$$anonfun$1() {
        return "";
    }
}

