/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.SimpleIdentitySet$empty$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JFunction2;
import scala.runtime.function.JProcedure1;

public abstract class SimpleIdentitySet<Elem> {
    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract <E> SimpleIdentitySet<E> $plus(E var1);

    public abstract <E> SimpleIdentitySet<Elem> $minus(E var1);

    public abstract <E> boolean contains(E var1);

    public abstract void foreach(Function1<Elem, BoxedUnit> var1);

    public abstract <E> boolean exists(Function1<E, Object> var1);

    public abstract <A, E> A $div$colon(A var1, Function2<A, E, A> var2);

    public abstract List<Elem> toList();

    public <E> SimpleIdentitySet<E> $plus$plus(SimpleIdentitySet<E> that) {
        return this.size() == 0 ? that : (that.size() == 0 ? this : that.$div$colon((Object)this, (Function2)(JFunction2 & Serializable)(_$1, _$2) -> _$1.$plus(_$2)));
    }

    public <E> SimpleIdentitySet<E> $minus$minus(SimpleIdentitySet<E> that) {
        SimpleIdentitySet simpleIdentitySet;
        if (that.size() == 0) {
            simpleIdentitySet = this;
        } else {
            SimpleIdentitySet$empty$ simpleIdentitySet$empty$ = SimpleIdentitySet$empty$.MODULE$;
            simpleIdentitySet = this.$div$colon((Object)simpleIdentitySet$empty$, (Function2)(JFunction2 & Serializable)(s, x) -> that.contains(x) ? s : s.$plus(x));
        }
        return simpleIdentitySet;
    }

    public String toString() {
        return this.toList().mkString("(", ", ", ")");
    }

    private static class Set1<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;

        public <Elem> Set1(Object x0) {
            this.x0 = x0;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            return this.contains(x) ? this : new Set2(this.x0, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? SimpleIdentitySet$empty$.MODULE$ : this;
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(z, this.x0);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            return package$.MODULE$.Nil().$colon$colon(object);
        }
    }

    private static class Set2<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;

        public <Elem> Set2(Object x0, Object x1) {
            this.x0 = x0;
            this.x1 = x1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            return this.contains(x) ? this : new Set3(this.x0, this.x1, x);
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? new Set1(this.x1) : (x == this.x1 ? new Set1(this.x0) : this);
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x1));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(f.apply(z, this.x0), this.x1);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            Object object2 = this.x1;
            return package$.MODULE$.Nil().$colon$colon(object2).$colon$colon(object);
        }
    }

    private static class Set3<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object x0;
        private final Object x1;
        private final Object x2;

        public <Elem> Set3(Object x0, Object x1, Object x2) {
            this.x0 = x0;
            this.x1 = x1;
            this.x2 = x2;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            SimpleIdentitySet simpleIdentitySet;
            if (this.contains(x)) {
                simpleIdentitySet = this;
            } else {
                Object[] xs = new Object[]{this.x0, this.x1, this.x2, x};
                simpleIdentitySet = new SetN(xs);
            }
            return simpleIdentitySet;
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            return x == this.x0 ? new Set2(this.x1, this.x2) : (x == this.x1 ? new Set2(this.x0, this.x2) : (x == this.x2 ? new Set2(this.x0, this.x1) : this));
        }

        @Override
        public <E> boolean contains(E x) {
            return x == this.x0 || x == this.x1 || x == this.x2;
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            f.apply(this.x0);
            f.apply(this.x1);
            f.apply(this.x2);
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            return BoxesRunTime.unboxToBoolean((Object)p.apply(this.x0)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x1)) || BoxesRunTime.unboxToBoolean((Object)p.apply(this.x2));
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            return (A)f.apply(f.apply(f.apply(z, this.x0), this.x1), this.x2);
        }

        @Override
        public List<Elem> toList() {
            Object object = this.x0;
            Object object2 = this.x1;
            Object object3 = this.x2;
            return package$.MODULE$.Nil().$colon$colon(object3).$colon$colon(object2).$colon$colon(object);
        }
    }

    private static class SetN<Elem>
    extends SimpleIdentitySet<Elem> {
        private final Object[] xs;

        public <Elem> SetN(Object[] xs) {
            this.xs = xs;
        }

        public Object[] xs() {
            return this.xs;
        }

        @Override
        public int size() {
            return this.xs().length;
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus(E x) {
            SetN setN;
            if (this.contains(x)) {
                setN = this;
            } else {
                Object[] xs1 = new Object[this.size() + 1];
                System.arraycopy(this.xs(), 0, xs1, 0, this.size());
                xs1[this.size()] = x;
                setN = new SetN<Elem>(xs1);
            }
            return setN;
        }

        @Override
        public <E> SimpleIdentitySet<Elem> $minus(E x) {
            SimpleIdentitySet simpleIdentitySet;
            int i;
            for (i = 0; i < this.size() && this.xs()[i] != x; ++i) {
            }
            if (i == this.size()) {
                simpleIdentitySet = this;
            } else if (this.size() == 4) {
                simpleIdentitySet = i == 0 ? new Set3(this.xs()[1], this.xs()[2], this.xs()[3]) : (i == 1 ? new Set3(this.xs()[0], this.xs()[2], this.xs()[3]) : (i == 2 ? new Set3(this.xs()[0], this.xs()[1], this.xs()[3]) : new Set3(this.xs()[0], this.xs()[1], this.xs()[2])));
            } else {
                Object[] xs1 = new Object[this.size() - 1];
                System.arraycopy(this.xs(), 0, xs1, 0, i);
                System.arraycopy(this.xs(), i + 1, xs1, i, this.size() - (i + 1));
                simpleIdentitySet = new SetN<Elem>(xs1);
            }
            return simpleIdentitySet;
        }

        @Override
        public <E> boolean contains(E x) {
            int i;
            for (i = 0; i < this.size() && this.xs()[i] != x; ++i) {
            }
            return i < this.size();
        }

        @Override
        public void foreach(Function1<Elem, BoxedUnit> f) {
            for (int i = 0; i < this.size(); ++i) {
                f.apply(this.xs()[i]);
            }
        }

        @Override
        public <E> boolean exists(Function1<E, Object> p) {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return ArrayOps$.MODULE$.exists$extension(object, p);
        }

        @Override
        public <A, E> A $div$colon(A z, Function2<A, E, A> f) {
            Object object = Predef$.MODULE$.refArrayOps(this.xs());
            return (A)ArrayOps$.MODULE$.foldLeft$extension(object, z, f);
        }

        @Override
        public List<Elem> toList() {
            ListBuffer buf = new ListBuffer();
            this.foreach((Function1<Elem, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> buf.$plus$eq(_$3));
            return buf.toList();
        }

        @Override
        public <E> SimpleIdentitySet<E> $plus$plus(SimpleIdentitySet<E> that) {
            SetN setN;
            SimpleIdentitySet<E> simpleIdentitySet = that;
            if (simpleIdentitySet instanceof SetN) {
                SetN that2 = (SetN)simpleIdentitySet;
                ArrayBuffer toAdd = null;
                int limit = that2.xs().length;
                for (int i = 0; i < limit; ++i) {
                    Object elem = that2.xs()[i];
                    if (this.contains(elem)) continue;
                    if (toAdd == null) {
                        toAdd = new ArrayBuffer();
                    }
                    toAdd.$plus$eq(elem);
                }
                if (toAdd == null) {
                    setN = this;
                } else {
                    int numAdded = toAdd.size();
                    Object[] xs1 = new Object[this.size() + numAdded];
                    System.arraycopy(this.xs(), 0, xs1, 0, this.size());
                    for (int i = 0; i < numAdded; ++i) {
                        xs1[i + this.size()] = toAdd.apply(i);
                    }
                    setN = new SetN<Elem>(xs1);
                }
            } else {
                setN = super.$plus$plus(that);
            }
            return setN;
        }

        @Override
        public <E> SimpleIdentitySet<E> $minus$minus(SimpleIdentitySet<E> that) {
            SimpleIdentitySet simpleIdentitySet;
            SimpleIdentitySet<E> simpleIdentitySet2 = that;
            if (simpleIdentitySet2 instanceof SetN) {
                SetN that2 = (SetN)simpleIdentitySet2;
                ArrayBuffer toAdd = null;
                int thisSize = this.size();
                int thatSize = that2.size();
                Object[] thatElems = that2.xs();
                int searchStart = 0;
                for (int i = 0; i < thisSize; ++i) {
                    Growable growable;
                    Object elem = this.xs()[i];
                    int j = searchStart;
                    boolean missing = false;
                    while (!missing && elem != thatElems[j]) {
                        if (++j == thatSize) {
                            j = 0;
                        }
                        missing = j == searchStart;
                    }
                    if (missing) {
                        if (toAdd == null) {
                            toAdd = new ArrayBuffer();
                        }
                        growable = toAdd.$plus$eq(elem);
                        continue;
                    }
                    searchStart = (j + 1) % thatSize;
                    growable = BoxedUnit.UNIT;
                }
                if (toAdd == null) {
                    simpleIdentitySet = SimpleIdentitySet$empty$.MODULE$;
                } else {
                    int n = toAdd.size();
                    switch (n) {
                        case 1: {
                            simpleIdentitySet = new Set1(toAdd.apply(0));
                            break;
                        }
                        case 2: {
                            simpleIdentitySet = new Set2(toAdd.apply(0), toAdd.apply(1));
                            break;
                        }
                        case 3: {
                            simpleIdentitySet = new Set3(toAdd.apply(0), toAdd.apply(1), toAdd.apply(2));
                            break;
                        }
                        default: {
                            simpleIdentitySet = new SetN<Elem>((Object[])toAdd.toArray(ClassTag$.MODULE$.apply(Object.class)));
                            break;
                        }
                    }
                }
            } else {
                simpleIdentitySet = that.$div$colon(this, (JFunction2 & Serializable)(_$4, _$5) -> _$4.$minus(_$5));
            }
            return simpleIdentitySet;
        }
    }
}

