/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.FatalError;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import dotty.tools.io.File$;
import dotty.tools.io.Jar$;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainFile;
import dotty.tools.io.VirtualDirectory;
import dotty.tools.io.ZipArchive;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JFunction2;

public class OutputDirs {
    private List<Tuple2<AbstractFile, AbstractFile>> outputDirs = package$.MODULE$.Nil();
    private Option<AbstractFile> singleOutDir = None$.MODULE$;

    public void add(String srcDir, String outDir) {
        this.add(this.checkDir(AbstractFile$.MODULE$.getDirectory(srcDir), srcDir, this.checkDir$default$3()), this.checkDir(AbstractFile$.MODULE$.getDirectory(outDir), outDir, this.checkDir$default$3()));
    }

    private AbstractFile checkDir(AbstractFile dir, String name, boolean allowJar) {
        AbstractFile abstractFile;
        if (dir != null && dir.isDirectory()) {
            abstractFile = dir;
        } else if (allowJar && dir == null && Jar$.MODULE$.isJarOrZip(File$.MODULE$.apply(name, Codec$.MODULE$.fallbackSystemCodec()), false)) {
            abstractFile = new PlainFile(Path$.MODULE$.apply(name));
        } else {
            throw new FatalError(name + " does not exist or is not a directory");
        }
        return abstractFile;
    }

    private boolean checkDir$default$3() {
        return false;
    }

    public void setSingleOutput(String outDir) {
        AbstractFile dst = AbstractFile$.MODULE$.getDirectory(outDir);
        this.setSingleOutput(this.checkDir(dst, outDir, true));
    }

    public Option<AbstractFile> getSingleOutput() {
        return this.singleOutDir;
    }

    public void setSingleOutput(AbstractFile dir) {
        this.singleOutDir = Some$.MODULE$.apply((Object)dir);
    }

    public void add(AbstractFile src, AbstractFile dst) {
        this.singleOutDir = None$.MODULE$;
        this.outputDirs = this.outputDirs.$colon$colon((Object)Tuple2$.MODULE$.apply((Object)src, (Object)dst));
    }

    public List<Tuple2<AbstractFile, AbstractFile>> outputs() {
        return this.outputDirs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractFile outputDirFor(AbstractFile src) {
        AbstractFile abstractFile;
        Option<AbstractFile> option = this.singleOutDir;
        if (option instanceof Some) {
            AbstractFile d;
            abstractFile = d = (AbstractFile)((Some)option).value();
            return abstractFile;
        } else {
            AbstractFile d;
            Tuple2 tuple2;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option option2 = this.outputs().find(((JFunction2 & Serializable)(JFunction2 & Serializable)(srcDir, outDir) -> OutputDirs.isBelow$1(src, srcDir, outDir)).tupled());
            if (!(option2 instanceof Some) || (tuple2 = (Tuple2)((Some)option2).value()) == null) throw new FatalError("Could not find an output directory for " + src.path() + " in " + this.outputs());
            abstractFile = d = (AbstractFile)tuple2._2();
        }
        return abstractFile;
    }

    public List<AbstractFile> srcFilesFor(AbstractFile classFile, String srcPath) {
        Object object;
        Option<AbstractFile> option = this.singleOutDir;
        if (option instanceof Some) {
            AbstractFile d = (AbstractFile)((Some)option).value();
            AbstractFile abstractFile = d;
            object = abstractFile instanceof VirtualDirectory || abstractFile instanceof ZipArchive ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractFile[]{d.lookupPathUnchecked(srcPath, false)}));
        } else if (None$.MODULE$.equals(option)) {
            List list = this.outputs().filter(((JFunction2 & Serializable)(JFunction2 & Serializable)(srcDir, outDir) -> OutputDirs.isBelow$2(classFile, srcDir, outDir)).tupled());
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                object = package$.MODULE$.Nil();
            } else {
                List matches = list;
                object = matches.map((Function1)(JFunction1 & Serializable)_$1 -> ((AbstractFile)_$1._1()).lookupPathUnchecked(srcPath, false));
            }
        } else {
            throw new MatchError(option);
        }
        return object;
    }

    private static final boolean isBelow$1(AbstractFile src$1, AbstractFile srcDir, AbstractFile outDir) {
        return src$1.path().startsWith(srcDir.path());
    }

    private static final boolean isBelow$2(AbstractFile classFile$1, AbstractFile srcDir, AbstractFile outDir) {
        return classFile$1.path().startsWith(outDir.path());
    }
}

