/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.ClassFileEntry;
import dotty.tools.dotc.classpath.ClassFileEntryImpl$;
import dotty.tools.dotc.classpath.ClassPathEntries;
import dotty.tools.dotc.classpath.ClassPathEntries$;
import dotty.tools.dotc.classpath.FileUtils$;
import dotty.tools.dotc.classpath.JrtClassPath$;
import dotty.tools.dotc.classpath.NoSourcePaths;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassPath;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.File;
import dotty.tools.io.PlainFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JFunction1;

public final class JrtClassPath
implements ClassPath,
NoSourcePaths {
    private final Map<String, scala.collection.immutable.Seq<Path>> packageToModuleBases;

    public static Option<ClassPath> apply() {
        return JrtClassPath$.MODULE$.apply();
    }

    public JrtClassPath(FileSystem fs) {
        Path dir = fs.getPath("/packages", new String[0]);
        Iterator ps = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.newDirectoryStream(dir).iterator()).asScala();
        this.packageToModuleBases = ps.map((Function1)(JFunction1 & Serializable)p -> Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(p.toString()), "/packages/"), (Object)JrtClassPath.lookup$2(p))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public boolean hasPackage(PackageName pkg) {
        return this.packageToModuleBases.contains((Object)pkg.dottedString());
    }

    @Override
    public scala.collection.immutable.Seq<PackageEntry> packages(PackageName inPackage) {
        return this.packageToModuleBases.keysIterator().filter((Function1)(JFunction1 & Serializable)packageDottedName -> this.matches$1(inPackage, (String)packageDottedName)).map((Function1)(JFunction1 & Serializable)_$1 -> PackageEntryImpl$.MODULE$.apply((String)_$1)).toVector();
    }

    @Override
    public scala.collection.immutable.Seq<ClassFileEntry> classes(PackageName inPackage) {
        return (scala.collection.immutable.Seq)(inPackage.isRoot() ? package$.MODULE$.Nil() : ((IterableOnceOps)((IterableOps)((IterableOps)this.packageToModuleBases.getOrElse((Object)inPackage.dottedString(), JrtClassPath::classes$$anonfun$1)).flatMap((Function1)(JFunction1 & Serializable)x -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(x.resolve(inPackage.dirPathTrailingSlash())).iterator()).asScala()).filter((Function1)(JFunction1 & Serializable)_$2 -> _$2.getFileName().toString().endsWith(".class")))).map((Function1)(JFunction1 & Serializable)x -> ClassFileEntryImpl$.MODULE$.apply(new PlainFile(new File((Path)x, Codec$.MODULE$.fallbackSystemCodec()))))).toVector());
    }

    @Override
    public ClassPathEntries list(PackageName inPackage) {
        return inPackage.isRoot() ? ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)package$.MODULE$.Nil()) : ClassPathEntries$.MODULE$.apply((Seq<PackageEntry>)this.packages(inPackage), (Seq<ClassRepresentation>)this.classes(inPackage));
    }

    @Override
    public scala.collection.immutable.Seq<URL> asURLs() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URL[]{new URL("jrt:/")}));
    }

    @Override
    public scala.collection.immutable.Seq<String> asClassPathStrings() {
        return package$.MODULE$.Nil();
    }

    @Override
    public Option<AbstractFile> findClassFile(String className) {
        None$ none$;
        if (!className.contains(".")) {
            none$ = None$.MODULE$;
        } else {
            String inPackage = this.packageOf(className);
            none$ = ((IterableOnce)this.packageToModuleBases.getOrElse((Object)inPackage, JrtClassPath::findClassFile$$anonfun$1)).iterator().flatMap((Function1)(JFunction1 & Serializable)x -> {
                Nil$ nil$;
                Path file = x.resolve(FileUtils$.MODULE$.dirPath(className) + ".class");
                if (Files.exists(file, new LinkOption[0])) {
                    PlainFile plainFile = new PlainFile(new File(file, Codec$.MODULE$.fallbackSystemCodec()));
                    nil$ = package$.MODULE$.Nil().$colon$colon((Object)plainFile);
                } else {
                    nil$ = package$.MODULE$.Nil();
                }
                return nil$;
            }).take(1).toList().headOption();
        }
        return none$;
    }

    private String packageOf(String dottedClassName) {
        return dottedClassName.substring(0, dottedClassName.lastIndexOf("."));
    }

    private static final scala.collection.immutable.Seq lookup$2(Path pack) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(pack).iterator()).asScala()).map((Function1)(JFunction1 & Serializable)l -> Files.isSymbolicLink(l) ? Files.readSymbolicLink(l) : l).toList();
    }

    private final boolean matches$1(PackageName inPackage$3, String packageDottedName) {
        boolean bl;
        if (packageDottedName.contains(".")) {
            String string = this.packageOf(packageDottedName);
            String string2 = inPackage$3.dottedString();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = inPackage$3.isRoot();
        }
        return bl;
    }

    private static final Nil$ classes$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final Nil$ findClassFile$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

