/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.util.IntMap;
import dotty.tools.dotc.util.IntMap$;
import dotty.tools.dotc.util.Util$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class TreeBuffer
extends TastyBuffer {
    private int[] offsets;
    private boolean[] isRelative;
    private int[] delta;
    private int numOffsets;
    private final IntMap<Trees.Tree<Null$>> treeAddrs;

    public TreeBuffer() {
        super(50000);
        int ItemsOverOffsets = 2;
        int initialOffsetSize = this.bytes().length / 8;
        this.offsets = new int[initialOffsetSize];
        this.isRelative = new boolean[initialOffsetSize];
        this.numOffsets = 0;
        this.treeAddrs = new IntMap(8192, IntMap$.MODULE$.$lessinit$greater$default$2());
    }

    public int registerTreeAddr(Trees.Tree tree) {
        int n;
        int idx = this.treeAddrs.apply(tree);
        if (idx < 0) {
            this.treeAddrs.update(tree, this.currentAddr());
            n = this.currentAddr();
        } else {
            n = TastyBuffer.Addr$.MODULE$.apply(idx);
        }
        return n;
    }

    public int addrOfTree(Trees.Tree tree) {
        int idx = this.treeAddrs.apply(tree);
        return idx < 0 ? TastyBuffer$.MODULE$.NoAddr() : TastyBuffer.Addr$.MODULE$.apply(idx);
    }

    private int offset(int i) {
        return TastyBuffer.Addr$.MODULE$.apply(this.offsets[i]);
    }

    private void keepOffset(boolean relative) {
        if (this.numOffsets == this.offsets.length) {
            this.offsets = (int[])dotty.tools.tasty.util.Util$.MODULE$.dble((Object)this.offsets, ClassTag$.MODULE$.apply(Integer.TYPE));
            this.isRelative = (boolean[])dotty.tools.tasty.util.Util$.MODULE$.dble((Object)this.isRelative, ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        this.offsets[this.numOffsets] = this.length();
        this.isRelative[this.numOffsets] = relative;
        ++this.numOffsets;
    }

    /*
     * WARNING - void declaration
     */
    public int reserveRef(boolean relative) {
        void var2_2;
        int addr = this.currentAddr();
        this.keepOffset(relative);
        this.reserveAddr();
        return (int)var2_2;
    }

    public void writeRef(int target) {
        this.keepOffset(false);
        this.fillAddr(this.reserveAddr(), target);
    }

    public void fillRef(int at, int target, boolean relative) {
        int addr = relative ? TastyBuffer.Addr$.MODULE$.relativeTo$extension(target, at) : target;
        this.fillAddr(at, addr);
    }

    public int deltaAt(int at) {
        int idx = Util$.MODULE$.bestFit(this.offsets, this.numOffsets, at - 1, Util$.MODULE$.bestFit$default$4());
        return idx < 0 ? 0 : this.delta[idx];
    }

    public int adjusted(int x) {
        return TastyBuffer.Addr$.MODULE$.$minus$extension(x, this.deltaAt(x));
    }

    private void computeDeltas() {
        this.delta = new int[this.numOffsets];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int off = this.offset(i);
            int skippedOff = this.skipZeroes(off);
            int skippedCount = skippedOff - off;
            if (skippedCount >= 4) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("unset field at position " + new TastyBuffer.Addr(off)));
            }
            this.delta[i] = lastDelta += skippedCount;
        }
    }

    private int adjustedOffset(int i) {
        int n;
        int at = this.offset(i);
        int original = this.getAddr(at);
        if (this.isRelative[i]) {
            int len2;
            int start = this.skipNat(at);
            int len1 = TastyBuffer.Addr$.MODULE$.$minus$extension(TastyBuffer.Addr$.MODULE$.$plus$extension(original, this.delta[i]), this.deltaAt(TastyBuffer.Addr$.MODULE$.$plus$extension(original, start)));
            if (!TastyBuffer.Addr$.MODULE$.$eq$eq$extension(len1, len2 = TastyBuffer.Addr$.MODULE$.$minus$extension(this.adjusted(TastyBuffer.Addr$.MODULE$.$plus$extension(original, start)), this.adjusted(start)))) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("adjusting offset #" + i + ": " + new TastyBuffer.Addr(at) + ", original = " + new TastyBuffer.Addr(original) + ", len1 = " + new TastyBuffer.Addr(len1) + ", len2 = " + new TastyBuffer.Addr(len2)));
            }
            n = len1;
        } else {
            n = this.adjusted(original);
        }
        return n;
    }

    private void adjustOffsets() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numOffsets).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int corrected = this.adjustedOffset(i);
            this.fillAddr(this.offset(i), corrected);
        });
    }

    private int adjustDeltas() {
        int[] delta1 = new int[this.delta.length];
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int corrected = this.adjustedOffset(i);
            delta1[i] = lastDelta += 4 - TastyBuffer$.MODULE$.natSize(corrected);
        }
        int saved = this.numOffsets == 0 ? 0 : delta1[this.numOffsets - 1] - this.delta[this.numOffsets - 1];
        this.delta = delta1;
        return saved;
    }

    private int compress() {
        IntRef lastDelta = IntRef.create((int)0);
        IntRef start = IntRef.create((int)0);
        int wasted = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int n;
            int n2;
            int next = this.offsets[i];
            this.shift$1(lastDelta, start, next);
            start.elem = n2 = next + this.delta[i] - lastDelta.elem;
            int pastZeroes = this.skipZeroes(TastyBuffer.Addr$.MODULE$.apply(next));
            if (pastZeroes < start.elem) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"something's wrong: eliminated non-zero");
            }
            wasted += pastZeroes - start.elem;
            lastDelta.elem = n = this.delta[i];
        }
        this.shift$1(lastDelta, start, this.length());
        this.length_$eq(this.length() - lastDelta.elem);
        return wasted;
    }

    public void adjustTreeAddrs() {
        for (int i = 0; i < this.treeAddrs.size(); ++i) {
            this.treeAddrs.setValue(i, this.adjusted(TastyBuffer.Addr$.MODULE$.apply(this.treeAddrs.value(i))));
        }
    }

    public void compactify() {
        int origLength = this.length();
        this.computeDeltas();
        IntRef saved = IntRef.create((int)0);
        do {
            int n;
            saved.elem = n = this.adjustDeltas();
        } while (saved.elem > 0 && this.length() / saved.elem < 100);
        this.adjustOffsets();
        this.adjustTreeAddrs();
        int wasted = this.compress();
    }

    private final void shift$1(IntRef lastDelta$1, IntRef start$1, int end) {
        System.arraycopy(this.bytes(), start$1.elem, this.bytes(), start$1.elem - lastDelta$1.elem, end - start$1.elem);
    }

    private final String msg$proxy2$1(int origLength$1, int wasted$1) {
        return "original length: " + origLength$1 + ", compressed to: " + this.length() + ", wasted: " + wasted$1;
    }
}

