/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.SyntaxMsg;
import java.io.Serializable;
import scala.Function1;
import scala.StringContext$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class StaticFieldsShouldPrecedeNonStatic
extends SyntaxMsg {
    private final Symbols.Symbol member;
    private final List<Trees.Tree<Types.Type>> defns;
    private final Contexts.Context x$3;

    public StaticFieldsShouldPrecedeNonStatic(Symbols.Symbol member, List<Trees.Tree<Types.Type>> defns, Contexts.Context x$3) {
        this.member = member;
        this.defns = defns;
        this.x$3 = x$3;
        super(ErrorMessageID$.StaticFieldsShouldPrecedeNonStaticID);
    }

    @Override
    public String msg() {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " in ", " must be defined before non-static fields."})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$.MODULE$.hl("@static", this.x$3), this.member, Symbols$.MODULE$.toDenot(this.member, this.x$3).owner()}), this.x$3);
    }

    @Override
    public String explain() {
        List nonStatics = this.defns.takeWhile((Function1)(JFunction1 & Serializable)_$12 -> {
            Symbols.Symbol symbol = _$12.symbol(this.x$3);
            Symbols.Symbol symbol2 = this.member;
            return symbol == null ? symbol2 != null : !symbol.equals(symbol2);
        }).take(3).filter((Function1)(JFunction1 & Serializable)_$13 -> _$13 instanceof Trees.ValDef);
        String codeExample = "object " + Symbols$.MODULE$.toDenot(this.member, this.x$3).owner().name(this.x$3).firstPart() + " {\n                        |  @static " + this.member + " = ...\n                        |  " + nonStatics.map((Function1)(JFunction1 & Serializable)m -> "" + m.symbol(this.x$3) + " = ...").mkString("\n  ") + "\n                        |  ...\n                        |}";
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The fields annotated with @static should precede any non @static fields.\n        |This ensures that we do not introduce surprises for users in initialization order of this class.\n        |Static field are initialized when class loading the code of Foo.\n        |Non static fields are only initialized the first  time that Foo is accessed.\n        |\n        |The definition of ", " should have been before the non ", "s:\n        |", "\n        |"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.member.name(this.x$3), Formatting$.MODULE$.hl("@static val", this.x$3), codeExample}), this.x$3);
    }
}

