/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.runtime.function.JFunction1;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.printing.Printer;
import dotty.tools.dotc.printing.Showable;
import dotty.tools.dotc.printing.Texts;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class SourcePosition
implements SrcPos,
dotty.tools.dotc.interfaces.SourcePosition,
Showable,
Product,
Serializable {
    private final SourceFile source;
    private final long span;
    private final SourcePosition outer;

    public static SourcePosition apply(SourceFile sourceFile, long l, SourcePosition sourcePosition) {
        return SourcePosition$.MODULE$.apply(sourceFile, l, sourcePosition);
    }

    public static Function1 curried() {
        return SourcePosition$.MODULE$.curried();
    }

    public static SourcePosition fromProduct(Product product) {
        return SourcePosition$.MODULE$.fromProduct(product);
    }

    public static Function1 tupled() {
        return SourcePosition$.MODULE$.tupled();
    }

    public static SourcePosition unapply(SourcePosition sourcePosition) {
        return SourcePosition$.MODULE$.unapply(sourcePosition);
    }

    public static NoSourcePosition$ $lessinit$greater$default$3() {
        return SourcePosition$.MODULE$.$lessinit$greater$default$3();
    }

    public SourcePosition(SourceFile source, long span, SourcePosition outer) {
        this.source = source;
        this.span = span;
        this.outer = outer;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SourcePosition)) return false;
        SourcePosition sourcePosition = (SourcePosition)object;
        SourceFile sourceFile = this.source();
        SourceFile sourceFile2 = sourcePosition.source();
        if (sourceFile == null) {
            if (sourceFile2 != null) {
                return false;
            }
        } else if (!((Object)sourceFile).equals(sourceFile2)) return false;
        if (!Spans$Span$.MODULE$.$eq$eq$extension(this.span(), sourcePosition.span())) return false;
        SourcePosition sourcePosition2 = this.outer();
        SourcePosition sourcePosition3 = sourcePosition.outer();
        if (sourcePosition2 == null) {
            if (sourcePosition3 == null) return true;
            return false;
        } else {
            if (!((Object)sourcePosition2).equals(sourcePosition3)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof SourcePosition;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "SourcePosition";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = new Spans.Span(this._2());
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "source";
                break;
            }
            case 1: {
                string = "span";
                break;
            }
            case 2: {
                string = "outer";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public SourceFile source() {
        return this.source;
    }

    @Override
    public long span() {
        return this.span;
    }

    public SourcePosition outer() {
        return this.outer;
    }

    @Override
    public SourcePosition sourcePos(Contexts.Context x$1) {
        return this;
    }

    public boolean contains(SourcePosition that) {
        SourceFile sourceFile = this.source();
        SourceFile sourceFile2 = that.source();
        return !(sourceFile != null ? !((Object)sourceFile).equals(sourceFile2) : sourceFile2 != null) && Spans$Span$.MODULE$.contains$extension(this.span(), that.span());
    }

    public boolean exists() {
        return Spans$Span$.MODULE$.exists$extension(this.span());
    }

    public String lineContent() {
        return this.source().lineContent(this.point());
    }

    public int point() {
        return Spans$Span$.MODULE$.point$extension(this.span());
    }

    public int line() {
        return this.source().length() != 0 ? this.source().offsetToLine(this.point()) : -1;
    }

    public char[] linesSlice() {
        Object object = Predef$.MODULE$.charArrayOps(this.source().content());
        return (char[])ArrayOps$.MODULE$.slice$extension(object, this.source().startOfLine(this.start()), this.source().nextLine(this.end()));
    }

    public Range lines() {
        int endOffset;
        int startOffset = this.source().offsetToLine(this.start());
        return startOffset >= (endOffset = this.source().offsetToLine(this.end() - 1)) ? RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.line()), this.line()) : RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startOffset), endOffset);
    }

    public List<Object> lineOffsets() {
        return this.lines().toList().map((Function1)(JFunction1.mcII.sp & Serializable)_$1 -> this.source().lineToOffset(_$1));
    }

    public Tuple2<List<Object>, List<Object>> beforeAndAfterPoint() {
        return this.lineOffsets().partition((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 <= this.point());
    }

    public int column() {
        return this.source().content().length != 0 ? this.source().column(this.point()) : -1;
    }

    public int start() {
        return Spans$Span$.MODULE$.start$extension(this.span());
    }

    public int startLine() {
        return this.source().content().length != 0 ? this.source().offsetToLine(this.start()) : -1;
    }

    public int startColumn() {
        return this.source().content().length != 0 ? this.source().column(this.start()) : -1;
    }

    public String startColumnPadding() {
        return this.source().startColumnPadding(this.start());
    }

    public int end() {
        return Spans$Span$.MODULE$.end$extension(this.span());
    }

    public int endLine() {
        return this.source().content().length != 0 ? this.source().offsetToLine(this.end()) : -1;
    }

    public int endColumn() {
        return this.source().content().length != 0 ? this.source().column(this.end()) : -1;
    }

    public SourcePosition withOuter(SourcePosition outer) {
        return SourcePosition$.MODULE$.apply(this.source(), this.span(), outer);
    }

    public SourcePosition withSpan(long range) {
        return SourcePosition$.MODULE$.apply(this.source(), range, this.outer());
    }

    public SourcePosition startPos() {
        return this.withSpan(Spans$Span$.MODULE$.startPos$extension(this.span()));
    }

    public SourcePosition endPos() {
        return this.withSpan(Spans$Span$.MODULE$.endPos$extension(this.span()));
    }

    public SourcePosition focus() {
        return this.withSpan(Spans$Span$.MODULE$.focus$extension(this.span()));
    }

    public SourcePosition toSynthetic() {
        return this.withSpan(Spans$Span$.MODULE$.toSynthetic$extension(this.span()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public SourcePosition outermost() {
        SourcePosition sourcePosition;
        block3: {
            block2: {
                if (this.outer() == null) break block2;
                SourcePosition sourcePosition2 = this.outer();
                NoSourcePosition$ noSourcePosition$ = NoSourcePosition$.MODULE$;
                if (sourcePosition2 != null ? !((Object)sourcePosition2).equals(noSourcePosition$) : noSourcePosition$ != null) break block3;
            }
            sourcePosition = this;
            return sourcePosition;
        }
        sourcePosition = this.outer().outermost();
        return sourcePosition;
    }

    public SourcePosition nonInlined() {
        SourcePosition om = this.outermost();
        return SourcePosition.rec$1(om, this);
    }

    public String toString() {
        return "" + (this.source().exists() ? this.source().file().toString() : "(no source)") + ":" + new Spans.Span(this.span());
    }

    @Override
    public Texts.Text toText(Printer printer) {
        return printer.toText(this);
    }

    public SourcePosition copy(SourceFile source, long span, SourcePosition outer) {
        return new SourcePosition(source, span, outer);
    }

    public SourceFile copy$default$1() {
        return this.source();
    }

    public long copy$default$2() {
        return this.span();
    }

    public SourcePosition copy$default$3() {
        return this.outer();
    }

    public SourceFile _1() {
        return this.source();
    }

    public long _2() {
        return this.span();
    }

    public SourcePosition _3() {
        return this.outer();
    }

    private static final SourcePosition rec$1(SourcePosition om$1, SourcePosition self) {
        SourcePosition sourcePosition = self;
        while (!om$1.contains(sourcePosition)) {
            sourcePosition = sourcePosition.outer();
        }
        return sourcePosition;
    }
}

