/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.runtime.function.JProcedure1;
import dotty.tools.dotc.ast.Positioned;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.tasty.TastyPickler;
import dotty.tools.dotc.core.tasty.TreePickler;
import dotty.tools.dotc.util.NoSource$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.Spans$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Null$;

public class PositionPickler {
    private final TastyPickler pickler;
    private final TreeToAddr addrOfTree;
    private final Function1<Trees.MemberDef<Null$>, List<Trees.Tree<Types.Type>>> treeAnnots;
    private final TastyBuffer buf;
    private final BitSet pickledIndices;

    public PositionPickler(TastyPickler pickler, TreeToAddr addrOfTree, Function1<Trees.MemberDef<Null$>, List<Trees.Tree<Types.Type>>> treeAnnots) {
        this.pickler = pickler;
        this.addrOfTree = addrOfTree;
        this.treeAnnots = treeAnnots;
        this.buf = new TastyBuffer(5000);
        pickler.newSection("Positions", this.buf());
        this.pickledIndices = new BitSet();
    }

    public TastyBuffer buf() {
        return this.buf;
    }

    public int header(int addrDelta, boolean hasStartDelta, boolean hasEndDelta, boolean hasPoint) {
        return addrDelta << 3 | PositionPickler.toInt$1(hasStartDelta) << 2 | PositionPickler.toInt$1(hasEndDelta) << 1 | PositionPickler.toInt$1(hasPoint);
    }

    public void picklePositions(List<Trees.Tree<Types.Type>> roots, ListBuffer<String> warnings) {
        IntRef lastIndex = IntRef.create((int)0);
        LongRef lastSpan = LongRef.create((long)Spans$.MODULE$.Span(0, 0));
        roots.foreach((Function1)(JProcedure1 & Serializable)root -> this.traverse$1(warnings, lastIndex, lastSpan, root, NoSource$.MODULE$));
    }

    private static final int toInt$1(boolean b) {
        return b ? 1 : 0;
    }

    private final BitSet pickleDeltas$1(IntRef lastIndex$1, LongRef lastSpan$1, int index, long span) {
        long l;
        int n;
        int addrDelta = index - lastIndex$1.elem;
        int startDelta = Spans$Span$.MODULE$.start$extension(span) - Spans$Span$.MODULE$.start$extension(lastSpan$1.elem);
        int endDelta = Spans$Span$.MODULE$.end$extension(span) - Spans$Span$.MODULE$.end$extension(lastSpan$1.elem);
        this.buf().writeInt(this.header(addrDelta, startDelta != 0, endDelta != 0, !Spans$Span$.MODULE$.isSynthetic$extension(span)));
        if (startDelta != 0) {
            this.buf().writeInt(startDelta);
        }
        if (endDelta != 0) {
            this.buf().writeInt(endDelta);
        }
        if (!Spans$Span$.MODULE$.isSynthetic$extension(span)) {
            this.buf().writeInt(Spans$Span$.MODULE$.pointDelta$extension(span));
        }
        lastIndex$1.elem = n = index;
        lastSpan$1.elem = l = span;
        return this.pickledIndices.addOne(index);
    }

    private final void pickleSource$1(ListBuffer warnings$1, SourceFile source) {
        Path path;
        this.buf().writeInt(4);
        String pathName = source.path();
        Path originalPath = Paths.get(pathName.toString(), new String[0]).normalize();
        if (originalPath.isAbsolute()) {
            Path path2 = originalPath.toAbsolutePath().normalize();
            Path cwd = Paths.get("", new String[0]).toAbsolutePath().normalize();
            try {
                path = cwd.relativize(path2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                warnings$1.$plus$eq((Object)("Could not relativize path for pickling: " + originalPath));
                path = originalPath;
            }
        } else {
            path = originalPath;
        }
        Path pickledPath = path;
        this.buf().writeInt(this.pickler.nameBuffer().nameIndex(Decorators$.MODULE$.extension_toTermName(pickledPath.toString())));
    }

    private static final boolean alwaysNeedsPos$1(Positioned x) {
        Positioned positioned = x;
        return positioned instanceof Trees.WithLazyField || positioned instanceof Trees.DefTree || positioned instanceof Trees.PackageDef || positioned instanceof TreePickler.Hole;
    }

    private final void traverse$1(ListBuffer warnings$2, IntRef lastIndex$2, LongRef lastSpan$2, Object x, SourceFile current) {
        Object object = x;
        while (true) {
            Object object2;
            if ((object2 = object) instanceof Trees.Tree) {
                Trees.Tree tree;
                int addr;
                Trees.Tree x2 = (Trees.Tree)object2;
                if (Spans$Span$.MODULE$.exists$extension(x2.span()) && TastyBuffer.Addr$.MODULE$.$bang$eq$extension(addr = this.addrOfTree.apply(x2), TastyBuffer$.MODULE$.NoAddr())) {
                    SourceFile sourceFile = x2.source();
                    SourceFile sourceFile2 = current;
                    if (sourceFile == null ? sourceFile2 != null : !((Object)sourceFile).equals(sourceFile2)) {
                        this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                        this.pickleSource$1(warnings$2, x2.source());
                    } else if (!this.pickledIndices.contains(addr) && (Spans$Span$.MODULE$.$bang$eq$extension(Spans$Span$.MODULE$.toSynthetic$extension(x2.span()), x2.envelope(x2.source(), x2.envelope$default$2())) || PositionPickler.alwaysNeedsPos$1(x2))) {
                        this.pickleDeltas$1(lastIndex$2, lastSpan$2, addr, x2.span());
                    }
                }
                if ((tree = x2) instanceof Trees.MemberDef) {
                    Trees.MemberDef x3 = (Trees.MemberDef)tree;
                    this.traverse$1(warnings$2, lastIndex$2, lastSpan$2, this.treeAnnots.apply((Object)x3), x3.source());
                }
                int limit = x2.productArity();
                for (int n = 0; n < limit; ++n) {
                    this.traverse$1(warnings$2, lastIndex$2, lastSpan$2, x2.productElement(n), x2.source());
                }
                break;
            }
            if (!(object2 instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)object2;
            List list = colon2.next$access$1();
            Object y = colon2.head();
            List ys = list;
            this.traverse$1(warnings$2, lastIndex$2, lastSpan$2, y, current);
            object = ys;
        }
    }

    @FunctionalInterface
    public static interface TreeToAddr {
        public int apply(Trees.Tree var1);
    }
}

