/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.decompiler;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.core.tasty.TastyPrinter$;
import dotty.tools.dotc.quoted.QuoteContextImpl$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.File$;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;

public class DecompilationPrinter
extends Phases.Phase {
    @Override
    public String phaseName() {
        return "decompilationPrinter";
    }

    @Override
    public void run(Contexts.Context x$1) {
        if (Settings$Setting$.MODULE$.extension_isDefault(x$1.settings().outputDir(), x$1)) {
            this.printToOutput(System.out, x$1);
        } else {
            AbstractFile outputDir = Settings$Setting$.MODULE$.extension_value(x$1.settings().outputDir(), x$1);
            OutputStream os = null;
            PrintStream ps = null;
            try {
                os = File$.MODULE$.apply(outputDir.fileNamed("decompiled.scala").path(), Codec$.MODULE$.UTF8()).outputStream(true);
                ps = new PrintStream(os, false, StandardCharsets.UTF_8.name());
                this.printToOutput(ps, x$1);
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private void printToOutput(PrintStream out, Contexts.Context x$2) {
        CompilationUnit unit = x$2.compilationUnit();
        if (BoxesRunTime.unboxToBoolean((Object)Settings$Setting$.MODULE$.extension_value(x$2.settings().printTasty(), x$2))) {
            Predef$.MODULE$.println((Object)TastyPrinter$.MODULE$.show((byte[])((Function0)((Tuple2)unit.pickled().head())._2()).apply(), x$2));
        } else {
            String unitFile = unit.source().toString().replace("\\", "/").replace(".class", ".tasty");
            out.println("/** Decompiled from " + unitFile + " */");
            out.println(QuoteContextImpl$.MODULE$.showTree(unit.tpdTree(), x$2));
        }
    }
}

