/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.printing.Formatting$;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.SyntaxMsg;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class MixedLeftAndRightAssociativeOps
extends SyntaxMsg {
    private final Names.Name op1;
    private final Names.Name op2;
    private final boolean op2LeftAssoc;
    private final Contexts.Context x$4;

    public MixedLeftAndRightAssociativeOps(Names.Name op1, Names.Name op2, boolean op2LeftAssoc, Contexts.Context x$4) {
        this.op1 = op1;
        this.op2 = op2;
        this.op2LeftAssoc = op2LeftAssoc;
        this.x$4 = x$4;
        super(ErrorMessageID$.MixedLeftAndRightAssociativeOpsID);
    }

    @Override
    public String msg() {
        String op1Asso = this.op2LeftAssoc ? "which is right-associative" : "which is left-associative";
        String op2Asso = this.op2LeftAssoc ? "which is left-associative" : "which is right-associative";
        return Decorators$.MODULE$.extension_em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " (", ") and ", " (", ") have same precedence and may not be mixed"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.op1, op1Asso, this.op2, op2Asso}), this.x$4);
    }

    @Override
    public String explain() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|The operators " + this.op1 + " and " + this.op2 + " are used as infix operators in the same expression,\n          |but they bind to different sides:\n          |" + this.op1 + " is applied to the operand to its " + (this.op2LeftAssoc ? "right" : "left") + "\n          |" + this.op2 + " is applied to the operand to its " + (this.op2LeftAssoc ? "left" : "right") + "\n          |As both have the same precedence the compiler can't decide which to apply first.\n          |\n          |You may use parenthesis to make the application order explicit,\n          |or use method application syntax operand1." + this.op1 + "(operand2).\n          |\n          |Operators ending in a colon " + Formatting$.MODULE$.hl(":", this.x$4) + " are right-associative. All other operators are left-associative.\n          |\n          |Infix operator precedence is determined by the operator's first character. Characters are listed\n          |below in increasing order of precedence, with characters on the same line having the same precedence.\n          |  (all letters)\n          |  |\n          |  ^\n          |  &\n          |  = !\n          |  < >\n          |  :\n          |  + -\n          |  * / %\n          |  (all other special characters)\n          |Operators starting with a letter have lowest precedence, followed by operators starting with `|`, etc.\n          |"));
    }
}

