/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.DottyPredef$;
import dotty.tools.dotc.classpath.DirectoryLookup;
import dotty.tools.dotc.classpath.FileUtils$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.PlainFile;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public interface JFileDirectoryLookup<FileEntryType extends ClassRepresentation>
extends DirectoryLookup<FileEntryType> {
    public static void $init$(JFileDirectoryLookup $this) {
        $this.$init$();
    }

    default public <FileEntryType extends ClassRepresentation> void $init$() {
        if (this.dir() == null) {
            throw DottyPredef$.MODULE$.assertFail(JFileDirectoryLookup::$init$$$anonfun$1);
        }
    }

    public static File[] emptyFiles$(JFileDirectoryLookup $this) {
        return $this.emptyFiles();
    }

    default public File[] emptyFiles() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public static Option getSubDir$(JFileDirectoryLookup $this, String packageDirName) {
        return $this.getSubDir(packageDirName);
    }

    @Override
    default public Option<File> getSubDir(String packageDirName) {
        File packageDir = new File((File)this.dir(), packageDirName);
        return packageDir.exists() && packageDir.isDirectory() ? Some$.MODULE$.apply((Object)packageDir) : None$.MODULE$;
    }

    public static File[] listChildren$(JFileDirectoryLookup $this, File dir, Option filter) {
        return $this.listChildren(dir, (Option<Function1<File, Object>>)filter);
    }

    default public File[] listChildren(File dir, Option<Function1<File, Object>> filter) {
        File[] fileArray;
        File[] fileArray2;
        Option<Function1<File, Object>> option = filter;
        if (option instanceof Some) {
            Function1 f = (Function1)((Some)option).value();
            fileArray2 = dir.listFiles(FileUtils$.MODULE$.mkFileFilter((Function1<File, Object>)f));
        } else if (None$.MODULE$.equals(option)) {
            fileArray2 = dir.listFiles();
        } else {
            throw new MatchError(option);
        }
        File[] listing = fileArray2;
        if (listing != null) {
            Arrays.sort(listing, new Comparator(){

                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            fileArray = listing;
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    public static String getName$(JFileDirectoryLookup $this, File f) {
        return $this.getName(f);
    }

    default public String getName(File f) {
        return f.getName();
    }

    public static AbstractFile toAbstractFile$(JFileDirectoryLookup $this, File f) {
        return $this.toAbstractFile(f);
    }

    default public AbstractFile toAbstractFile(File f) {
        return new PlainFile(new dotty.tools.io.File(f.toPath(), Codec$.MODULE$.fallbackSystemCodec()));
    }

    public static boolean isPackage$(JFileDirectoryLookup $this, File f) {
        return $this.isPackage(f);
    }

    default public boolean isPackage(File f) {
        return FileUtils$.MODULE$.extension_isPackage(f);
    }

    public static Seq asURLs$(JFileDirectoryLookup $this) {
        return $this.asURLs();
    }

    @Override
    default public Seq<URL> asURLs() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new URL[]{((File)this.dir()).toURI().toURL()}));
    }

    public static Seq asClassPathStrings$(JFileDirectoryLookup $this) {
        return $this.asClassPathStrings();
    }

    @Override
    default public Seq<String> asClassPathStrings() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((File)this.dir()).getPath()}));
    }

    private static String $init$$$anonfun$1() {
        return "Directory file in DirectoryFileLookup cannot be null";
    }
}

