/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.Directory$;
import scala.tools.nsc.io.Path$;
import scala.tools.partest.PartestDefaults$;
import scala.tools.partest.nest.DiffPrint;
import scala.tools.partest.nest.FileManager;
import scala.tools.partest.nest.FileManager$;
import scala.tools.partest.nest.LogFile;
import scala.tools.partest.nest.StreamAppender;

public abstract class FileManager$class {
    public static String compareFiles(FileManager $this, File f1, File f2) {
        StringWriter diffWriter = new StringWriter();
        String[] args = (String[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{f1.getCanonicalPath(), f2.getCanonicalPath()}), ClassManifest$.MODULE$.classType(String.class));
        DiffPrint.doDiff(args, diffWriter);
        String res = diffWriter.toString();
        return res.startsWith("No") ? "" : res;
    }

    public static HashMap testTimings(FileManager $this) {
        return new HashMap();
    }

    public static void recordTestTiming(FileManager $this, String name, long milliseconds) {
        synchronized ($this) {
            $this.testTimings().update((Object)name, (Object)BoxesRunTime.boxToLong((long)milliseconds));
            return;
        }
    }

    public static void showTestTimings(FileManager $this) {
        ((LinearSeqOptimized)$this.testTimings().toList().sortBy((Function1)new FileManager$.anonfun.showTestTimings.1($this), (Ordering)Ordering$Long$.MODULE$)).foreach((Function1)new FileManager$.anonfun.showTestTimings.2($this));
    }

    public static LogFile getLogFile(FileManager $this, File dir, String fileBase, String kind) {
        return new LogFile(dir, new StringBuilder().append((Object)fileBase).append((Object)"-").append((Object)kind).append((Object)".log").toString());
    }

    public static LogFile getLogFile(FileManager $this, File file, String kind) {
        File dir = file.getParentFile();
        String string = file.getName();
        String fileBase = Path$.MODULE$.apply(string).stripExtension();
        return $this.getLogFile(dir, fileBase, kind);
    }

    public static boolean logFileExists(FileManager $this, File file, String kind) {
        return $this.getLogFile(file, kind).canRead();
    }

    public static boolean overwriteFileWith(FileManager $this, File dest, File file) {
        return dest.isFile() && $this.copyFile(file, dest);
    }

    public static boolean copyFile(FileManager $this, File from, File dest) {
        boolean bl;
        if (from.isDirectory()) {
            boolean bl2 = dest.isDirectory();
            if (!bl2) {
                throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"cannot copy directory to file").toString());
            }
            Directory subDir$1 = Path$.MODULE$.apply(dest).$div(Directory$.MODULE$.apply(Path$.MODULE$.string2path(from.getName())));
            subDir$1.createDirectory(subDir$1.createDirectory$default$1(), subDir$1.createDirectory$default$2());
            Object[] objectArray = from.listFiles();
            bl = new ArrayOps.ofRef(objectArray).toList().forall((Function1)new FileManager$.anonfun.copyFile.2($this, subDir$1));
        } else {
            bl = FileManager$class.copyFile0$1($this, from, dest.isDirectory() ? new File(dest, from.getName()) : dest);
        }
        return bl;
    }

    public static void mapFile(FileManager $this, File file, String suffix, File dir, Function1 replace) {
        File tmpFile = File.createTempFile("tmp", suffix, dir);
        FileWriter fileWriter = new FileWriter(tmpFile);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StreamAppender appender = new StreamAppender(bufferedReader, new PrintWriter((Writer)fileWriter, true));
        appender.runAndMap((Function1<String, String>)replace);
        appender.closeAll();
        FileWriter fileWriter2 = new FileWriter(file);
        FileReader fileReader2 = new FileReader(tmpFile);
        BufferedReader bufferedReader2 = new BufferedReader(fileReader2);
        StreamAppender appender2 = new StreamAppender(bufferedReader2, new PrintWriter((Writer)fileWriter2, true));
        appender2.run();
        appender2.closeAll();
        tmpFile.delete();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean copyFile0$1(FileManager $this, File from, File to) {
        boolean exceptionResult1;
        try {
            void writer0;
            FileWriter fileWriter = new FileWriter(to);
            FileReader reader0 = new FileReader(from);
            BufferedReader reader2 = new BufferedReader(reader0);
            StreamAppender appender = new StreamAppender(reader2, new PrintWriter((Writer)writer0, true));
            appender.run();
            appender.closeAll();
            exceptionResult1 = true;
        }
        catch (IOException iOException) {
            exceptionResult1 = false;
        }
        return exceptionResult1;
    }

    public static void $init$(FileManager $this) {
        $this.showDiff_$eq(false);
        $this.showLog_$eq(false);
        $this.failed_$eq(false);
        $this.SCALAC_OPTS_$eq(PartestDefaults$.MODULE$.scalacOpts());
        $this.JAVA_OPTS_$eq(PartestDefaults$.MODULE$.javaOpts());
        $this.timeout_$eq(PartestDefaults$.MODULE$.timeout());
    }
}

