/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.File;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.List;
import scala.tools.partest.nest.DirectCompiler;
import scala.tools.partest.nest.FileManager;
import scala.tools.partest.nest.SimpleCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileManager
implements ScalaObject {
    private int numSeparateCompilers;
    private SimpleCompiler compiler;
    private final FileManager fileManager;

    public CompileManager(FileManager fileManager) {
        this.fileManager = fileManager;
        this.compiler = new DirectCompiler(fileManager);
        this.numSeparateCompilers = 1;
    }

    public boolean shouldFailCompile(File out, List<File> files, String kind, File log) {
        this.createSeparateCompiler();
        return !this.compiler().compile((Option<File>)new Some((Object)out), files, kind, log);
    }

    public boolean shouldFailCompile(List<File> files, String kind, File log) {
        this.createSeparateCompiler();
        return !this.compiler().compile((Option<File>)None$.MODULE$, files, kind, log);
    }

    public boolean shouldCompile(File out, List<File> files, String kind, File log) {
        this.createSeparateCompiler();
        return this.compiler().compile((Option<File>)new Some((Object)out), files, kind, log);
    }

    public boolean shouldCompile(List<File> files, String kind, File log) {
        this.createSeparateCompiler();
        return this.compiler().compile((Option<File>)None$.MODULE$, files, kind, log);
    }

    public void createSeparateCompiler() {
        this.numSeparateCompilers_$eq(this.numSeparateCompilers() + 1);
        this.compiler_$eq(new DirectCompiler(this.fileManager()));
    }

    public void numSeparateCompilers_$eq(int n) {
        this.numSeparateCompilers = n;
    }

    public int numSeparateCompilers() {
        return this.numSeparateCompilers;
    }

    public void compiler_$eq(SimpleCompiler simpleCompiler) {
        this.compiler = simpleCompiler;
    }

    public SimpleCompiler compiler() {
        return this.compiler;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }
}

