/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.File;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;
import scala.tools.partest.nest.ConsoleFileManager$;
import scala.tools.partest.nest.FileManager;
import scala.tools.partest.nest.FileManager$class;
import scala.tools.partest.nest.LogFile;
import scala.tools.partest.nest.NestUI$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFileManager
implements FileManager,
ScalaObject {
    private String timeout;
    private String JAVA_OPTS;
    private String SCALAC_OPTS;
    private boolean failed;
    private boolean showLog;
    private boolean showDiff;
    private String LIB_DIR;
    private List<File> testFiles;
    private File testClassesFile;
    private File testBuildFile;
    private File latestFjbgFile;
    private File latestPartestFile;
    private File latestCompFile;
    private File latestActFile;
    private File latestLibFile;
    private File latestFile;
    private String SCALAC_CMD;
    private String SCALA;
    private String LATEST_PARTEST;
    private String LATEST_COMP;
    private String LATEST_LIB;
    private String BIN_DIR;
    private final File srcDir;
    private String srcDirName;
    private final String TESTROOT;
    private final File testRootFile;
    private final String PREFIX;
    private final File prefixFile;
    private String JAVAC_CMD;
    private String JAVACMD;
    private String CLASSPATH;
    private final boolean debug;
    private Option<String> testClasses;
    private String testBuild;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConsoleFileManager() {
        File src;
        File file;
        File file2;
        FileManager$class.$init$(this);
        this.testBuild = System.getProperty("scalatest.build");
        this.testClasses = None$.MODULE$;
        this.debug = System.getProperty("partest.debug", "false").equals("true") || System.getProperty("scalatest.debug", "false").equals("true");
        this.CLASSPATH = System.getProperty("java.class.path", ".");
        NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"CLASSPATH: ").append((Object)this.CLASSPATH()).toString());
        this.JAVACMD = System.getProperty("scalatest.javacmd", "java");
        this.JAVAC_CMD = System.getProperty("scalatest.javac_cmd", "javac");
        String cwd = System.getProperty("user.dir");
        if (cwd == null || cwd.equals(null)) {
            throw Predef$.MODULE$.error("user.dir property not set");
        }
        this.prefixFile = new File(cwd).getCanonicalFile();
        this.PREFIX = this.prefixFile().getAbsolutePath();
        String testRootProp = System.getProperty("scalatest.root");
        if (testRootProp == null || testRootProp.equals(null)) {
            String string = this.prefixFile().getName();
            String string2 = "test";
            if (!(string != null ? !string.equals(string2) : string2 != null) && new File(this.prefixFile(), "files").exists()) {
                file2 = this.prefixFile();
            } else {
                File test = new File(this.prefixFile(), "test");
                File scalaTest = new File(new File(this.prefixFile(), "misc"), "scala-test");
                if (test.isDirectory()) {
                    file2 = test;
                } else {
                    if (!scalaTest.isDirectory()) throw Predef$.MODULE$.error("Test directory not found");
                    file2 = scalaTest;
                }
            }
        } else {
            file2 = new File(testRootProp);
        }
        File testroot = file2;
        this.testRootFile = testroot.getCanonicalFile();
        this.TESTROOT = this.testRootFile().getAbsolutePath();
        this.srcDirName = "";
        String srcDirProp = System.getProperty("partest.srcdir");
        if (srcDirProp == null || srcDirProp.equals(null)) {
            this.srcDirName_$eq("files");
            file = new File(this.testRootFile(), this.srcDirName());
        } else {
            this.srcDirName_$eq(srcDirProp);
            file = src = new File(this.testRootFile(), this.srcDirName());
        }
        if (src.isDirectory()) {
            this.srcDir = src.getCanonicalFile();
            this.LIB_DIR_$eq(new File(this.testRootFile().getParentFile(), "lib").getCanonicalFile().getAbsolutePath());
            File libs = new File(this.srcDir(), "lib");
            this.CLASSPATH_$eq(new StringBuilder().append((Object)this.CLASSPATH()).append((Object)File.pathSeparator).append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])libs.listFiles(new $anon$1(this))).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).mkString(new StringBuilder().append((Object)"").append((Object)File.pathSeparator).toString())).toString());
            this.BIN_DIR = "";
            this.LATEST_LIB = "";
            this.LATEST_COMP = "";
            this.LATEST_PARTEST = "";
            this.SCALA = "";
            this.SCALAC_CMD = "";
            this.findLatest();
            this.testFiles = Nil$.MODULE$;
            return;
        }
        String path = new StringBuilder().append((Object)this.TESTROOT()).append((Object)File.separator).append((Object)"files").toString();
        NestUI$.MODULE$.failure(new StringBuilder().append((Object)"Source directory \"").append((Object)path).append((Object)"\" not found").toString());
        throw Predef$.MODULE$.exit(1);
    }

    private final long max$1(long a, long b) {
        return a > b ? a : b;
    }

    private final void setupPack$1(File file) {
        NestUI$.MODULE$.verbose("Running build/pack");
        this.latestFile_$eq(this.prefixFile$1("build/pack/bin", file));
        this.latestLibFile_$eq(this.prefixFile$1("build/pack/lib/scala-library.jar", file));
        this.latestActFile_$eq(this.prefixFile$1("build/pack/lib/scala-library.jar", file));
        this.latestCompFile_$eq(this.prefixFile$1("build/pack/lib/scala-compiler.jar", file));
        this.latestPartestFile_$eq(this.prefixFile$1("build/pack/lib/scala-partest.jar", file));
    }

    private final void setupDist$1(File file) {
        NestUI$.MODULE$.verbose("Running dists/latest");
        this.latestFile_$eq(this.prefixFile$1("dists/latest/bin", file));
        this.latestLibFile_$eq(this.prefixFile$1("dists/latest/lib/scala-library.jar", file));
        this.latestActFile_$eq(this.prefixFile$1("dists/latest/lib/scala-library.jar", file));
        this.latestCompFile_$eq(this.prefixFile$1("dists/latest/lib/scala-compiler.jar", file));
        this.latestPartestFile_$eq(this.prefixFile$1("dists/latest/lib/scala-partest.jar", file));
    }

    private final void setupInst$1(File file) {
        NestUI$.MODULE$.verbose("Running dist (installed)");
        File p = file.getParentFile();
        this.latestFile_$eq(this.prefixFileWith$1(p, "bin"));
        this.latestLibFile_$eq(this.prefixFileWith$1(p, "lib/scala-library.jar"));
        this.latestActFile_$eq(this.prefixFileWith$1(p, "lib/scala-library.jar"));
        this.latestCompFile_$eq(this.prefixFileWith$1(p, "lib/scala-compiler.jar"));
        this.latestPartestFile_$eq(this.prefixFileWith$1(p, "lib/scala-partest.jar"));
    }

    private final void setupQuick$1(File file) {
        NestUI$.MODULE$.verbose("Running build/quick");
        this.latestFile_$eq(this.prefixFile$1("build/quick/bin", file));
        this.latestLibFile_$eq(this.prefixFile$1("build/quick/classes/library", file));
        this.latestActFile_$eq(this.prefixFile$1("build/quick/classes/library", file));
        this.latestCompFile_$eq(this.prefixFile$1("build/quick/classes/compiler", file));
        this.latestPartestFile_$eq(this.prefixFile$1("build/quick/classes/partest", file));
    }

    private final File prefixFile$1(String relPath, File file) {
        return this.prefixFileWith$1(file, relPath);
    }

    private final File prefixFileWith$1(File parent, String relPath) {
        return new File(parent, relPath).getCanonicalFile();
    }

    public List<File> getFiles(String kind, boolean doCheck) {
        boolean bl = true;
        return this.getFiles(kind, doCheck, (Option<Tuple2<String, Boolean>>)new Some((Object)new Tuple2((Object)".scala", (Object)BoxesRunTime.boxToBoolean((boolean)bl))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<File> getFiles(String kind$1, boolean doCheck, Option<Tuple2<String, Boolean>> filter) {
        Nil$ nil$;
        File dir = new File(this.srcDir(), kind$1);
        NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"look in ").append((Object)dir).append((Object)" for tests").toString());
        if (dir.isDirectory()) {
            if (this.testFiles().isEmpty()) {
                if (doCheck) {
                    if (filter instanceof Some) {
                        Some temp2 = (Some)filter;
                        Tuple2 temp3 = (Tuple2)temp2.x();
                        if (temp3 == null) throw new MatchError(filter.toString());
                        String temp4 = (String)temp3._1();
                        boolean temp5 = BoxesRunTime.unboxToBoolean((Object)temp3._2());
                        if (!true) throw new MatchError(filter.toString());
                        $anon$2 filter2 = new $anon$2(this, temp4, temp5);
                        Object[] objectArray = dir.listFiles(filter2);
                        nil$ = new ArrayOps.ofRef(objectArray).toList();
                    } else {
                        None$ none$ = None$.MODULE$;
                        if (none$ != null ? !none$.equals(filter) : filter != null) throw new MatchError(filter.toString());
                        if (!true) throw new MatchError(filter.toString());
                        $anon$3 filter3 = new $anon$3(this);
                        Object[] objectArray = dir.listFiles(filter3);
                        nil$ = new ArrayOps.ofRef(objectArray).toList();
                    }
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                String dirpath$1 = dir.getAbsolutePath();
                nil$ = (List)this.testFiles().filter((Function1)new $anonfun$2(this, dirpath$1));
            }
        } else {
            NestUI$.MODULE$.failure(new StringBuilder().append((Object)"Directory \"").append((Object)dir.getPath()).append((Object)"\" not found").toString());
            nil$ = Nil$.MODULE$;
        }
        Nil$ files = nil$;
        return this.failed() ? (List)files.filter((Function1)new $anonfun$getFiles$1(this, kind$1)) : files;
    }

    public void testFiles_$eq(List<File> list) {
        this.testFiles = list;
    }

    public List<File> testFiles() {
        return this.testFiles;
    }

    public void testClassesFile_$eq(File file) {
        this.testClassesFile = file;
    }

    public File testClassesFile() {
        return this.testClassesFile;
    }

    public void testBuildFile_$eq(File file) {
        this.testBuildFile = file;
    }

    public File testBuildFile() {
        return this.testBuildFile;
    }

    public void latestFjbgFile_$eq(File file) {
        this.latestFjbgFile = file;
    }

    public File latestFjbgFile() {
        return this.latestFjbgFile;
    }

    public void latestPartestFile_$eq(File file) {
        this.latestPartestFile = file;
    }

    public File latestPartestFile() {
        return this.latestPartestFile;
    }

    public void latestCompFile_$eq(File file) {
        this.latestCompFile = file;
    }

    public File latestCompFile() {
        return this.latestCompFile;
    }

    public void latestActFile_$eq(File file) {
        this.latestActFile = file;
    }

    public File latestActFile() {
        return this.latestActFile;
    }

    public void latestLibFile_$eq(File file) {
        this.latestLibFile = file;
    }

    public File latestLibFile() {
        return this.latestLibFile;
    }

    public void latestFile_$eq(File file) {
        this.latestFile = file;
    }

    public File latestFile() {
        return this.latestFile;
    }

    public void SCALAC_CMD_$eq(String string) {
        this.SCALAC_CMD = string;
    }

    public String SCALAC_CMD() {
        return this.SCALAC_CMD;
    }

    public void SCALA_$eq(String string) {
        this.SCALA = string;
    }

    public String SCALA() {
        return this.SCALA;
    }

    public void LATEST_PARTEST_$eq(String string) {
        this.LATEST_PARTEST = string;
    }

    public String LATEST_PARTEST() {
        return this.LATEST_PARTEST;
    }

    public void LATEST_COMP_$eq(String string) {
        this.LATEST_COMP = string;
    }

    public String LATEST_COMP() {
        return this.LATEST_COMP;
    }

    @Override
    public void LATEST_LIB_$eq(String string) {
        this.LATEST_LIB = string;
    }

    @Override
    public String LATEST_LIB() {
        return this.LATEST_LIB;
    }

    public void BIN_DIR_$eq(String string) {
        this.BIN_DIR = string;
    }

    public String BIN_DIR() {
        return this.BIN_DIR;
    }

    public void findLatest() {
        File testParent$1 = this.testRootFile().getParentFile();
        NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"test parent: ").append((Object)testParent$1).toString());
        if (this.testClasses().isEmpty()) {
            String string = this.testBuild();
            if (string == null || string.equals(null)) {
                new File(testParent$1, "dists");
                new File(testParent$1, "build");
                new File(testParent$1.getParentFile(), "bin");
                long quickTime = this.max$1(this.prefixFile$1("build/quick/classes/compiler/compiler.properties", testParent$1).lastModified(), this.prefixFile$1("build/quick/classes/library/library.properties", testParent$1).lastModified());
                long packTime = this.max$1(this.prefixFile$1("build/pack/lib/scala-compiler.jar", testParent$1).lastModified(), this.prefixFile$1("build/pack/lib/scala-library.jar", testParent$1).lastModified());
                long distTime = this.max$1(this.prefixFile$1("dists/latest/lib/scala-compiler.jar", testParent$1).lastModified(), this.prefixFile$1("dists/latest/lib/scala-library.jar", testParent$1).lastModified());
                File p = testParent$1.getParentFile();
                long instTime = this.max$1(this.prefixFileWith$1(p, "lib/scala-compiler.jar").lastModified(), this.prefixFileWith$1(p, "lib/scala-library.jar").lastModified());
                if (quickTime > packTime) {
                    if (quickTime > distTime) {
                        if (quickTime > instTime) {
                            this.setupQuick$1(testParent$1);
                        } else {
                            this.setupInst$1(testParent$1);
                        }
                    } else if (distTime > instTime) {
                        this.setupDist$1(testParent$1);
                    } else {
                        this.setupInst$1(testParent$1);
                    }
                } else if (packTime > distTime) {
                    if (packTime > instTime) {
                        this.setupPack$1(testParent$1);
                    } else {
                        this.setupInst$1(testParent$1);
                    }
                } else if (distTime > instTime) {
                    this.setupDist$1(testParent$1);
                } else {
                    this.setupInst$1(testParent$1);
                }
                this.latestFjbgFile_$eq(this.prefixFile$1("lib/fjbg.jar", testParent$1));
            } else {
                this.testBuildFile_$eq(this.prefixFile$1(this.testBuild(), testParent$1));
                NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"Running on ").append((Object)this.testBuild()).toString());
                this.latestFile_$eq(this.prefixFile$1(new StringBuilder().append((Object)this.testBuild()).append((Object)"/bin").toString(), testParent$1));
                this.latestLibFile_$eq(this.prefixFile$1(new StringBuilder().append((Object)this.testBuild()).append((Object)"/lib/scala-library.jar").toString(), testParent$1));
                this.latestActFile_$eq(this.prefixFile$1(new StringBuilder().append((Object)this.testBuild()).append((Object)"/lib/scala-library.jar").toString(), testParent$1));
                this.latestCompFile_$eq(this.prefixFile$1(new StringBuilder().append((Object)this.testBuild()).append((Object)"/lib/scala-compiler.jar").toString(), testParent$1));
                this.latestPartestFile_$eq(this.prefixFile$1(new StringBuilder().append((Object)this.testBuild()).append((Object)"/lib/scala-partest.jar").toString(), testParent$1));
            }
        } else {
            this.testClassesFile_$eq(new File((String)this.testClasses().get()).getCanonicalFile());
            NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"Running with classes in ").append((Object)this.testClassesFile()).toString());
            this.latestFile_$eq(this.prefixFileWith$1(this.testClassesFile().getParentFile(), "bin"));
            this.latestLibFile_$eq(this.prefixFileWith$1(this.testClassesFile(), "library"));
            this.latestActFile_$eq(this.prefixFileWith$1(this.testClassesFile(), "library"));
            this.latestCompFile_$eq(this.prefixFileWith$1(this.testClassesFile(), "compiler"));
            this.latestPartestFile_$eq(this.prefixFileWith$1(this.testClassesFile(), "partest"));
            this.latestFjbgFile_$eq(this.prefixFile$1("lib/fjbg.jar", testParent$1));
        }
        this.BIN_DIR_$eq(this.latestFile().getAbsolutePath());
        this.LATEST_LIB_$eq(this.latestLibFile().getAbsolutePath());
        this.LATEST_COMP_$eq(this.latestCompFile().getAbsolutePath());
        this.LATEST_PARTEST_$eq(this.latestPartestFile().getAbsolutePath());
        String osName = System.getProperty("os.name");
        NestUI$.MODULE$.verbose(new StringBuilder().append((Object)"OS: ").append((Object)osName).toString());
        String scalaCommand = osName.startsWith("Windows") ? "scala.bat" : "scala";
        String scalacCommand = osName.startsWith("Windows") ? "scalac.bat" : "scalac";
        this.SCALA_$eq(new File(this.latestFile(), scalaCommand).getAbsolutePath());
        this.SCALAC_CMD_$eq(new File(this.latestFile(), scalacCommand).getAbsolutePath());
    }

    public File srcDir() {
        return this.srcDir;
    }

    public void srcDirName_$eq(String string) {
        this.srcDirName = string;
    }

    public String srcDirName() {
        return this.srcDirName;
    }

    @Override
    public String TESTROOT() {
        return this.TESTROOT;
    }

    public File testRootFile() {
        return this.testRootFile;
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public File prefixFile() {
        return this.prefixFile;
    }

    @Override
    public void JAVAC_CMD_$eq(String string) {
        this.JAVAC_CMD = string;
    }

    @Override
    public String JAVAC_CMD() {
        return this.JAVAC_CMD;
    }

    @Override
    public void JAVACMD_$eq(String string) {
        this.JAVACMD = string;
    }

    @Override
    public String JAVACMD() {
        return this.JAVACMD;
    }

    @Override
    public void CLASSPATH_$eq(String string) {
        this.CLASSPATH = string;
    }

    @Override
    public String CLASSPATH() {
        return this.CLASSPATH;
    }

    public ConsoleFileManager(String buildPath, boolean rawClasses, String moreOpts) {
        this(buildPath, rawClasses);
        this.SCALAC_OPTS_$eq(new StringBuilder().append((Object)this.SCALAC_OPTS()).append((Object)" ").append((Object)moreOpts).toString());
    }

    public ConsoleFileManager(String buildPath) {
        this(buildPath, false);
    }

    public ConsoleFileManager(String buildPath, boolean rawClasses) {
        this();
        if (rawClasses) {
            this.testClasses_$eq((Option<String>)new Some((Object)buildPath));
        } else {
            this.testBuild_$eq(buildPath);
        }
        this.findLatest();
    }

    public boolean debug() {
        return this.debug;
    }

    public void testClasses_$eq(Option<String> option) {
        this.testClasses = option;
    }

    public Option<String> testClasses() {
        return this.testClasses;
    }

    public void testBuild_$eq(String string) {
        this.testBuild = string;
    }

    public String testBuild() {
        return this.testBuild;
    }

    @Override
    public boolean logFileExists(File file, String kind) {
        return FileManager$class.logFileExists(this, file, kind);
    }

    @Override
    public LogFile getLogFile(File file, String kind) {
        return FileManager$class.getLogFile(this, file, kind);
    }

    @Override
    public LogFile getLogFile(File dir, String fileBase, String kind) {
        return FileManager$class.getLogFile(this, dir, fileBase, kind);
    }

    @Override
    public String compareFiles(File f1, File f2) {
        return FileManager$class.compareFiles(this, f1, f2);
    }

    @Override
    public void deleteRecursive(File dir) {
        FileManager$class.deleteRecursive(this, dir);
    }

    @Override
    public String basename(String name) {
        return FileManager$class.basename(this, name);
    }

    @Override
    public void timeout_$eq(String string) {
        this.timeout = string;
    }

    @Override
    public String timeout() {
        return this.timeout;
    }

    @Override
    public void JAVA_OPTS_$eq(String string) {
        this.JAVA_OPTS = string;
    }

    @Override
    public String JAVA_OPTS() {
        return this.JAVA_OPTS;
    }

    @Override
    public void SCALAC_OPTS_$eq(String string) {
        this.SCALAC_OPTS = string;
    }

    @Override
    public String SCALAC_OPTS() {
        return this.SCALAC_OPTS;
    }

    @Override
    public void failed_$eq(boolean bl) {
        this.failed = bl;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public void showLog_$eq(boolean bl) {
        this.showLog = bl;
    }

    @Override
    public boolean showLog() {
        return this.showLog;
    }

    @Override
    public void showDiff_$eq(boolean bl) {
        this.showDiff = bl;
    }

    @Override
    public boolean showDiff() {
        return this.showDiff;
    }

    @Override
    public void LIB_DIR_$eq(String string) {
        this.LIB_DIR = string;
    }

    @Override
    public String LIB_DIR() {
        return this.LIB_DIR;
    }
}

