/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Settings;
import scala.tools.partest.nest.FileManager;

public class TestFile
implements ScalaObject {
    private final String fileBase;
    private final String dirpath;
    private final File dir;
    private final boolean createOutDir;
    private final FileManager fileManager;
    private final File file;
    private final String kind;

    public TestFile(String kind, File file, FileManager fileManager, boolean createOutDir) {
        this.kind = kind;
        this.file = file;
        this.fileManager = fileManager;
        this.createOutDir = createOutDir;
        this.dir = file.getParentFile();
        this.dirpath = this.dir().getAbsolutePath();
        this.fileBase = this.basename(file.getName());
    }

    public String toString() {
        return new StringBuilder().append((Object)this.kind).append((Object)" ").append((Object)this.file()).toString();
    }

    private String basename(String name) {
        int inx = name.lastIndexOf(".");
        return inx < 0 ? name : name.substring(0, inx);
    }

    public void defineSettings(Settings settings) {
        this.baseSettings(settings);
    }

    public void baseSettings(Settings settings) {
        BufferedReader reader;
        String flags;
        File flagsFile;
        settings.classpath().value_$eq((Object)new StringBuilder().append((Object)((String)settings.classpath().value())).append((Object)File.pathSeparator).append((Object)this.dirpath()).toString());
        if (this.createOutDir) {
            File outDir = new File(this.dir(), new StringBuilder().append((Object)this.fileBase()).append((Object)"-").append((Object)this.kind).append((Object)".obj").toString());
            Object object = outDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)outDir.mkdir());
            settings.outdir().value_$eq(outDir.toString());
        }
        if ((flagsFile = new File(this.dir(), new StringBuilder().append((Object)this.fileBase()).append((Object)".flags").toString())).exists() && (flags = (reader = new BufferedReader(new FileReader(flagsFile))).readLine()) != null) {
            settings.parseParams(flags);
        }
    }

    public String fileBase() {
        return this.fileBase;
    }

    public String dirpath() {
        return this.dirpath;
    }

    public File dir() {
        return this.dir;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public File file() {
        return this.file;
    }
}

