/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.instrumented;

import java.util.HashMap;
import java.util.Map;

public class Profiler {
    private static boolean isProfiling = false;
    private static Map<MethodCallTrace, Integer> counts = new HashMap<MethodCallTrace, Integer>();

    public static void startProfiling() {
        isProfiling = true;
    }

    public static void stopProfiling() {
        isProfiling = false;
    }

    public static boolean isProfiling() {
        return isProfiling;
    }

    public static void resetProfiling() {
        counts = new HashMap<MethodCallTrace, Integer>();
    }

    public static void methodCalled(String className, String methodName, String methodDescriptor) {
        if (isProfiling) {
            MethodCallTrace trace = new MethodCallTrace(className, methodName, methodDescriptor);
            Integer counter = counts.get(trace);
            if (counter == null) {
                counts.put(trace, 1);
            } else {
                counts.put(trace, counter + 1);
            }
        }
    }

    public static Map<MethodCallTrace, Integer> getStatistics() {
        return new HashMap<MethodCallTrace, Integer>(counts);
    }

    public static class MethodCallTrace {
        final String className;
        final String methodName;
        final String methodDescriptor;

        public MethodCallTrace(String className, String methodName, String methodDescriptor) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodCallTrace)) {
                return false;
            }
            MethodCallTrace that = (MethodCallTrace)obj;
            return that.className.equals(this.className) && that.methodName.equals(this.methodName) && that.methodDescriptor.equals(this.methodDescriptor);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.methodName.hashCode() ^ this.methodDescriptor.hashCode();
        }
    }
}

