/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ImmutableBuilder;
import scala.math.Integral;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class Iterator$
implements IterableFactory<Iterator> {
    private static final long serialVersionUID = 3L;
    private static final Iterator<Nothing$> _empty;
    public static final Iterator$ MODULE$;

    private Iterator$() {
    }

    static {
        MODULE$ = new Iterator$();
        IterableFactory.$init$(MODULE$);
        _empty = new AbstractIterator<Nothing$>(){

            public boolean hasNext() {
                return false;
            }

            public Nothing$ next() {
                throw new NoSuchElementException("next on empty iterator");
            }

            public int knownSize() {
                return 0;
            }

            public AbstractIterator sliceIterator(int from, int until) {
                return this;
            }
        };
    }

    @Override
    public Object iterate(Object start, int len, Function1 f) {
        return IterableFactory.iterate$(this, start, len, f);
    }

    @Override
    public Object range(Object start, Object end, Integral evidence$1) {
        return IterableFactory.range$(this, start, end, evidence$1);
    }

    @Override
    public Object range(Object start, Object end, Object step, Integral evidence$1) {
        return IterableFactory.range$(this, start, end, step, evidence$1);
    }

    @Override
    public Object fill(int n1, int n2, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, int n5, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, n5, elem);
    }

    @Override
    public Object tabulate(int n1, int n2, Function2 f) {
        return IterableFactory.tabulate$(this, n1, n2, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, Function3 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, Function4 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, int n5, Function5 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, n5, f);
    }

    @Override
    public Object concat(Seq xss) {
        return IterableFactory.concat$(this, xss);
    }

    @Override
    public <A> Factory<A, Iterator<A>> iterableFactory() {
        return IterableFactory.iterableFactory$(this);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Iterator$.class);
    }

    @Override
    public <A> Iterator<A> from(IterableOnce<A> source) {
        return source.iterator();
    }

    @Override
    public final <T> Iterator<T> empty() {
        return _empty;
    }

    public <A> Iterator<A> single(A a) {
        return new AbstractIterator<A>(a){
            private final Object a$1;
            private boolean consumed;
            {
                this.a$1 = a$2;
                this.consumed = false;
            }

            public boolean hasNext() {
                return !this.consumed;
            }

            public Object next() {
                if (this.consumed) {
                    return Iterator$.MODULE$.empty().next();
                }
                this.consumed = true;
                return this.a$1;
            }

            public Iterator sliceIterator(int from, int until) {
                if (this.consumed || from > 0 || until == 0) {
                    return Iterator$.MODULE$.empty();
                }
                return this;
            }
        };
    }

    @Override
    public <A> Iterator<A> apply(Seq<A> xs) {
        return xs.iterator();
    }

    @Override
    public <A> Builder<A, Iterator<A>> newBuilder() {
        return new ImmutableBuilder<A, Iterator<A>>(){

            public anon.21 addOne(Object elem) {
                this.elems_$eq(((Iterator)this.elems()).$plus$plus(() -> Iterator$.scala$collection$Iterator$$anon$21$$_$addOne$$anonfun$1(elem)));
                return this;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$collection$Iterator$$anon$21$$_$addOne$$anonfun$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    @Override
    public <A> Iterator<A> fill(int len, Function0<A> elem) {
        return new AbstractIterator<A>(len, elem){
            private final int len$2;
            private final Function0 elem$4;
            private int i;
            {
                this.len$2 = len$4;
                this.elem$4 = elem$7;
                this.i = 0;
            }

            public int knownSize() {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.len$2 - this.i), 0);
            }

            public boolean hasNext() {
                return this.i < this.len$2;
            }

            public Object next() {
                if (this.hasNext()) {
                    ++this.i;
                    return this.elem$4.apply();
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    @Override
    public <A> Iterator<A> tabulate(int end, Function1<Object, A> f) {
        return new AbstractIterator<A>(end, f){
            private final int end$1;
            private final Function1 f$5;
            private int i;
            {
                this.end$1 = end$4;
                this.f$5 = f$12;
                this.i = 0;
            }

            public int knownSize() {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.end$1 - this.i), 0);
            }

            public boolean hasNext() {
                return this.i < this.end$1;
            }

            public Object next() {
                if (this.hasNext()) {
                    R result = this.f$5.apply(BoxesRunTime.boxToInteger(this.i));
                    ++this.i;
                    return result;
                }
                return Iterator$.MODULE$.empty().next();
            }
        };
    }

    public Iterator<Object> from(int start) {
        return this.from(start, 1);
    }

    public Iterator<Object> from(int start, int step) {
        return new AbstractIterator<Object>(start, step){
            private final int step$3;
            private int i;
            {
                this.step$3 = step$2;
                this.i = start$1;
            }

            public boolean hasNext() {
                return true;
            }

            public int next() {
                int result = this.i;
                this.i += this.step$3;
                return result;
            }
        };
    }

    public Iterator<Object> range(int start, int end) {
        return this.range(start, end, 1);
    }

    public Iterator<Object> range(int start, int end, int step) {
        return new AbstractIterator<Object>(step, start, end){
            private final int end$3;
            private final int step$5;
            private int i;
            private boolean hasOverflowed;
            {
                this.end$3 = end$2;
                this.step$5 = step$4;
                if (step$4 == 0) {
                    throw new IllegalArgumentException("zero step");
                }
                this.i = start$2;
                this.hasOverflowed = false;
            }

            public int knownSize() {
                double size = package$.MODULE$.ceil((double)((long)this.end$3 - (long)this.i) / (double)this.step$5);
                if (size < 0.0) {
                    return 0;
                }
                if (size > (double)Integer.MAX_VALUE) {
                    return -1;
                }
                return (int)size;
            }

            public boolean hasNext() {
                return !(this.step$5 > 0 && this.i >= this.end$3 || this.step$5 < 0 && this.i <= this.end$3 || this.hasOverflowed);
            }

            public int next() {
                if (this.hasNext()) {
                    int result = this.i;
                    int nextValue = this.i + this.step$5;
                    this.hasOverflowed = this.step$5 > 0 == nextValue < this.i;
                    this.i = nextValue;
                    return result;
                }
                return BoxesRunTime.unboxToInt(Iterator$.MODULE$.empty().next());
            }
        };
    }

    public <T> Iterator<T> iterate(T start, Function1<T, T> f) {
        return new AbstractIterator<T>(start, f){
            private final Function1 f$7;
            private boolean first;
            private Object acc;
            {
                this.f$7 = f$6;
                this.first = true;
                this.acc = start$3;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.acc = this.f$7.apply(this.acc);
                }
                return this.acc;
            }
        };
    }

    @Override
    public <A, S> Iterator<A> unfold(S init2, Function1<S, Option<Tuple2<A, S>>> f) {
        return new Iterator.UnfoldIterator<A, S>(init2, f);
    }

    public <A> Iterator<A> continually(Function0<A> elem) {
        return new AbstractIterator<A>(elem){
            private final Function0 elem$5;
            {
                this.elem$5 = elem$8;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                return this.elem$5.apply();
            }
        };
    }

    public static final IterableOnce scala$collection$Iterator$$anon$21$$_$addOne$$anonfun$1(Object elem$3) {
        return MODULE$.single(elem$3);
    }
}

