/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.LazyZip2;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.convert.impl.BoxedBooleanArrayStepper;
import scala.collection.convert.impl.DoubleArrayStepper;
import scala.collection.convert.impl.IndexedStepperBase;
import scala.collection.convert.impl.IntArrayStepper;
import scala.collection.convert.impl.LongArrayStepper;
import scala.collection.convert.impl.ObjectArrayStepper;
import scala.collection.convert.impl.WidenedByteArrayStepper;
import scala.collection.convert.impl.WidenedCharArrayStepper;
import scala.collection.convert.impl.WidenedFloatArrayStepper;
import scala.collection.convert.impl.WidenedShortArrayStepper;
import scala.collection.generic.CommonErrors$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Boolean$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Sorting$;

public final class ArrayOps$
implements Serializable {
    private static final Function1<Object, Object> fallback;
    public static final ArrayOps$ MODULE$;

    private ArrayOps$() {
    }

    static {
        MODULE$ = new ArrayOps$();
        int MaxStableSortLength = 300;
        fallback = (Function1<Object, Object> & Serializable)_$1 -> fallback;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayOps$.class);
    }

    public final <A> int hashCode$extension(Object $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Object $this, Object x$0) {
        Object object = x$0;
        if (object instanceof ArrayOps) {
            Object object2;
            Object object3 = object2 = object == null ? null : ((ArrayOps)object).scala$collection$ArrayOps$$xs();
            return BoxesRunTime.equals($this, object3);
        }
        return false;
    }

    public final <A> ClassTag<A> scala$collection$ArrayOps$$$elemTag$extension(Object $this) {
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType());
    }

    public final <A> int size$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> int knownSize$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) == 0;
    }

    public final <A> boolean nonEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) != 0;
    }

    public final <A> A head$extension(Object $this) {
        if (this.nonEmpty$extension($this)) {
            return (A)ScalaRunTime$.MODULE$.array_apply($this, 0);
        }
        throw new NoSuchElementException("head of empty array");
    }

    public final <A> A last$extension(Object $this) {
        if (this.nonEmpty$extension($this)) {
            return (A)ScalaRunTime$.MODULE$.array_apply($this, ScalaRunTime$.MODULE$.array_length($this) - 1);
        }
        throw new NoSuchElementException("last of empty array");
    }

    public final <A> Option<A> headOption$extension(Object $this) {
        if (this.isEmpty$extension($this)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.head$extension($this));
    }

    public final <A> Option<A> lastOption$extension(Object $this) {
        if (this.isEmpty$extension($this)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.last$extension($this));
    }

    public final <A> int sizeCompare$extension(Object $this, int otherSize) {
        return Integer.compare(ScalaRunTime$.MODULE$.array_length($this), otherSize);
    }

    public final <A> int lengthCompare$extension(Object $this, int len) {
        return Integer.compare(ScalaRunTime$.MODULE$.array_length($this), len);
    }

    public final <A> int sizeIs$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> int lengthIs$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        int lo = Math.max(from, 0);
        int hi = Math.min(until, ScalaRunTime$.MODULE$.array_length($this));
        if (hi > lo) {
            Object object = $this;
            if (object instanceof Object[]) {
                Object[] objectArray;
                Object[] x = objectArray = (Object[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof int[]) {
                int[] nArray;
                int[] x = nArray = (int[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof double[]) {
                double[] dArray;
                double[] x = dArray = (double[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof long[]) {
                long[] lArray;
                long[] x = lArray = (long[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof float[]) {
                float[] fArray;
                float[] x = fArray = (float[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof char[]) {
                char[] cArray;
                char[] x = cArray = (char[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof byte[]) {
                byte[] byArray;
                byte[] x = byArray = (byte[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof short[]) {
                short[] sArray;
                short[] x = sArray = (short[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            if (object instanceof boolean[]) {
                boolean[] blArray;
                boolean[] x = blArray = (boolean[])object;
                return Arrays.copyOfRange(x, lo, hi);
            }
            throw new MatchError(object);
        }
        return Arrays$.MODULE$.newGenericArray(0, this.scala$collection$ArrayOps$$$elemTag$extension($this));
    }

    public final <A> Object tail$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("tail of empty array");
        }
        return this.slice$extension($this, 1, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object init$extension(Object $this) {
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            throw new UnsupportedOperationException("init of empty array");
        }
        return this.slice$extension($this, 0, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Iterator<Object> tails$extension(Object $this) {
        return this.scala$collection$ArrayOps$$$iterateUntilEmpty$extension($this, (Function1<Object, Object> & Serializable)xs -> MODULE$.tail$extension(xs));
    }

    public final <A> Iterator<Object> inits$extension(Object $this) {
        return this.scala$collection$ArrayOps$$$iterateUntilEmpty$extension($this, (Function1<Object, Object> & Serializable)xs -> MODULE$.init$extension(xs));
    }

    public final <A> Iterator<Object> scala$collection$ArrayOps$$$iterateUntilEmpty$extension(Object $this, Function1<Object, Object> f) {
        return Iterator$.MODULE$.iterate($this, f).takeWhile((Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)x -> ScalaRunTime$.MODULE$.array_length(x) != 0).$plus$plus(() -> ArrayOps$.iterateUntilEmpty$extension$$anonfun$2($this));
    }

    public final <A> Object take$extension(Object $this, int n) {
        return this.slice$extension($this, 0, n);
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, n, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object takeRight$extension(Object $this, int n) {
        return this.drop$extension($this, ScalaRunTime$.MODULE$.array_length($this) - Math.max(n, 0));
    }

    public final <A> Object dropRight$extension(Object $this, int n) {
        return this.take$extension($this, ScalaRunTime$.MODULE$.array_length($this) - Math.max(n, 0));
    }

    public final <A> Object takeWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Boolean> & Serializable)x -> !BoxesRunTime.unboxToBoolean(p.apply(x)), this.indexWhere$default$2$extension($this));
        int hi = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, 0, hi);
    }

    public final <A> Object dropWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Boolean> & Serializable)x -> !BoxesRunTime.unboxToBoolean(p.apply(x)), this.indexWhere$default$2$extension($this));
        int lo = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, lo, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Iterator<A> iterator$extension(Object $this) {
        Object object = $this;
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] xs = dArray = (double[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof float[]) {
            float[] fArray;
            float[] xs = fArray = (float[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray;
            BoxedUnit[] xs = boxedUnitArray = (BoxedUnit[])object;
            return new ArrayOps.ArrayIterator(xs);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new MatchError(object);
    }

    public final <S extends Stepper<?>, A> S stepper$extension(Object $this, StepperShape<A, S> shape) {
        IndexedStepperBase indexedStepperBase;
        int n = shape.shape();
        if (StepperShape$.MODULE$.ReferenceShape() == n) {
            Object object = $this;
            if (object instanceof boolean[]) {
                boolean[] blArray;
                boolean[] bs = blArray = (boolean[])object;
                indexedStepperBase = new BoxedBooleanArrayStepper(bs, 0, ScalaRunTime$.MODULE$.array_length($this));
            } else {
                indexedStepperBase = new ObjectArrayStepper<Object>((Object[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
            }
        } else if (StepperShape$.MODULE$.IntShape() == n) {
            indexedStepperBase = new IntArrayStepper((int[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.LongShape() == n) {
            indexedStepperBase = new LongArrayStepper((long[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.DoubleShape() == n) {
            indexedStepperBase = new DoubleArrayStepper((double[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.ByteShape() == n) {
            indexedStepperBase = new WidenedByteArrayStepper((byte[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.ShortShape() == n) {
            indexedStepperBase = new WidenedShortArrayStepper((short[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.CharShape() == n) {
            indexedStepperBase = new WidenedCharArrayStepper((char[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else if (StepperShape$.MODULE$.FloatShape() == n) {
            indexedStepperBase = new WidenedFloatArrayStepper((float[])$this, 0, ScalaRunTime$.MODULE$.array_length($this));
        } else {
            throw new MatchError(new StepperShape.Shape(n));
        }
        IndexedStepperBase s = indexedStepperBase;
        return (S)s;
    }

    public final <A> Iterator<Object> grouped$extension(Object $this, int size) {
        return new ArrayOps.GroupedIterator($this, size);
    }

    public final <A> Tuple2<Object, Object> span$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Boolean> & Serializable)x -> !BoxesRunTime.unboxToBoolean(p.apply(x)), this.indexWhere$default$2$extension($this));
        int idx = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return Tuple2$.MODULE$.apply(this.slice$extension($this, 0, idx), this.slice$extension($this, idx, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Tuple2<Object, Object> splitAt$extension(Object $this, int n) {
        return Tuple2$.MODULE$.apply(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Object, Object> partition$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res1 = ArrayBuilder$.MODULE$.make(this.scala$collection$ArrayOps$$$elemTag$extension($this));
        ArrayBuilder<A> res2 = ArrayBuilder$.MODULE$.make(this.scala$collection$ArrayOps$$$elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            (BoxesRunTime.unboxToBoolean(p.apply(x)) ? res1 : res2).$plus$eq(x);
        }
        return Tuple2$.MODULE$.apply(res1.result(), res2.result());
    }

    public final <A1, A2, A> Tuple2<Object, Object> partitionMap$extension(Object $this, Function1<A, Either<A1, A2>> f, ClassTag<A1> evidence$1, ClassTag<A2> evidence$2) {
        ArrayBuilder<A1> res1 = ArrayBuilder$.MODULE$.make(evidence$1);
        ArrayBuilder<A2> res2 = ArrayBuilder$.MODULE$.make(evidence$2);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ArrayBuilder arrayBuilder;
            Either<A1, A2> either = f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            if (either instanceof Left) {
                Left left = (Left)either;
                Object x = left.value();
                arrayBuilder = (ArrayBuilder)res1.$plus$eq(x);
                continue;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Object x = right.value();
                arrayBuilder = (ArrayBuilder)res2.$plus$eq(x);
                continue;
            }
            throw new MatchError(either);
        }
        return Tuple2$.MODULE$.apply(res1.result(), res2.result());
    }

    public final <A> Object reverse$extension(Object $this) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object res = Arrays$.MODULE$.newGenericArray(len, this.scala$collection$ArrayOps$$$elemTag$extension($this));
        for (int i = 0; i < len; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, len - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return res;
    }

    public final <A> Iterator<A> reverseIterator$extension(Object $this) {
        Object object = $this;
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] xs = dArray = (double[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof float[]) {
            float[] fArray;
            float[] xs = fArray = (float[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray;
            BoxedUnit[] xs = boxedUnitArray = (BoxedUnit[])object;
            return new ArrayOps.ReverseIterator(xs);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new MatchError(object);
    }

    public final <A> Object filter$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<A> res = ArrayBuilder$.MODULE$.make(this.scala$collection$ArrayOps$$$elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            if (!BoxesRunTime.unboxToBoolean(p.apply(x))) continue;
            res.$plus$eq(x);
        }
        return res.result();
    }

    public final <A> Object filterNot$extension(Object $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Boolean> & Serializable)x -> !BoxesRunTime.unboxToBoolean(p.apply(x)));
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        if (len <= 1) {
            return ScalaRunTime$.MODULE$.array_clone($this);
        }
        Object object = $this;
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            Object[] a = Arrays.copyOf(xs, len);
            Arrays.sort(a, ord);
            return a;
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            if (ord == Ordering$Int$.MODULE$) {
                int[] a = Arrays.copyOf(xs, len);
                Arrays.sort(a);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            if (ord == Ordering$Long$.MODULE$) {
                long[] a = Arrays.copyOf(xs, len);
                Arrays.sort(a);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            if (ord == Ordering$Char$.MODULE$) {
                char[] a = Arrays.copyOf(xs, len);
                Arrays.sort(a);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            if (ord == Ordering$Byte$.MODULE$) {
                byte[] a = Arrays.copyOf(xs, len);
                Arrays.sort(a);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            if (ord == Ordering$Short$.MODULE$) {
                short[] a = Arrays.copyOf(xs, len);
                Arrays.sort(a);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            if (ord == Ordering$Boolean$.MODULE$) {
                boolean[] a = Arrays.copyOf(xs, len);
                Sorting$.MODULE$.stableSort((Object)a, Ordering$Boolean$.MODULE$);
                return a;
            }
            return this.boxed$1(len, $this, ord);
        }
        Object xs = object;
        return this.boxed$1(len, $this, ord);
    }

    public final <A> Object sortWith$extension(Object $this, Function2<A, A, Object> lt) {
        return this.sorted$extension($this, Ordering$.MODULE$.fromLessThan(lt));
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Object $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <A> int indexOf$extension(Object $this, A elem, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexOf$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> int indexWhere$extension(Object $this, Function1<A, Object> p, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> int lastIndexOf$extension(Object $this, A elem, int end) {
        for (int i = Math.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.equals(elem, ScalaRunTime$.MODULE$.array_apply($this, i))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexOf$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> int lastIndexWhere$extension(Object $this, Function1<A, Object> p, int end) {
        for (int i = Math.min(end, ScalaRunTime$.MODULE$.array_length($this) - 1); i >= 0; --i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexWhere$default$2$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) - 1;
    }

    public final <A> Option<A> find$extension(Object $this, Function1<A, Object> p) {
        int idx = this.indexWhere$extension($this, p, this.indexWhere$default$2$extension($this));
        if (idx == -1) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply($this, idx));
    }

    public final <A> boolean exists$extension(Object $this, Function1<A, Object> p) {
        return this.indexWhere$extension($this, p, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Object $this, Function1<A, Object> p) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> B foldLeft$extension(Object $this, B z, Function2<B, A, B> op) {
        Object object = $this;
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] xs = dArray = (double[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof float[]) {
            float[] fArray;
            float[] xs = fArray = (float[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            return (B)this.f$3(xs, op, z);
        }
        if (object instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray;
            BoxedUnit[] xs = boxedUnitArray = (BoxedUnit[])object;
            return (B)this.f$3(xs, op, z);
        }
        throw new MatchError(object);
    }

    public final <B, A> Object scanLeft$extension(Object $this, B z, Function2<B, A, B> op, ClassTag<B> evidence$1) {
        int i;
        B v = z;
        Object res = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$1);
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, v);
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        ScalaRunTime$.MODULE$.array_update(res, i, v);
        return res;
    }

    public final <B, A> Object scan$extension(Object $this, B z, Function2<B, B, B> op, ClassTag<B> evidence$1) {
        return this.scanLeft$extension($this, z, op, evidence$1);
    }

    public final <B, A> Object scanRight$extension(Object $this, B z, Function2<A, B, B> op, ClassTag<B> evidence$1) {
        B v = z;
        Object res = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$1);
        ScalaRunTime$.MODULE$.array_update(res, ScalaRunTime$.MODULE$.array_length($this), z);
        for (int i = ScalaRunTime$.MODULE$.array_length($this) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply($this, i), v);
            ScalaRunTime$.MODULE$.array_update(res, i, v);
        }
        return res;
    }

    public final <B, A> B foldRight$extension(Object $this, B z, Function2<A, B, B> op) {
        Object object = $this;
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] xs = dArray = (double[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof float[]) {
            float[] fArray;
            float[] xs = fArray = (float[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            return (B)this.f$4(xs, op, z);
        }
        if (object instanceof BoxedUnit[]) {
            BoxedUnit[] boxedUnitArray;
            BoxedUnit[] xs = boxedUnitArray = (BoxedUnit[])object;
            return (B)this.f$4(xs, op, z);
        }
        throw new MatchError(object);
    }

    public final <A1, A> A1 fold$extension(Object $this, A1 z, Function2<A1, A1, A1> op) {
        return this.foldLeft$extension($this, z, op);
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> ct) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object ys = Arrays$.MODULE$.newGenericArray(len, ct);
        if (len > 0) {
            Object object = $this;
            if (object instanceof Object[]) {
                Object[] objectArray;
                Object[] xs = objectArray = (Object[])object;
                for (i = 0; i < len; ++i) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(xs[i]));
                }
            } else if (object instanceof int[]) {
                int[] nArray;
                int[] xs = nArray = (int[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToInteger(xs[i])));
                    ++i;
                }
            } else if (object instanceof double[]) {
                double[] dArray;
                double[] xs = dArray = (double[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToDouble(xs[i])));
                    ++i;
                }
            } else if (object instanceof long[]) {
                long[] lArray;
                long[] xs = lArray = (long[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToLong(xs[i])));
                    ++i;
                }
            } else if (object instanceof float[]) {
                float[] fArray;
                float[] xs = fArray = (float[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToFloat(xs[i])));
                    ++i;
                }
            } else if (object instanceof char[]) {
                char[] cArray;
                char[] xs = cArray = (char[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToCharacter(xs[i])));
                    ++i;
                }
            } else if (object instanceof byte[]) {
                byte[] byArray;
                byte[] xs = byArray = (byte[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToByte(xs[i])));
                    ++i;
                }
            } else if (object instanceof short[]) {
                short[] sArray;
                short[] xs = sArray = (short[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToShort(xs[i])));
                    ++i;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray;
                boolean[] xs = blArray = (boolean[])object;
                while (i < len) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply((Object)BoxesRunTime.boxToBoolean(xs[i])));
                    ++i;
                }
            } else {
                throw new MatchError(object);
            }
        }
        return ys;
    }

    public final <A> Object mapInPlace$extension(Object $this, Function1<A, A> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update($this, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return $this;
    }

    public final <B, A> Object flatMap$extension(Object $this, Function1<A, IterableOnce<B>> f, ClassTag<B> evidence$1) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$1);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b.$plus$plus$eq((IterableOnce)f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return b.result();
    }

    public final <BS, B, A> Object flatMap$extension(Object $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable, ClassTag<B> m) {
        return this.flatMap$extension($this, (Function1<Object, IterableOnce> & Serializable)x -> (IterableOnce)asIterable.apply(f.apply(x)), m);
    }

    public final <B, A> Object flatten$extension(Object $this, Function1<A, IterableOnce<B>> asIterable, ClassTag<B> m) {
        int i;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(m);
        int len = ScalaRunTime$.MODULE$.array_length($this);
        int size = 0;
        for (i = 0; i < len; ++i) {
            Object object;
            Object object2 = ScalaRunTime$.MODULE$.array_apply($this, i);
            if (object2 instanceof IterableOnce) {
                IterableOnce iterableOnce = (IterableOnce)object2;
                Object it = iterableOnce;
                int k = ((IterableOnce)it).knownSize();
                if (k <= 0) continue;
                size += k;
                continue;
            }
            if (!ScalaRunTime$.MODULE$.isArray(object2, 1)) continue;
            Object a = object = object2;
            size += ScalaRunTime$.MODULE$.array_length(a);
        }
        if (size > 0) {
            b.sizeHint(size);
        }
        for (i = 0; i < len; ++i) {
            b.$plus$plus$eq((IterableOnce)asIterable.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return b.result();
    }

    public final <B, A> Object collect$extension(Object $this, PartialFunction<A, B> pf, ClassTag<B> evidence$1) {
        Function1<Object, Object> fallback = ArrayOps$.fallback;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$1);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object v = pf.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), fallback);
            if (v == fallback) continue;
            b.addOne(v);
        }
        return b.result();
    }

    public final <B, A> Option<B> collectFirst$extension(Object $this, PartialFunction<A, B> pf) {
        Function1<Object, Object> fallback = ArrayOps$.fallback;
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object v = pf.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), fallback);
            if (v == fallback) continue;
            return Some$.MODULE$.apply(v);
        }
        return None$.MODULE$;
    }

    public final <B, A> Tuple2<A, B>[] zip$extension(Object $this, IterableOnce<B> that) {
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? Math.min(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator<B> it = that.iterator();
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            b.$plus$eq(Tuple2$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply($this, i), it.next()));
        }
        return (Tuple2[])b.result();
    }

    public final <B, A> LazyZip2<A, B, Object> lazyZip$extension(Object $this, Iterable<B> that) {
        return new LazyZip2($this, scala.collection.immutable.ArraySeq$.MODULE$.unsafeWrapArray($this), that);
    }

    public final <A1, B, A> Tuple2<A1, B>[] zipAll$extension(Object $this, Iterable<B> that, A1 thisElem, B thatElem) {
        int i;
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(Math.max(k, ScalaRunTime$.MODULE$.array_length($this)));
        Iterator it = that.iterator();
        for (i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            b.$plus$eq(Tuple2$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply($this, i), it.next()));
        }
        while (it.hasNext()) {
            b.$plus$eq(Tuple2$.MODULE$.apply(thisElem, it.next()));
            ++i;
        }
        while (i < ScalaRunTime$.MODULE$.array_length($this)) {
            b.$plus$eq(Tuple2$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply($this, i), thatElem));
            ++i;
        }
        return (Tuple2[])b.result();
    }

    public final <A> Tuple2<A, Object>[] zipWithIndex$extension(Object $this) {
        Tuple2[] b = new Tuple2[ScalaRunTime$.MODULE$.array_length($this)];
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b[i] = Tuple2$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply($this, i), BoxesRunTime.boxToInteger(i));
        }
        return b;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$1) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$1);
        ScalaRunTime$.MODULE$.array_update(dest, ScalaRunTime$.MODULE$.array_length($this), x);
        return dest;
    }

    public final <B, A> Object $colon$plus$extension(Object $this, B x, ClassTag<B> evidence$1) {
        return this.appended$extension($this, x, evidence$1);
    }

    public final <B, A> Object prepended$extension(Object $this, B x, ClassTag<B> evidence$1) {
        Object dest = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$1);
        ScalaRunTime$.MODULE$.array_update(dest, 0, x);
        Array$.MODULE$.copy($this, 0, dest, 1, ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$colon$extension(Object $this, B x, ClassTag<B> evidence$1) {
        return this.prepended$extension($this, x, evidence$1);
    }

    public final <B, A> Object prependedAll$extension(Object $this, IterableOnce<B> prefix, ClassTag<B> evidence$1) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$1);
        int k = prefix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll((IterableOnce)prefix);
        if (k < 0) {
            b.sizeHint(b.length() + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        return b.result();
    }

    public final <B, A> Object prependedAll$extension(Object $this, Object prefix, ClassTag<B> evidence$1) {
        Object dest = Array$.MODULE$.copyAs(prefix, ScalaRunTime$.MODULE$.array_length(prefix) + ScalaRunTime$.MODULE$.array_length($this), evidence$1);
        Array$.MODULE$.copy($this, 0, dest, ScalaRunTime$.MODULE$.array_length(prefix), ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$plus$colon$extension(Object $this, IterableOnce<B> prefix, ClassTag<B> evidence$1) {
        return this.prependedAll$extension($this, prefix, evidence$1);
    }

    public final <B, A> Object $plus$plus$colon$extension(Object $this, Object prefix, ClassTag<B> evidence$1) {
        return this.prependedAll$extension($this, prefix, evidence$1);
    }

    public final <B, A> Object appendedAll$extension(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$1) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$1);
        b.sizeHint(suffix, ScalaRunTime$.MODULE$.array_length($this));
        b.addAll($this);
        b.addAll((IterableOnce)suffix);
        return b.result();
    }

    public final <B, A> Object appendedAll$extension(Object $this, Object suffix, ClassTag<B> evidence$1) {
        Object dest = Array$.MODULE$.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + ScalaRunTime$.MODULE$.array_length(suffix), evidence$1);
        Array$.MODULE$.copy(suffix, 0, dest, ScalaRunTime$.MODULE$.array_length($this), ScalaRunTime$.MODULE$.array_length(suffix));
        return dest;
    }

    public final <B, A> Object $colon$plus$plus$extension(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, suffix, evidence$1);
    }

    public final <B, A> Object $colon$plus$plus$extension(Object $this, Object suffix, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, suffix, evidence$1);
    }

    public final <B, A> Object concat$extension(Object $this, IterableOnce<B> suffix, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, suffix, evidence$1);
    }

    public final <B, A> Object concat$extension(Object $this, Object suffix, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, suffix, evidence$1);
    }

    public final <B, A> Object $plus$plus$extension(Object $this, IterableOnce<B> xs, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, xs, evidence$1);
    }

    public final <B, A> Object $plus$plus$extension(Object $this, Object xs, ClassTag<B> evidence$1) {
        return this.appendedAll$extension($this, xs, evidence$1);
    }

    public final <A> boolean contains$extension(Object $this, A elem) {
        return this.exists$extension($this, (Function1<Object, Boolean> & Serializable)_$2 -> BoxesRunTime.equals(_$2, elem));
    }

    public final <B, A> Object patch$extension(Object $this, int from, IterableOnce<B> other, int replaced, ClassTag<B> evidence$1) {
        int chunk1;
        int r;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$1);
        int k = other.knownSize();
        int n = r = replaced < 0 ? 0 : replaced;
        if (k >= 0) {
            b.sizeHint(ScalaRunTime$.MODULE$.array_length($this) + k - r);
        }
        int n2 = chunk1 = from > 0 ? Math.min(from, ScalaRunTime$.MODULE$.array_length($this)) : 0;
        if (chunk1 > 0) {
            b.addAll($this, 0, chunk1);
        }
        b.$plus$plus$eq((IterableOnce)other);
        int remaining = ScalaRunTime$.MODULE$.array_length($this) - chunk1 - r;
        if (remaining > 0) {
            b.addAll($this, ScalaRunTime$.MODULE$.array_length($this) - remaining, remaining);
        }
        return b.result();
    }

    public final <A1, A2, A> Tuple2<Object, Object> unzip$extension(Object $this, Function1<A, Tuple2<A1, A2>> asPair, ClassTag<A1> ct1, ClassTag<A2> ct2) {
        Object a1 = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), ct1);
        Object a2 = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), ct2);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple2<A1, A2> e = asPair.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
        }
        return Tuple2$.MODULE$.apply(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Object, Object, Object> unzip3$extension(Object $this, Function1<A, Tuple3<A1, A2, A3>> asTriple, ClassTag<A1> ct1, ClassTag<A2> ct2, ClassTag<A3> ct3) {
        Object a1 = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), ct1);
        Object a2 = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), ct2);
        Object a3 = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), ct3);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
            ScalaRunTime$.MODULE$.array_update(a3, i, e._3());
        }
        return Tuple3$.MODULE$.apply(a1, a2, a3);
    }

    public final <B, A> Object[] transpose$extension(Object $this, Function1<A, Object> asArray) {
        Class<?> aClass = $this.getClass().getComponentType();
        ArrayBuilder.ofRef bb = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(aClass));
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            return bb.result();
        }
        ArrayBuilder[] bs = (ArrayBuilder[])this.map$extension(asArray.apply(ScalaRunTime$.MODULE$.array_apply($this, 0)), (Function1<Object, ArrayBuilder> & Serializable)x -> this.mkRowBuilder$1(aClass), ClassTag$.MODULE$.apply(ArrayBuilder.class));
        this.foreach$extension($this, xs -> {
            IntRef i = IntRef.create(0);
            MODULE$.foreach$extension(asArray.apply(xs), x -> {
                bs[i$1.elem].$plus$eq(x);
                ++i$1.elem;
            });
        });
        this.foreach$extension(bs, (Function1<ArrayBuilder, ArrayBuilder.ofRef> & Serializable)b -> (ArrayBuilder.ofRef)bb.$plus$eq(b.result()));
        return bb.result();
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int i;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object object = $this;
        if (object instanceof Object[]) {
            Object[] objectArray;
            Object[] xs = objectArray = (Object[])object;
            for (i = 0; i < len; ++i) {
                f.apply(xs[i]);
            }
            return;
        }
        if (object instanceof int[]) {
            int[] nArray;
            int[] xs = nArray = (int[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToInteger(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof double[]) {
            double[] dArray;
            double[] xs = dArray = (double[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToDouble(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof long[]) {
            long[] lArray;
            long[] xs = lArray = (long[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToLong(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof float[]) {
            float[] fArray;
            float[] xs = fArray = (float[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToFloat(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof char[]) {
            char[] cArray;
            char[] xs = cArray = (char[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToCharacter(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray;
            byte[] xs = byArray = (byte[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToByte(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof short[]) {
            short[] sArray;
            short[] xs = sArray = (short[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToShort(xs[i]));
                ++i;
            }
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] blArray;
            boolean[] xs = blArray = (boolean[])object;
            while (i < len) {
                f.apply((Object)BoxesRunTime.boxToBoolean(xs[i]));
                ++i;
            }
            return;
        }
        throw new MatchError(object);
    }

    public final <A> Object distinct$extension(Object $this) {
        return this.distinctBy$extension($this, (Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    public final <B, A> Object distinctBy$extension(Object $this, Function1<A, B> f) {
        return ArrayBuilder$.MODULE$.make(this.scala$collection$ArrayOps$$$elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(f)).result();
    }

    public final <B, A> Object padTo$extension(Object $this, int len, B elem, ClassTag<B> evidence$1) {
        int i;
        int newlen = Math.max(i, len);
        Object dest = Array$.MODULE$.copyAs($this, newlen, evidence$1);
        for (i = ScalaRunTime$.MODULE$.array_length($this); i < newlen; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i, elem);
        }
        return dest;
    }

    public final <A> Range indices$extension(Object $this) {
        return Range$.MODULE$.apply(0, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <K, A> Map<K, Object> groupBy$extension(Object $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K key = f.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(key, () -> ArrayOps$.$anonfun$5($this));
            bldr.$plus$eq(elem);
        }
        return m.view().mapValues((Function1<ArrayBuilder, Object> & Serializable)_$3 -> _$3.result()).toMap($less$colon$less$.MODULE$.refl());
    }

    public final <K, B, A> Map<K, Object> groupMap$extension(Object $this, Function1<A, K> key, Function1<A, B> f, ClassTag<B> evidence$1) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K k = key.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(k, () -> ArrayOps$.$anonfun$6(evidence$1));
            bldr.$plus$eq(f.apply(elem));
        }
        return m.view().mapValues((Function1<ArrayBuilder, Object> & Serializable)_$4 -> _$4.result()).toMap($less$colon$less$.MODULE$.refl());
    }

    public final <A> scala.collection.immutable.Seq<A> toSeq$extension(Object $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return scala.collection.immutable.ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.copyOf($this, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <B, A> int copyToArray$extension(Object $this, Object xs) {
        return this.copyToArray$extension($this, xs, 0);
    }

    public final <B, A> int copyToArray$extension(Object $this, Object xs, int start) {
        return this.copyToArray$extension($this, xs, start, Integer.MAX_VALUE);
    }

    public final <B, A> int copyToArray$extension(Object $this, Object xs, int start, int len) {
        int copied = IterableOnce$.MODULE$.elemsToCopyToArray(ScalaRunTime$.MODULE$.array_length($this), ScalaRunTime$.MODULE$.array_length(xs), start, len);
        if (copied > 0) {
            Array$.MODULE$.copy($this, 0, xs, start, copied);
        }
        return copied;
    }

    public final <B, A> Object toArray$extension(Object $this, ClassTag<B> evidence$1) {
        Object destination = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length($this), evidence$1);
        int copied = this.copyToArray$extension($this, destination, 0);
        return destination;
    }

    public final <A> int count$extension(Object $this, Function1<A, Object> p) {
        int res = 0;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            ++res;
        }
        return res;
    }

    public final <B, A> boolean startsWith$extension(Object $this, Object that) {
        return this.startsWith$extension($this, that, 0);
    }

    public final <B, A> boolean startsWith$extension(Object $this, Object that, int offset) {
        int safeOffset = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(offset), 0);
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        if (thatl > ScalaRunTime$.MODULE$.array_length($this) - safeOffset) {
            return thatl == 0;
        }
        for (int i = 0; i < thatl; ++i) {
            if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + safeOffset), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> boolean endsWith$extension(Object $this, Object that) {
        int thatl = ScalaRunTime$.MODULE$.array_length(that);
        int off = ScalaRunTime$.MODULE$.array_length($this) - thatl;
        if (off < 0) {
            return false;
        }
        for (int i = 0; i < thatl; ++i) {
            if (BoxesRunTime.equals(ScalaRunTime$.MODULE$.array_apply($this, i + off), ScalaRunTime$.MODULE$.array_apply(that, i))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> Object updated$extension(Object $this, int index, B elem, ClassTag<B> evidence$1) {
        if (index < 0 || index >= ScalaRunTime$.MODULE$.array_length($this)) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(index, ScalaRunTime$.MODULE$.array_length($this) - 1);
        }
        Object dest = this.toArray$extension($this, evidence$1);
        ScalaRunTime$.MODULE$.array_update(dest, index, elem);
        return dest;
    }

    public final <A> IndexedSeqView<A> view$extension(Object $this) {
        return new ArrayOps.ArrayView($this);
    }

    public final <B, A> Object diff$extension(Object $this, Seq<B> that) {
        return ((IterableOnceOps)ArraySeq$.MODULE$.make($this).diff((Seq)that)).toArray(this.scala$collection$ArrayOps$$$elemTag$extension($this));
    }

    public final <B, A> Object intersect$extension(Object $this, Seq<B> that) {
        return ((IterableOnceOps)ArraySeq$.MODULE$.make($this).intersect((Seq)that)).toArray(this.scala$collection$ArrayOps$$$elemTag$extension($this));
    }

    public final <A> Iterator<Object> sliding$extension(Object $this, int size, int step) {
        return ArraySeq$.MODULE$.make($this).sliding(size, step).map((Function1<ArraySeq, Object> & Serializable)_$5 -> _$5.toArray(MODULE$.scala$collection$ArrayOps$$$elemTag$extension($this)));
    }

    public final <A> int sliding$default$2$extension(Object $this) {
        return 1;
    }

    public final <A> Iterator<Object> combinations$extension(Object $this, int n) {
        return ArraySeq$.MODULE$.make($this).combinations(n).map((Function1<ArraySeq, Object> & Serializable)_$6 -> _$6.toArray(MODULE$.scala$collection$ArrayOps$$$elemTag$extension($this)));
    }

    public final <A> Iterator<Object> permutations$extension(Object $this) {
        return ArraySeq$.MODULE$.make($this).permutations().map((Function1<ArraySeq, Object> & Serializable)_$7 -> _$7.toArray(MODULE$.scala$collection$ArrayOps$$$elemTag$extension($this)));
    }

    public final <B, A> boolean startsWith$extension(Object $this, IterableOnce<B> that, int offset) {
        return ArraySeq$.MODULE$.make($this).startsWith(that, offset);
    }

    public final <B, A> int startsWith$default$2$extension(Object $this) {
        return 0;
    }

    public final <B, A> boolean endsWith$extension(Object $this, Iterable<B> that) {
        return ArraySeq$.MODULE$.make($this).endsWith(that);
    }

    public static final /* synthetic */ IterableOnce scala$collection$ArrayOps$WithFilter$$_$flatMap$$anonfun$1(Function1 asIterable$1, Function1 f$1, Object x) {
        return (IterableOnce)asIterable$1.apply(f$1.apply(x));
    }

    private static final IterableOnce iterateUntilEmpty$extension$$anonfun$2(Object $this$1) {
        return Iterator$.MODULE$.single(Array$.MODULE$.empty(MODULE$.scala$collection$ArrayOps$$$elemTag$extension($this$1)));
    }

    private final Object boxed$1(int len$1, Object $this$2, Ordering ord$1) {
        if (len$1 < 300) {
            Object a = ScalaRunTime$.MODULE$.array_clone($this$2);
            Sorting$.MODULE$.stableSort(a, ord$1);
            return a;
        }
        Object[] a = (Object[])Array$.MODULE$.copyAs($this$2, len$1, ClassTag$.MODULE$.AnyRef());
        Arrays.sort(a, ord$1);
        return Array$.MODULE$.copyAs(a, len$1, this.scala$collection$ArrayOps$$$elemTag$extension($this$2));
    }

    private final Object f$3(Object xs, Function2 op, Object z) {
        int length = ScalaRunTime$.MODULE$.array_length(xs);
        Object v = z;
        for (int i = 0; i < length; ++i) {
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply(xs, i));
        }
        return v;
    }

    private final Object f$4(Object xs, Function2 op, Object z) {
        Object v = z;
        for (int i = ScalaRunTime$.MODULE$.array_length(xs) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply(xs, i), v);
        }
        return v;
    }

    private final ArrayBuilder mkRowBuilder$1(Class aClass$1) {
        return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(aClass$1.getComponentType()));
    }

    private static final ArrayBuilder $anonfun$5(Object $this$3) {
        return ArrayBuilder$.MODULE$.make(MODULE$.scala$collection$ArrayOps$$$elemTag$extension($this$3));
    }

    private static final ArrayBuilder $anonfun$6(ClassTag evidence$1$1) {
        return ArrayBuilder$.MODULE$.make(evidence$1$1);
    }
}

