/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$class;
import scala.collection.Sequence;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Position$;
import scala.io.Source$;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Source
implements Iterator<Character>,
ScalaObject {
    private int tabinc;
    private int nwarnings;
    private int nerrors;
    private String descr;
    private char ch;
    private int pos;
    private int ccol;
    private int cline;

    public static final Codec fromInputStream$default$2(InputStream inputStream) {
        return Source$.MODULE$.fromInputStream$default$2(inputStream);
    }

    public static final Codec fromURL$default$2(URL uRL) {
        return Source$.MODULE$.fromURL$default$2(uRL);
    }

    public static final Codec fromURI$default$2(URI uRI) {
        return Source$.MODULE$.fromURI$default$2(uRI);
    }

    public static final Codec fromPath$default$2(String string2) {
        return Source$.MODULE$.fromPath$default$2(string2);
    }

    public static final Codec fromBytes$default$2(byte[] byArray) {
        return Source$.MODULE$.fromBytes$default$2(byArray);
    }

    public static final Codec fromFile$default$3(File file, int n) {
        return Source$.MODULE$.fromFile$default$3(file, n);
    }

    public static final int fromFile$default$2() {
        return Source$.MODULE$.fromFile$default$2();
    }

    public static final Source fromInputStream(InputStream inputStream, Codec codec) {
        return Source$.MODULE$.fromInputStream(inputStream, codec);
    }

    public static final Source fromURL(URL uRL, Codec codec) {
        return Source$.MODULE$.fromURL(uRL, codec);
    }

    public static final Source fromFile(File file, int n, Codec codec) {
        return Source$.MODULE$.fromFile(file, n, codec);
    }

    public static final Source fromURI(URI uRI, Codec codec) {
        return Source$.MODULE$.fromURI(uRI, codec);
    }

    public static final Source fromPath(String string2, Codec codec) {
        return Source$.MODULE$.fromPath(string2, codec);
    }

    public static final Source fromBytes(byte[] byArray, Codec codec) {
        return Source$.MODULE$.fromBytes(byArray, codec);
    }

    public static final Source fromString(String string2) {
        return Source$.MODULE$.fromString(string2);
    }

    public static final Source fromChars(char[] cArray) {
        return Source$.MODULE$.fromChars(cArray);
    }

    public static final Source fromChar(char c) {
        return Source$.MODULE$.fromChar(c);
    }

    public static final Source fromIterable(Iterable<Character> iterable) {
        return Source$.MODULE$.fromIterable(iterable);
    }

    public static final Function0<Source> NoReset() {
        return Source$.MODULE$.NoReset();
    }

    public static final int DefaultBufSize() {
        return Source$.MODULE$.DefaultBufSize();
    }

    public Source() {
        Iterator$class.$init$(this);
        this.cline = 1;
        this.ccol = 1;
        this.pos = 0;
        this.descr = "";
        this.nerrors = 0;
        this.nwarnings = 0;
        this.tabinc = 4;
    }

    public /* synthetic */ PrintStream reportError$default$3() {
        return Console$.MODULE$.err();
    }

    public /* synthetic */ PrintStream reportWarning$default$3() {
        return Console$.MODULE$.out();
    }

    public abstract Source reset();

    public void reportWarning(int pos, String msg, PrintStream out) {
        this.nwarnings_$eq(this.nwarnings() + 1);
        this.report(pos, new StringBuilder().append((Object)"warning! ").append((Object)msg).toString(), out);
    }

    public void report(int pos, String msg, PrintStream out) {
        StringBuilder buf = new StringBuilder();
        int line = Position$.MODULE$.line(pos);
        int col = Position$.MODULE$.column(pos);
        buf.append(new StringBuilder().append((Object)this.descr()).append((Object)":").append(BoxesRunTime.boxToInteger(line)).append((Object)":").append(BoxesRunTime.boxToInteger(col)).append((Object)": ").append((Object)msg).toString());
        buf.append(this.getLine(line));
        for (int i = 1; i < col; ++i) {
            buf.append(' ');
        }
        buf.append('^');
        out.println(buf.toString());
    }

    public void reportError(int pos, String msg, PrintStream out) {
        this.nerrors_$eq(this.nerrors() + 1);
        this.report(pos, msg, out);
    }

    @Override
    public char next() {
        this.ch_$eq(BoxesRunTime.unboxToChar(this.iter().next()));
        this.pos_$eq(Position$.MODULE$.encode(this.cline(), this.ccol()));
        char temp1 = this.ch();
        switch (temp1) {
            default: {
                this.ccol_$eq(this.ccol() + 1);
                break;
            }
            case '\n': {
                this.ccol_$eq(1);
                this.cline_$eq(this.cline() + 1);
                break;
            }
            case '\t': {
                this.ccol_$eq(this.ccol() + this.tabinc());
            }
        }
        return this.ch();
    }

    @Override
    public boolean hasNext() {
        return this.iter().hasNext();
    }

    public Iterator<String> getLines() {
        return new $anon$2(this);
    }

    public String getLine(int line) {
        if (line < 1) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(line)).toString());
        }
        StringBuilder buf = new StringBuilder();
        Source it = this.reset();
        int i = 0;
        while (it.hasNext() && i < line - 1) {
            if ('\n' != it.next()) continue;
            ++i;
        }
        if (it.hasNext()) {
            char ch = it.next();
            while (it.hasNext() && '\n' != ch) {
                buf.append(ch);
                ch = it.next();
            }
            Object object = '\n' != ch ? buf.append(ch) : BoxedUnit.UNIT;
            String res = buf.toString();
            buf.setLength(0);
            return res;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"line ").append(BoxesRunTime.boxToInteger(line)).append((Object)" does not exist").toString());
    }

    public void tabinc_$eq(int n) {
        this.tabinc = n;
    }

    public int tabinc() {
        return this.tabinc;
    }

    public void nwarnings_$eq(int n) {
        this.nwarnings = n;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void nerrors_$eq(int n) {
        this.nerrors = n;
    }

    public int nerrors() {
        return this.nerrors;
    }

    public void descr_$eq(String string2) {
        this.descr = string2;
    }

    public String descr() {
        return this.descr;
    }

    public void ch_$eq(char c) {
        this.ch = c;
    }

    public char ch() {
        return this.ch;
    }

    public void pos_$eq(int n) {
        this.pos = n;
    }

    public int pos() {
        return this.pos;
    }

    public void ccol_$eq(int n) {
        this.ccol = n;
    }

    public int ccol() {
        return this.ccol;
    }

    public void cline_$eq(int n) {
        this.cline = n;
    }

    public int cline() {
        return this.cline;
    }

    public abstract Iterator<Character> iter();

    public void readInto(BoxedArray xs) {
        Iterator$class.readInto(this, xs);
    }

    public void readInto(BoxedArray xs, int start2) {
        Iterator$class.readInto(this, xs, start2);
    }

    public void readInto(BoxedArray xs, int start2, int sz) {
        Iterator$class.readInto(this, xs, start2, sz);
    }

    @Override
    public Object counted() {
        return Iterator$class.counted(this);
    }

    @Override
    public Sequence collect() {
        return Iterator$class.collect(this);
    }

    @Override
    public int findIndexOf(Function1 p) {
        return Iterator$class.findIndexOf(this, p);
    }

    @Override
    public Object append(Iterator that) {
        return Iterator$class.append(this, that);
    }

    @Override
    public String toString() {
        return Iterator$class.toString(this);
    }

    @Override
    public StringBuilder addString(StringBuilder buf) {
        return Iterator$class.addString(this, buf);
    }

    @Override
    public StringBuilder addString(StringBuilder buf, String sep) {
        return Iterator$class.addString(this, buf, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder buf, String start2, String sep, String end) {
        return Iterator$class.addString(this, buf, start2, sep, end);
    }

    @Override
    public String mkString() {
        return Iterator$class.mkString(this);
    }

    @Override
    public String mkString(String sep) {
        return Iterator$class.mkString(this, sep);
    }

    @Override
    public String mkString(String start2, String sep, String end) {
        return Iterator$class.mkString(this, start2, sep, end);
    }

    @Override
    public Sequence toSequence() {
        return Iterator$class.toSequence(this);
    }

    @Override
    public Stream toStream() {
        return Iterator$class.toStream(this);
    }

    @Override
    public List toList() {
        return Iterator$class.toList(this);
    }

    @Override
    public void copyToBuffer(Buffer dest) {
        Iterator$class.copyToBuffer(this, dest);
    }

    public void copyToArray(BoxedArray xs) {
        Iterator$class.copyToArray(this, xs);
    }

    public void copyToArray(BoxedArray xs, int start2) {
        Iterator$class.copyToArray(this, xs, start2);
    }

    public void copyToArray(BoxedArray xs, int start2, int len) {
        Iterator$class.copyToArray(this, xs, start2, len);
    }

    @Override
    public Object patch(int from2, Iterator patchElems, int replaced) {
        return Iterator$class.patch(this, from2, patchElems, replaced);
    }

    @Override
    public Tuple2 duplicate() {
        return Iterator$class.duplicate(this);
    }

    @Override
    public int length() {
        return Iterator$class.length(this);
    }

    @Override
    public Object buffered() {
        return Iterator$class.buffered(this);
    }

    @Override
    public Option reduceRightOpt(Function2 op) {
        return Iterator$class.reduceRightOpt(this, op);
    }

    @Override
    public Option reduceLeftOpt(Function2 op) {
        return Iterator$class.reduceLeftOpt(this, op);
    }

    @Override
    public Object reduceRight(Function2 op) {
        return Iterator$class.reduceRight(this, op);
    }

    @Override
    public Object reduceLeft(Function2 op) {
        return Iterator$class.reduceLeft(this, op);
    }

    @Override
    public Object $colon$bslash(Object z, Function2 op) {
        return Iterator$class.$colon$bslash(this, z, op);
    }

    @Override
    public Object $div$colon(Object z, Function2 op) {
        return Iterator$class.$div$colon(this, z, op);
    }

    @Override
    public Object foldRight(Object z, Function2 op) {
        return Iterator$class.foldRight(this, z, op);
    }

    @Override
    public Object foldLeft(Object z, Function2 op) {
        return Iterator$class.foldLeft(this, z, op);
    }

    @Override
    public int indexOf(Object elem2) {
        return Iterator$class.indexOf(this, elem2);
    }

    @Override
    public int indexWhere(Function1 p) {
        return Iterator$class.indexWhere(this, p);
    }

    @Override
    public Option find(Function1 p) {
        return Iterator$class.find(this, p);
    }

    @Override
    public boolean contains(Object elem2) {
        return Iterator$class.contains(this, elem2);
    }

    @Override
    public boolean exists(Function1 p) {
        return Iterator$class.exists(this, p);
    }

    @Override
    public boolean forall(Function1 p) {
        return Iterator$class.forall(this, p);
    }

    @Override
    public void foreach(Function1 f) {
        Iterator$class.foreach(this, f);
    }

    @Override
    public Object zipAll(Iterator that, Object thisElem, Object thatElem) {
        return Iterator$class.zipAll(this, that, thisElem, thatElem);
    }

    @Override
    public Object zipWithIndex() {
        return Iterator$class.zipWithIndex(this);
    }

    @Override
    public Object padTo(int len, Object elem2) {
        return Iterator$class.padTo(this, len, elem2);
    }

    @Override
    public Object zip(Iterator that) {
        return Iterator$class.zip(this, that);
    }

    @Override
    public Iterator dropWhile(Function1 p) {
        return Iterator$class.dropWhile(this, p);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return Iterator$class.partition(this, p);
    }

    @Override
    public Iterator takeWhile(Function1 p) {
        return Iterator$class.takeWhile(this, p);
    }

    @Override
    public Iterator filter(Function1 p) {
        return Iterator$class.filter(this, p);
    }

    @Override
    public Iterator flatMap(Function1 f) {
        return Iterator$class.flatMap(this, f);
    }

    @Override
    public Object $plus$plus(Function0 that) {
        return Iterator$class.$plus$plus(this, that);
    }

    @Override
    public Iterator map(Function1 f) {
        return Iterator$class.map(this, f);
    }

    @Override
    public Iterator slice(int from2, int until2) {
        return Iterator$class.slice(this, from2, until2);
    }

    @Override
    public Iterator drop(int n) {
        return Iterator$class.drop(this, n);
    }

    @Override
    public Iterator take(int n) {
        return Iterator$class.take(this, n);
    }
}

