/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Either;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Sequence;
import scala.collection.generic.Builder;
import scala.collection.generic.BuilderFactory;
import scala.collection.generic.IterableTemplate;
import scala.collection.generic.SequenceFactory;
import scala.collection.generic.TraversableFactory;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List$
extends SequenceFactory<List>
implements ScalaObject {
    public static final List$ MODULE$;

    static {
        new List$();
    }

    private List$() {
        MODULE$ = this;
    }

    private final List loop$4(List ys, List list2, Function1 function1) {
        List list3;
        block5: {
            Object head1;
            while (true) {
                if (ys.isEmpty()) {
                    list3 = list2;
                    break block5;
                }
                Object head0 = ys.head();
                head1 = function1.apply(head0);
                if (head1 != head0) break;
                ys = (List)ys.tail();
            }
            Object r = head1;
            List ys1 = this.mapConserve((List)ys.tail(), function1).$colon$colon(r);
            if (list2 == ys) {
                list3 = ys1;
            } else {
                ListBuffer b = new ListBuffer();
                for (List xc = list2; xc != ys; xc = (List)xc.tail()) {
                    b.$plus$eq(xc.head());
                }
                list3 = b.prependToList(ys1);
            }
        }
        return list3;
    }

    public <A> List<List<A>> transpose(List<List<A>> xss) {
        ListBuffer buf = new ListBuffer();
        List<List<A>> yss = xss;
        Object a;
        while (!((IterableTemplate)((a = yss.head()) instanceof IterableTemplate ? a : ScalaRunTime$.MODULE$.boxArray(a))).isEmpty()) {
            buf.$plus$eq(yss.map(new anonfun.transpose.1(), this.builderFactory()));
            yss = yss.map(new anonfun.transpose.2(), this.builderFactory());
        }
        return buf.toList();
    }

    public <A, B> boolean exists2(List<A> xs, List<B> ys, Function2<A, B, Boolean> f) {
        List xc = xs;
        List yc = ys;
        while (!xc.isEmpty() && !yc.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(f.apply(xc.head(), yc.head()))) {
                return true;
            }
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return false;
    }

    public <A, B> boolean forall2(List<A> xs, List<B> ys, Function2<A, B, Boolean> f) {
        List xc = xs;
        List yc = ys;
        while (true) {
            if (xc.isEmpty() || yc.isEmpty()) {
                return true;
            }
            if (!BoxesRunTime.unboxToBoolean(f.apply(xc.head(), yc.head()))) break;
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return false;
    }

    public <A, B, C, D> List<D> map3(List<A> xs, List<B> ys, List<C> zs, Function3<A, B, C, D> f) {
        ListBuffer b = new ListBuffer();
        List xc = xs;
        List yc = ys;
        List zc = zs;
        while (!(xc.isEmpty() || yc.isEmpty() || zc.isEmpty())) {
            b.$plus$eq(f.apply(xc.head(), yc.head(), zc.head()));
            xc = (List)xc.tail();
            yc = (List)yc.tail();
            zc = (List)zc.tail();
        }
        return b.toList();
    }

    public <A, B, C> List<C> map2(List<A> xs, List<B> ys, Function2<A, B, C> f) {
        ListBuffer b = new ListBuffer();
        List xc = xs;
        List yc = ys;
        while (!xc.isEmpty() && !yc.isEmpty()) {
            b.$plus$eq(f.apply(xc.head(), yc.head()));
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return b.toList();
    }

    public <A> List<A> mapConserve(List<A> xs$1, Function1<A, A> f$3) {
        return this.loop$4(xs$1, xs$1, f$3);
    }

    public String toString(List<Character> xs) {
        StringBuilder sb = new StringBuilder();
        List xc = xs;
        while (!xc.isEmpty()) {
            sb.append(BoxesRunTime.unboxToChar(xc.head()));
            xc = (List)xc.tail();
        }
        return sb.toString();
    }

    public List<Character> fromString(String str) {
        return Predef$.MODULE$.stringWrapper(str).toList();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> fromString(String str, char separator) {
        void var3_3;
        List words = Nil$.MODULE$;
        int pos = str.length();
        while (pos > 0) {
            int pos1 = str.lastIndexOf(Predef$.MODULE$.char2int(separator), pos - 1);
            if (pos1 + 1 < pos) {
                String string2 = str.substring(pos1 + 1, pos);
                words = words.$colon$colon(string2);
            }
            pos = pos1;
        }
        return var3_3;
    }

    public <A> List<A> fromArray(A[] arr, int start2, int len) {
        List res = Nil$.MODULE$;
        int i = start2 + len;
        while (i > start2) {
            Object a = arr.apply(--i);
            res = res.$colon$colon(a);
        }
        return res;
    }

    public <A> List<A> fromArray(A[] arr) {
        return this.fromArray((BoxedArray)arr, 0, arr.length());
    }

    public <A> List<A> fromIterator(Iterator<A> it) {
        return it.toList();
    }

    public <A, B> Tuple2<List<A>, List<B>> separate(Iterable<Either<A, B>> es) {
        return es.foldRight(new Tuple2<Nil$, Nil$>(Nil$.MODULE$, Nil$.MODULE$), new anonfun.separate.1());
    }

    public <A, B> List<B> rights(Iterable<Either<A, B>> es) {
        return es.foldRight(Nil$.MODULE$, new anonfun.rights.1());
    }

    public <A, B> List<A> lefts(Iterable<Either<A, B>> es) {
        return es.foldRight(Nil$.MODULE$, new anonfun.lefts.1());
    }

    public <A, B> Tuple2<List<A>, List<B>> unzip(Iterable<Tuple2<A, B>> xs) {
        return xs.foldRight(new Tuple2<Nil$, Nil$>(Nil$.MODULE$, Nil$.MODULE$), new anonfun.unzip.1());
    }

    public <A, B> Tuple2<List<A>, List<B>> unzip(List<Tuple2<A, B>> xs) {
        ListBuffer b1 = new ListBuffer();
        ListBuffer b2 = new ListBuffer();
        List xc = xs;
        while (!xc.isEmpty()) {
            b1.$plus$eq(((Tuple2)xc.head())._1());
            b2.$plus$eq(((Tuple2)xc.head())._2());
            xc = (List)xc.tail();
        }
        return new Tuple2<List<A>, List<B>>(b1.toList(), b2.toList());
    }

    public <A> List<A> flatten(List<List<A>> xss) {
        ListBuffer b$1 = new ListBuffer();
        xss.foreach(new anonfun.flatten.1(b$1));
        return b$1.toList();
    }

    public <A> List<A> make(int n, A elem2) {
        ListBuffer b = new ListBuffer();
        for (int i = 0; i < n; ++i) {
            b.$plus$eq((Object)elem2);
        }
        return b.toList();
    }

    public List<Integer> range(int start2, int end, Function1<Integer, Integer> step) {
        boolean up2 = BoxesRunTime.unboxToInt(step.apply(BoxesRunTime.boxToInteger(start2))) > start2;
        boolean down = BoxesRunTime.unboxToInt(step.apply(BoxesRunTime.boxToInteger(start2))) < start2;
        ListBuffer b = new ListBuffer();
        int i = start2;
        while (!(up2 && i >= end || down && i <= end)) {
            b.$plus$eq(BoxesRunTime.boxToInteger(i));
            int next2 = BoxesRunTime.unboxToInt(step.apply(BoxesRunTime.boxToInteger(i)));
            if (i == next2) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"the step function did not make any progress on ").append(BoxesRunTime.boxToInteger(i)).toString());
            }
            i = next2;
        }
        return b.toList();
    }

    @Override
    public <A> List<A> apply(Sequence<A> xs) {
        return xs.toList();
    }

    @Override
    public <A> List<A> empty() {
        return Nil$.MODULE$;
    }

    @Override
    public <A> Builder<A, List<A>> newBuilder() {
        return new ListBuffer();
    }

    public <A> BuilderFactory<A, List<A>, List<?>> builderFactory() {
        return new TraversableFactory.VirtualBuilderFactory();
    }
}

