/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import scala.Function0;
import scala.ScalaObject;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.scheduler.SingleThreadedEventLoopScheduler$;
import scala.collection.mutable.Queue;
import scala.concurrent.ManagedBlocker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleThreadedEventLoopScheduler
implements IScheduler,
ScalaObject {
    private boolean isShutdown;
    private int curNest;
    private int maxNesting;
    private final Queue<Runnable> tasks;

    public SingleThreadedEventLoopScheduler() {
        IScheduler$class.$init$(this);
        this.tasks = new Queue();
        this.maxNesting = 10;
        this.curNest = 0;
        this.isShutdown = false;
    }

    @Override
    public void managedBlock(ManagedBlocker blocker) {
        blocker.block();
    }

    @Override
    public boolean isActive() {
        return !this.isShutdown();
    }

    @Override
    public void onTerminate(Reactor actor, Function0<Object> f) {
    }

    @Override
    public void terminated(Reactor actor) {
    }

    @Override
    public void newActor(Reactor actor) {
    }

    @Override
    public void shutdown() {
        this.isShutdown_$eq(false);
        while (true) {
            if (this.tasks().isEmpty()) {
                this.isShutdown_$eq(true);
                return;
            }
            Runnable task = this.tasks().dequeue();
            task.run();
        }
    }

    @Override
    public void execute(Function0<Object> fun$1) {
        this.execute(new $anon$1(this, fun$1));
    }

    @Override
    public void execute(Runnable task) {
        if (this.curNest() < this.maxNesting()) {
            this.curNest_$eq(this.curNest() + 1);
            task.run();
        } else {
            this.curNest_$eq(0);
            this.tasks().$plus$eq((Object)task);
        }
    }

    private void isShutdown_$eq(boolean bl) {
        this.isShutdown = bl;
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }

    private void curNest_$eq(int n) {
        this.curNest = n;
    }

    private int curNest() {
        return this.curNest;
    }

    public void maxNesting_$eq(int n) {
        this.maxNesting = n;
    }

    public int maxNesting() {
        return this.maxNesting;
    }

    private Queue<Runnable> tasks() {
        return this.tasks;
    }

    @Override
    public void executeFromActor(Runnable task) {
        IScheduler$class.executeFromActor(this, task);
    }
}

