/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.forkjoin.ForkJoinPool;
import scala.actors.forkjoin.ForkJoinTask;
import scala.actors.scheduler.DrainableForkJoinPool;
import scala.actors.scheduler.ForkJoinScheduler$;
import scala.actors.scheduler.QuitException;
import scala.actors.scheduler.TerminationMonitor;
import scala.actors.scheduler.TerminationMonitor$class;
import scala.actors.scheduler.ThreadPoolConfig$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ManagedBlocker;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinScheduler
implements Runnable,
IScheduler,
TerminationMonitor,
ScalaObject {
    private boolean scala$actors$scheduler$TerminationMonitor$$started;
    private final HashMap scala$actors$scheduler$TerminationMonitor$$termHandlers;
    private int scala$actors$scheduler$TerminationMonitor$$pendingReactions;
    private final int CHECK_FREQ;
    private Collection<ForkJoinTask<?>> drainedTasks;
    private boolean snapshoting;
    private boolean terminating;
    private DrainableForkJoinPool pool;

    public ForkJoinScheduler() {
        IScheduler$class.$init$(this);
        TerminationMonitor$class.$init$(this);
        this.pool = this.makeNewPool();
        this.terminating = false;
        this.snapshoting = false;
        this.drainedTasks = null;
        this.CHECK_FREQ = 10;
    }

    private final void liftedTree1$1() {
        try {
            this.wait(Predef$.MODULE$.int2long(this.CHECK_FREQ()));
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void restart() {
        block7: {
            ForkJoinScheduler forkJoinScheduler = this;
            // MONITORENTER : forkJoinScheduler
            if (!this.snapshoting()) break block7;
            if (this.isActive()) {
                throw Predef$.MODULE$.error("scheduler is still active");
            }
            this.snapshoting_$eq(false);
            // MONITOREXIT : forkJoinScheduler
            this.pool_$eq(this.makeNewPool());
            Iterator<ForkJoinTask<?>> iter = this.drainedTasks().iterator();
            while (true) {
                if (!iter.hasNext()) {
                    this.start();
                    return;
                }
                this.pool().execute(iter.next());
            }
        }
        throw Predef$.MODULE$.error("snapshot has not been invoked");
    }

    public void snapshot() {
        ForkJoinScheduler forkJoinScheduler = this;
        synchronized (forkJoinScheduler) {
            this.snapshoting_$eq(true);
            return;
        }
    }

    @Override
    public boolean isActive() {
        return this.pool() != null && !this.pool().isShutdown();
    }

    @Override
    public void shutdown() {
        ForkJoinScheduler forkJoinScheduler = this;
        synchronized (forkJoinScheduler) {
            this.terminating_$eq(true);
            return;
        }
    }

    @Override
    public void managedBlock(ManagedBlocker blocker$1) {
        ForkJoinPool.managedBlock(new $anon$3(this, blocker$1), true);
    }

    @Override
    public void execute(Function0<Object> fun$1) {
        this.execute(new $anon$2(this, fun$1));
    }

    @Override
    public void executeFromActor(Runnable task$1) {
        $anon$1 recAction = new $anon$1(this, task$1);
        recAction.fork();
    }

    @Override
    public void execute(Runnable task) {
        this.pool().execute(task);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var2_1 = this;
                synchronized (var2_1) {
                    this.liftedTree1$1();
                    if (this.terminating()) {
                        throw new QuitException();
                    }
                    if (this.allTerminated()) {
                        throw new QuitException();
                    }
                    if (this.snapshoting()) {
                        if (this.pool().isQuiescent()) {
                            list = new ArrayList<ForkJoinTask<?>>();
                            num = this.pool().drainTasksTo(list);
                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": drained ")).append(BoxesRunTime.boxToInteger(num)).append((Object)" tasks").toString());
                            this.drainedTasks_$eq(list);
                            throw new QuitException();
                        }
                        v0 = BoxedUnit.UNIT;
                    } else {
                        poolSize = this.pool().getPoolSize();
                        if (this.allWorkersBlocked() && poolSize < ThreadPoolConfig$.MODULE$.maxPoolSize()) {
                            this.pool().setParallelism(poolSize + 1);
                            v0 = BoxedUnit.UNIT;
                        } else {
                            v0 = BoxedUnit.UNIT;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (QuitException v2) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": initiating shutdown..."));
            while (true) {
                if (this.pool().isQuiescent()) {
                    this.pool().shutdown();
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException var1_5) {}
                {
                }
            }
        }
        {
            ** while (true)
        }
    }

    private boolean allWorkersBlocked() {
        return this.pool().workers != null && ScalaRunTime$.MODULE$.boxArray(this.pool().workers).forall(new $anonfun$allWorkersBlocked$1(this));
    }

    public void start() {
        new Thread(this).start();
    }

    /*
     * WARNING - void declaration
     */
    private DrainableForkJoinPool makeNewPool() {
        void var1_1;
        DrainableForkJoinPool p = new DrainableForkJoinPool();
        p.setAsyncMode(true);
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": parallelism ")).append(BoxesRunTime.boxToInteger(p.getParallelism())).toString());
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": max pool size ")).append(BoxesRunTime.boxToInteger(p.getMaximumPoolSize())).toString());
        return var1_1;
    }

    private int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private void drainedTasks_$eq(Collection<ForkJoinTask<?>> collection) {
        this.drainedTasks = collection;
    }

    private Collection<ForkJoinTask<?>> drainedTasks() {
        return this.drainedTasks;
    }

    private void snapshoting_$eq(boolean bl) {
        this.snapshoting = bl;
    }

    private boolean snapshoting() {
        return this.snapshoting;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void pool_$eq(DrainableForkJoinPool drainableForkJoinPool) {
        this.pool = drainableForkJoinPool;
    }

    private DrainableForkJoinPool pool() {
        return this.pool;
    }

    @Override
    public boolean allTerminated() {
        return TerminationMonitor$class.allTerminated(this);
    }

    @Override
    public void terminated(Reactor a) {
        TerminationMonitor$class.terminated(this, a);
    }

    public void onTerminate(Reactor a, Function0 f) {
        TerminationMonitor$class.onTerminate(this, a, f);
    }

    @Override
    public void newActor(Reactor a) {
        TerminationMonitor$class.newActor(this, a);
    }

    @Override
    public void scala$actors$scheduler$TerminationMonitor$_setter_$scala$actors$scheduler$TerminationMonitor$$termHandlers_$eq(HashMap hashMap) {
        this.scala$actors$scheduler$TerminationMonitor$$termHandlers = hashMap;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$started_$eq(boolean bl) {
        this.scala$actors$scheduler$TerminationMonitor$$started = bl;
    }

    @Override
    public final boolean scala$actors$scheduler$TerminationMonitor$$started() {
        return this.scala$actors$scheduler$TerminationMonitor$$started;
    }

    @Override
    public final HashMap scala$actors$scheduler$TerminationMonitor$$termHandlers() {
        return this.scala$actors$scheduler$TerminationMonitor$$termHandlers;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$pendingReactions_$eq(int n) {
        this.scala$actors$scheduler$TerminationMonitor$$pendingReactions = n;
    }

    @Override
    public final int scala$actors$scheduler$TerminationMonitor$$pendingReactions() {
        return this.scala$actors$scheduler$TerminationMonitor$$pendingReactions;
    }
}

